/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadLocalRandom;
import ksp.com.intellij.diagnostic.PluginException;
import ksp.com.intellij.model.Symbol;
import ksp.com.intellij.openapi.Disposable;
import ksp.com.intellij.openapi.application.ApplicationManager;
import ksp.com.intellij.openapi.application.ex.ApplicationManagerEx;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.util.Computable;
import ksp.com.intellij.openapi.util.Pair;
import ksp.com.intellij.openapi.util.RecursionGuard;
import ksp.com.intellij.openapi.util.RecursionManager;
import ksp.com.intellij.openapi.util.Trinity;
import ksp.com.intellij.openapi.util.registry.Registry;
import ksp.com.intellij.openapi.util.registry.RegistryValue;
import ksp.com.intellij.openapi.util.text.StringUtil;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiNamedElement;
import ksp.com.intellij.psi.ResolveResult;
import ksp.com.intellij.util.CachedValueBase;
import ksp.com.intellij.util.ReflectionUtil;
import ksp.com.intellij.util.containers.ConcurrentFactoryMap;
import ksp.com.intellij.util.containers.ContainerUtil;
import ksp.com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class IdempotenceChecker {
    private static final Logger LOG = Logger.getInstance(IdempotenceChecker.class);
    private static final Set<Class<?>> ourReportedValueClasses = Collections.synchronizedSet(new HashSet());
    private static final ThreadLocal<Integer> ourRandomCheckNesting = ThreadLocal.withInitial(() -> 0);
    private static final ThreadLocal<List<String>> ourLog = new ThreadLocal();
    private static final RegistryValue ourRateCheckProperty = Registry.get("platform.random.idempotence.check.rate");
    private static final Map<Class, Set<Class>> allSupersWithEquals = ConcurrentFactoryMap.createMap(clazz -> JBIterable.generate(clazz, Class::getSuperclass).filter(c -> c != Object.class && ReflectionUtil.getDeclaredMethod(c, "equals", Object.class) != null).toSet());

    public static <T> void checkEquivalence(@Nullable T existing, @Nullable T fresh, @NotNull Class<?> providerClass, @Nullable Computable<? extends T> recomputeValue) {
        String msg2;
        if (providerClass == null) {
            IdempotenceChecker.$$$reportNull$$$0(0);
        }
        if ((msg2 = IdempotenceChecker.checkValueEquivalence(existing, fresh)) != null) {
            IdempotenceChecker.reportFailure(existing, fresh, providerClass, recomputeValue, msg2);
        }
    }

    private static <T> void reportFailure(@Nullable T existing, @Nullable T fresh, @NotNull Class<?> providerClass, @Nullable Computable<? extends T> recomputeValue, String msg2) {
        boolean shouldReport;
        if (providerClass == null) {
            IdempotenceChecker.$$$reportNull$$$0(1);
        }
        boolean bl = shouldReport = ApplicationManager.getApplication().isUnitTestMode() || ourReportedValueClasses.add(providerClass);
        if (shouldReport) {
            if (recomputeValue != null) {
                msg2 = msg2 + IdempotenceChecker.recomputeWithLogging(existing, fresh, recomputeValue);
            }
            LOG.error(PluginException.createByClass(msg2, null, providerClass));
        }
    }

    @NotNull
    private static <T> String recomputeWithLogging(@Nullable T existing, @Nullable T fresh, @NotNull Computable<? extends T> recomputeValue) {
        if (recomputeValue == null) {
            IdempotenceChecker.$$$reportNull$$$0(2);
        }
        ResultWithLog<T> rwl = IdempotenceChecker.computeWithLogging(recomputeValue);
        Object freshest = ((ResultWithLog)rwl).result;
        @NonNls String msg2 = "\n\nRecomputation gives " + IdempotenceChecker.objAndClass(freshest);
        msg2 = IdempotenceChecker.checkValueEquivalence(existing, freshest) == null ? msg2 + " which is equivalent to 'existing'" : (IdempotenceChecker.checkValueEquivalence(fresh, freshest) == null ? msg2 + " which is equivalent to 'fresh'" : msg2 + " which is different from both values");
        if (!((ResultWithLog)rwl).log.isEmpty() && !(freshest instanceof ResultWithLog)) {
            msg2 = msg2 + "\nRecomputation log:\n" + rwl.printLog();
        }
        String string2 = msg2;
        if (string2 == null) {
            IdempotenceChecker.$$$reportNull$$$0(3);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static <T> ResultWithLog<T> computeWithLogging(Computable<? extends T> recomputeValue) {
        boolean outermost;
        List<String> threadLog = ourLog.get();
        boolean bl = outermost = threadLog == null;
        if (outermost) {
            threadLog = new ArrayList<String>();
            ourLog.set(threadLog);
        }
        int start = threadLog.size();
        T result2 = recomputeValue.compute();
        ResultWithLog resultWithLog = new ResultWithLog(result2, new ArrayList<String>(threadLog.subList(start, threadLog.size())));
        ResultWithLog resultWithLog2 = resultWithLog;
        if (resultWithLog2 == null) {
            IdempotenceChecker.$$$reportNull$$$0(4);
        }
        return resultWithLog2;
        finally {
            if (outermost) {
                ourLog.set(null);
            }
        }
    }

    @NonNls
    private static String objAndClass(Object o) {
        if (o == null) {
            return "null";
        }
        String s = o.toString();
        return s.contains(o.getClass().getSimpleName()) || o instanceof String || o instanceof Number || o instanceof Class ? s : s + " (class " + o.getClass().getName() + ")";
    }

    private static String checkValueEquivalence(@Nullable Object existing, @Nullable Object fresh) {
        if (existing == fresh) {
            return null;
        }
        String eqMsg = IdempotenceChecker.checkClassEquivalence(existing, fresh);
        if (eqMsg != null) {
            return eqMsg;
        }
        Object[] eArray = IdempotenceChecker.asArray(existing);
        if (eArray != null) {
            return IdempotenceChecker.checkArrayEquivalence(eArray, Objects.requireNonNull(IdempotenceChecker.asArray(fresh)), existing);
        }
        if (existing instanceof ResultWithLog) {
            return IdempotenceChecker.whichIsField("result", existing, fresh, IdempotenceChecker.checkValueEquivalence(((ResultWithLog)existing).getResult(), ((ResultWithLog)fresh).getResult()));
        }
        if (existing instanceof CachedValueBase.Data) {
            return IdempotenceChecker.checkCachedValueData((CachedValueBase.Data)existing, (CachedValueBase.Data)fresh);
        }
        if (existing instanceof List || IdempotenceChecker.isOrderedSet(existing)) {
            return IdempotenceChecker.checkCollectionElements((Collection)existing, (Collection)fresh);
        }
        if (IdempotenceChecker.isOrderedMap(existing)) {
            return IdempotenceChecker.checkCollectionElements(((Map)existing).entrySet(), ((Map)fresh).entrySet());
        }
        if (existing instanceof Set) {
            return IdempotenceChecker.whichIsField("size", existing, fresh, IdempotenceChecker.checkCollectionSizes(((Set)existing).size(), ((Set)fresh).size()));
        }
        if (existing instanceof Map) {
            if (existing instanceof ConcurrentMap) {
                return null;
            }
            return IdempotenceChecker.whichIsField("size", existing, fresh, IdempotenceChecker.checkCollectionSizes(((Map)existing).size(), ((Map)fresh).size()));
        }
        if (IdempotenceChecker.isExpectedToHaveSaneEquals(existing) && !existing.equals(fresh)) {
            return IdempotenceChecker.reportProblem(existing, fresh);
        }
        if (existing instanceof PsiNamedElement) {
            return IdempotenceChecker.checkPsiEquivalence((PsiElement)existing, (PsiElement)fresh);
        }
        if (existing instanceof ResolveResult) {
            PsiElement freshPsi;
            PsiElement existingPsi = ((ResolveResult)existing).getElement();
            if (existingPsi != (freshPsi = ((ResolveResult)fresh).getElement())) {
                String s = IdempotenceChecker.checkClassEquivalence(existingPsi, freshPsi);
                if (s == null) {
                    s = IdempotenceChecker.checkPsiEquivalence(existingPsi, freshPsi);
                }
                return IdempotenceChecker.whichIsField("element", existing, fresh, s);
            }
            return null;
        }
        return null;
    }

    private static boolean isOrderedMap(Object o) {
        return o instanceof LinkedHashMap || o instanceof SortedMap;
    }

    private static boolean isOrderedSet(Object o) {
        return o instanceof LinkedHashSet || o instanceof SortedSet;
    }

    private static String whichIsField(@NotNull @NonNls String field2, @NotNull Object existing, @NotNull Object fresh, @Nullable String msg2) {
        if (field2 == null) {
            IdempotenceChecker.$$$reportNull$$$0(5);
        }
        if (existing == null) {
            IdempotenceChecker.$$$reportNull$$$0(6);
        }
        if (fresh == null) {
            IdempotenceChecker.$$$reportNull$$$0(7);
        }
        return msg2 == null ? null : IdempotenceChecker.appendDetail(msg2, "which is " + field2 + " of " + existing + " and " + fresh);
    }

    private static Object @Nullable [] asArray(Object o) {
        if (o instanceof Object[]) {
            return (Object[])o;
        }
        if (o instanceof Map.Entry) {
            return new Object[]{((Map.Entry)o).getKey(), ((Map.Entry)o).getValue()};
        }
        if (o instanceof Pair) {
            return new Object[]{((Pair)o).first, ((Pair)o).second};
        }
        if (o instanceof Trinity) {
            return new Object[]{((Trinity)o).first, ((Trinity)o).second, ((Trinity)o).third};
        }
        return null;
    }

    private static String checkCachedValueData(@NotNull CachedValueBase.Data<?> existing, @NotNull CachedValueBase.Data<?> fresh) {
        if (existing == null) {
            IdempotenceChecker.$$$reportNull$$$0(8);
        }
        if (fresh == null) {
            IdempotenceChecker.$$$reportNull$$$0(9);
        }
        Object[] deps1 = existing.getDependencies();
        Object[] deps2 = fresh.getDependencies();
        Object eValue = existing.get();
        Object fValue = fresh.get();
        if (deps1.length != deps2.length) {
            String msg2 = IdempotenceChecker.reportProblem(deps1.length, deps2.length);
            msg2 = IdempotenceChecker.appendDetail(msg2, "which is length of CachedValue dependencies: " + Arrays.toString(deps1) + " and " + Arrays.toString(deps2));
            msg2 = IdempotenceChecker.appendDetail(msg2, "where values are  " + IdempotenceChecker.objAndClass(eValue) + " and " + IdempotenceChecker.objAndClass(fValue));
            return msg2;
        }
        return IdempotenceChecker.checkValueEquivalence(eValue, fValue);
    }

    private static boolean isExpectedToHaveSaneEquals(@NotNull Object existing) {
        if (existing == null) {
            IdempotenceChecker.$$$reportNull$$$0(10);
        }
        return existing instanceof Comparable || existing instanceof Symbol;
    }

    @Contract(value="null,_->!null;_,null->!null")
    private static String checkClassEquivalence(@Nullable Object existing, @Nullable Object fresh) {
        Class<?> c2;
        if (existing == null || fresh == null) {
            return IdempotenceChecker.reportProblem(existing, fresh);
        }
        Class<?> c1 = existing.getClass();
        if (c1 != (c2 = fresh.getClass()) && !IdempotenceChecker.objectsOfDifferentClassesCanStillBeEquivalent(existing, fresh)) {
            return IdempotenceChecker.whichIsField("class", existing, fresh, IdempotenceChecker.reportProblem(c1, c2));
        }
        return null;
    }

    private static boolean objectsOfDifferentClassesCanStillBeEquivalent(@NotNull Object existing, @NotNull Object fresh) {
        if (existing == null) {
            IdempotenceChecker.$$$reportNull$$$0(11);
        }
        if (fresh == null) {
            IdempotenceChecker.$$$reportNull$$$0(12);
        }
        if (existing instanceof Map && fresh instanceof Map && IdempotenceChecker.isOrderedMap(existing) == IdempotenceChecker.isOrderedMap(fresh)) {
            return true;
        }
        if (existing instanceof Set && fresh instanceof Set && IdempotenceChecker.isOrderedSet(existing) == IdempotenceChecker.isOrderedSet(fresh)) {
            return true;
        }
        if (existing instanceof List && fresh instanceof List) {
            return true;
        }
        if (existing instanceof PsiNamedElement && fresh instanceof PsiNamedElement) {
            return true;
        }
        return ContainerUtil.intersects((Collection)allSupersWithEquals.get(existing.getClass()), (Collection)allSupersWithEquals.get(fresh.getClass()));
    }

    private static String checkPsiEquivalence(@NotNull PsiElement existing, @NotNull PsiElement fresh) {
        if (existing == null) {
            IdempotenceChecker.$$$reportNull$$$0(13);
        }
        if (fresh == null) {
            IdempotenceChecker.$$$reportNull$$$0(14);
        }
        if (!(existing.equals(fresh) || existing.isEquivalentTo(fresh) || fresh.isEquivalentTo(existing) || !IdempotenceChecker.seemsToBeResolveTarget(existing) && !IdempotenceChecker.seemsToBeResolveTarget(fresh))) {
            return IdempotenceChecker.reportProblem(existing, fresh);
        }
        return null;
    }

    private static boolean seemsToBeResolveTarget(@NotNull PsiElement psi2) {
        if (psi2 == null) {
            IdempotenceChecker.$$$reportNull$$$0(15);
        }
        if (psi2.isPhysical()) {
            return true;
        }
        PsiElement nav = psi2.getNavigationElement();
        return nav != null && nav.isPhysical();
    }

    private static String checkCollectionElements(@NotNull Collection<?> existing, @NotNull Collection<?> fresh) {
        if (existing == null) {
            IdempotenceChecker.$$$reportNull$$$0(16);
        }
        if (fresh == null) {
            IdempotenceChecker.$$$reportNull$$$0(17);
        }
        if (fresh.isEmpty()) {
            return null;
        }
        return IdempotenceChecker.checkArrayEquivalence(existing.toArray(), fresh.toArray(), existing);
    }

    private static String checkCollectionSizes(int size1, int size2) {
        if (size2 == 0) {
            return null;
        }
        if (size1 != size2) {
            return IdempotenceChecker.reportProblem(size1, size2);
        }
        return null;
    }

    private static String checkArrayEquivalence(Object[] a1, Object[] a2, Object original1) {
        int len1 = a1.length;
        int len2 = a2.length;
        if (len1 != len2) {
            return IdempotenceChecker.appendDetail(IdempotenceChecker.reportProblem(len1, len2), "which is length of " + Arrays.toString(a1) + " and " + Arrays.toString(a2));
        }
        for (int i = 0; i < len1; ++i) {
            String msg2 = IdempotenceChecker.checkValueEquivalence(a1[i], a2[i]);
            if (msg2 == null) continue;
            return IdempotenceChecker.whichIsField(original1 instanceof Map.Entry ? (i == 0 ? "key" : "value") : i + "th element", Arrays.toString(a1), Arrays.toString(a2), msg2);
        }
        return null;
    }

    private static String reportProblem(Object o1, Object o2) {
        return IdempotenceChecker.appendDetail("Non-idempotent computation: it returns different results when invoked multiple times or on different threads:", IdempotenceChecker.objAndClass(o1) + " != " + IdempotenceChecker.objAndClass(o2));
    }

    private static String appendDetail(@NonNls String message2, @NonNls String detail) {
        return message2 + "\n  " + StringUtil.trimLog(detail, 10000);
    }

    public static boolean areRandomChecksEnabled() {
        return ApplicationManager.getApplication().isUnitTestMode() && !ApplicationManagerEx.isInStressTest();
    }

    @TestOnly
    public static void disableRandomChecksUntil(Disposable parentDisposable) {
        ourRateCheckProperty.setValue(0, parentDisposable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void applyForRandomCheck(T data2, Object provider2, Computable<? extends T> recomputeValue) {
        if (IdempotenceChecker.areRandomChecksEnabled() && IdempotenceChecker.shouldPerformRandomCheck()) {
            RecursionGuard.StackStamp stamp = RecursionManager.markStack();
            Integer prevNesting = ourRandomCheckNesting.get();
            ourRandomCheckNesting.set(prevNesting + 1);
            try {
                T fresh = recomputeValue.compute();
                if (stamp.mayCacheNow()) {
                    IdempotenceChecker.checkEquivalence(data2, fresh, provider2.getClass(), recomputeValue);
                }
            }
            finally {
                ourRandomCheckNesting.set(prevNesting);
            }
        }
    }

    private static boolean shouldPerformRandomCheck() {
        int rate = ourRateCheckProperty.asInteger();
        return rate > 0 && ThreadLocalRandom.current().nextInt(rate) == 0;
    }

    @TestOnly
    public static boolean isCurrentThreadInsideRandomCheck() {
        return ourRandomCheckNesting.get() > 0;
    }

    public static boolean isLoggingEnabled() {
        return ourLog.get() != null;
    }

    public static void logTrace(@NotNull @NonNls String message2) {
        List<String> log2;
        if (message2 == null) {
            IdempotenceChecker.$$$reportNull$$$0(18);
        }
        if ((log2 = ourLog.get()) != null) {
            log2.add(message2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recomputeValue";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/util/IdempotenceChecker";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existing";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fresh";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/util/IdempotenceChecker";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "recomputeWithLogging";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computeWithLogging";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkEquivalence";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reportFailure";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "recomputeWithLogging";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "whichIsField";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkCachedValueData";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isExpectedToHaveSaneEquals";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "objectsOfDifferentClassesCanStillBeEquivalent";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkPsiEquivalence";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "seemsToBeResolveTarget";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "checkCollectionElements";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "logTrace";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class ResultWithLog<T> {
        private final T result;
        private final List<String> log;

        private ResultWithLog(T result2, List<String> log2) {
            this.result = result2;
            this.log = log2;
        }

        public T getResult() {
            return this.result;
        }

        String printLog() {
            return StringUtil.join(this.log, s -> "  " + s, "\n");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ResultWithLog)) {
                return false;
            }
            ResultWithLog log2 = (ResultWithLog)o;
            return Arrays.deepEquals(new Object[]{this.result}, new Object[]{log2.result});
        }

        public int hashCode() {
            return Objects.hash(this.result);
        }

        public String toString() {
            return "ResultWithLog{" + this.result + (this.log.isEmpty() ? "" : ", log='\n" + this.printLog() + '\'') + '}';
        }
    }
}

