/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.util;

import ksp.com.intellij.codeInsight.runner.JavaMainMethodProvider;
import ksp.com.intellij.openapi.util.Condition;
import ksp.com.intellij.psi.PsiAnonymousClass;
import ksp.com.intellij.psi.PsiArrayType;
import ksp.com.intellij.psi.PsiClass;
import ksp.com.intellij.psi.PsiMethod;
import ksp.com.intellij.psi.PsiParameter;
import ksp.com.intellij.psi.PsiType;
import ksp.com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.Nullable;

public final class PsiMethodUtil {
    public static final Condition<PsiClass> MAIN_CLASS = psiClass -> {
        if (psiClass instanceof PsiAnonymousClass) {
            return false;
        }
        if (psiClass.isAnnotationType()) {
            return false;
        }
        if (psiClass.isInterface() && !PsiUtil.isLanguageLevel8OrHigher(psiClass)) {
            return false;
        }
        return psiClass.getContainingClass() == null || psiClass.hasModifierProperty("static");
    };

    private PsiMethodUtil() {
    }

    @Nullable
    public static PsiMethod findMainMethod(PsiClass aClass) {
        for (JavaMainMethodProvider provider2 : JavaMainMethodProvider.EP_NAME.getExtensionList()) {
            if (!provider2.isApplicable(aClass)) continue;
            return provider2.findMainInClass(aClass);
        }
        PsiMethod[] mainMethods = aClass.findMethodsByName("main", true);
        return PsiMethodUtil.findMainMethod(mainMethods);
    }

    @Nullable
    private static PsiMethod findMainMethod(PsiMethod[] mainMethods) {
        for (PsiMethod mainMethod : mainMethods) {
            if (!PsiMethodUtil.isMainMethod(mainMethod)) continue;
            return mainMethod;
        }
        return null;
    }

    public static boolean isMainMethod(PsiMethod method) {
        if (method == null || method.getContainingClass() == null) {
            return false;
        }
        if (!PsiType.VOID.equals(method.getReturnType())) {
            return false;
        }
        if (!method.hasModifierProperty("static")) {
            return false;
        }
        if (!method.hasModifierProperty("public")) {
            return false;
        }
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        if (parameters2.length != 1) {
            return false;
        }
        PsiType type2 = parameters2[0].getType();
        if (!(type2 instanceof PsiArrayType)) {
            return false;
        }
        PsiType componentType = ((PsiArrayType)type2).getComponentType();
        return componentType.equalsToText("java.lang.String");
    }

    public static boolean hasMainMethod(PsiClass psiClass) {
        for (JavaMainMethodProvider provider2 : JavaMainMethodProvider.EP_NAME.getExtensionList()) {
            if (!provider2.isApplicable(psiClass)) continue;
            return provider2.hasMainMethod(psiClass);
        }
        return PsiMethodUtil.findMainMethod(psiClass.findMethodsByName("main", true)) != null;
    }

    @Nullable
    public static PsiMethod findMainInClass(PsiClass aClass) {
        if (!MAIN_CLASS.value(aClass)) {
            return null;
        }
        return PsiMethodUtil.findMainMethod(aClass);
    }
}

