/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.stubs;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.stubs.IStubElementType;
import ksp.com.intellij.psi.stubs.MaterialStubList;
import ksp.com.intellij.psi.stubs.ObjectStubBase;
import ksp.com.intellij.psi.stubs.StubElement;
import ksp.com.intellij.psi.stubs.StubList;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.com.intellij.psi.tree.TokenSet;
import ksp.com.intellij.util.ArrayFactory;
import ksp.com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StubBase<T extends PsiElement>
extends ObjectStubBase<StubElement<?>>
implements StubElement<T> {
    StubList myStubList;
    private volatile T myPsi;
    private static final AtomicReferenceFieldUpdater<StubBase, PsiElement> myPsiUpdater = AtomicReferenceFieldUpdater.newUpdater(StubBase.class, PsiElement.class, "myPsi");

    protected StubBase(@Nullable StubElement parent2, IStubElementType elementType) {
        super(parent2);
        this.myStubList = parent2 == null ? new MaterialStubList(10) : ((StubBase)parent2).myStubList;
        this.myStubList.addStub(this, (StubBase)parent2, elementType);
    }

    @Override
    public StubElement getParentStub() {
        return (StubElement)this.myParent;
    }

    @Override
    @NotNull
    public List<StubElement> getChildrenStubs() {
        List<StubElement> list2 = this.myStubList.getChildrenStubs(this.id);
        if (list2 == null) {
            StubBase.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @Override
    @Nullable
    public <P extends PsiElement, S extends StubElement<P>> S findChildStubByType(@NotNull IStubElementType<S, P> elementType) {
        if (elementType == null) {
            StubBase.$$$reportNull$$$0(1);
        }
        return this.myStubList.findChildStubByType(this.id, elementType);
    }

    public void setPsi(@NotNull T psi2) {
        if (psi2 == null) {
            StubBase.$$$reportNull$$$0(2);
        }
        assert (this.myPsi == null || this.myPsi == psi2);
        this.myPsi = psi2;
    }

    @Nullable
    final T getCachedPsi() {
        return this.myPsi;
    }

    @Override
    public T getPsi() {
        Object psi2 = this.myPsi;
        if (psi2 != null) {
            return psi2;
        }
        psi2 = this.getStubType().createPsi(this);
        return (T)(myPsiUpdater.compareAndSet(this, (PsiElement)null, (PsiElement)psi2) ? psi2 : (PsiElement)Objects.requireNonNull(this.myPsi));
    }

    @Override
    public <E extends PsiElement> E @NotNull [] getChildrenByType(@NotNull IElementType elementType, E[] array) {
        if (elementType == null) {
            StubBase.$$$reportNull$$$0(3);
        }
        List<StubElement> childrenStubs = this.getChildrenStubs();
        int count = StubBase.countChildren(elementType, childrenStubs);
        array = (PsiElement[])ArrayUtil.ensureExactSize(count, array);
        if (count == 0) {
            if (array == null) {
                StubBase.$$$reportNull$$$0(4);
            }
            return array;
        }
        StubBase.fillFilteredChildren((IElementType)elementType, array, childrenStubs);
        if (array == null) {
            StubBase.$$$reportNull$$$0(5);
        }
        return array;
    }

    @Override
    public <E extends PsiElement> E @NotNull [] getChildrenByType(@NotNull TokenSet filter2, E[] array) {
        if (filter2 == null) {
            StubBase.$$$reportNull$$$0(6);
        }
        List<StubElement> childrenStubs = this.getChildrenStubs();
        int count = StubBase.countChildren(filter2, childrenStubs);
        array = (PsiElement[])ArrayUtil.ensureExactSize(count, array);
        if (count == 0) {
            if (array == null) {
                StubBase.$$$reportNull$$$0(7);
            }
            return array;
        }
        StubBase.fillFilteredChildren((TokenSet)filter2, array, childrenStubs);
        if (array == null) {
            StubBase.$$$reportNull$$$0(8);
        }
        return array;
    }

    @Override
    public <E extends PsiElement> E @NotNull [] getChildrenByType(@NotNull IElementType elementType, @NotNull ArrayFactory<E> f) {
        if (elementType == null) {
            StubBase.$$$reportNull$$$0(9);
        }
        if (f == null) {
            StubBase.$$$reportNull$$$0(10);
        }
        List<StubElement> childrenStubs = this.getChildrenStubs();
        int count = StubBase.countChildren(elementType, childrenStubs);
        PsiElement[] result2 = (PsiElement[])f.create(count);
        if (count > 0) {
            StubBase.fillFilteredChildren((IElementType)elementType, (PsiElement[])result2, childrenStubs);
        }
        if (result2 == null) {
            StubBase.$$$reportNull$$$0(11);
        }
        return result2;
    }

    private static int countChildren(IElementType elementType, List<? extends StubElement> childrenStubs) {
        int count = 0;
        int childrenStubsSize = childrenStubs.size();
        for (int i = 0; i < childrenStubsSize; ++i) {
            StubElement childStub = childrenStubs.get(i);
            if (childStub.getStubType() != elementType) continue;
            ++count;
        }
        return count;
    }

    private static int countChildren(TokenSet types2, List<? extends StubElement> childrenStubs) {
        int count = 0;
        int childrenStubsSize = childrenStubs.size();
        for (int i = 0; i < childrenStubsSize; ++i) {
            StubElement childStub = childrenStubs.get(i);
            if (!types2.contains(childStub.getStubType())) continue;
            ++count;
        }
        return count;
    }

    private static <E extends PsiElement> void fillFilteredChildren(IElementType type2, E[] result2, List<? extends StubElement> childrenStubs) {
        int count = 0;
        int childrenStubsSize = childrenStubs.size();
        for (int i = 0; i < childrenStubsSize; ++i) {
            StubElement childStub = childrenStubs.get(i);
            if (childStub.getStubType() != type2) continue;
            result2[count++] = childStub.getPsi();
        }
        assert (count == result2.length);
    }

    private static <E extends PsiElement> void fillFilteredChildren(TokenSet set, E[] result2, List<? extends StubElement> childrenStubs) {
        int count = 0;
        int childrenStubsSize = childrenStubs.size();
        for (int i = 0; i < childrenStubsSize; ++i) {
            StubElement childStub = childrenStubs.get(i);
            if (!set.contains(childStub.getStubType())) continue;
            result2[count++] = childStub.getPsi();
        }
        assert (count == result2.length);
    }

    @Override
    public <E extends PsiElement> E @NotNull [] getChildrenByType(@NotNull TokenSet filter2, @NotNull ArrayFactory<E> f) {
        if (filter2 == null) {
            StubBase.$$$reportNull$$$0(12);
        }
        if (f == null) {
            StubBase.$$$reportNull$$$0(13);
        }
        List<StubElement> childrenStubs = this.getChildrenStubs();
        int count = StubBase.countChildren(filter2, childrenStubs);
        PsiElement[] array = (PsiElement[])f.create(count);
        if (count == 0) {
            if (array == null) {
                StubBase.$$$reportNull$$$0(14);
            }
            return array;
        }
        StubBase.fillFilteredChildren((TokenSet)filter2, (PsiElement[])array, childrenStubs);
        if (array == null) {
            StubBase.$$$reportNull$$$0(15);
        }
        return array;
    }

    @Override
    @Nullable
    public <E extends PsiElement> E getParentStubOfType(@NotNull Class<E> parentClass) {
        if (parentClass == null) {
            StubBase.$$$reportNull$$$0(16);
        }
        for (StubElement parent2 = (StubElement)this.myParent; parent2 != null; parent2 = parent2.getParentStub()) {
            Object psi2 = parent2.getPsi();
            if (!parentClass.isInstance(psi2)) continue;
            return (E)psi2;
        }
        return null;
    }

    @Override
    public IStubElementType getStubType() {
        return this.myStubList.getStubType(this.id);
    }

    public Project getProject() {
        return this.getPsi().getProject();
    }

    public String printTree() {
        StringBuilder builder2 = new StringBuilder();
        this.printTree(builder2, 0);
        return builder2.toString();
    }

    private void printTree(StringBuilder builder2, int nestingLevel) {
        for (int i = 0; i < nestingLevel; ++i) {
            builder2.append("  ");
        }
        builder2.append(this).append('\n');
        for (StubElement child : this.getChildrenStubs()) {
            ((StubBase)child).printTree(builder2, nestingLevel + 1);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName();
    }

    public int compareByOrderWith(ObjectStubBase<?> another) {
        return Integer.compare(this.getStubId(), another.getStubId());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 16: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/stubs/StubBase";
                break;
            }
            case 1: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenStubs";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/stubs/StubBase";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenByType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findChildStubByType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setPsi";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenByType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getParentStubOfType";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 16: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

