/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.search;

import java.util.HashSet;
import java.util.Set;
import ksp.com.intellij.openapi.module.Module;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.roots.PackageIndex;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.psi.JavaPsiFacade;
import ksp.com.intellij.psi.PsiClassOwner;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.PsiPackage;
import ksp.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;

public class PackageScope
extends GlobalSearchScope {
    private final Set<VirtualFile> myDirs;
    private final PsiPackage myPackage;
    private final boolean myIncludeSubpackages;
    private final boolean myIncludeLibraries;
    private final boolean myPartOfPackagePrefix;
    private final String myPackageQualifiedName;
    private final String myPackageQNamePrefix;

    public PackageScope(@NotNull PsiPackage aPackage, boolean includeSubpackages, boolean includeLibraries) {
        if (aPackage == null) {
            PackageScope.$$$reportNull$$$0(0);
        }
        super(aPackage.getProject());
        this.myPackage = aPackage;
        this.myIncludeSubpackages = includeSubpackages;
        Project project = this.myPackage.getProject();
        this.myPackageQualifiedName = this.myPackage.getQualifiedName();
        this.myDirs = new HashSet<VirtualFile>(PackageIndex.getInstance(project).getDirsByPackageName(this.myPackageQualifiedName, true).findAll());
        this.myIncludeLibraries = includeLibraries;
        this.myPartOfPackagePrefix = JavaPsiFacade.getInstance(this.getProject()).isPartOfPackagePrefix(this.myPackageQualifiedName);
        this.myPackageQNamePrefix = this.myPackageQualifiedName + ".";
    }

    @Override
    public boolean contains(@NotNull VirtualFile file2) {
        String packageName2;
        PsiFile psiFile;
        VirtualFile dir;
        if (file2 == null) {
            PackageScope.$$$reportNull$$$0(1);
        }
        VirtualFile virtualFile2 = dir = file2.isDirectory() ? file2 : file2.getParent();
        if (!this.myIncludeSubpackages) {
            if (this.myDirs.contains(dir)) {
                return true;
            }
        } else {
            while (dir != null) {
                if (this.myDirs.contains(dir)) {
                    return true;
                }
                dir = dir.getParent();
            }
        }
        return this.myPartOfPackagePrefix && this.myIncludeSubpackages && (psiFile = this.myPackage.getManager().findFile(file2)) instanceof PsiClassOwner && (this.myPackageQualifiedName.equals(packageName2 = ((PsiClassOwner)psiFile).getPackageName()) || packageName2.startsWith(this.myPackageQNamePrefix));
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            PackageScope.$$$reportNull$$$0(2);
        }
        return true;
    }

    @Override
    public boolean isSearchInLibraries() {
        return this.myIncludeLibraries;
    }

    public String toString() {
        return "package scope: " + this.myPackage + ", includeSubpackages = " + this.myIncludeSubpackages;
    }

    @NotNull
    public static GlobalSearchScope packageScope(@NotNull PsiPackage aPackage, boolean includeSubpackages) {
        if (aPackage == null) {
            PackageScope.$$$reportNull$$$0(3);
        }
        return new PackageScope(aPackage, includeSubpackages, true);
    }

    @NotNull
    public static GlobalSearchScope packageScopeWithoutLibraries(@NotNull PsiPackage aPackage, boolean includeSubpackages) {
        if (aPackage == null) {
            PackageScope.$$$reportNull$$$0(4);
        }
        return new PackageScope(aPackage, includeSubpackages, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aModule";
                break;
            }
        }
        objectArray2[1] = "ksp/com/intellij/psi/search/PackageScope";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "contains";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isSearchInModuleContent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "packageScope";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "packageScopeWithoutLibraries";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

