/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.source.tree.java;

import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.psi.JavaElementVisitor;
import ksp.com.intellij.psi.JavaTokenType;
import ksp.com.intellij.psi.PsiElementVisitor;
import ksp.com.intellij.psi.PsiJavaCodeReferenceElement;
import ksp.com.intellij.psi.PsiModifierList;
import ksp.com.intellij.psi.PsiPackageStatement;
import ksp.com.intellij.psi.impl.source.tree.ChildRole;
import ksp.com.intellij.psi.impl.source.tree.CompositePsiElement;
import ksp.com.intellij.psi.impl.source.tree.JavaElementType;
import ksp.com.intellij.psi.impl.source.tree.JavaSourceUtil;
import ksp.com.intellij.psi.impl.source.tree.TreeUtil;
import ksp.com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class PsiPackageStatementImpl
extends CompositePsiElement
implements PsiPackageStatement {
    private static final Logger LOG = Logger.getInstance(PsiPackageStatementImpl.class);

    public PsiPackageStatementImpl() {
        super(JavaElementType.PACKAGE_STATEMENT);
    }

    @Override
    public PsiJavaCodeReferenceElement getPackageReference() {
        return (PsiJavaCodeReferenceElement)this.findChildByRoleAsPsiElement(103);
    }

    @Override
    public String getPackageName() {
        PsiJavaCodeReferenceElement ref = this.getPackageReference();
        return ref == null ? null : JavaSourceUtil.getReferenceText(ref);
    }

    @Override
    public PsiModifierList getAnnotationList() {
        return (PsiModifierList)this.findChildByRoleAsPsiElement(8);
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 102: {
                return this.findChildByType(JavaTokenType.PACKAGE_KEYWORD);
            }
            case 103: {
                return this.findChildByType(JavaElementType.JAVA_CODE_REFERENCE);
            }
            case 22: {
                return TreeUtil.findChildBackward(this, JavaTokenType.SEMICOLON);
            }
            case 8: 
        }
        return this.findChildByType(JavaElementType.MODIFIER_LIST);
    }

    @Override
    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            PsiPackageStatementImpl.$$$reportNull$$$0(0);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaTokenType.PACKAGE_KEYWORD) {
            return 102;
        }
        if (i == JavaElementType.JAVA_CODE_REFERENCE) {
            return 103;
        }
        if (i == JavaTokenType.SEMICOLON) {
            return 22;
        }
        if (i == JavaElementType.MODIFIER_LIST) {
            return 8;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiPackageStatementImpl.$$$reportNull$$$0(1);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitPackageStatement(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiPackageStatement:" + this.getPackageName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        objectArray2[1] = "ksp/com/intellij/psi/impl/source/tree/java/PsiPackageStatementImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getChildRole";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

