/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.source.resolve.graphInference.constraints;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ksp.com.intellij.psi.LambdaUtil;
import ksp.com.intellij.psi.PsiClassType;
import ksp.com.intellij.psi.PsiConditionalExpression;
import ksp.com.intellij.psi.PsiExpression;
import ksp.com.intellij.psi.PsiFunctionalExpression;
import ksp.com.intellij.psi.PsiLambdaExpression;
import ksp.com.intellij.psi.PsiMethod;
import ksp.com.intellij.psi.PsiMethodReferenceExpression;
import ksp.com.intellij.psi.PsiParameter;
import ksp.com.intellij.psi.PsiParenthesizedExpression;
import ksp.com.intellij.psi.PsiSubstitutor;
import ksp.com.intellij.psi.PsiSwitchExpression;
import ksp.com.intellij.psi.PsiType;
import ksp.com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import ksp.com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import ksp.com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import ksp.com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import ksp.com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.Nullable;

public abstract class InputOutputConstraintFormula
implements ConstraintFormula {
    private PsiType myT;

    protected InputOutputConstraintFormula(PsiType t) {
        this.myT = t;
    }

    public abstract PsiExpression getExpression();

    protected abstract InputOutputConstraintFormula createSelfConstraint(PsiType var1, PsiExpression var2);

    protected abstract void collectReturnTypeVariables(InferenceSession var1, PsiExpression var2, PsiType var3, Set<? super InferenceVariable> var4);

    public Set<InferenceVariable> getInputVariables(InferenceSession session2) {
        PsiExpression psiExpression = this.getExpression();
        PsiType type2 = this.myT;
        if (psiExpression instanceof PsiFunctionalExpression) {
            PsiType functionType;
            PsiClassType.ClassResolveResult resolveResult;
            PsiMethod interfaceMethod;
            InferenceVariable inferenceVariable = session2.getInferenceVariable(type2);
            if (inferenceVariable != null) {
                HashSet<InferenceVariable> result2 = new HashSet<InferenceVariable>();
                result2.add(inferenceVariable);
                return result2;
            }
            if (LambdaUtil.isFunctionalType(type2) && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult = PsiUtil.resolveGenericsClassInType(functionType = psiExpression instanceof PsiLambdaExpression ? FunctionalInterfaceParameterizationUtil.getGroundTargetType(type2, (PsiLambdaExpression)psiExpression, false) : type2))) != null) {
                PsiType returnType2;
                HashSet<InferenceVariable> result3 = new HashSet<InferenceVariable>();
                PsiSubstitutor substitutor2 = LambdaUtil.getSubstitutor(interfaceMethod, resolveResult);
                if (psiExpression instanceof PsiLambdaExpression && !((PsiLambdaExpression)psiExpression).hasFormalParameterTypes() || psiExpression instanceof PsiMethodReferenceExpression && !((PsiMethodReferenceExpression)psiExpression).isExact()) {
                    for (PsiParameter parameter2 : interfaceMethod.getParameterList().getParameters()) {
                        session2.collectDependencies(substitutor2.substitute(parameter2.getType()), result3);
                    }
                }
                if ((returnType2 = interfaceMethod.getReturnType()) != null) {
                    this.collectReturnTypeVariables(session2, psiExpression, substitutor2.substitute(returnType2), result3);
                }
                return result3;
            }
        }
        if (psiExpression instanceof PsiParenthesizedExpression) {
            PsiExpression expression3 = ((PsiParenthesizedExpression)psiExpression).getExpression();
            return expression3 != null ? this.createSelfConstraint(type2, expression3).getInputVariables(session2) : null;
        }
        if (psiExpression instanceof PsiConditionalExpression) {
            Set<InferenceVariable> elseResult;
            PsiExpression thenExpression = ((PsiConditionalExpression)psiExpression).getThenExpression();
            PsiExpression elseExpression = ((PsiConditionalExpression)psiExpression).getElseExpression();
            Set<InferenceVariable> thenResult = thenExpression != null ? this.createSelfConstraint(type2, thenExpression).getInputVariables(session2) : null;
            Set<InferenceVariable> set = elseResult = elseExpression != null ? this.createSelfConstraint(type2, elseExpression).getInputVariables(session2) : null;
            if (thenResult == null) {
                return elseResult;
            }
            if (elseResult == null) {
                return thenResult;
            }
            thenResult.addAll(elseResult);
            return thenResult;
        }
        if (psiExpression instanceof PsiSwitchExpression) {
            Set<InferenceVariable> variables2 = PsiUtil.getSwitchResultExpressions((PsiSwitchExpression)psiExpression).stream().flatMap(expression2 -> {
                Set<InferenceVariable> inputVariables = this.createSelfConstraint(type2, (PsiExpression)expression2).getInputVariables(session2);
                return inputVariables != null ? inputVariables.stream() : Stream.empty();
            }).collect(Collectors.toSet());
            return variables2.isEmpty() ? null : variables2;
        }
        return null;
    }

    @Nullable
    public Set<InferenceVariable> getOutputVariables(Set<InferenceVariable> inputVariables, InferenceSession session2) {
        HashSet<InferenceVariable> mentionedVariables = new HashSet<InferenceVariable>();
        session2.collectDependencies(this.myT, mentionedVariables);
        if (inputVariables != null) {
            mentionedVariables.removeAll(inputVariables);
        }
        return mentionedVariables.isEmpty() ? null : mentionedVariables;
    }

    @Override
    public void apply(PsiSubstitutor substitutor2, boolean cache2) {
        this.myT = substitutor2.substitute(this.myT);
    }

    public PsiType getCurrentType() {
        return this.myT;
    }

    public String toString() {
        return this.getExpression().getText() + " -> " + this.myT.getPresentableText();
    }
}

