/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.source;

import ksp.com.intellij.openapi.util.TextRange;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiIdentifier;
import ksp.com.intellij.psi.PsiLabeledStatement;
import ksp.com.intellij.psi.PsiReference;
import ksp.com.intellij.psi.PsiStatement;
import ksp.com.intellij.psi.impl.PsiImplUtil;
import ksp.com.intellij.util.ArrayUtil;
import ksp.com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class PsiLabelReference
implements PsiReference {
    private final PsiStatement myStatement;
    private PsiIdentifier myIdentifier;

    public PsiLabelReference(PsiStatement stat, PsiIdentifier identifier) {
        this.myStatement = stat;
        this.myIdentifier = identifier;
    }

    @Override
    @NotNull
    public PsiElement getElement() {
        PsiStatement psiStatement = this.myStatement;
        if (psiStatement == null) {
            PsiLabelReference.$$$reportNull$$$0(0);
        }
        return psiStatement;
    }

    @Override
    @NotNull
    public TextRange getRangeInElement() {
        int start = this.myIdentifier.getStartOffsetInParent();
        return new TextRange(start, this.myIdentifier.getTextLength() + start);
    }

    @Override
    public PsiElement resolve() {
        String label = this.myIdentifier.getText();
        for (PsiElement context2 = this.myStatement; context2 != null; context2 = context2.getContext()) {
            if (!(context2 instanceof PsiLabeledStatement) || !label.equals(((PsiLabeledStatement)context2).getName())) continue;
            return context2;
        }
        return null;
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String string2 = this.getElement().getText();
        if (string2 == null) {
            PsiLabelReference.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @Override
    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            PsiLabelReference.$$$reportNull$$$0(2);
        }
        this.myIdentifier = (PsiIdentifier)PsiImplUtil.setName(this.myIdentifier, newElementName);
        return this.myIdentifier;
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element2) throws IncorrectOperationException {
        if (element2 == null) {
            PsiLabelReference.$$$reportNull$$$0(3);
        }
        if (!(element2 instanceof PsiLabeledStatement)) {
            throw new IncorrectOperationException("Can't bind to non-labeled statement");
        }
        return this.handleElementRename(((PsiLabeledStatement)element2).getName());
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element2) {
        if (element2 == null) {
            PsiLabelReference.$$$reportNull$$$0(4);
        }
        return this.resolve() == element2;
    }

    public String @NotNull [] getVariants() {
        String[] stringArray = ArrayUtil.toStringArray(PsiImplUtil.findAllEnclosingLabels(this.myStatement));
        if (stringArray == null) {
            PsiLabelReference.$$$reportNull$$$0(5);
        }
        return stringArray;
    }

    @Override
    public boolean isSoft() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/impl/source/PsiLabelReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/impl/source/PsiLabelReference";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

