/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import ksp.com.intellij.codeInsight.AnnotationTargetUtil;
import ksp.com.intellij.codeInsight.AnnotationUtil;
import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.lang.FileASTNode;
import ksp.com.intellij.openapi.application.ApplicationManager;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.util.Key;
import ksp.com.intellij.openapi.util.text.StringUtil;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.psi.JavaPsiFacade;
import ksp.com.intellij.psi.JavaResolveResult;
import ksp.com.intellij.psi.NavigatablePsiElement;
import ksp.com.intellij.psi.PsiAnnotation;
import ksp.com.intellij.psi.PsiAnnotationMemberValue;
import ksp.com.intellij.psi.PsiAnnotationMethod;
import ksp.com.intellij.psi.PsiAnnotationOwner;
import ksp.com.intellij.psi.PsiAnonymousClass;
import ksp.com.intellij.psi.PsiArrayAccessExpression;
import ksp.com.intellij.psi.PsiArrayType;
import ksp.com.intellij.psi.PsiCapturedWildcardType;
import ksp.com.intellij.psi.PsiCaseLabelElement;
import ksp.com.intellij.psi.PsiCaseLabelElementList;
import ksp.com.intellij.psi.PsiClass;
import ksp.com.intellij.psi.PsiClassInitializer;
import ksp.com.intellij.psi.PsiClassObjectAccessExpression;
import ksp.com.intellij.psi.PsiClassType;
import ksp.com.intellij.psi.PsiCodeBlock;
import ksp.com.intellij.psi.PsiComment;
import ksp.com.intellij.psi.PsiDeclarationStatement;
import ksp.com.intellij.psi.PsiDiamondType;
import ksp.com.intellij.psi.PsiDocCommentOwner;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiElementFactory;
import ksp.com.intellij.psi.PsiEnumConstantInitializer;
import ksp.com.intellij.psi.PsiExpression;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.PsiIdentifier;
import ksp.com.intellij.psi.PsiJavaCodeReferenceElement;
import ksp.com.intellij.psi.PsiJavaDocumentedElement;
import ksp.com.intellij.psi.PsiJavaFile;
import ksp.com.intellij.psi.PsiJavaModule;
import ksp.com.intellij.psi.PsiLabeledStatement;
import ksp.com.intellij.psi.PsiLambdaExpression;
import ksp.com.intellij.psi.PsiLocalVariable;
import ksp.com.intellij.psi.PsiLoopStatement;
import ksp.com.intellij.psi.PsiManager;
import ksp.com.intellij.psi.PsiMember;
import ksp.com.intellij.psi.PsiMethod;
import ksp.com.intellij.psi.PsiMethodCallExpression;
import ksp.com.intellij.psi.PsiMethodReferenceExpression;
import ksp.com.intellij.psi.PsiMirrorElement;
import ksp.com.intellij.psi.PsiModifierList;
import ksp.com.intellij.psi.PsiModifierListOwner;
import ksp.com.intellij.psi.PsiNameHelper;
import ksp.com.intellij.psi.PsiNameValuePair;
import ksp.com.intellij.psi.PsiPackage;
import ksp.com.intellij.psi.PsiParameter;
import ksp.com.intellij.psi.PsiParameterList;
import ksp.com.intellij.psi.PsiParameterListOwner;
import ksp.com.intellij.psi.PsiParenthesizedPattern;
import ksp.com.intellij.psi.PsiPrimitiveType;
import ksp.com.intellij.psi.PsiReferenceParameterList;
import ksp.com.intellij.psi.PsiResourceList;
import ksp.com.intellij.psi.PsiResourceListElement;
import ksp.com.intellij.psi.PsiResourceVariable;
import ksp.com.intellij.psi.PsiStatement;
import ksp.com.intellij.psi.PsiSubstitutor;
import ksp.com.intellij.psi.PsiSwitchExpression;
import ksp.com.intellij.psi.PsiSwitchLabelStatementBase;
import ksp.com.intellij.psi.PsiSwitchStatement;
import ksp.com.intellij.psi.PsiType;
import ksp.com.intellij.psi.PsiTypeElement;
import ksp.com.intellij.psi.PsiTypeParameter;
import ksp.com.intellij.psi.PsiTypeParameterList;
import ksp.com.intellij.psi.PsiTypeParameterListOwner;
import ksp.com.intellij.psi.PsiWhiteSpace;
import ksp.com.intellij.psi.PsiWildcardType;
import ksp.com.intellij.psi.ResolveResult;
import ksp.com.intellij.psi.ResolveState;
import ksp.com.intellij.psi.ServerPageFile;
import ksp.com.intellij.psi.StubBasedPsiElement;
import ksp.com.intellij.psi.ThreadLocalTypes;
import ksp.com.intellij.psi.filters.ElementFilter;
import ksp.com.intellij.psi.impl.DebugUtil;
import ksp.com.intellij.psi.impl.ResolveScopeManager;
import ksp.com.intellij.psi.impl.light.LightClassReference;
import ksp.com.intellij.psi.impl.light.LightJavaModule;
import ksp.com.intellij.psi.impl.source.DummyHolder;
import ksp.com.intellij.psi.impl.source.PsiClassReferenceType;
import ksp.com.intellij.psi.impl.source.PsiImmediateClassType;
import ksp.com.intellij.psi.impl.source.resolve.ResolveCache;
import ksp.com.intellij.psi.impl.source.tree.CompositeElement;
import ksp.com.intellij.psi.impl.source.tree.CompositePsiElement;
import ksp.com.intellij.psi.impl.source.tree.JavaDocElementType;
import ksp.com.intellij.psi.impl.source.tree.LeafElement;
import ksp.com.intellij.psi.impl.source.tree.SharedImplUtil;
import ksp.com.intellij.psi.impl.source.tree.TreeElement;
import ksp.com.intellij.psi.impl.source.tree.TreeUtil;
import ksp.com.intellij.psi.javadoc.PsiDocComment;
import ksp.com.intellij.psi.scope.ElementClassHint;
import ksp.com.intellij.psi.scope.PsiScopeProcessor;
import ksp.com.intellij.psi.scope.processor.FilterScopeProcessor;
import ksp.com.intellij.psi.scope.util.PsiScopesUtil;
import ksp.com.intellij.psi.search.GlobalSearchScope;
import ksp.com.intellij.psi.search.LocalSearchScope;
import ksp.com.intellij.psi.search.PackageScope;
import ksp.com.intellij.psi.search.SearchScope;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.com.intellij.psi.tree.TokenSet;
import ksp.com.intellij.psi.util.JavaPsiPatternUtil;
import ksp.com.intellij.psi.util.PsiTreeUtil;
import ksp.com.intellij.psi.util.PsiUtil;
import ksp.com.intellij.psi.util.PsiUtilCore;
import ksp.com.intellij.util.IncorrectOperationException;
import ksp.com.intellij.util.PairFunction;
import ksp.com.intellij.util.SmartList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiImplUtil {
    private static final Logger LOG = Logger.getInstance(PsiImplUtil.class);
    private static final Key<Boolean> TYPE_ANNO_MARK = Key.create("type.annotation.mark");

    private PsiImplUtil() {
    }

    public static PsiMethod @NotNull [] getConstructors(@NotNull PsiClass aClass) {
        if (aClass == null) {
            PsiImplUtil.$$$reportNull$$$0(0);
        }
        SmartList<PsiMethod> result2 = null;
        for (PsiMethod method : aClass.getMethods()) {
            if (!method.isConstructor() || !method.getName().equals(aClass.getName())) continue;
            if (result2 == null) {
                result2 = new SmartList<PsiMethod>();
            }
            result2.add(method);
        }
        PsiMethod[] psiMethodArray = result2 == null ? PsiMethod.EMPTY_ARRAY : result2.toArray(PsiMethod.EMPTY_ARRAY);
        if (psiMethodArray == null) {
            PsiImplUtil.$$$reportNull$$$0(1);
        }
        return psiMethodArray;
    }

    @Nullable
    public static PsiAnnotationMemberValue findDeclaredAttributeValue(@NotNull PsiAnnotation annotation2, @NonNls @Nullable String attributeName) {
        PsiNameValuePair attribute;
        if (annotation2 == null) {
            PsiImplUtil.$$$reportNull$$$0(2);
        }
        return (attribute = AnnotationUtil.findDeclaredAttribute(annotation2, attributeName)) == null ? null : attribute.getValue();
    }

    @Nullable
    public static PsiAnnotationMemberValue findAttributeValue(@NotNull PsiAnnotation annotation2, @Nullable @NonNls String attributeName) {
        PsiElement resolved;
        PsiJavaCodeReferenceElement referenceElement;
        PsiAnnotationMemberValue value2;
        if (annotation2 == null) {
            PsiImplUtil.$$$reportNull$$$0(3);
        }
        if ((value2 = PsiImplUtil.findDeclaredAttributeValue(annotation2, attributeName)) != null) {
            return value2;
        }
        if (attributeName == null) {
            attributeName = "value";
        }
        if ((referenceElement = annotation2.getNameReferenceElement()) != null && (resolved = referenceElement.resolve()) != null) {
            PsiMethod[] methods2;
            for (PsiMethod method : methods2 = ((PsiClass)resolved).findMethodsByName(attributeName, false)) {
                if (!PsiUtil.isAnnotationMethod(method)) continue;
                return ((PsiAnnotationMethod)method).getDefaultValue();
            }
        }
        return null;
    }

    public static PsiTypeParameter @NotNull [] getTypeParameters(@NotNull PsiTypeParameterListOwner owner) {
        PsiTypeParameterList typeParameterList;
        if (owner == null) {
            PsiImplUtil.$$$reportNull$$$0(4);
        }
        if ((typeParameterList = owner.getTypeParameterList()) != null) {
            PsiTypeParameter[] psiTypeParameterArray = typeParameterList.getTypeParameters();
            if (psiTypeParameterArray == null) {
                PsiImplUtil.$$$reportNull$$$0(5);
            }
            return psiTypeParameterArray;
        }
        if (PsiTypeParameter.EMPTY_ARRAY == null) {
            PsiImplUtil.$$$reportNull$$$0(6);
        }
        return PsiTypeParameter.EMPTY_ARRAY;
    }

    public static PsiJavaCodeReferenceElement @NotNull [] namesToPackageReferences(@NotNull PsiManager manager, String @NotNull [] names2) {
        if (manager == null) {
            PsiImplUtil.$$$reportNull$$$0(7);
        }
        if (names2 == null) {
            PsiImplUtil.$$$reportNull$$$0(8);
        }
        PsiJavaCodeReferenceElement[] refs = new PsiJavaCodeReferenceElement[names2.length];
        for (int i = 0; i < names2.length; ++i) {
            String name2 = names2[i];
            try {
                refs[i] = JavaPsiFacade.getElementFactory(manager.getProject()).createPackageReferenceElement(name2);
                continue;
            }
            catch (IncorrectOperationException e) {
                LOG.error(e);
            }
        }
        if (refs == null) {
            PsiImplUtil.$$$reportNull$$$0(9);
        }
        return refs;
    }

    public static int getParameterIndex(@NotNull PsiParameter parameter2, @NotNull PsiParameterList parameterList2) {
        int i;
        if (parameter2 == null) {
            PsiImplUtil.$$$reportNull$$$0(10);
        }
        if (parameterList2 == null) {
            PsiImplUtil.$$$reportNull$$$0(11);
        }
        PsiElement parameterParent = parameter2.getParent();
        assert (parameterParent == parameterList2) : parameterList2 + "; " + parameterParent;
        PsiParameter[] parameters2 = parameterList2.getParameters();
        for (int i2 = 0; i2 < parameters2.length; ++i2) {
            PsiParameter paramInList = parameters2[i2];
            if (!parameter2.equals(paramInList)) continue;
            return i2;
        }
        String name2 = parameter2.getName();
        PsiParameter suspect = null;
        for (i = parameters2.length - 1; i >= 0; --i) {
            PsiParameter paramInList = parameters2[i];
            if (!Objects.equals(name2, paramInList.getName())) continue;
            suspect = paramInList;
            break;
        }
        String message2 = parameter2 + ":" + parameter2.getClass() + " not found among parameters: " + Arrays.asList(parameters2) + ". parameterList' parent: " + parameterList2.getParent() + "; parameter.isValid()=" + parameter2.isValid() + "; parameterList.isValid()= " + parameterList2.isValid() + "; parameterList stub: " + (parameterList2 instanceof StubBasedPsiElement ? ((StubBasedPsiElement)((Object)parameterList2)).getStub() : "---") + ";  parameter stub: " + (parameter2 instanceof StubBasedPsiElement ? ((StubBasedPsiElement)((Object)parameter2)).getStub() : "---") + "; suspect: " + suspect + " (index=" + i + "); " + (suspect == null ? null : suspect.getClass()) + " suspect stub: " + (suspect instanceof StubBasedPsiElement ? ((StubBasedPsiElement)((Object)suspect)).getStub() : (suspect == null ? "-null-" : "---" + suspect.getClass())) + "; parameter.equals(suspect) = " + parameter2.equals(suspect) + ";  parameter.getNode() == suspect.getNode():  " + (parameter2.getNode() == (suspect == null ? null : suspect.getNode())) + "; .";
        LOG.error(message2);
        return i;
    }

    public static int getTypeParameterIndex(@NotNull PsiTypeParameter typeParameter, @NotNull PsiTypeParameterList typeParameterList) {
        if (typeParameter == null) {
            PsiImplUtil.$$$reportNull$$$0(12);
        }
        if (typeParameterList == null) {
            PsiImplUtil.$$$reportNull$$$0(13);
        }
        PsiTypeParameter[] typeParameters2 = typeParameterList.getTypeParameters();
        for (int i = 0; i < typeParameters2.length; ++i) {
            if (!typeParameter.equals(typeParameters2[i])) continue;
            return i;
        }
        LOG.error(typeParameter + " in " + typeParameterList);
        return -1;
    }

    public static Object @NotNull [] getReferenceVariantsByFilter(@NotNull PsiJavaCodeReferenceElement reference2, @NotNull ElementFilter filter2) {
        if (reference2 == null) {
            PsiImplUtil.$$$reportNull$$$0(14);
        }
        if (filter2 == null) {
            PsiImplUtil.$$$reportNull$$$0(15);
        }
        FilterScopeProcessor processor2 = new FilterScopeProcessor(filter2);
        PsiScopesUtil.resolveAndWalk(processor2, reference2, null, true);
        Object[] objectArray = processor2.getResults().toArray();
        if (objectArray == null) {
            PsiImplUtil.$$$reportNull$$$0(16);
        }
        return objectArray;
    }

    public static boolean processDeclarationsInMethod(@NotNull PsiMethod method, @NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (method == null) {
            PsiImplUtil.$$$reportNull$$$0(17);
        }
        if (processor2 == null) {
            PsiImplUtil.$$$reportNull$$$0(18);
        }
        if (state == null) {
            PsiImplUtil.$$$reportNull$$$0(19);
        }
        if (place == null) {
            PsiImplUtil.$$$reportNull$$$0(20);
        }
        if (lastParent instanceof DummyHolder) {
            lastParent = lastParent.getFirstChild();
        }
        boolean fromBody = lastParent instanceof PsiCodeBlock;
        PsiTypeParameterList typeParameterList = method.getTypeParameterList();
        return PsiImplUtil.processDeclarationsInMethodLike(method, processor2, state, place, fromBody, typeParameterList);
    }

    public static boolean processDeclarationsInLambda(@NotNull PsiLambdaExpression lambda2, @NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        PsiElement firstChild;
        if (lambda2 == null) {
            PsiImplUtil.$$$reportNull$$$0(21);
        }
        if (processor2 == null) {
            PsiImplUtil.$$$reportNull$$$0(22);
        }
        if (state == null) {
            PsiImplUtil.$$$reportNull$$$0(23);
        }
        if (place == null) {
            PsiImplUtil.$$$reportNull$$$0(24);
        }
        boolean fromBody = lastParent instanceof DummyHolder ? (firstChild = lastParent.getFirstChild()) instanceof PsiExpression || firstChild instanceof PsiCodeBlock : lastParent != null && lastParent == lambda2.getBody();
        return PsiImplUtil.processDeclarationsInMethodLike(lambda2, processor2, state, place, fromBody, null);
    }

    private static boolean processDeclarationsInMethodLike(@NotNull PsiParameterListOwner element2, @NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, @NotNull PsiElement place, boolean fromBody, @Nullable PsiTypeParameterList typeParameterList) {
        ElementClassHint hint;
        if (element2 == null) {
            PsiImplUtil.$$$reportNull$$$0(25);
        }
        if (processor2 == null) {
            PsiImplUtil.$$$reportNull$$$0(26);
        }
        if (state == null) {
            PsiImplUtil.$$$reportNull$$$0(27);
        }
        if (place == null) {
            PsiImplUtil.$$$reportNull$$$0(28);
        }
        processor2.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, element2);
        if (typeParameterList != null && ((hint = processor2.getHint(ElementClassHint.KEY)) == null || hint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) && !typeParameterList.processDeclarations(processor2, state, null, place)) {
            return false;
        }
        if (fromBody) {
            PsiParameter[] parameters2;
            for (PsiParameter parameter2 : parameters2 = element2.getParameterList().getParameters()) {
                if (processor2.execute(parameter2, state)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean processDeclarationsInResourceList(@NotNull PsiResourceList resourceList, @NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent) {
        PsiResourceListElement resource;
        ElementClassHint hint;
        if (resourceList == null) {
            PsiImplUtil.$$$reportNull$$$0(29);
        }
        if (processor2 == null) {
            PsiImplUtil.$$$reportNull$$$0(30);
        }
        if (state == null) {
            PsiImplUtil.$$$reportNull$$$0(31);
        }
        if ((hint = processor2.getHint(ElementClassHint.KEY)) != null && !hint.shouldProcess(ElementClassHint.DeclarationKind.VARIABLE)) {
            return true;
        }
        Iterator iterator2 = resourceList.iterator();
        while (iterator2.hasNext() && (resource = (PsiResourceListElement)iterator2.next()) != lastParent) {
            if (!(resource instanceof PsiResourceVariable) || processor2.execute(resource, state)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasTypeParameters(@NotNull PsiTypeParameterListOwner owner) {
        PsiTypeParameterList typeParameterList;
        if (owner == null) {
            PsiImplUtil.$$$reportNull$$$0(32);
        }
        return (typeParameterList = owner.getTypeParameterList()) != null && typeParameterList.getTypeParameters().length != 0;
    }

    public static PsiType @NotNull [] typesByReferenceParameterList(@NotNull PsiReferenceParameterList parameterList2) {
        if (parameterList2 == null) {
            PsiImplUtil.$$$reportNull$$$0(33);
        }
        PsiTypeElement[] typeElements = parameterList2.getTypeParameterElements();
        return PsiImplUtil.typesByTypeElements(typeElements);
    }

    public static PsiType @NotNull [] typesByTypeElements(PsiTypeElement @NotNull [] typeElements) {
        if (typeElements == null) {
            PsiImplUtil.$$$reportNull$$$0(34);
        }
        PsiType[] types2 = PsiType.createArray(typeElements.length);
        for (int i = 0; i < types2.length; ++i) {
            types2[i] = typeElements[i].getType();
        }
        if (types2.length == 1 && types2[0] instanceof PsiDiamondType) {
            PsiType[] psiTypeArray = ((PsiDiamondType)types2[0]).resolveInferredTypes().getTypes();
            if (psiTypeArray == null) {
                PsiImplUtil.$$$reportNull$$$0(35);
            }
            return psiTypeArray;
        }
        if (types2 == null) {
            PsiImplUtil.$$$reportNull$$$0(36);
        }
        return types2;
    }

    @NotNull
    public static PsiType getType(@NotNull PsiClassObjectAccessExpression classAccessExpression) {
        PsiTypeParameter[] typeParameters2;
        if (classAccessExpression == null) {
            PsiImplUtil.$$$reportNull$$$0(37);
        }
        GlobalSearchScope resolveScope2 = classAccessExpression.getResolveScope();
        PsiManager manager = classAccessExpression.getManager();
        PsiClass classClass = JavaPsiFacade.getInstance(manager.getProject()).findClass("java.lang.Class", resolveScope2);
        if (classClass == null) {
            return new PsiClassReferenceType(new LightClassReference(manager, "Class", "java.lang.Class", resolveScope2), null);
        }
        if (!PsiUtil.isLanguageLevel5OrHigher(classAccessExpression)) {
            PsiClassType psiClassType = JavaPsiFacade.getElementFactory(manager.getProject()).createType(classClass);
            if (psiClassType == null) {
                PsiImplUtil.$$$reportNull$$$0(38);
            }
            return psiClassType;
        }
        PsiSubstitutor substitutor2 = PsiSubstitutor.EMPTY;
        PsiType operandType = classAccessExpression.getOperand().getType();
        if (operandType instanceof PsiPrimitiveType && !PsiType.NULL.equals(operandType)) {
            operandType = PsiType.VOID.equals(operandType) ? JavaPsiFacade.getElementFactory(manager.getProject()).createTypeByFQClassName("java.lang.Void", classAccessExpression.getResolveScope()) : ((PsiPrimitiveType)operandType).getBoxedType(classAccessExpression);
        }
        if ((typeParameters2 = classClass.getTypeParameters()).length == 1) {
            substitutor2 = substitutor2.put(typeParameters2[0], operandType instanceof PsiClassType ? ((PsiClassType)operandType).rawType() : operandType);
        }
        return new PsiImmediateClassType(classClass, substitutor2);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiAnnotationOwner annotationOwner, @NotNull String qualifiedName2) {
        if (qualifiedName2 == null) {
            PsiImplUtil.$$$reportNull$$$0(39);
        }
        if (annotationOwner == null) {
            return null;
        }
        PsiAnnotation[] annotations2 = annotationOwner.getAnnotations();
        if (annotations2.length == 0) {
            return null;
        }
        String shortName2 = StringUtil.getShortName(qualifiedName2);
        for (PsiAnnotation annotation2 : annotations2) {
            PsiJavaCodeReferenceElement referenceElement = annotation2.getNameReferenceElement();
            if (referenceElement == null || !shortName2.equals(referenceElement.getReferenceName()) || !qualifiedName2.equals(annotation2.getQualifiedName())) continue;
            return annotation2;
        }
        return null;
    }

    @Nullable
    public static ASTNode findDocComment(@NotNull CompositeElement element2) {
        TreeElement node;
        if (element2 == null) {
            PsiImplUtil.$$$reportNull$$$0(40);
        }
        for (node = element2.getFirstChildNode(); node != null && PsiImplUtil.isWhitespaceOrComment(node) && !(node.getPsi() instanceof PsiDocComment); node = node.getTreeNext()) {
        }
        return node == null || node.getElementType() != JavaDocElementType.DOC_COMMENT ? null : node;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static PsiType normalizeWildcardTypeByPosition(@NotNull PsiType type2, @NotNull PsiExpression expression2) {
        PsiExpression topLevel;
        if (type2 == null) {
            PsiImplUtil.$$$reportNull$$$0(41);
        }
        if (expression2 == null) {
            PsiImplUtil.$$$reportNull$$$0(42);
        }
        PsiUtil.ensureValidType(type2);
        for (topLevel = expression2; topLevel.getParent() instanceof PsiArrayAccessExpression && ((PsiArrayAccessExpression)topLevel.getParent()).getArrayExpression() == topLevel; topLevel = (PsiExpression)topLevel.getParent()) {
        }
        if (topLevel instanceof PsiArrayAccessExpression && !PsiUtil.isAccessedForWriting(topLevel)) {
            return PsiUtil.captureToplevelWildcards(type2, expression2);
        }
        PsiType normalized = PsiImplUtil.doNormalizeWildcardByPosition(type2, expression2, topLevel);
        LOG.assertTrue(normalized.isValid(), type2);
        if (normalized instanceof PsiClassType && !PsiUtil.isAccessedForWriting(topLevel)) {
            return PsiUtil.captureToplevelWildcards(normalized, expression2);
        }
        return normalized;
    }

    private static PsiType doNormalizeWildcardByPosition(PsiType type2, @NotNull PsiExpression expression2, @NotNull PsiExpression topLevel) {
        PsiType componentType;
        PsiType normalizedComponentType;
        if (expression2 == null) {
            PsiImplUtil.$$$reportNull$$$0(43);
        }
        if (topLevel == null) {
            PsiImplUtil.$$$reportNull$$$0(44);
        }
        if (type2 instanceof PsiWildcardType) {
            PsiWildcardType wildcardType = (PsiWildcardType)type2;
            if (PsiUtil.isAccessedForWriting(topLevel)) {
                return wildcardType.isSuper() ? wildcardType.getBound() : PsiCapturedWildcardType.create(wildcardType, expression2);
            }
            if (wildcardType.isExtends()) {
                return wildcardType.getBound();
            }
            return PsiType.getJavaLangObject(expression2.getManager(), expression2.getResolveScope());
        }
        if (type2 instanceof PsiArrayType && (normalizedComponentType = PsiImplUtil.doNormalizeWildcardByPosition(componentType = ((PsiArrayType)type2).getComponentType(), expression2, topLevel)) != componentType) {
            return normalizedComponentType.createArrayType();
        }
        return type2;
    }

    @NotNull
    public static SearchScope getMemberUseScope(@NotNull PsiMember member2) {
        PsiPackage aPackage;
        int accessLevel;
        PsiFile file2;
        if (member2 == null) {
            PsiImplUtil.$$$reportNull$$$0(45);
        }
        NavigatablePsiElement topElement = (file2 = member2.getContainingFile()) == null ? member2 : file2;
        Project project = topElement.getProject();
        GlobalSearchScope maximalUseScope = ResolveScopeManager.getInstance(project).getUseScope(topElement);
        if (PsiImplUtil.isInServerPage(file2)) {
            GlobalSearchScope globalSearchScope = maximalUseScope;
            if (globalSearchScope == null) {
                PsiImplUtil.$$$reportNull$$$0(46);
            }
            return globalSearchScope;
        }
        PsiClass aClass = member2.getContainingClass();
        if (!(!(aClass instanceof PsiAnonymousClass) || aClass instanceof PsiEnumConstantInitializer && member2 instanceof PsiMethod && member2.hasModifierProperty("public") && ((PsiMethod)member2).findSuperMethods().length > 0)) {
            PsiElement[] elements;
            PsiElement scope;
            PsiElement psiElement = scope = PsiUtil.isLanguageLevel8OrHigher(aClass) ? PsiTreeUtil.getTopmostParentOfType(aClass, PsiStatement.class) : PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiMethodCallExpression.class);
            if (scope instanceof PsiDeclarationStatement && (elements = ((PsiDeclarationStatement)scope).getDeclaredElements()).length == 1 && elements[0] instanceof PsiLocalVariable && ((PsiLocalVariable)elements[0]).getTypeElement().isInferredType()) {
                scope = scope.getParent();
            }
            return new LocalSearchScope(scope != null ? scope : aClass);
        }
        PsiModifierList modifierList2 = member2.getModifierList();
        int n = accessLevel = modifierList2 == null ? 4 : PsiUtil.getAccessLevel(modifierList2);
        if (accessLevel == 4 || accessLevel == 3) {
            PsiClass containingClass;
            if (member2 instanceof PsiMethod && ((PsiMethod)member2).isConstructor() && (containingClass = member2.getContainingClass()) != null) {
                SearchScope searchScope = containingClass.getUseScope();
                if (searchScope == null) {
                    PsiImplUtil.$$$reportNull$$$0(47);
                }
                return searchScope;
            }
            GlobalSearchScope globalSearchScope = maximalUseScope;
            if (globalSearchScope == null) {
                PsiImplUtil.$$$reportNull$$$0(48);
            }
            return globalSearchScope;
        }
        if (accessLevel == 1) {
            PsiClass topClass = PsiUtil.getTopLevelClass(member2);
            return topClass != null ? new LocalSearchScope(topClass) : (file2 == null ? maximalUseScope : new LocalSearchScope(file2));
        }
        if (file2 instanceof PsiJavaFile && (aPackage = JavaPsiFacade.getInstance(project).findPackage(((PsiJavaFile)file2).getPackageName())) != null) {
            GlobalSearchScope scope = PackageScope.packageScope(aPackage, false);
            SearchScope searchScope = ((SearchScope)scope).intersectWith(maximalUseScope);
            if (searchScope == null) {
                PsiImplUtil.$$$reportNull$$$0(49);
            }
            return searchScope;
        }
        GlobalSearchScope globalSearchScope = maximalUseScope;
        if (globalSearchScope == null) {
            PsiImplUtil.$$$reportNull$$$0(50);
        }
        return globalSearchScope;
    }

    public static boolean isInServerPage(@Nullable PsiElement element2) {
        return PsiImplUtil.getServerPageFile(element2) != null;
    }

    @Nullable
    private static ServerPageFile getServerPageFile(PsiElement element2) {
        PsiFile psiFile = PsiUtilCore.getTemplateLanguageFile(element2);
        return psiFile instanceof ServerPageFile ? (ServerPageFile)psiFile : null;
    }

    public static PsiElement setName(@NotNull PsiElement element2, @NotNull String name2) throws IncorrectOperationException {
        if (element2 == null) {
            PsiImplUtil.$$$reportNull$$$0(51);
        }
        if (name2 == null) {
            PsiImplUtil.$$$reportNull$$$0(52);
        }
        PsiManager manager = element2.getManager();
        PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(manager.getProject());
        PsiIdentifier newNameIdentifier = factory2.createIdentifier(name2);
        return element2.replace(newNameIdentifier);
    }

    public static boolean isDeprecatedByAnnotation(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            PsiImplUtil.$$$reportNull$$$0(53);
        }
        return AnnotationUtil.findAnnotation(owner, "java.lang.Deprecated") != null;
    }

    public static boolean isDeprecatedByDocTag(@NotNull PsiJavaDocumentedElement owner) {
        PsiDocComment docComment;
        if (owner == null) {
            PsiImplUtil.$$$reportNull$$$0(54);
        }
        return (docComment = owner.getDocComment()) != null && docComment.findTagByName("deprecated") != null;
    }

    public static boolean isDeprecated(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            PsiImplUtil.$$$reportNull$$$0(55);
        }
        if (psiElement instanceof PsiDocCommentOwner) {
            return ((PsiDocCommentOwner)psiElement).isDeprecated();
        }
        if (psiElement instanceof PsiModifierListOwner && PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)psiElement)) {
            return true;
        }
        if (psiElement instanceof PsiJavaDocumentedElement) {
            return PsiImplUtil.isDeprecatedByDocTag((PsiJavaDocumentedElement)psiElement);
        }
        return false;
    }

    @Nullable
    public static PsiJavaDocumentedElement findDocCommentOwner(@NotNull PsiDocComment comment) {
        PsiJavaDocumentedElement owner;
        PsiElement parent2;
        if (comment == null) {
            PsiImplUtil.$$$reportNull$$$0(56);
        }
        if ((parent2 = comment.getParent()) instanceof PsiJavaDocumentedElement && (owner = (PsiJavaDocumentedElement)parent2).getDocComment() == comment) {
            return owner;
        }
        return null;
    }

    @Nullable
    public static PsiAnnotationMemberValue setDeclaredAttributeValue(@NotNull PsiAnnotation psiAnnotation, @Nullable String attributeName, @Nullable PsiAnnotationMemberValue value2, @NotNull PairFunction<? super Project, ? super String, ? extends PsiAnnotation> annotationCreator) {
        if (psiAnnotation == null) {
            PsiImplUtil.$$$reportNull$$$0(57);
        }
        if (annotationCreator == null) {
            PsiImplUtil.$$$reportNull$$$0(58);
        }
        PsiAnnotationMemberValue existing = psiAnnotation.findDeclaredAttributeValue(attributeName);
        if (value2 == null) {
            if (existing == null) {
                return null;
            }
            existing.getParent().delete();
        } else if (existing != null) {
            ((PsiNameValuePair)existing.getParent()).setValue(value2);
        } else {
            PsiNameValuePair attribute;
            PsiNameValuePair[] attributes2 = psiAnnotation.getParameterList().getAttributes();
            if (attributes2.length == 1 && (attribute = attributes2[0]).getName() == null) {
                PsiAnnotationMemberValue defValue = attribute.getValue();
                assert (defValue != null) : attribute;
                attribute.replace(PsiImplUtil.createNameValuePair(defValue, "value=", annotationCreator));
            }
            boolean allowNoName = attributes2.length == 0 && ("value".equals(attributeName) || null == attributeName);
            String namePrefix = allowNoName ? "" : attributeName + "=";
            psiAnnotation.getParameterList().addBefore(PsiImplUtil.createNameValuePair(value2, namePrefix, annotationCreator), null);
        }
        return psiAnnotation.findDeclaredAttributeValue(attributeName);
    }

    private static PsiNameValuePair createNameValuePair(@NotNull PsiAnnotationMemberValue value2, @NotNull String namePrefix, @NotNull PairFunction<? super Project, ? super String, ? extends PsiAnnotation> annotationCreator) {
        if (value2 == null) {
            PsiImplUtil.$$$reportNull$$$0(59);
        }
        if (namePrefix == null) {
            PsiImplUtil.$$$reportNull$$$0(60);
        }
        if (annotationCreator == null) {
            PsiImplUtil.$$$reportNull$$$0(61);
        }
        return annotationCreator.fun(value2.getProject(), "@A(" + namePrefix + value2.getText() + ")").getParameterList().getAttributes()[0];
    }

    @Nullable
    public static ASTNode skipWhitespaceAndComments(ASTNode node) {
        return TreeUtil.skipWhitespaceAndComments(node, true);
    }

    @Nullable
    public static ASTNode skipWhitespaceCommentsAndTokens(ASTNode node, @NotNull TokenSet alsoSkip) {
        if (alsoSkip == null) {
            PsiImplUtil.$$$reportNull$$$0(62);
        }
        return TreeUtil.skipWhitespaceCommentsAndTokens(node, alsoSkip, true);
    }

    public static boolean isWhitespaceOrComment(ASTNode element2) {
        return TreeUtil.isWhitespaceOrComment(element2);
    }

    @Nullable
    public static ASTNode skipWhitespaceAndCommentsBack(ASTNode node) {
        if (node == null) {
            return null;
        }
        if (!PsiImplUtil.isWhitespaceOrComment(node)) {
            return node;
        }
        ASTNode parent2 = node.getTreeParent();
        ASTNode prev = node;
        while (prev instanceof CompositeElement) {
            if (!PsiImplUtil.isWhitespaceOrComment(prev)) {
                return prev;
            }
            prev = prev.getTreePrev();
        }
        if (prev == null) {
            return null;
        }
        ASTNode lastRelevant = null;
        for (ASTNode firstChildNode = parent2.getFirstChildNode(); firstChildNode != prev; firstChildNode = firstChildNode.getTreeNext()) {
            if (PsiImplUtil.isWhitespaceOrComment(firstChildNode)) continue;
            lastRelevant = firstChildNode;
        }
        return lastRelevant;
    }

    @Nullable
    public static ASTNode findStatementChild(@NotNull CompositePsiElement statement2) {
        if (statement2 == null) {
            PsiImplUtil.$$$reportNull$$$0(63);
        }
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        for (ASTNode element2 = statement2.getFirstChildNode(); element2 != null; element2 = element2.getTreeNext()) {
            if (!(element2.getPsi() instanceof PsiStatement)) continue;
            return element2;
        }
        return null;
    }

    public static PsiStatement @NotNull [] getChildStatements(@NotNull CompositeElement psiCodeBlock) {
        if (psiCodeBlock == null) {
            PsiImplUtil.$$$reportNull$$$0(64);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int count = 0;
        for (ASTNode child1 = psiCodeBlock.getFirstChildNode(); child1 != null; child1 = child1.getTreeNext()) {
            if (!(child1.getPsi() instanceof PsiStatement)) continue;
            ++count;
        }
        PsiStatement[] result2 = PsiStatement.ARRAY_FACTORY.create(count);
        if (count == 0) {
            if (result2 == null) {
                PsiImplUtil.$$$reportNull$$$0(65);
            }
            return result2;
        }
        int idx = 0;
        for (ASTNode child = psiCodeBlock.getFirstChildNode(); child != null && idx < count; child = child.getTreeNext()) {
            PsiElement element2 = child.getPsi();
            if (!(element2 instanceof PsiStatement)) continue;
            result2[idx++] = (PsiStatement)element2;
        }
        if (result2 == null) {
            PsiImplUtil.$$$reportNull$$$0(66);
        }
        return result2;
    }

    public static boolean isVarArgs(@NotNull PsiMethod method) {
        PsiParameter[] parameters2;
        if (method == null) {
            PsiImplUtil.$$$reportNull$$$0(67);
        }
        return (parameters2 = method.getParameterList().getParameters()).length > 0 && parameters2[parameters2.length - 1].isVarArgs();
    }

    public static PsiElement handleMirror(PsiElement element2) {
        return element2 instanceof PsiMirrorElement ? ((PsiMirrorElement)element2).getPrototype() : element2;
    }

    @Nullable
    public static PsiModifierList findNeighbourModifierList(@NotNull PsiJavaCodeReferenceElement ref) {
        PsiElement grandParent;
        PsiElement parent2;
        if (ref == null) {
            PsiImplUtil.$$$reportNull$$$0(68);
        }
        if ((parent2 = PsiTreeUtil.skipParentsOfType(ref, PsiJavaCodeReferenceElement.class)) instanceof PsiTypeElement && (grandParent = parent2.getParent()) instanceof PsiModifierListOwner) {
            return ((PsiModifierListOwner)grandParent).getModifierList();
        }
        return null;
    }

    public static boolean isTypeAnnotation(@Nullable PsiElement element2) {
        return element2 instanceof PsiAnnotation && AnnotationTargetUtil.isTypeAnnotation((PsiAnnotation)element2);
    }

    public static void collectTypeUseAnnotations(@NotNull PsiModifierList modifierList2, @NotNull List<? super PsiAnnotation> annotations2) {
        if (modifierList2 == null) {
            PsiImplUtil.$$$reportNull$$$0(69);
        }
        if (annotations2 == null) {
            PsiImplUtil.$$$reportNull$$$0(70);
        }
        AnnotationTargetUtil.collectStrictlyTypeUseAnnotations(modifierList2, annotations2);
    }

    public static void markTypeAnnotations(@NotNull PsiTypeElement typeElement) {
        PsiElement left;
        if (typeElement == null) {
            PsiImplUtil.$$$reportNull$$$0(71);
        }
        if ((left = PsiTreeUtil.skipSiblingsBackward(typeElement, PsiComment.class, PsiWhiteSpace.class, PsiTypeParameterList.class)) instanceof PsiModifierList) {
            for (PsiAnnotation annotation2 : ((PsiModifierList)left).getAnnotations()) {
                if (!AnnotationTargetUtil.isTypeAnnotation(annotation2)) continue;
                annotation2.putUserData(TYPE_ANNO_MARK, Boolean.TRUE);
            }
        }
    }

    public static void deleteTypeAnnotations(@NotNull PsiTypeElement typeElement) {
        PsiElement left;
        if (typeElement == null) {
            PsiImplUtil.$$$reportNull$$$0(72);
        }
        if ((left = PsiTreeUtil.skipSiblingsBackward(typeElement, PsiComment.class, PsiWhiteSpace.class, PsiTypeParameterList.class)) instanceof PsiModifierList) {
            for (PsiAnnotation annotation2 : ((PsiModifierList)left).getAnnotations()) {
                if (TYPE_ANNO_MARK.get(annotation2) != Boolean.TRUE) continue;
                annotation2.delete();
            }
        }
    }

    @Nullable
    public static PsiLoopStatement findEnclosingLoop(@NotNull PsiElement start) {
        if (start == null) {
            PsiImplUtil.$$$reportNull$$$0(73);
        }
        PsiElement e = start;
        while (!PsiImplUtil.isCodeBoundary(e)) {
            if (e instanceof PsiLoopStatement) {
                return (PsiLoopStatement)e;
            }
            e = e.getParent();
        }
        return null;
    }

    @Nullable
    public static PsiStatement findEnclosingSwitchOrLoop(@NotNull PsiElement start) {
        if (start == null) {
            PsiImplUtil.$$$reportNull$$$0(74);
        }
        PsiElement e = start;
        while (!PsiImplUtil.isCodeBoundary(e)) {
            if (e instanceof PsiSwitchStatement || e instanceof PsiLoopStatement) {
                return (PsiStatement)e;
            }
            e = e.getParent();
        }
        return null;
    }

    @Nullable
    public static PsiSwitchExpression findEnclosingSwitchExpression(@NotNull PsiElement start) {
        if (start == null) {
            PsiImplUtil.$$$reportNull$$$0(75);
        }
        PsiElement e = start;
        while (!PsiImplUtil.isCodeBoundary(e)) {
            if (e instanceof PsiSwitchExpression) {
                return (PsiSwitchExpression)e;
            }
            e = e.getParent();
        }
        return null;
    }

    @Nullable
    public static PsiLabeledStatement findEnclosingLabeledStatement(@NotNull PsiElement start, @NotNull String label) {
        if (start == null) {
            PsiImplUtil.$$$reportNull$$$0(76);
        }
        if (label == null) {
            PsiImplUtil.$$$reportNull$$$0(77);
        }
        PsiElement e = start;
        while (!PsiImplUtil.isCodeBoundary(e)) {
            if (e instanceof PsiLabeledStatement && label.equals(((PsiLabeledStatement)e).getName())) {
                return (PsiLabeledStatement)e;
            }
            e = e.getParent();
        }
        return null;
    }

    @NotNull
    public static List<String> findAllEnclosingLabels(@NotNull PsiElement start) {
        if (start == null) {
            PsiImplUtil.$$$reportNull$$$0(78);
        }
        SmartList<String> result2 = new SmartList<String>();
        PsiElement context2 = start;
        while (!PsiImplUtil.isCodeBoundary(context2)) {
            if (context2 instanceof PsiLabeledStatement) {
                result2.add(((PsiLabeledStatement)context2).getName());
            }
            context2 = context2.getContext();
        }
        SmartList<String> smartList = result2;
        if (smartList == null) {
            PsiImplUtil.$$$reportNull$$$0(79);
        }
        return smartList;
    }

    private static boolean isCodeBoundary(@Nullable PsiElement e) {
        return e == null || e instanceof PsiMethod || e instanceof PsiClassInitializer || e instanceof PsiLambdaExpression;
    }

    @Nullable
    public static PsiSwitchLabelStatementBase getSwitchLabel(@NotNull PsiCaseLabelElement labelElement) {
        PsiElement grand;
        PsiElement parent2;
        if (labelElement == null) {
            PsiImplUtil.$$$reportNull$$$0(80);
        }
        PsiElement psiElement = parent2 = labelElement instanceof PsiParenthesizedPattern ? JavaPsiPatternUtil.skipParenthesizedPatternUp(labelElement.getParent()) : PsiUtil.skipParenthesizedExprUp(labelElement.getParent());
        if (parent2 instanceof PsiCaseLabelElementList && (grand = parent2.getParent()) instanceof PsiSwitchLabelStatementBase) {
            return (PsiSwitchLabelStatementBase)grand;
        }
        return null;
    }

    public static boolean isLeafElementOfType(@Nullable PsiElement element2, @NotNull IElementType type2) {
        if (type2 == null) {
            PsiImplUtil.$$$reportNull$$$0(81);
        }
        return element2 instanceof LeafElement && ((LeafElement)((Object)element2)).getElementType() == type2;
    }

    public static boolean isLeafElementOfType(PsiElement element2, @NotNull TokenSet tokenSet) {
        if (tokenSet == null) {
            PsiImplUtil.$$$reportNull$$$0(82);
        }
        return element2 instanceof LeafElement && tokenSet.contains(((LeafElement)((Object)element2)).getElementType());
    }

    public static PsiType buildTypeFromTypeString(@NotNull String typeName, @NotNull PsiElement context2, @NotNull PsiFile psiFile) {
        PsiClassType resultType2;
        PsiClass aClass;
        if (typeName == null) {
            PsiImplUtil.$$$reportNull$$$0(83);
        }
        if (context2 == null) {
            PsiImplUtil.$$$reportNull$$$0(84);
        }
        if (psiFile == null) {
            PsiImplUtil.$$$reportNull$$$0(85);
        }
        PsiManager psiManager2 = psiFile.getManager();
        if (typeName.indexOf(60) != -1 || typeName.indexOf(91) != -1 || typeName.indexOf(46) == -1) {
            try {
                return JavaPsiFacade.getElementFactory(psiManager2.getProject()).createTypeFromText(typeName, context2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((aClass = JavaPsiFacade.getInstance(psiManager2.getProject()).findClass(typeName, context2.getResolveScope())) == null) {
            LightClassReference ref = new LightClassReference(psiManager2, PsiNameHelper.getShortClassName(typeName), typeName, PsiSubstitutor.EMPTY, psiFile);
            resultType2 = new PsiClassReferenceType(ref, null);
        } else {
            PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(psiManager2.getProject());
            PsiSubstitutor substitutor2 = factory2.createRawSubstitutor(aClass);
            resultType2 = factory2.createType(aClass, substitutor2);
        }
        return resultType2;
    }

    public static <T extends PsiJavaCodeReferenceElement> JavaResolveResult @NotNull [] multiResolveImpl(@NotNull T element2, boolean incompleteCode, @NotNull ResolveCache.PolyVariantContextResolver<? super T> resolver2) {
        FileASTNode fileElement;
        if (element2 == null) {
            PsiImplUtil.$$$reportNull$$$0(86);
        }
        if (resolver2 == null) {
            PsiImplUtil.$$$reportNull$$$0(87);
        }
        if ((fileElement = SharedImplUtil.findFileElement(element2.getNode())) == null) {
            PsiUtilCore.ensureValid(element2);
            LOG.error("fileElement == null!");
            if (JavaResolveResult.EMPTY_ARRAY == null) {
                PsiImplUtil.$$$reportNull$$$0(88);
            }
            return JavaResolveResult.EMPTY_ARRAY;
        }
        PsiFile psiFile = SharedImplUtil.getContainingFile(fileElement);
        return PsiImplUtil.multiResolveImpl(element2, psiFile, incompleteCode, resolver2);
    }

    @NotNull
    public static <T extends PsiJavaCodeReferenceElement> @NotNull JavaResolveResult @NotNull [] multiResolveImpl(@NotNull T element2, PsiFile psiFile, boolean incompleteCode, @NotNull ResolveCache.PolyVariantContextResolver<? super T> resolver2) {
        PsiManager manager;
        if (element2 == null) {
            PsiImplUtil.$$$reportNull$$$0(89);
        }
        if (resolver2 == null) {
            PsiImplUtil.$$$reportNull$$$0(90);
        }
        PsiManager psiManager2 = manager = psiFile == null ? null : psiFile.getManager();
        if (manager == null) {
            PsiUtilCore.ensureValid(element2);
            LOG.error("getManager() == null!");
            if (JavaResolveResult.EMPTY_ARRAY == null) {
                PsiImplUtil.$$$reportNull$$$0(91);
            }
            return JavaResolveResult.EMPTY_ARRAY;
        }
        boolean valid = psiFile.isValid();
        if (!valid) {
            PsiUtilCore.ensureValid(element2);
            LOG.error("psiFile.isValid() == false!");
            if (JavaResolveResult.EMPTY_ARRAY == null) {
                PsiImplUtil.$$$reportNull$$$0(92);
            }
            return JavaResolveResult.EMPTY_ARRAY;
        }
        if (element2 instanceof PsiMethodReferenceExpression && ThreadLocalTypes.hasBindingFor(element2)) {
            JavaResolveResult[] javaResolveResultArray = (JavaResolveResult[])resolver2.resolve(element2, psiFile, incompleteCode);
            if (javaResolveResultArray == null) {
                PsiImplUtil.$$$reportNull$$$0(93);
            }
            return javaResolveResultArray;
        }
        return PsiImplUtil.multiResolveImpl(manager.getProject(), psiFile, element2, incompleteCode, resolver2);
    }

    public static <T extends PsiJavaCodeReferenceElement> JavaResolveResult @NotNull [] multiResolveImpl(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull T element2, boolean incompleteCode, @NotNull ResolveCache.PolyVariantContextResolver<? super T> resolver2) {
        ResolveResult[] results;
        if (project == null) {
            PsiImplUtil.$$$reportNull$$$0(94);
        }
        if (psiFile == null) {
            PsiImplUtil.$$$reportNull$$$0(95);
        }
        if (element2 == null) {
            PsiImplUtil.$$$reportNull$$$0(96);
        }
        if (resolver2 == null) {
            PsiImplUtil.$$$reportNull$$$0(97);
        }
        JavaResolveResult[] javaResolveResultArray = (results = ResolveCache.getInstance(project).resolveWithCaching(element2, resolver2, true, incompleteCode, psiFile)).length == 0 ? JavaResolveResult.EMPTY_ARRAY : (JavaResolveResult[])results;
        if (javaResolveResultArray == null) {
            PsiImplUtil.$$$reportNull$$$0(98);
        }
        return javaResolveResultArray;
    }

    @NotNull
    public static VirtualFile getModuleVirtualFile(@NotNull PsiJavaModule module2) {
        if (module2 == null) {
            PsiImplUtil.$$$reportNull$$$0(99);
        }
        if (module2 instanceof LightJavaModule) {
            VirtualFile virtualFile2 = ((LightJavaModule)module2).getRootVirtualFile();
            if (virtualFile2 == null) {
                PsiImplUtil.$$$reportNull$$$0(100);
            }
            return virtualFile2;
        }
        VirtualFile file2 = PsiUtilCore.getVirtualFile(module2);
        if (file2 == null) {
            throw new IllegalArgumentException("Module '" + module2 + "' lost its VF; file=" + module2.getContainingFile() + "; valid=" + module2.isValid());
        }
        VirtualFile virtualFile3 = file2;
        if (virtualFile3 == null) {
            PsiImplUtil.$$$reportNull$$$0(101);
        }
        return virtualFile3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 9: 
            case 16: 
            case 35: 
            case 36: 
            case 38: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 65: 
            case 66: 
            case 79: 
            case 88: 
            case 91: 
            case 92: 
            case 93: 
            case 98: 
            case 100: 
            case 101: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 9: 
            case 16: 
            case 35: 
            case 36: 
            case 38: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 65: 
            case 66: 
            case 79: 
            case 88: 
            case 91: 
            case 92: 
            case 93: 
            case 98: 
            case 100: 
            case 101: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 9: 
            case 16: 
            case 35: 
            case 36: 
            case 38: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 65: 
            case 66: 
            case 79: 
            case 88: 
            case 91: 
            case 92: 
            case 93: 
            case 98: 
            case 100: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/impl/PsiImplUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 4: 
            case 32: 
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 11: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameterList";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 17: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 18: 
            case 22: 
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 19: 
            case 23: 
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 20: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambda";
                break;
            }
            case 25: 
            case 40: 
            case 51: 
            case 86: 
            case 89: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceList";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElements";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classAccessExpression";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 41: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topLevel";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 58: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationCreator";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namePrefix";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alsoSkip";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiCodeBlock";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierList";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 71: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelElement";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenSet";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 85: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 87: 
            case 90: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/impl/PsiImplUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructors";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameters";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "namesToPackageReferences";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceVariantsByFilter";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "typesByTypeElements";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberUseScope";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildStatements";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllEnclosingLabels";
                break;
            }
            case 88: 
            case 91: 
            case 92: 
            case 93: 
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveImpl";
                break;
            }
            case 100: 
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleVirtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getConstructors";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 9: 
            case 16: 
            case 35: 
            case 36: 
            case 38: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 65: 
            case 66: 
            case 79: 
            case 88: 
            case 91: 
            case 92: 
            case 93: 
            case 98: 
            case 100: 
            case 101: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findDeclaredAttributeValue";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findAttributeValue";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParameters";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "namesToPackageReferences";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getParameterIndex";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParameterIndex";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceVariantsByFilter";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsInMethod";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsInLambda";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsInMethodLike";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsInResourceList";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "hasTypeParameters";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "typesByReferenceParameterList";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "typesByTypeElements";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotation";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "findDocComment";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "normalizeWildcardTypeByPosition";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "doNormalizeWildcardByPosition";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getMemberUseScope";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "isDeprecatedByAnnotation";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "isDeprecatedByDocTag";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isDeprecated";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "findDocCommentOwner";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "setDeclaredAttributeValue";
                break;
            }
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "createNameValuePair";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "skipWhitespaceCommentsAndTokens";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "findStatementChild";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getChildStatements";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "isVarArgs";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "findNeighbourModifierList";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "collectTypeUseAnnotations";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "markTypeAnnotations";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "deleteTypeAnnotations";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "findEnclosingLoop";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "findEnclosingSwitchOrLoop";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "findEnclosingSwitchExpression";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "findEnclosingLabeledStatement";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "findAllEnclosingLabels";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "getSwitchLabel";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "isLeafElementOfType";
                break;
            }
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeFromTypeString";
                break;
            }
            case 86: 
            case 87: 
            case 89: 
            case 90: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveImpl";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "getModuleVirtualFile";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 9: 
            case 16: 
            case 35: 
            case 36: 
            case 38: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 65: 
            case 66: 
            case 79: 
            case 88: 
            case 91: 
            case 92: 
            case 93: 
            case 98: 
            case 100: 
            case 101: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

