/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.util.NlsSafe;
import ksp.com.intellij.openapi.util.text.StringUtil;
import ksp.com.intellij.pom.java.LanguageLevel;
import ksp.com.intellij.psi.PsiAnnotation;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiJavaCodeReferenceElement;
import ksp.com.intellij.psi.PsiType;
import ksp.com.intellij.psi.util.PsiUtil;
import ksp.com.intellij.util.ArrayUtilRt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiNameHelper {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("(?:\\s)|(?:/\\*.*\\*/)|(?://[^\\n]*)");

    public static PsiNameHelper getInstance(Project project) {
        return project.getService(PsiNameHelper.class);
    }

    public abstract boolean isIdentifier(@Nullable String var1);

    public abstract boolean isIdentifier(@Nullable String var1, @NotNull LanguageLevel var2);

    public abstract boolean isKeyword(@Nullable String var1);

    public abstract boolean isQualifiedName(@Nullable String var1);

    @NotNull
    @NlsSafe
    public static String getShortClassName(@NotNull String referenceText) {
        int i;
        if (referenceText == null) {
            PsiNameHelper.$$$reportNull$$$0(0);
        }
        int lessPos = referenceText.length();
        int bracesBalance = 0;
        block5: for (i = referenceText.length() - 1; i >= 0; --i) {
            char ch = referenceText.charAt(i);
            switch (ch) {
                case ')': 
                case '>': {
                    ++bracesBalance;
                    continue block5;
                }
                case '(': 
                case '<': {
                    --bracesBalance;
                    lessPos = i;
                    continue block5;
                }
                case '.': 
                case '@': {
                    if (bracesBalance > 0) continue block5;
                    break block5;
                }
                default: {
                    if (!Character.isWhitespace(ch) || bracesBalance > 0) continue block5;
                    for (int j = i + 1; j < lessPos; ++j) {
                        if (!Character.isWhitespace(referenceText.charAt(j))) break block5;
                    }
                    lessPos = i;
                }
            }
        }
        String string2 = referenceText.substring(i + 1, lessPos).trim();
        if (string2 == null) {
            PsiNameHelper.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @NotNull
    public static String getPresentableText(@NotNull PsiJavaCodeReferenceElement ref) {
        if (ref == null) {
            PsiNameHelper.$$$reportNull$$$0(2);
        }
        String name2 = ref.getReferenceName();
        PsiType[] types2 = ref.getTypeParameters();
        if (types2.length == 0) {
            return name2 != null ? name2 : "";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(name2);
        PsiNameHelper.appendTypeArgs(buffer, types2, false, false);
        String string2 = buffer.toString();
        if (string2 == null) {
            PsiNameHelper.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @NotNull
    public static String getPresentableText(@Nullable String refName, PsiAnnotation @NotNull [] annotations2, PsiType @NotNull [] types2) {
        if (annotations2 == null) {
            PsiNameHelper.$$$reportNull$$$0(4);
        }
        if (types2 == null) {
            PsiNameHelper.$$$reportNull$$$0(5);
        }
        if (types2.length == 0 && annotations2.length == 0) {
            return refName != null ? refName : "";
        }
        StringBuilder buffer = new StringBuilder();
        PsiNameHelper.appendAnnotations(buffer, annotations2, false);
        buffer.append(refName);
        PsiNameHelper.appendTypeArgs(buffer, types2, false, true);
        String string2 = buffer.toString();
        if (string2 == null) {
            PsiNameHelper.$$$reportNull$$$0(6);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String getOuterClassReference(String referenceText) {
        int stack = 0;
        block5: for (int i = referenceText.length() - 1; i >= 0; --i) {
            char c = referenceText.charAt(i);
            switch (c) {
                case '<': {
                    --stack;
                    continue block5;
                }
                case '>': {
                    ++stack;
                    continue block5;
                }
                case '.': {
                    if (stack != 0) continue block5;
                    String string2 = referenceText.substring(0, i);
                    if (string2 == null) {
                        PsiNameHelper.$$$reportNull$$$0(7);
                    }
                    return string2;
                }
            }
        }
        return "";
    }

    @Contract(pure=true)
    @NotNull
    public static String getQualifiedClassName(@NotNull String referenceText, boolean removeWhitespace) {
        if (referenceText == null) {
            PsiNameHelper.$$$reportNull$$$0(8);
        }
        if (removeWhitespace) {
            referenceText = PsiNameHelper.removeWhitespace(referenceText);
        }
        if (referenceText.indexOf(60) < 0) {
            String string2 = referenceText;
            if (string2 == null) {
                PsiNameHelper.$$$reportNull$$$0(9);
            }
            return string2;
        }
        StringBuilder buffer = new StringBuilder(referenceText.length());
        char[] chars = referenceText.toCharArray();
        int gtPos = 0;
        int count = 0;
        block4: for (int i = 0; i < chars.length; ++i) {
            char aChar = chars[i];
            switch (aChar) {
                case '<': {
                    if (++count != 1) continue block4;
                    buffer.append(new String(chars, gtPos, i - gtPos));
                    continue block4;
                }
                case '>': {
                    --count;
                    gtPos = i + 1;
                }
            }
        }
        if (count == 0) {
            buffer.append(new String(chars, gtPos, chars.length - gtPos));
        }
        String string3 = buffer.toString();
        if (string3 == null) {
            PsiNameHelper.$$$reportNull$$$0(10);
        }
        return string3;
    }

    @NotNull
    private static String removeWhitespace(@NotNull String referenceText) {
        if (referenceText == null) {
            PsiNameHelper.$$$reportNull$$$0(11);
        }
        boolean needsChange = false;
        for (int i = 0; i < referenceText.length(); ++i) {
            char c = referenceText.charAt(i);
            if (c != '/' && !Character.isWhitespace(c)) continue;
            needsChange = true;
            break;
        }
        if (!needsChange) {
            String string2 = referenceText;
            if (string2 == null) {
                PsiNameHelper.$$$reportNull$$$0(12);
            }
            return string2;
        }
        String string3 = WHITESPACE_PATTERN.matcher(referenceText).replaceAll("");
        if (string3 == null) {
            PsiNameHelper.$$$reportNull$$$0(13);
        }
        return string3;
    }

    public static String @NotNull [] getClassParametersText(@NotNull String referenceText) {
        if (referenceText == null) {
            PsiNameHelper.$$$reportNull$$$0(14);
        }
        if (referenceText.indexOf(60) < 0) {
            if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
                PsiNameHelper.$$$reportNull$$$0(15);
            }
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        char[] chars = referenceText.toCharArray();
        int afterLastDotIndex = 0;
        int level = 0;
        block15: for (int i = 0; i < chars.length; ++i) {
            char aChar = chars[i];
            switch (aChar) {
                case '<': {
                    ++level;
                    continue block15;
                }
                case '.': {
                    if (level != 0) continue block15;
                    afterLastDotIndex = i + 1;
                    continue block15;
                }
                case '>': {
                    --level;
                }
            }
        }
        if (level != 0) {
            if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
                PsiNameHelper.$$$reportNull$$$0(16);
            }
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        int dim = 0;
        block16: for (int i = afterLastDotIndex; i < chars.length; ++i) {
            char aChar = chars[i];
            switch (aChar) {
                case '<': {
                    if (++level != 1) continue block16;
                    ++dim;
                    continue block16;
                }
                case ',': {
                    if (level != 1) continue block16;
                    ++dim;
                    continue block16;
                }
                case '>': {
                    --level;
                }
            }
        }
        if (level != 0 || dim == 0) {
            if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
                PsiNameHelper.$$$reportNull$$$0(17);
            }
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        String[] result2 = new String[dim];
        dim = 0;
        int ltPos = 0;
        block17: for (int i = afterLastDotIndex; i < chars.length; ++i) {
            char aChar = chars[i];
            switch (aChar) {
                case '<': {
                    if (++level != 1) continue block17;
                    ltPos = i;
                    continue block17;
                }
                case ',': {
                    if (level != 1) continue block17;
                    result2[dim++] = new String(chars, ltPos + 1, i - ltPos - 1);
                    ltPos = i;
                    continue block17;
                }
                case '>': {
                    if (--level != 0) continue block17;
                    result2[dim++] = new String(chars, ltPos + 1, i - ltPos - 1);
                }
            }
        }
        if (result2 == null) {
            PsiNameHelper.$$$reportNull$$$0(18);
        }
        return result2;
    }

    public static boolean isSubpackageOf(@NotNull String subpackageName, @NotNull String packageName2) {
        if (subpackageName == null) {
            PsiNameHelper.$$$reportNull$$$0(19);
        }
        if (packageName2 == null) {
            PsiNameHelper.$$$reportNull$$$0(20);
        }
        return subpackageName.equals(packageName2) || subpackageName.startsWith(packageName2) && subpackageName.charAt(packageName2.length()) == '.';
    }

    public static void appendTypeArgs(@NotNull StringBuilder sb, PsiType @NotNull [] types2, boolean canonical, boolean annotated) {
        if (sb == null) {
            PsiNameHelper.$$$reportNull$$$0(21);
        }
        if (types2 == null) {
            PsiNameHelper.$$$reportNull$$$0(22);
        }
        if (types2.length == 0) {
            return;
        }
        sb.append('<');
        for (int i = 0; i < types2.length; ++i) {
            if (i > 0) {
                sb.append(canonical ? "," : ", ");
            }
            PsiType type2 = types2[i];
            if (canonical) {
                sb.append(type2.getCanonicalText(annotated));
                continue;
            }
            sb.append(type2.getPresentableText(annotated));
        }
        sb.append('>');
    }

    public static boolean appendAnnotations(@NotNull StringBuilder sb, PsiAnnotation @NotNull [] annotations2, boolean canonical) {
        if (sb == null) {
            PsiNameHelper.$$$reportNull$$$0(23);
        }
        if (annotations2 == null) {
            PsiNameHelper.$$$reportNull$$$0(24);
        }
        return PsiNameHelper.appendAnnotations(sb, Arrays.asList(annotations2), canonical);
    }

    public static boolean appendAnnotations(@NotNull StringBuilder sb, @NotNull List<? extends PsiAnnotation> annotations2, boolean canonical) {
        if (sb == null) {
            PsiNameHelper.$$$reportNull$$$0(25);
        }
        if (annotations2 == null) {
            PsiNameHelper.$$$reportNull$$$0(26);
        }
        boolean updated = false;
        for (PsiAnnotation psiAnnotation : annotations2) {
            if (canonical) {
                String name2 = psiAnnotation.getQualifiedName();
                if (name2 == null) continue;
                sb.append('@').append(name2).append(psiAnnotation.getParameterList().getText()).append(' ');
                updated = true;
                continue;
            }
            PsiJavaCodeReferenceElement refElement = psiAnnotation.getNameReferenceElement();
            if (refElement == null) continue;
            sb.append('@').append(refElement.getText()).append(' ');
            updated = true;
        }
        return updated;
    }

    public static boolean isValidModuleName(@NotNull String name2, @NotNull PsiElement context2) {
        if (name2 == null) {
            PsiNameHelper.$$$reportNull$$$0(27);
        }
        if (context2 == null) {
            PsiNameHelper.$$$reportNull$$$0(28);
        }
        PsiNameHelper helper = PsiNameHelper.getInstance(context2.getProject());
        LanguageLevel level = PsiUtil.getLanguageLevel(context2);
        return StringUtil.split(name2, ".", true, false).stream().allMatch(part -> helper.isIdentifier((String)part, level));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceText";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/PsiNameHelper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 4: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 5: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subpackageName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 21: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/PsiNameHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortClassName";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOuterClassReference";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedClassName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "removeWhitespace";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassParametersText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getShortClassName";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedClassName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeWhitespace";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getClassParametersText";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isSubpackageOf";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "appendTypeArgs";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "appendAnnotations";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isValidModuleName";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

