/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.patterns;

import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.lang.Language;
import ksp.com.intellij.lang.injection.InjectedLanguageManager;
import ksp.com.intellij.openapi.util.TextRange;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.patterns.ElementPattern;
import ksp.com.intellij.patterns.InitialPatternCondition;
import ksp.com.intellij.patterns.PatternCondition;
import ksp.com.intellij.patterns.PatternConditionPlus;
import ksp.com.intellij.patterns.PlatformPatterns;
import ksp.com.intellij.patterns.PsiNamePatternCondition;
import ksp.com.intellij.patterns.StandardPatterns;
import ksp.com.intellij.patterns.TreeElementPattern;
import ksp.com.intellij.psi.PsiComment;
import ksp.com.intellij.psi.PsiCompiledElement;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiErrorElement;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.PsiPolyVariantReference;
import ksp.com.intellij.psi.PsiReference;
import ksp.com.intellij.psi.ResolveResult;
import ksp.com.intellij.psi.TokenType;
import ksp.com.intellij.psi.meta.PsiMetaData;
import ksp.com.intellij.psi.meta.PsiMetaOwner;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.com.intellij.psi.tree.TokenSet;
import ksp.com.intellij.psi.util.PsiTreeUtil;
import ksp.com.intellij.util.PairProcessor;
import ksp.com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class PsiElementPattern<T extends PsiElement, Self extends PsiElementPattern<T, Self>>
extends TreeElementPattern<PsiElement, T, Self> {
    protected PsiElementPattern(Class<T> aClass) {
        super(aClass);
    }

    protected PsiElementPattern(@NotNull InitialPatternCondition<T> condition) {
        if (condition == null) {
            PsiElementPattern.$$$reportNull$$$0(0);
        }
        super(condition);
    }

    protected PsiElement[] getChildren(@NotNull PsiElement element2) {
        if (element2 == null) {
            PsiElementPattern.$$$reportNull$$$0(1);
        }
        return element2.getChildren();
    }

    @Override
    protected PsiElement getParent(@NotNull PsiElement element2) {
        if (element2 == null) {
            PsiElementPattern.$$$reportNull$$$0(2);
        }
        if (element2 instanceof PsiFile && InjectedLanguageManager.getInstance(element2.getProject()).isInjectedFragment((PsiFile)element2)) {
            return element2.getParent();
        }
        return element2.getContext();
    }

    @NotNull
    public Self withElementType(IElementType type2) {
        Self Self = this.withElementType((ElementPattern<IElementType>)PlatformPatterns.elementType().equalTo(type2));
        if (Self == null) {
            PsiElementPattern.$$$reportNull$$$0(3);
        }
        return Self;
    }

    @NotNull
    public Self withElementType(TokenSet type2) {
        Self Self = this.withElementType(PlatformPatterns.elementType().tokenSet(type2));
        if (Self == null) {
            PsiElementPattern.$$$reportNull$$$0(4);
        }
        return Self;
    }

    @NotNull
    public Self afterLeaf(String ... withText) {
        if (withText == null) {
            PsiElementPattern.$$$reportNull$$$0(5);
        }
        Self Self = this.afterLeaf((ElementPattern<? extends PsiElement>)PlatformPatterns.psiElement().withText(StandardPatterns.string().oneOf(withText)));
        if (Self == null) {
            PsiElementPattern.$$$reportNull$$$0(6);
        }
        return Self;
    }

    @NotNull
    public Self afterLeaf(@NotNull ElementPattern<? extends PsiElement> pattern) {
        if (pattern == null) {
            PsiElementPattern.$$$reportNull$$$0(7);
        }
        Self Self = this.afterLeafSkipping((ElementPattern)PlatformPatterns.psiElement().whitespaceCommentEmptyOrError(), pattern);
        if (Self == null) {
            PsiElementPattern.$$$reportNull$$$0(8);
        }
        return Self;
    }

    @NotNull
    public Self beforeLeaf(String ... withText) {
        if (withText == null) {
            PsiElementPattern.$$$reportNull$$$0(9);
        }
        Self Self = this.beforeLeaf((ElementPattern<? extends PsiElement>)PlatformPatterns.psiElement().withText(StandardPatterns.string().oneOf(withText)));
        if (Self == null) {
            PsiElementPattern.$$$reportNull$$$0(10);
        }
        return Self;
    }

    @NotNull
    public Self beforeLeaf(@NotNull ElementPattern<? extends PsiElement> pattern) {
        if (pattern == null) {
            PsiElementPattern.$$$reportNull$$$0(11);
        }
        Self Self = this.beforeLeafSkipping((ElementPattern)PlatformPatterns.psiElement().whitespaceCommentEmptyOrError(), pattern);
        if (Self == null) {
            PsiElementPattern.$$$reportNull$$$0(12);
        }
        return Self;
    }

    @NotNull
    public Self whitespace() {
        Self Self = this.withElementType(TokenType.WHITE_SPACE);
        if (Self == null) {
            PsiElementPattern.$$$reportNull$$$0(13);
        }
        return Self;
    }

    @NotNull
    public Self whitespaceCommentOrError() {
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.andOr(new ElementPattern[]{PlatformPatterns.psiElement().whitespace(), PlatformPatterns.psiElement(PsiComment.class), PlatformPatterns.psiElement(PsiErrorElement.class)});
        if (psiElementPattern == null) {
            PsiElementPattern.$$$reportNull$$$0(14);
        }
        return (Self)psiElementPattern;
    }

    @NotNull
    public Self whitespaceCommentEmptyOrError() {
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.andOr(new ElementPattern[]{PlatformPatterns.psiElement().whitespace(), PlatformPatterns.psiElement(PsiComment.class), PlatformPatterns.psiElement(PsiErrorElement.class), PlatformPatterns.psiElement().withText("")});
        if (psiElementPattern == null) {
            PsiElementPattern.$$$reportNull$$$0(15);
        }
        return (Self)psiElementPattern;
    }

    @NotNull
    public Self withFirstNonWhitespaceChild(@NotNull ElementPattern<? extends PsiElement> pattern) {
        if (pattern == null) {
            PsiElementPattern.$$$reportNull$$$0(16);
        }
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.withChildren(StandardPatterns.collection(PsiElement.class).filter(StandardPatterns.not(PlatformPatterns.psiElement().whitespace()), StandardPatterns.collection(PsiElement.class).first(pattern)));
        if (psiElementPattern == null) {
            PsiElementPattern.$$$reportNull$$$0(17);
        }
        return (Self)psiElementPattern;
    }

    @NotNull
    public Self withReference(final Class<? extends PsiReference> referenceClass2) {
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.with(new PatternCondition<T>("withReference"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context2) {
                if (t == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (PsiReference reference2 : t.getReferences()) {
                    if (!referenceClass2.isInstance(reference2)) continue;
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "ksp/com/intellij/patterns/PsiElementPattern$1", "accepts"));
            }
        });
        if (psiElementPattern == null) {
            PsiElementPattern.$$$reportNull$$$0(18);
        }
        return (Self)psiElementPattern;
    }

    @NotNull
    public Self inFile(final @NotNull ElementPattern<? extends PsiFile> filePattern) {
        if (filePattern == null) {
            PsiElementPattern.$$$reportNull$$$0(19);
        }
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.with(new PatternCondition<T>("inFile"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context2) {
                if (t == null) {
                    2.$$$reportNull$$$0(0);
                }
                return filePattern.accepts(t.getContainingFile(), context2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "ksp/com/intellij/patterns/PsiElementPattern$2", "accepts"));
            }
        });
        if (psiElementPattern == null) {
            PsiElementPattern.$$$reportNull$$$0(20);
        }
        return (Self)psiElementPattern;
    }

    @NotNull
    public Self inVirtualFile(final @NotNull ElementPattern<? extends VirtualFile> filePattern) {
        if (filePattern == null) {
            PsiElementPattern.$$$reportNull$$$0(21);
        }
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.with(new PatternCondition<T>("inVirtualFile"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context2) {
                if (t == null) {
                    3.$$$reportNull$$$0(0);
                }
                return filePattern.accepts(t.getContainingFile().getViewProvider().getVirtualFile(), context2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "ksp/com/intellij/patterns/PsiElementPattern$3", "accepts"));
            }
        });
        if (psiElementPattern == null) {
            PsiElementPattern.$$$reportNull$$$0(22);
        }
        return (Self)psiElementPattern;
    }

    @Override
    @NotNull
    public Self equalTo(@NotNull T o) {
        if (o == null) {
            PsiElementPattern.$$$reportNull$$$0(23);
        }
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.with(new PatternCondition<T>("equalTo", (PsiElement)o){
            final /* synthetic */ PsiElement val$o;
            {
                this.val$o = psiElement;
                super(debugMethodName);
            }

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context2) {
                if (t == null) {
                    4.$$$reportNull$$$0(0);
                }
                return t.getManager().areElementsEquivalent((PsiElement)t, this.val$o);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "ksp/com/intellij/patterns/PsiElementPattern$4", "accepts"));
            }
        });
        if (psiElementPattern == null) {
            PsiElementPattern.$$$reportNull$$$0(24);
        }
        return (Self)psiElementPattern;
    }

    @NotNull
    public Self withElementType(final ElementPattern<IElementType> pattern) {
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.with(new PatternCondition<T>("withElementType"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context2) {
                ASTNode node;
                if (t == null) {
                    5.$$$reportNull$$$0(0);
                }
                return (node = t.getNode()) != null && pattern.accepts(node.getElementType());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "ksp/com/intellij/patterns/PsiElementPattern$5", "accepts"));
            }
        });
        if (psiElementPattern == null) {
            PsiElementPattern.$$$reportNull$$$0(25);
        }
        return (Self)psiElementPattern;
    }

    @NotNull
    public Self withText(@NotNull @NonNls String text) {
        if (text == null) {
            PsiElementPattern.$$$reportNull$$$0(26);
        }
        Self Self = this.withText((ElementPattern)StandardPatterns.string().equalTo(text));
        if (Self == null) {
            PsiElementPattern.$$$reportNull$$$0(27);
        }
        return Self;
    }

    @NotNull
    public Self withoutText(@NotNull String text) {
        if (text == null) {
            PsiElementPattern.$$$reportNull$$$0(28);
        }
        Self Self = this.withoutText((ElementPattern)StandardPatterns.string().equalTo(text));
        if (Self == null) {
            PsiElementPattern.$$$reportNull$$$0(29);
        }
        return Self;
    }

    @NotNull
    public Self withName(@NotNull @NonNls String name2) {
        if (name2 == null) {
            PsiElementPattern.$$$reportNull$$$0(30);
        }
        Self Self = this.withName((ElementPattern<String>)StandardPatterns.string().equalTo(name2));
        if (Self == null) {
            PsiElementPattern.$$$reportNull$$$0(31);
        }
        return Self;
    }

    @NotNull
    public Self withName(String ... names2) {
        if (names2 == null) {
            PsiElementPattern.$$$reportNull$$$0(32);
        }
        Self Self = this.withName(StandardPatterns.string().oneOf(names2));
        if (Self == null) {
            PsiElementPattern.$$$reportNull$$$0(33);
        }
        return Self;
    }

    @NotNull
    public Self withName(@NotNull ElementPattern<String> name2) {
        if (name2 == null) {
            PsiElementPattern.$$$reportNull$$$0(34);
        }
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.with(new PsiNamePatternCondition("withName", name2));
        if (psiElementPattern == null) {
            PsiElementPattern.$$$reportNull$$$0(35);
        }
        return (Self)psiElementPattern;
    }

    @NotNull
    public Self afterLeafSkipping(final @NotNull ElementPattern skip2, final @NotNull ElementPattern pattern) {
        if (skip2 == null) {
            PsiElementPattern.$$$reportNull$$$0(36);
        }
        if (pattern == null) {
            PsiElementPattern.$$$reportNull$$$0(37);
        }
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.with(new PatternCondition<T>("afterLeafSkipping"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context2) {
                if (t == null) {
                    6.$$$reportNull$$$0(0);
                }
                Object element2 = t;
                while ((element2 = PsiTreeUtil.prevLeaf(element2)) != null && element2.getTextLength() == 0 || skip2.accepts(element2, context2)) {
                }
                return pattern.accepts(element2, context2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "ksp/com/intellij/patterns/PsiElementPattern$6", "accepts"));
            }
        });
        if (psiElementPattern == null) {
            PsiElementPattern.$$$reportNull$$$0(38);
        }
        return (Self)psiElementPattern;
    }

    @NotNull
    public Self beforeLeafSkipping(final @NotNull ElementPattern skip2, final @NotNull ElementPattern pattern) {
        if (skip2 == null) {
            PsiElementPattern.$$$reportNull$$$0(39);
        }
        if (pattern == null) {
            PsiElementPattern.$$$reportNull$$$0(40);
        }
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.with(new PatternCondition<T>("beforeLeafSkipping"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context2) {
                if (t == null) {
                    7.$$$reportNull$$$0(0);
                }
                Object element2 = t;
                while ((element2 = PsiTreeUtil.nextLeaf(element2)) != null && element2.getTextLength() == 0 || skip2.accepts(element2, context2)) {
                }
                return pattern.accepts(element2, context2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "ksp/com/intellij/patterns/PsiElementPattern$7", "accepts"));
            }
        });
        if (psiElementPattern == null) {
            PsiElementPattern.$$$reportNull$$$0(41);
        }
        return (Self)psiElementPattern;
    }

    @NotNull
    public Self atStartOf(final @NotNull ElementPattern pattern) {
        if (pattern == null) {
            PsiElementPattern.$$$reportNull$$$0(42);
        }
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.with(new PatternCondition<T>("atStartOf"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context2) {
                if (t == null) {
                    8.$$$reportNull$$$0(0);
                }
                for (Object element2 = t; element2 != null; element2 = element2.getContext()) {
                    if (!pattern.accepts(element2, context2)) continue;
                    return element2.getTextRange().getStartOffset() == t.getTextRange().getStartOffset();
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "ksp/com/intellij/patterns/PsiElementPattern$8", "accepts"));
            }
        });
        if (psiElementPattern == null) {
            PsiElementPattern.$$$reportNull$$$0(43);
        }
        return (Self)psiElementPattern;
    }

    @NotNull
    public Self withTextLength(@NotNull ElementPattern lengthPattern) {
        if (lengthPattern == null) {
            PsiElementPattern.$$$reportNull$$$0(44);
        }
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.with(new PatternConditionPlus<T, Integer>("withTextLength", lengthPattern){

            @Override
            public boolean processValues(T t, ProcessingContext context2, PairProcessor<? super Integer, ? super ProcessingContext> integerProcessingContextPairProcessor) {
                return integerProcessingContextPairProcessor.process((Integer)t.getTextLength(), context2);
            }
        });
        if (psiElementPattern == null) {
            PsiElementPattern.$$$reportNull$$$0(45);
        }
        return (Self)psiElementPattern;
    }

    @NotNull
    public Self notEmpty() {
        Self Self = this.withTextLengthLongerThan(0);
        if (Self == null) {
            PsiElementPattern.$$$reportNull$$$0(46);
        }
        return Self;
    }

    @NotNull
    public Self withTextLengthLongerThan(final int minLength) {
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.with(new PatternCondition<T>("withTextLengthLongerThan"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context2) {
                if (t == null) {
                    10.$$$reportNull$$$0(0);
                }
                return t.getTextLength() > minLength;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "ksp/com/intellij/patterns/PsiElementPattern$10", "accepts"));
            }
        });
        if (psiElementPattern == null) {
            PsiElementPattern.$$$reportNull$$$0(47);
        }
        return (Self)psiElementPattern;
    }

    @NotNull
    public Self withText(@NotNull ElementPattern text) {
        if (text == null) {
            PsiElementPattern.$$$reportNull$$$0(48);
        }
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.with(this._withText(text));
        if (psiElementPattern == null) {
            PsiElementPattern.$$$reportNull$$$0(49);
        }
        return (Self)psiElementPattern;
    }

    @NotNull
    private PatternCondition<T> _withText(ElementPattern pattern) {
        return new PatternConditionPlus<T, String>("_withText", pattern){

            @Override
            public boolean processValues(T t, ProcessingContext context2, PairProcessor<? super String, ? super ProcessingContext> processor2) {
                return processor2.process(t.getText(), context2);
            }
        };
    }

    @NotNull
    public Self withoutText(@NotNull ElementPattern text) {
        if (text == null) {
            PsiElementPattern.$$$reportNull$$$0(50);
        }
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.without(this._withText(text));
        if (psiElementPattern == null) {
            PsiElementPattern.$$$reportNull$$$0(51);
        }
        return (Self)psiElementPattern;
    }

    @NotNull
    public Self withLanguage(final @NotNull Language language) {
        if (language == null) {
            PsiElementPattern.$$$reportNull$$$0(52);
        }
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.with(new PatternCondition<T>("withLanguage"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context2) {
                if (t == null) {
                    12.$$$reportNull$$$0(0);
                }
                return t.getLanguage().equals(language);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "ksp/com/intellij/patterns/PsiElementPattern$12", "accepts"));
            }
        });
        if (psiElementPattern == null) {
            PsiElementPattern.$$$reportNull$$$0(53);
        }
        return (Self)psiElementPattern;
    }

    @NotNull
    public Self withMetaData(final ElementPattern<? extends PsiMetaData> metaDataPattern) {
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.with(new PatternCondition<T>("withMetaData"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context2) {
                if (t == null) {
                    13.$$$reportNull$$$0(0);
                }
                return t instanceof PsiMetaOwner && metaDataPattern.accepts(((PsiMetaOwner)t).getMetaData(), context2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "ksp/com/intellij/patterns/PsiElementPattern$13", "accepts"));
            }
        });
        if (psiElementPattern == null) {
            PsiElementPattern.$$$reportNull$$$0(54);
        }
        return (Self)psiElementPattern;
    }

    @NotNull
    public Self referencing(final ElementPattern<? extends PsiElement> targetPattern) {
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.with(new PatternCondition<T>("referencing"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context2) {
                PsiReference[] references;
                if (t == null) {
                    14.$$$reportNull$$$0(0);
                }
                for (PsiReference reference2 : references = t.getReferences()) {
                    if (targetPattern.accepts(reference2.resolve(), context2)) {
                        return true;
                    }
                    if (!(reference2 instanceof PsiPolyVariantReference)) continue;
                    for (ResolveResult result2 : ((PsiPolyVariantReference)reference2).multiResolve(true)) {
                        if (!targetPattern.accepts(result2.getElement(), context2)) continue;
                        return true;
                    }
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "ksp/com/intellij/patterns/PsiElementPattern$14", "accepts"));
            }
        });
        if (psiElementPattern == null) {
            PsiElementPattern.$$$reportNull$$$0(55);
        }
        return (Self)psiElementPattern;
    }

    @NotNull
    public Self compiled() {
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.with(new PatternCondition<T>("compiled"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context2) {
                if (t == null) {
                    15.$$$reportNull$$$0(0);
                }
                return t instanceof PsiCompiledElement;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "ksp/com/intellij/patterns/PsiElementPattern$15", "accepts"));
            }
        });
        if (psiElementPattern == null) {
            PsiElementPattern.$$$reportNull$$$0(56);
        }
        return (Self)psiElementPattern;
    }

    @NotNull
    public Self withTreeParent(final ElementPattern<? extends PsiElement> ancestor) {
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.with(new PatternCondition<T>("withTreeParent"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context2) {
                if (t == null) {
                    16.$$$reportNull$$$0(0);
                }
                return ancestor.accepts(t.getParent(), context2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "ksp/com/intellij/patterns/PsiElementPattern$16", "accepts"));
            }
        });
        if (psiElementPattern == null) {
            PsiElementPattern.$$$reportNull$$$0(57);
        }
        return (Self)psiElementPattern;
    }

    @NotNull
    public Self insideStarting(final ElementPattern<? extends PsiElement> ancestor) {
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.with(new PatternCondition<PsiElement>("insideStarting"){

            @Override
            public boolean accepts(@NotNull PsiElement start, ProcessingContext context2) {
                if (start == null) {
                    17.$$$reportNull$$$0(0);
                }
                PsiElement element2 = PsiElementPattern.this.getParent(start);
                TextRange range = start.getTextRange();
                if (range == null) {
                    return false;
                }
                int startOffset = range.getStartOffset();
                while (element2 != null && element2.getTextRange() != null && element2.getTextRange().getStartOffset() == startOffset) {
                    if (ancestor.accepts(element2, context2)) {
                        return true;
                    }
                    element2 = PsiElementPattern.this.getParent(element2);
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "ksp/com/intellij/patterns/PsiElementPattern$17", "accepts"));
            }
        });
        if (psiElementPattern == null) {
            PsiElementPattern.$$$reportNull$$$0(58);
        }
        return (Self)psiElementPattern;
    }

    @NotNull
    public Self withLastChildSkipping(final @NotNull ElementPattern skip2, final @NotNull ElementPattern pattern) {
        if (skip2 == null) {
            PsiElementPattern.$$$reportNull$$$0(59);
        }
        if (pattern == null) {
            PsiElementPattern.$$$reportNull$$$0(60);
        }
        PsiElementPattern psiElementPattern = (PsiElementPattern)this.with(new PatternCondition<T>("withLastChildSkipping"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context2) {
                PsiElement last;
                if (t == null) {
                    18.$$$reportNull$$$0(0);
                }
                for (last = t.getLastChild(); last != null && skip2.accepts(last); last = last.getPrevSibling()) {
                }
                return pattern.accepts(last);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "ksp/com/intellij/patterns/PsiElementPattern$18", "accepts"));
            }
        });
        if (psiElementPattern == null) {
            PsiElementPattern.$$$reportNull$$$0(61);
        }
        return (Self)psiElementPattern;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 38: 
            case 41: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 61: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 38: 
            case 41: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 61: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 38: 
            case 41: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/patterns/PsiElementPattern";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "withText";
                break;
            }
            case 7: 
            case 11: 
            case 16: 
            case 37: 
            case 40: 
            case 42: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePattern";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 26: 
            case 28: 
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 36: 
            case 39: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skip";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lengthPattern";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/patterns/PsiElementPattern";
                break;
            }
            case 3: 
            case 4: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "withElementType";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "afterLeaf";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeLeaf";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "whitespace";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "whitespaceCommentOrError";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "whitespaceCommentEmptyOrError";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "withFirstNonWhitespaceChild";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "withReference";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "inFile";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "inVirtualFile";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "equalTo";
                break;
            }
            case 27: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "withText";
                break;
            }
            case 29: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "withoutText";
                break;
            }
            case 31: 
            case 33: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "withName";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "afterLeafSkipping";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeLeafSkipping";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "atStartOf";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "withTextLength";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "notEmpty";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "withTextLengthLongerThan";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "withLanguage";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "withMetaData";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "referencing";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "compiled";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "withTreeParent";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "insideStarting";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "withLastChildSkipping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getParent";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 38: 
            case 41: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 61: {
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "afterLeaf";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "beforeLeaf";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "withFirstNonWhitespaceChild";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "inFile";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "inVirtualFile";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "equalTo";
                break;
            }
            case 26: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "withText";
                break;
            }
            case 28: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "withoutText";
                break;
            }
            case 30: 
            case 32: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "withName";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "afterLeafSkipping";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "beforeLeafSkipping";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "atStartOf";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "withTextLength";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "withLanguage";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "withLastChildSkipping";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 38: 
            case 41: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 61: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Capture<T extends PsiElement>
    extends PsiElementPattern<T, Capture<T>> {
        protected Capture(Class<T> aClass) {
            super(aClass);
        }

        protected Capture(@NotNull InitialPatternCondition<T> condition) {
            if (condition == null) {
                Capture.$$$reportNull$$$0(0);
            }
            super(condition);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "ksp/com/intellij/patterns/PsiElementPattern$Capture", "<init>"));
        }
    }
}

