/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.util.io;

import java.io.DataInputStream;
import java.util.Arrays;
import ksp.com.intellij.openapi.util.io.ByteSequence;
import ksp.com.intellij.util.ArrayUtil;
import ksp.com.intellij.util.io.UnsyncByteArrayInputStream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class ByteArraySequence
implements ByteSequence {
    public static final ByteArraySequence EMPTY = new ByteArraySequence(ArrayUtil.EMPTY_BYTE_ARRAY);
    private final byte[] myBytes;
    private final int myOffset;
    private final int myLen;

    public ByteArraySequence(byte @NotNull [] bytes) {
        if (bytes == null) {
            ByteArraySequence.$$$reportNull$$$0(0);
        }
        this(bytes, 0, bytes.length);
    }

    public ByteArraySequence(byte @NotNull [] bytes, int offset, int len) {
        if (bytes == null) {
            ByteArraySequence.$$$reportNull$$$0(1);
        }
        this.myBytes = bytes;
        this.myOffset = offset;
        this.myLen = len;
        if (offset < 0 || offset > bytes.length || offset + len > bytes.length || len < 0) {
            throw new IllegalArgumentException("Offset is out of range: " + offset + "; bytes.length: " + bytes.length + "; len: " + len);
        }
    }

    @ApiStatus.Internal
    public byte @NotNull [] getInternalBuffer() {
        if (this.myBytes == null) {
            ByteArraySequence.$$$reportNull$$$0(2);
        }
        return this.myBytes;
    }

    public int getOffset() {
        return this.myOffset;
    }

    public int getLength() {
        return this.myLen;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteArraySequence sequence2 = (ByteArraySequence)o;
        int len = this.myLen;
        if (len != sequence2.myLen) {
            return false;
        }
        byte[] thisBytes = this.myBytes;
        byte[] thatBytes = sequence2.myBytes;
        int i = 0;
        int j = this.myOffset;
        int k = sequence2.myOffset;
        while (i < len) {
            if (thisBytes[j] != thatBytes[k]) {
                return false;
            }
            ++i;
            ++j;
            ++k;
        }
        return true;
    }

    public int hashCode() {
        int len = this.myLen;
        byte[] thisBytes = this.myBytes;
        int result2 = 1;
        int i = 0;
        int j = this.myOffset;
        while (i < len) {
            result2 = result2 * 31 + thisBytes[j];
            ++i;
            ++j;
        }
        return result2;
    }

    @Override
    public int length() {
        return this.getLength();
    }

    @Override
    public byte byteAt(int index2) {
        return this.myBytes[this.myOffset + index2];
    }

    @Override
    @NotNull
    public ByteSequence subSequence(int start, int end) {
        return new ByteArraySequence(this.myBytes, this.myOffset + start, end - start);
    }

    @Override
    public byte @NotNull [] toBytes() {
        byte[] byArray = Arrays.copyOfRange(this.myBytes, this.myOffset, this.myOffset + this.length());
        if (byArray == null) {
            ByteArraySequence.$$$reportNull$$$0(3);
        }
        return byArray;
    }

    @NotNull
    public DataInputStream toInputStream() {
        return new DataInputStream(new UnsyncByteArrayInputStream(this.myBytes, this.myOffset, this.length()));
    }

    @NotNull
    public static ByteArraySequence create(byte @NotNull [] bytes) {
        if (bytes == null) {
            ByteArraySequence.$$$reportNull$$$0(4);
        }
        return bytes.length == 0 ? EMPTY : new ByteArraySequence(bytes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/openapi/util/io/ByteArraySequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/openapi/util/io/ByteArraySequence";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalBuffer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toBytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

