/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.progress.impl;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import ksp.com.intellij.codeWithMe.ClientId;
import ksp.com.intellij.diagnostic.ThreadDumper;
import ksp.com.intellij.openapi.Disposable;
import ksp.com.intellij.openapi.application.Application;
import ksp.com.intellij.openapi.application.ApplicationManager;
import ksp.com.intellij.openapi.application.ModalityState;
import ksp.com.intellij.openapi.application.ex.ApplicationEx;
import ksp.com.intellij.openapi.application.ex.ApplicationManagerEx;
import ksp.com.intellij.openapi.application.ex.ApplicationUtil;
import ksp.com.intellij.openapi.diagnostic.Attachment;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.progress.Cancellation;
import ksp.com.intellij.openapi.progress.EmptyProgressIndicator;
import ksp.com.intellij.openapi.progress.PerformInBackgroundOption;
import ksp.com.intellij.openapi.progress.ProcessCanceledException;
import ksp.com.intellij.openapi.progress.ProgressIndicator;
import ksp.com.intellij.openapi.progress.ProgressManager;
import ksp.com.intellij.openapi.progress.StandardProgressIndicator;
import ksp.com.intellij.openapi.progress.Task;
import ksp.com.intellij.openapi.progress.WrappedProgressIndicator;
import ksp.com.intellij.openapi.progress.impl.NonCancelableIndicator;
import ksp.com.intellij.openapi.progress.impl.ProgressRunner;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.util.Disposer;
import ksp.com.intellij.openapi.util.NlsContexts;
import ksp.com.intellij.openapi.util.Ref;
import ksp.com.intellij.openapi.util.ThrowableComputable;
import ksp.com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import ksp.com.intellij.util.ExceptionUtil;
import ksp.com.intellij.util.ObjectUtils;
import ksp.com.intellij.util.SystemProperties;
import ksp.com.intellij.util.concurrency.AppExecutorUtil;
import ksp.com.intellij.util.containers.ConcurrentLongObjectMap;
import ksp.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class CoreProgressManager
extends ProgressManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(CoreProgressManager.class);
    static final int CHECK_CANCELED_DELAY_MILLIS = 10;
    private final AtomicInteger myUnsafeProgressCount = new AtomicInteger(0);
    public static final boolean ENABLED = !"disabled".equals(System.getProperty("idea.ProcessCanceledException"));
    private static CheckCanceledHook ourCheckCanceledHook;
    private ScheduledFuture<?> myCheckCancelledFuture;
    private static final Map<ProgressIndicator, Set<Thread>> threadsUnderIndicator;
    private static final ConcurrentLongObjectMap<ProgressIndicator> currentIndicators;
    private static final ConcurrentLongObjectMap<ProgressIndicator> threadTopLevelIndicators;
    static final Set<Thread> threadsUnderCanceledIndicator;
    @NotNull
    private static volatile CheckCanceledBehavior ourCheckCanceledBehavior;
    private static final Map<ProgressIndicator, AtomicInteger> nonStandardIndicators;
    private static final ThreadLocal<Boolean> isInNonCancelableSection;
    private static final long MAX_PRIORITIZATION_NANOS;
    private static final Thread[] EMPTY_THREAD_ARRAY;
    private final Set<Thread> myPrioritizedThreads = ContainerUtil.newConcurrentSet();
    private volatile Thread[] myEffectivePrioritizedThreads = EMPTY_THREAD_ARRAY;
    private int myDeprioritizations;
    private final Object myPrioritizationLock = ObjectUtils.sentinel("myPrioritizationLock");
    private volatile long myPrioritizingStarted;

    private void startBackgroundNonStandardIndicatorsPing() {
        if (this.myCheckCancelledFuture != null) {
            return;
        }
        this.myCheckCancelledFuture = AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(() -> {
            for (ProgressIndicator indicator : nonStandardIndicators.keySet()) {
                try {
                    indicator.checkCanceled();
                }
                catch (ProcessCanceledException e) {
                    this.indicatorCanceled(indicator);
                }
            }
        }, 0L, 10L, TimeUnit.MILLISECONDS);
    }

    private void stopBackgroundNonStandardIndicatorsPing() {
        if (this.myCheckCancelledFuture != null) {
            this.myCheckCancelledFuture.cancel(true);
            this.myCheckCancelledFuture = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Map<ProgressIndicator, Set<Thread>> map = threadsUnderIndicator;
        synchronized (map) {
            this.stopBackgroundNonStandardIndicatorsPing();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    @ApiStatus.Internal
    public static List<ProgressIndicator> getCurrentIndicators() {
        Map<ProgressIndicator, Set<Thread>> map = threadsUnderIndicator;
        // MONITORENTER : map
        ArrayList<ProgressIndicator> arrayList = new ArrayList<ProgressIndicator>(threadsUnderIndicator.keySet());
        // MONITOREXIT : map
        if (arrayList != null) return arrayList;
        CoreProgressManager.$$$reportNull$$$0(0);
        return arrayList;
    }

    @ApiStatus.Internal
    public static boolean runCheckCanceledHooks(@Nullable ProgressIndicator indicator) {
        CheckCanceledHook hook = ourCheckCanceledHook;
        return hook != null && hook.runHook(indicator);
    }

    @Override
    protected void doCheckCanceled() throws ProcessCanceledException {
        CheckCanceledBehavior behavior;
        if (!this.isInNonCancelableSection()) {
            Cancellation.checkCancelled();
        }
        if ((behavior = ourCheckCanceledBehavior) == CheckCanceledBehavior.NONE) {
            return;
        }
        if (behavior == CheckCanceledBehavior.INDICATOR_PLUS_HOOKS) {
            ProgressIndicator progress = this.getProgressIndicator();
            if (progress != null) {
                progress.checkCanceled();
            }
        } else {
            CoreProgressManager.runCheckCanceledHooks(null);
        }
    }

    @Override
    public boolean hasProgressIndicator() {
        return this.getProgressIndicator() != null;
    }

    @Override
    public boolean hasUnsafeProgressIndicator() {
        return this.myUnsafeProgressCount.get() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasModalProgressIndicator() {
        Map<ProgressIndicator, Set<Thread>> map = threadsUnderIndicator;
        synchronized (map) {
            return ContainerUtil.or(threadsUnderIndicator.keySet(), i -> i.isModal());
        }
    }

    @Override
    public void runProcess(@NotNull Runnable process2, @Nullable ProgressIndicator progress) {
        if (process2 == null) {
            CoreProgressManager.$$$reportNull$$$0(1);
        }
        if (progress != null) {
            CoreProgressManager.assertNoOtherThreadUnder(progress);
        }
        this.executeProcessUnderProgress(() -> {
            try {
                try {
                    if (progress != null && !progress.isRunning()) {
                        progress.start();
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
                process2.run();
            }
            finally {
                if (progress != null && progress.isRunning()) {
                    progress.stop();
                    if (progress instanceof ProgressIndicatorEx) {
                        ((ProgressIndicatorEx)progress).processFinish();
                    }
                }
            }
        }, progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void assertNoOtherThreadUnder(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            CoreProgressManager.$$$reportNull$$$0(2);
        }
        Map<ProgressIndicator, Set<Thread>> map = threadsUnderIndicator;
        synchronized (map) {
            Thread other;
            Collection threads = threadsUnderIndicator.get(progress);
            Thread thread = other = threads == null || threads.isEmpty() ? null : (Thread)threads.iterator().next();
            if (other != null) {
                if (other == Thread.currentThread()) {
                    LOG.error("This thread is already running under this indicator, starting/stopping it here might be a data race");
                } else {
                    StringWriter dump2 = new StringWriter();
                    ThreadDumper.dumpCallStack(other, (Writer)dump2, other.getStackTrace());
                    LOG.error("Other thread is already running under this indicator, starting/stopping it here might be a data race. Its thread dump:\n" + dump2);
                }
            }
        }
    }

    @Override
    public void executeNonCancelableSection(@NotNull Runnable runnable) {
        if (runnable == null) {
            CoreProgressManager.$$$reportNull$$$0(3);
        }
        this.computeInNonCancelableSection(() -> {
            runnable.run();
            return null;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T, E extends Exception> T computeInNonCancelableSection(@NotNull ThrowableComputable<T, E> computable) throws E {
        if (computable == null) {
            CoreProgressManager.$$$reportNull$$$0(4);
        }
        try {
            if (this.isInNonCancelableSection()) {
                return computable.compute();
            }
            try {
                isInNonCancelableSection.set(Boolean.TRUE);
                T t = this.computeUnderProgress(computable, NonCancelableIndicator.INSTANCE);
                return t;
            }
            finally {
                isInNonCancelableSection.remove();
            }
        }
        catch (ProcessCanceledException e) {
            throw new RuntimeException("PCE is not expected in non-cancellable section execution", e);
        }
    }

    @Override
    public boolean runProcessWithProgressSynchronously(@NotNull Runnable process2, @NotNull @NlsContexts.ProgressTitle String progressTitle, boolean canBeCanceled, @Nullable Project project) {
        if (process2 == null) {
            CoreProgressManager.$$$reportNull$$$0(5);
        }
        if (progressTitle == null) {
            CoreProgressManager.$$$reportNull$$$0(6);
        }
        return this.runProcessWithProgressSynchronously(process2, progressTitle, canBeCanceled, project, null);
    }

    @Override
    public <T, E extends Exception> T runProcessWithProgressSynchronously(final @NotNull ThrowableComputable<T, E> process2, @NotNull String progressTitle, boolean canBeCanceled, @Nullable Project project) throws E {
        if (process2 == null) {
            CoreProgressManager.$$$reportNull$$$0(7);
        }
        if (progressTitle == null) {
            CoreProgressManager.$$$reportNull$$$0(8);
        }
        final AtomicReference result2 = new AtomicReference();
        final AtomicReference exception = new AtomicReference();
        this.runProcessWithProgressSynchronously(new Task.Modal(project, progressTitle, canBeCanceled){

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    Object compute2 = process2.compute();
                    result2.set(compute2);
                }
                catch (Throwable t) {
                    exception.set(t);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "ksp/com/intellij/openapi/progress/impl/CoreProgressManager$1", "run"));
            }
        });
        Throwable t = (Throwable)exception.get();
        if (t != null) {
            ExceptionUtil.rethrowUnchecked(t);
            Exception e = (Exception)t;
            throw e;
        }
        return (T)result2.get();
    }

    @Override
    public boolean runProcessWithProgressSynchronously(final @NotNull Runnable process2, @NotNull @NlsContexts.DialogTitle String progressTitle, boolean canBeCanceled, @Nullable Project project, @Nullable JComponent parentComponent) {
        if (process2 == null) {
            CoreProgressManager.$$$reportNull$$$0(9);
        }
        if (progressTitle == null) {
            CoreProgressManager.$$$reportNull$$$0(10);
        }
        Task.Modal task = new Task.Modal(project, parentComponent, progressTitle, canBeCanceled){

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                process2.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "ksp/com/intellij/openapi/progress/impl/CoreProgressManager$2", "run"));
            }
        };
        return this.runProcessWithProgressSynchronously(task);
    }

    @Override
    public void runProcessWithProgressAsynchronously(@NotNull Project project, @NotNull @NlsContexts.ProgressTitle String progressTitle, final @NotNull Runnable process2, final @Nullable Runnable successRunnable, final @Nullable Runnable canceledRunnable, @NotNull PerformInBackgroundOption option) {
        if (project == null) {
            CoreProgressManager.$$$reportNull$$$0(11);
        }
        if (progressTitle == null) {
            CoreProgressManager.$$$reportNull$$$0(12);
        }
        if (process2 == null) {
            CoreProgressManager.$$$reportNull$$$0(13);
        }
        if (option == null) {
            CoreProgressManager.$$$reportNull$$$0(14);
        }
        this.runProcessWithProgressAsynchronously(new Task.Backgroundable(project, progressTitle, true, option){

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                process2.run();
            }

            @Override
            public void onCancel() {
                if (canceledRunnable != null) {
                    canceledRunnable.run();
                }
            }

            @Override
            public void onSuccess() {
                if (successRunnable != null) {
                    successRunnable.run();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "ksp/com/intellij/openapi/progress/impl/CoreProgressManager$3", "run"));
            }
        });
    }

    @ApiStatus.Internal
    public static boolean shouldKeepTasksAsynchronousInHeadlessMode() {
        return SystemProperties.getBooleanProperty("intellij.progress.task.ignoreHeadless", false);
    }

    @ApiStatus.Internal
    public static boolean shouldKeepTasksAsynchronous() {
        Application application = ApplicationManager.getApplication();
        boolean isHeadless = application.isUnitTestMode() || application.isHeadlessEnvironment();
        return !isHeadless || CoreProgressManager.shouldKeepTasksAsynchronousInHeadlessMode();
    }

    @Override
    public void run(@NotNull Task task) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(15);
        }
        if (task.isHeadless() && !CoreProgressManager.shouldKeepTasksAsynchronousInHeadlessMode()) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.runProcessWithProgressSynchronously(task);
            } else {
                this.runProcessWithProgressInCurrentThread(task, new EmptyProgressIndicator(), ModalityState.defaultModalityState());
            }
        } else if (task.isModal()) {
            this.runProcessWithProgressSynchronously(task.asModal());
        } else {
            Task.Backgroundable backgroundable = task.asBackgroundable();
            if (backgroundable.isConditionalModal() && !backgroundable.shouldStartInBackground()) {
                this.runProcessWithProgressSynchronously(backgroundable);
            } else {
                this.runAsynchronously(backgroundable);
            }
        }
    }

    private void runAsynchronously(@NotNull Task.Backgroundable task) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(16);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            this.runProcessWithProgressAsynchronously(task);
        } else {
            ApplicationManager.getApplication().invokeLater(() -> {
                Project project = task.getProject();
                if (project != null && project.isDisposed()) {
                    LOG.info("Task canceled because of project disposal: " + task);
                    this.finishTask(task, true, null);
                    return;
                }
                this.runProcessWithProgressAsynchronously(task);
            }, ModalityState.defaultModalityState());
        }
    }

    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(17);
        }
        Future<?> future = this.runProcessWithProgressAsynchronously(task, new EmptyProgressIndicator(), null);
        if (future == null) {
            CoreProgressManager.$$$reportNull$$$0(18);
        }
        return future;
    }

    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task, @NotNull ProgressIndicator progressIndicator, @Nullable Runnable continuation2) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(19);
        }
        if (progressIndicator == null) {
            CoreProgressManager.$$$reportNull$$$0(20);
        }
        Future<?> future = this.runProcessWithProgressAsynchronously(task, progressIndicator, continuation2, progressIndicator.getModalityState());
        if (future == null) {
            CoreProgressManager.$$$reportNull$$$0(21);
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected void startTask(@NotNull Task task, @NotNull ProgressIndicator indicator, @Nullable Runnable continuation2) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(22);
        }
        if (indicator == null) {
            CoreProgressManager.$$$reportNull$$$0(23);
        }
        try {
            task.run(indicator);
        }
        finally {
            try {
                if (indicator instanceof ProgressIndicatorEx) {
                    ((ProgressIndicatorEx)indicator).finish(task);
                }
            }
            finally {
                if (continuation2 != null) {
                    continuation2.run();
                }
            }
        }
    }

    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task, @NotNull ProgressIndicator progressIndicator, @Nullable Runnable continuation2, @NotNull ModalityState modalityState) {
        IndicatorDisposable indicatorDisposable;
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(24);
        }
        if (progressIndicator == null) {
            CoreProgressManager.$$$reportNull$$$0(25);
        }
        if (modalityState == null) {
            CoreProgressManager.$$$reportNull$$$0(26);
        }
        if (progressIndicator instanceof Disposable) {
            indicatorDisposable = new IndicatorDisposable(progressIndicator);
            Disposer.register(ApplicationManager.getApplication(), indicatorDisposable);
        } else {
            indicatorDisposable = null;
        }
        Future<?> future = this.runProcessWithProgressAsync(task, CompletableFuture.completedFuture(progressIndicator), continuation2, indicatorDisposable, modalityState);
        if (future == null) {
            CoreProgressManager.$$$reportNull$$$0(27);
        }
        return future;
    }

    @NotNull
    protected Future<?> runProcessWithProgressAsync(@NotNull Task.Backgroundable task, @NotNull @NotNull CompletableFuture<? extends @NotNull ProgressIndicator> progressIndicator, @Nullable Runnable continuation2, @Nullable IndicatorDisposable indicatorDisposable, @Nullable ModalityState modalityState) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(28);
        }
        if (progressIndicator == null) {
            CoreProgressManager.$$$reportNull$$$0(29);
        }
        AtomicLong elapsed = new AtomicLong();
        CompletionStage completionStage = new ProgressRunner<Object>(progress -> {
            long start = System.currentTimeMillis();
            try {
                this.startTask(task, (ProgressIndicator)progress, continuation2);
            }
            finally {
                elapsed.set(System.currentTimeMillis() - start);
            }
            return null;
        }).onThread(ProgressRunner.ThreadToUse.POOLED).withProgress(progressIndicator).submit().whenComplete(ClientId.decorateBiConsumer((result2, err) -> {
            ModalityState modality;
            if (!result2.isCanceled()) {
                this.notifyTaskFinished(task, elapsed.get());
            }
            if (modalityState != null) {
                modality = modalityState;
            } else {
                try {
                    modality = ((ProgressIndicator)progressIndicator.get()).getModalityState();
                }
                catch (Throwable e) {
                    modality = ModalityState.NON_MODAL;
                }
            }
            ApplicationUtil.invokeLaterSomewhere(task.whereToRunCallbacks(), modality, () -> {
                this.finishTask(task, result2.isCanceled(), result2.getThrowable() instanceof ProcessCanceledException ? null : result2.getThrowable());
                if (indicatorDisposable != null) {
                    Disposer.dispose(indicatorDisposable);
                }
            });
        }));
        if (completionStage == null) {
            CoreProgressManager.$$$reportNull$$$0(30);
        }
        return completionStage;
    }

    void notifyTaskFinished(@NotNull Task.Backgroundable task, long elapsed) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(31);
        }
    }

    protected boolean runProcessWithProgressSynchronously(@NotNull Task task) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(32);
        }
        Ref exceptionRef = new Ref();
        Runnable taskContainer = () -> {
            try {
                this.startTask(task, this.getProgressIndicator(), null);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                exceptionRef.set(e);
            }
        };
        ApplicationEx application = ApplicationManagerEx.getApplicationEx();
        boolean result2 = application.runProcessWithProgressSynchronously(taskContainer, task.getTitle(), task.isCancellable(), task.isModal(), task.getProject(), task.getParentComponent(), task.getCancelText());
        ApplicationUtil.invokeAndWaitSomewhere(task.whereToRunCallbacks(), application.getDefaultModalityState(), () -> this.finishTask(task, !result2, (Throwable)exceptionRef.get()));
        return result2;
    }

    public void runProcessWithProgressInCurrentThread(@NotNull Task task, @NotNull ProgressIndicator progressIndicator, @NotNull ModalityState modalityState) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(33);
        }
        if (progressIndicator == null) {
            CoreProgressManager.$$$reportNull$$$0(34);
        }
        if (modalityState == null) {
            CoreProgressManager.$$$reportNull$$$0(35);
        }
        if (progressIndicator instanceof Disposable) {
            Disposer.register(ApplicationManager.getApplication(), (Disposable)((Object)progressIndicator));
        }
        boolean processCanceled = false;
        Throwable exception = null;
        try {
            this.runProcess(() -> this.startTask(task, progressIndicator, null), progressIndicator);
        }
        catch (ProcessCanceledException e) {
            processCanceled = true;
        }
        catch (Throwable e) {
            exception = e;
        }
        boolean finalCanceled = processCanceled || progressIndicator.isCanceled();
        Throwable finalException = exception;
        ApplicationUtil.invokeAndWaitSomewhere(task.whereToRunCallbacks(), modalityState, () -> this.finishTask(task, finalCanceled, finalException));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finishTask(@NotNull Task task, boolean canceled, @Nullable Throwable error) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(36);
        }
        try {
            if (error != null) {
                task.onThrowable(error);
            } else if (canceled) {
                task.onCancel();
            } else {
                task.onSuccess();
            }
        }
        finally {
            task.onFinished();
        }
    }

    @Override
    public void runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task, @NotNull ProgressIndicator progressIndicator) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(37);
        }
        if (progressIndicator == null) {
            CoreProgressManager.$$$reportNull$$$0(38);
        }
        this.runProcessWithProgressAsynchronously(task, progressIndicator, null);
    }

    @Override
    public ProgressIndicator getProgressIndicator() {
        return CoreProgressManager.getCurrentIndicator(Thread.currentThread());
    }

    @Override
    public void executeProcessUnderProgress(@NotNull Runnable process2, ProgressIndicator progress) throws ProcessCanceledException {
        if (process2 == null) {
            CoreProgressManager.$$$reportNull$$$0(39);
        }
        this.computeUnderProgress(() -> {
            process2.run();
            return null;
        }, progress);
    }

    @Override
    public boolean runInReadActionWithWriteActionPriority(@NotNull Runnable action, @Nullable ProgressIndicator indicator) {
        if (action == null) {
            CoreProgressManager.$$$reportNull$$$0(40);
        }
        ApplicationManager.getApplication().runReadAction(action);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V, E extends Throwable> V computeUnderProgress(@NotNull ThrowableComputable<V, E> process2, ProgressIndicator progress) throws E {
        boolean set;
        if (process2 == null) {
            CoreProgressManager.$$$reportNull$$$0(41);
        }
        if (progress == null) {
            this.myUnsafeProgressCount.incrementAndGet();
        }
        ProgressIndicator oldIndicator = null;
        boolean bl = set = progress != null && progress != (oldIndicator = this.getProgressIndicator());
        if (set) {
            Thread currentThread = Thread.currentThread();
            long threadId = currentThread.getId();
            CoreProgressManager.setCurrentIndicator(threadId, progress);
            V v = this.registerIndicatorAndRun(progress, currentThread, oldIndicator, process2);
            return v;
            finally {
                CoreProgressManager.setCurrentIndicator(threadId, oldIndicator);
            }
        }
        V v = process2.compute();
        return v;
        finally {
            if (progress == null) {
                this.myUnsafeProgressCount.decrementAndGet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V, E extends Throwable> V registerIndicatorAndRun(@NotNull ProgressIndicator indicator, @NotNull Thread currentThread, ProgressIndicator oldIndicator, @NotNull ThrowableComputable<V, E> process2) throws E {
        Map<ProgressIndicator, Set<Thread>> map;
        ProgressIndicator thisIndicator;
        if (indicator == null) {
            CoreProgressManager.$$$reportNull$$$0(42);
        }
        if (currentThread == null) {
            CoreProgressManager.$$$reportNull$$$0(43);
        }
        if (process2 == null) {
            CoreProgressManager.$$$reportNull$$$0(44);
        }
        ArrayList<Set> threadsUnderThisIndicator = new ArrayList<Set>();
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            boolean oneOfTheIndicatorsIsCanceled = false;
            thisIndicator = indicator;
            while (thisIndicator != null) {
                Set underIndicator = threadsUnderIndicator.computeIfAbsent(thisIndicator, __ -> new HashSet());
                boolean alreadyUnder = !underIndicator.add(currentThread);
                threadsUnderThisIndicator.add(alreadyUnder ? null : underIndicator);
                boolean isStandard = thisIndicator instanceof StandardProgressIndicator;
                if (!isStandard) {
                    nonStandardIndicators.compute(thisIndicator, (__, count) -> {
                        if (count == null) {
                            return new AtomicInteger(1);
                        }
                        count.incrementAndGet();
                        return count;
                    });
                    this.startBackgroundNonStandardIndicatorsPing();
                }
                oneOfTheIndicatorsIsCanceled |= thisIndicator.isCanceled();
                thisIndicator = thisIndicator instanceof WrappedProgressIndicator ? ((WrappedProgressIndicator)thisIndicator).getOriginalProgressIndicator() : null;
            }
            this.updateThreadUnderCanceledIndicator(currentThread, oneOfTheIndicatorsIsCanceled);
        }
        try {
            map2 = process2.compute();
            map = threadsUnderIndicator;
        }
        catch (Throwable throwable) {
            Map<ProgressIndicator, Set<Thread>> map3 = threadsUnderIndicator;
            synchronized (map3) {
                ProgressIndicator thisIndicator2 = null;
                for (int i = 0; i < threadsUnderThisIndicator.size(); ++i) {
                    AtomicInteger newCount;
                    boolean isStandard;
                    boolean removed;
                    thisIndicator2 = i == 0 ? indicator : ((WrappedProgressIndicator)thisIndicator2).getOriginalProgressIndicator();
                    Set underIndicator = (Set)threadsUnderThisIndicator.get(i);
                    boolean bl = removed = underIndicator != null && underIndicator.remove(currentThread);
                    if (removed && underIndicator.isEmpty()) {
                        threadsUnderIndicator.remove(thisIndicator2);
                    }
                    if ((isStandard = thisIndicator2 instanceof StandardProgressIndicator) || (newCount = nonStandardIndicators.compute(thisIndicator2, (__, count) -> {
                        if (count.decrementAndGet() == 0) {
                            return null;
                        }
                        return count;
                    })) != null) continue;
                    this.stopBackgroundNonStandardIndicatorsPing();
                }
                this.updateThreadUnderCanceledIndicator(currentThread, oldIndicator != null && oldIndicator.isCanceled());
            }
            throw throwable;
        }
        synchronized (map) {
            thisIndicator = null;
            for (int i = 0; i < threadsUnderThisIndicator.size(); ++i) {
                AtomicInteger newCount;
                boolean isStandard;
                boolean removed;
                thisIndicator = i == 0 ? indicator : ((WrappedProgressIndicator)thisIndicator).getOriginalProgressIndicator();
                Set underIndicator = (Set)threadsUnderThisIndicator.get(i);
                boolean bl = removed = underIndicator != null && underIndicator.remove(currentThread);
                if (removed && underIndicator.isEmpty()) {
                    threadsUnderIndicator.remove(thisIndicator);
                }
                if ((isStandard = thisIndicator instanceof StandardProgressIndicator) || (newCount = nonStandardIndicators.compute(thisIndicator, (__, count) -> {
                    if (count.decrementAndGet() == 0) {
                        return null;
                    }
                    return count;
                })) != null) continue;
                this.stopBackgroundNonStandardIndicatorsPing();
            }
            this.updateThreadUnderCanceledIndicator(currentThread, oldIndicator != null && oldIndicator.isCanceled());
        }
        return (V)map2;
    }

    private void updateThreadUnderCanceledIndicator(@NotNull Thread thread, boolean underCanceledIndicator) {
        boolean changed;
        if (thread == null) {
            CoreProgressManager.$$$reportNull$$$0(45);
        }
        boolean bl = changed = underCanceledIndicator ? threadsUnderCanceledIndicator.add(thread) : threadsUnderCanceledIndicator.remove(thread);
        if (changed) {
            this.updateShouldCheckCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void updateShouldCheckCanceled() {
        Map<ProgressIndicator, Set<Thread>> map = threadsUnderIndicator;
        synchronized (map) {
            CheckCanceledHook hook = this.createCheckCanceledHook();
            boolean hasCanceledIndicator = !threadsUnderCanceledIndicator.isEmpty();
            ourCheckCanceledHook = hook;
            ourCheckCanceledBehavior = hook == null && !hasCanceledIndicator ? CheckCanceledBehavior.NONE : (hasCanceledIndicator && ENABLED ? CheckCanceledBehavior.INDICATOR_PLUS_HOOKS : CheckCanceledBehavior.ONLY_HOOKS);
        }
    }

    @Nullable
    protected CheckCanceledHook createCheckCanceledHook() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void indicatorCanceled(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            CoreProgressManager.$$$reportNull$$$0(46);
        }
        Map<ProgressIndicator, Set<Thread>> map = threadsUnderIndicator;
        synchronized (map) {
            Set<Thread> threads = threadsUnderIndicator.get(indicator);
            if (threads != null) {
                for (Thread thread : threads) {
                    boolean underCancelledIndicator = false;
                    ProgressIndicator currentIndicator = CoreProgressManager.getCurrentIndicator(thread);
                    while (currentIndicator != null) {
                        if (currentIndicator == indicator) {
                            underCancelledIndicator = true;
                            break;
                        }
                        currentIndicator = currentIndicator instanceof WrappedProgressIndicator ? ((WrappedProgressIndicator)currentIndicator).getOriginalProgressIndicator() : null;
                    }
                    if (!underCancelledIndicator) continue;
                    threadsUnderCanceledIndicator.add(thread);
                    this.updateShouldCheckCanceled();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public static boolean isCanceledThread(@NotNull Thread thread) {
        if (thread == null) {
            CoreProgressManager.$$$reportNull$$$0(47);
        }
        Map<ProgressIndicator, Set<Thread>> map = threadsUnderIndicator;
        synchronized (map) {
            return threadsUnderCanceledIndicator.contains(thread);
        }
    }

    @Override
    public boolean isInNonCancelableSection() {
        return isInNonCancelableSection.get() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, E extends Throwable> T computePrioritized(@NotNull ThrowableComputable<T, E> computable) throws E {
        boolean prioritize;
        if (computable == null) {
            CoreProgressManager.$$$reportNull$$$0(48);
        }
        Thread thread = Thread.currentThread();
        Object object = this.myPrioritizationLock;
        synchronized (object) {
            if (this.isCurrentThreadPrioritized()) {
                prioritize = false;
            } else {
                prioritize = true;
                if (this.myPrioritizedThreads.isEmpty()) {
                    this.myPrioritizingStarted = System.nanoTime();
                }
                this.myPrioritizedThreads.add(thread);
                this.updateEffectivePrioritized();
            }
        }
        try {
            object = computable.compute();
            return (T)object;
        }
        finally {
            if (prioritize) {
                Object object2 = this.myPrioritizationLock;
                synchronized (object2) {
                    this.myPrioritizedThreads.remove(thread);
                    this.updateEffectivePrioritized();
                }
            }
        }
    }

    private void updateEffectivePrioritized() {
        Thread[] prev = this.myEffectivePrioritizedThreads;
        Thread[] current = this.myDeprioritizations > 0 || this.myPrioritizedThreads.isEmpty() ? EMPTY_THREAD_ARRAY : this.myPrioritizedThreads.toArray(EMPTY_THREAD_ARRAY);
        this.myEffectivePrioritizedThreads = current;
        if (prev.length == 0 && current.length > 0) {
            this.prioritizingStarted();
        } else if (prev.length > 0 && current.length == 0) {
            this.prioritizingFinished();
        }
    }

    protected void prioritizingStarted() {
    }

    protected void prioritizingFinished() {
    }

    @ApiStatus.Internal
    public boolean isCurrentThreadPrioritized() {
        return this.myPrioritizedThreads.contains(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void suppressPrioritizing() {
        Object object = this.myPrioritizationLock;
        synchronized (object) {
            if (++this.myDeprioritizations == 100 + ForkJoinPool.getCommonPoolParallelism() * 2) {
                Attachment attachment = new Attachment("threadDump.txt", ThreadDumper.dumpThreadsToString());
                attachment.setIncluded(true);
                LOG.error("A suspiciously high nesting of suppressPrioritizing, forgot to call restorePrioritizing?", attachment);
            }
            this.updateEffectivePrioritized();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void restorePrioritizing() {
        Object object = this.myPrioritizationLock;
        synchronized (object) {
            if (--this.myDeprioritizations < 0) {
                this.myDeprioritizations = 0;
                LOG.error("Unmatched suppressPrioritizing/restorePrioritizing");
            }
            this.updateEffectivePrioritized();
        }
    }

    protected boolean sleepIfNeededToGivePriorityToAnotherThread() {
        if (!this.isCurrentThreadEffectivelyPrioritized() && this.checkLowPriorityReallyApplicable()) {
            LockSupport.parkNanos(1000000L);
            this.avoidBlockingPrioritizingThread();
            return true;
        }
        return false;
    }

    private boolean isCurrentThreadEffectivelyPrioritized() {
        Thread current = Thread.currentThread();
        for (Thread prioritized : this.myEffectivePrioritizedThreads) {
            if (prioritized != current) continue;
            return true;
        }
        return false;
    }

    private boolean checkLowPriorityReallyApplicable() {
        long time = System.nanoTime() - this.myPrioritizingStarted;
        if (time < 5000000L) {
            return false;
        }
        if (this.avoidBlockingPrioritizingThread()) {
            return false;
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            return false;
        }
        if (time > MAX_PRIORITIZATION_NANOS) {
            this.stopAllPrioritization();
            return false;
        }
        return true;
    }

    private boolean avoidBlockingPrioritizingThread() {
        if (this.isAnyPrioritizedThreadBlocked()) {
            this.suppressPrioritizing();
            this.checkLaterThreadsAreUnblocked();
            return true;
        }
        return false;
    }

    private void checkLaterThreadsAreUnblocked() {
        try {
            AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> {
                if (this.isAnyPrioritizedThreadBlocked()) {
                    this.checkLaterThreadsAreUnblocked();
                } else {
                    this.restorePrioritizing();
                }
            }, 5L, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopAllPrioritization() {
        Object object = this.myPrioritizationLock;
        synchronized (object) {
            this.myPrioritizedThreads.clear();
            this.updateEffectivePrioritized();
        }
    }

    private boolean isAnyPrioritizedThreadBlocked() {
        for (Thread thread : this.myEffectivePrioritizedThreads) {
            Thread.State state = thread.getState();
            if (state != Thread.State.WAITING && state != Thread.State.TIMED_WAITING && state != Thread.State.BLOCKED) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static ModalityState getCurrentThreadProgressModality() {
        ProgressIndicator indicator = threadTopLevelIndicators.get(Thread.currentThread().getId());
        ModalityState modality = indicator == null ? null : indicator.getModalityState();
        ModalityState modalityState = modality != null ? modality : ModalityState.NON_MODAL;
        if (modalityState == null) {
            CoreProgressManager.$$$reportNull$$$0(49);
        }
        return modalityState;
    }

    private static void setCurrentIndicator(long threadId, ProgressIndicator indicator) {
        if (indicator == null) {
            currentIndicators.remove(threadId);
            threadTopLevelIndicators.remove(threadId);
        } else {
            currentIndicators.put(threadId, indicator);
            threadTopLevelIndicators.putIfAbsent(threadId, indicator);
        }
    }

    private static ProgressIndicator getCurrentIndicator(@NotNull Thread thread) {
        if (thread == null) {
            CoreProgressManager.$$$reportNull$$$0(50);
        }
        return currentIndicators.get(thread.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertUnderProgress(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            CoreProgressManager.$$$reportNull$$$0(51);
        }
        Map<ProgressIndicator, Set<Thread>> map = threadsUnderIndicator;
        synchronized (map) {
            Set<Thread> threads = threadsUnderIndicator.get(indicator);
            if (threads == null || !threads.contains(Thread.currentThread())) {
                LOG.error("Must be executed under progress indicator: " + indicator + ". Please see e.g. ProgressManager.runProcess()");
            }
        }
    }

    static {
        threadsUnderIndicator = new HashMap<ProgressIndicator, Set<Thread>>();
        currentIndicators = ContainerUtil.createConcurrentLongObjectMap();
        threadTopLevelIndicators = ContainerUtil.createConcurrentLongObjectMap();
        threadsUnderCanceledIndicator = new HashSet<Thread>();
        ourCheckCanceledBehavior = CheckCanceledBehavior.NONE;
        nonStandardIndicators = new ConcurrentHashMap<ProgressIndicator, AtomicInteger>();
        isInNonCancelableSection = new ThreadLocal();
        MAX_PRIORITIZATION_NANOS = TimeUnit.SECONDS.toNanos(12L);
        EMPTY_THREAD_ARRAY = new Thread[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/openapi/progress/impl/CoreProgressManager";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 13: 
            case 39: 
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 4: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressTitle";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 24: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 20: 
            case 25: 
            case 29: 
            case 34: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 23: 
            case 42: 
            case 46: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 26: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentThread";
                break;
            }
            case 45: 
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentIndicators";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/openapi/progress/impl/CoreProgressManager";
                break;
            }
            case 18: 
            case 21: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "runProcessWithProgressAsynchronously";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "runProcessWithProgressAsync";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentThreadProgressModality";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "runProcess";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "assertNoOtherThreadUnder";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "executeNonCancelableSection";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computeInNonCancelableSection";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithProgressSynchronously";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithProgressAsynchronously";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "runAsynchronously";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "startTask";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithProgressAsync";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "notifyTaskFinished";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithProgressInCurrentThread";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "finishTask";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "executeProcessUnderProgress";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "runInReadActionWithWriteActionPriority";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "computeUnderProgress";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "registerIndicatorAndRun";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "updateThreadUnderCanceledIndicator";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "indicatorCanceled";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isCanceledThread";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "computePrioritized";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentIndicator";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "assertUnderProgress";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    static interface CheckCanceledHook {
        public boolean runHook(@Nullable ProgressIndicator var1);
    }

    private static class IndicatorDisposable
    implements Disposable {
        @NotNull
        private final ProgressIndicator myIndicator;

        IndicatorDisposable(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                IndicatorDisposable.$$$reportNull$$$0(0);
            }
            this.myIndicator = indicator;
        }

        @Override
        public void dispose() {
            Disposer.dispose((Disposable)((Object)this.myIndicator), false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "ksp/com/intellij/openapi/progress/impl/CoreProgressManager$IndicatorDisposable", "<init>"));
        }
    }

    private static enum CheckCanceledBehavior {
        NONE,
        ONLY_HOOKS,
        INDICATOR_PLUS_HOOKS;

    }
}

