/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.progress;

import java.util.concurrent.CancellationException;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import ksp.com.intellij.openapi.application.AccessToken;
import ksp.com.intellij.openapi.progress.Cancellation;
import ksp.com.intellij.openapi.progress.JobCanceledException;
import ksp.com.intellij.openapi.progress.JobFutureTask;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class JobRunnable
implements Runnable {
    @NotNull
    private final CompletableJob myJob;
    @NotNull
    private final Runnable myRunnable;

    private JobRunnable(@NotNull Runnable runnable) {
        if (runnable == null) {
            JobRunnable.$$$reportNull$$$0(0);
        }
        this.myJob = JobKt.Job((Job)Cancellation.currentJob());
        this.myRunnable = runnable;
    }

    @Override
    public void run() {
        try (AccessToken ignored = Cancellation.withJob((Job)this.myJob);){
            this.myRunnable.run();
            this.myJob.complete();
        }
        catch (JobCanceledException e) {
            if (!this.myJob.isCancelled()) {
                throw new IllegalStateException("JobCanceledException must be thrown by ProgressManager.checkCanceled()", e);
            }
        }
        catch (CancellationException e) {
            this.myJob.completeExceptionally((Throwable)e);
        }
        catch (Throwable e) {
            this.myJob.completeExceptionally(e);
            throw e;
        }
    }

    @NotNull
    public static Runnable jobRunnable(@NotNull Runnable runnable) {
        if (runnable == null) {
            JobRunnable.$$$reportNull$$$0(1);
        }
        if (runnable instanceof JobFutureTask) {
            Runnable runnable2 = runnable;
            if (runnable2 == null) {
                JobRunnable.$$$reportNull$$$0(2);
            }
            return runnable2;
        }
        return new JobRunnable(runnable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/openapi/progress/JobRunnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/openapi/progress/JobRunnable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "jobRunnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "jobRunnable";
                break;
            }
            case 2: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

