/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.lang.impl;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import ksp.com.intellij.lang.impl.PsiBuilderImpl;
import ksp.com.intellij.util.containers.IntStack;

final class MarkerPool
extends ObjectArrayList<PsiBuilderImpl.ProductionMarker> {
    private final PsiBuilderImpl myBuilder;
    private final IntStack myFreeStartMarkers = new IntStack();
    private final IntStack myFreeErrorItems = new IntStack();

    MarkerPool(PsiBuilderImpl builder2) {
        this.myBuilder = builder2;
        this.add(null);
    }

    PsiBuilderImpl.StartMarker allocateStartMarker() {
        if (this.myFreeStartMarkers.size() > 0) {
            return (PsiBuilderImpl.StartMarker)this.get(this.myFreeStartMarkers.pop());
        }
        PsiBuilderImpl.StartMarker marker = new PsiBuilderImpl.StartMarker(this.size(), this.myBuilder);
        this.add(marker);
        return marker;
    }

    PsiBuilderImpl.ErrorItem allocateErrorItem() {
        if (this.myFreeErrorItems.size() > 0) {
            return (PsiBuilderImpl.ErrorItem)this.get(this.myFreeErrorItems.pop());
        }
        PsiBuilderImpl.ErrorItem item = new PsiBuilderImpl.ErrorItem(this.size(), this.myBuilder);
        this.add(item);
        return item;
    }

    void freeMarker(PsiBuilderImpl.ProductionMarker marker) {
        marker.clean();
        (marker instanceof PsiBuilderImpl.StartMarker ? this.myFreeStartMarkers : this.myFreeErrorItems).push(marker.markerId);
    }
}

