/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.lang;

import ksp.com.intellij.lang.PsiBuilder;
import ksp.com.intellij.lang.WhitespacesBinders;
import ksp.com.intellij.lexer.Lexer;
import ksp.com.intellij.openapi.progress.ProgressManager;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiBuilderUtil {
    private PsiBuilderUtil() {
    }

    public static void advance(PsiBuilder builder2, int count) {
        for (int i = 0; i < count && !builder2.eof(); ++i) {
            builder2.getTokenType();
            builder2.advanceLexer();
        }
    }

    public static boolean expect(PsiBuilder builder2, IElementType expectedType) {
        if (builder2.getTokenType() == expectedType) {
            builder2.advanceLexer();
            return true;
        }
        return false;
    }

    public static boolean expect(PsiBuilder builder2, TokenSet expectedTypes) {
        if (expectedTypes.contains(builder2.getTokenType())) {
            builder2.advanceLexer();
            return true;
        }
        return false;
    }

    public static void drop(PsiBuilder.Marker ... markers2) {
        for (PsiBuilder.Marker marker : markers2) {
            if (marker == null) continue;
            marker.drop();
        }
    }

    public static void rollbackTo(@Nullable PsiBuilder.Marker marker) {
        if (marker != null) {
            marker.rollbackTo();
        }
    }

    @NotNull
    public static CharSequence rawTokenText(PsiBuilder builder2, int index2) {
        CharSequence charSequence = builder2.getOriginalText().subSequence(builder2.rawTokenTypeStart(index2), builder2.rawTokenTypeStart(index2 + 1));
        if (charSequence == null) {
            PsiBuilderUtil.$$$reportNull$$$0(0);
        }
        return charSequence;
    }

    @Nullable
    public static PsiBuilder.Marker parseBlockLazy(@NotNull PsiBuilder builder2, @NotNull IElementType leftBrace, @NotNull IElementType rightBrace, @NotNull IElementType codeBlock) {
        if (builder2 == null) {
            PsiBuilderUtil.$$$reportNull$$$0(1);
        }
        if (leftBrace == null) {
            PsiBuilderUtil.$$$reportNull$$$0(2);
        }
        if (rightBrace == null) {
            PsiBuilderUtil.$$$reportNull$$$0(3);
        }
        if (codeBlock == null) {
            PsiBuilderUtil.$$$reportNull$$$0(4);
        }
        if (builder2.getTokenType() != leftBrace) {
            return null;
        }
        PsiBuilder.Marker marker = builder2.mark();
        builder2.advanceLexer();
        int braceCount = 1;
        while (braceCount > 0 && !builder2.eof()) {
            IElementType tokenType = builder2.getTokenType();
            if (tokenType == leftBrace) {
                ++braceCount;
            } else if (tokenType == rightBrace) {
                --braceCount;
            }
            builder2.advanceLexer();
        }
        marker.collapse(codeBlock);
        if (braceCount > 0) {
            marker.setCustomEdgeTokenBinders(null, WhitespacesBinders.GREEDY_RIGHT_BINDER);
        }
        return marker;
    }

    public static boolean hasProperBraceBalance(@NotNull CharSequence text, @NotNull Lexer lexer, @NotNull IElementType leftBrace, @NotNull IElementType rightBrace) {
        if (text == null) {
            PsiBuilderUtil.$$$reportNull$$$0(5);
        }
        if (lexer == null) {
            PsiBuilderUtil.$$$reportNull$$$0(6);
        }
        if (leftBrace == null) {
            PsiBuilderUtil.$$$reportNull$$$0(7);
        }
        if (rightBrace == null) {
            PsiBuilderUtil.$$$reportNull$$$0(8);
        }
        lexer.start(text);
        if (lexer.getTokenType() != leftBrace) {
            return false;
        }
        lexer.advance();
        int balance = 1;
        while (true) {
            ProgressManager.checkCanceled();
            IElementType type2 = lexer.getTokenType();
            if (type2 == null) {
                return balance == 0;
            }
            if (balance == 0) {
                return false;
            }
            if (type2 == leftBrace) {
                ++balance;
            } else if (type2 == rightBrace) {
                --balance;
            }
            lexer.advance();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/lang/PsiBuilderUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftBrace";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightBrace";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeBlock";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "rawTokenText";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/lang/PsiBuilderUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseBlockLazy";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasProperBraceBalance";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

