/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.ide.plugins;

import java.awt.GraphicsEnvironment;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ksp.com.intellij.core.CoreBundle;
import ksp.com.intellij.diagnostic.Activity;
import ksp.com.intellij.diagnostic.ActivityCategory;
import ksp.com.intellij.diagnostic.LoadingState;
import ksp.com.intellij.diagnostic.PluginException;
import ksp.com.intellij.diagnostic.StartUpMeasurer;
import ksp.com.intellij.ide.plugins.ClassLoaderConfigurator;
import ksp.com.intellij.ide.plugins.DescriptorListLoadingContext;
import ksp.com.intellij.ide.plugins.DisabledPluginsState;
import ksp.com.intellij.ide.plugins.IdeaPluginDescriptor;
import ksp.com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import ksp.com.intellij.ide.plugins.ModuleDependenciesDescriptor;
import ksp.com.intellij.ide.plugins.PluginDependency;
import ksp.com.intellij.ide.plugins.PluginDescriptorLoader;
import ksp.com.intellij.ide.plugins.PluginEnabler;
import ksp.com.intellij.ide.plugins.PluginLoadingError;
import ksp.com.intellij.ide.plugins.PluginLoadingResult;
import ksp.com.intellij.ide.plugins.PluginManagerState;
import ksp.com.intellij.ide.plugins.PluginSet;
import ksp.com.intellij.ide.plugins.PluginSetBuilder;
import ksp.com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import ksp.com.intellij.ide.plugins.cl.PluginClassLoader;
import ksp.com.intellij.openapi.application.PathManager;
import ksp.com.intellij.openapi.application.ex.ApplicationInfoEx;
import ksp.com.intellij.openapi.application.impl.ApplicationInfoImpl;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.extensions.PluginDescriptor;
import ksp.com.intellij.openapi.extensions.PluginId;
import ksp.com.intellij.openapi.util.BuildNumber;
import ksp.com.intellij.openapi.util.NlsContexts;
import ksp.com.intellij.openapi.util.NlsSafe;
import ksp.com.intellij.openapi.util.io.FileUtilRt;
import ksp.com.intellij.openapi.util.text.HtmlChunk;
import ksp.com.intellij.openapi.util.text.StringUtil;
import ksp.com.intellij.util.containers.ContainerUtil;
import ksp.com.intellij.util.lang.UrlClassLoader;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public final class PluginManagerCore {
    @NonNls
    public static final String META_INF = "META-INF/";
    public static final PluginId CORE_ID = PluginId.getId("com.intellij");
    public static final String CORE_PLUGIN_ID = "com.intellij";
    public static final PluginId JAVA_PLUGIN_ID = PluginId.getId("ksp.com.intellij.java");
    static final PluginId JAVA_MODULE_ID = PluginId.getId("ksp.com.intellij.modules.java");
    public static final String PLUGIN_XML = "plugin.xml";
    public static final String PLUGIN_XML_PATH = "META-INF/plugin.xml";
    static final PluginId ALL_MODULES_MARKER = PluginId.getId("ksp.com.intellij.modules.all");
    public static final String VENDOR_JETBRAINS = "JetBrains";
    public static final String VENDOR_JETBRAINS_SRO = "JetBrains s.r.o.";
    private static final String MODULE_DEPENDENCY_PREFIX = "ksp.com.intellij.module";
    public static final PluginId SPECIAL_IDEA_PLUGIN_ID = PluginId.getId("IDEA CORE");
    static final String PROPERTY_PLUGIN_PATH = "plugin.path";
    @NonNls
    static final String DISABLE = "disable";
    @NonNls
    static final String ENABLE = "enable";
    @NonNls
    static final String EDIT = "edit";
    private static final boolean IGNORE_DISABLED_PLUGINS = Boolean.getBoolean("idea.ignore.disabled.plugins");
    private static final MethodType HAS_LOADED_CLASS_METHOD_TYPE = MethodType.methodType(Boolean.TYPE, String.class);
    private static Reference<Map<PluginId, Set<String>>> brokenPluginVersions;
    @Nullable
    private static volatile PluginSet pluginSet;
    private static Map<PluginId, PluginLoadingError> pluginLoadingErrors;
    public static volatile boolean isUnitTestMode;
    @ApiStatus.Internal
    private static final List<Supplier<? extends HtmlChunk>> pluginErrors;
    private static Set<PluginId> ourPluginsToDisable;
    private static Set<PluginId> ourPluginsToEnable;
    private static Set<PluginId> ourShadowedBundledPlugins;
    private static Boolean isRunningFromSources;
    private static volatile CompletableFuture<DescriptorListLoadingContext> descriptorListFuture;
    private static BuildNumber ourBuildNumber;

    @NotNull
    public static @NotNull IdeaPluginDescriptor @NotNull [] getPlugins() {
        IdeaPluginDescriptor[] ideaPluginDescriptorArray = PluginManagerCore.getPluginSet().allPlugins.toArray(new IdeaPluginDescriptor[0]);
        if (ideaPluginDescriptorArray == null) {
            PluginManagerCore.$$$reportNull$$$0(0);
        }
        return ideaPluginDescriptorArray;
    }

    @ApiStatus.Internal
    @NotNull
    public static PluginSet getPluginSet() {
        PluginSet pluginSet = Objects.requireNonNull(PluginManagerCore.pluginSet);
        if (pluginSet == null) {
            PluginManagerCore.$$$reportNull$$$0(1);
        }
        return pluginSet;
    }

    @NotNull
    public static List<? extends IdeaPluginDescriptor> getLoadedPlugins() {
        List<IdeaPluginDescriptorImpl> list2 = PluginManagerCore.getPluginSet().enabledPlugins;
        if (list2 == null) {
            PluginManagerCore.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @ApiStatus.Internal
    @NotNull
    public static List<IdeaPluginDescriptorImpl> getLoadedPlugins(@Nullable ClassLoader coreClassLoader) {
        PluginSet result2 = pluginSet;
        if (result2 != null) {
            List<IdeaPluginDescriptorImpl> list2 = result2.enabledPlugins;
            if (list2 == null) {
                PluginManagerCore.$$$reportNull$$$0(3);
            }
            return list2;
        }
        List<IdeaPluginDescriptorImpl> list3 = PluginManagerCore.loadAndInitializePlugins((DescriptorListLoadingContext)PluginDescriptorLoader.loadDescriptors((boolean)PluginManagerCore.isUnitTestMode, (boolean)PluginManagerCore.isRunningFromSources()), (ClassLoader)(coreClassLoader == null ? PluginManagerCore.class.getClassLoader() : coreClassLoader)).enabledPlugins;
        if (list3 == null) {
            PluginManagerCore.$$$reportNull$$$0(4);
        }
        return list3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @ApiStatus.Internal
    @NotNull
    public static List<HtmlChunk> getAndClearPluginLoadingErrors() {
        List<Supplier<? extends HtmlChunk>> list3 = pluginErrors;
        // MONITORENTER : list3
        List<HtmlChunk> errors = ContainerUtil.map(pluginErrors, Supplier::get);
        pluginErrors.clear();
        List<HtmlChunk> list2 = errors;
        // MONITOREXIT : list3
        if (list2 != null) return list2;
        PluginManagerCore.$$$reportNull$$$0(5);
        return list2;
    }

    @ApiStatus.Internal
    public static boolean arePluginsInitialized() {
        return pluginSet != null;
    }

    @ApiStatus.Internal
    public static void setPluginSet(@NotNull PluginSet value2) {
        if (value2 == null) {
            PluginManagerCore.$$$reportNull$$$0(6);
        }
        pluginSet = value2;
    }

    public static boolean isDisabled(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            PluginManagerCore.$$$reportNull$$$0(7);
        }
        return PluginEnabler.HEADLESS.isDisabled(pluginId);
    }

    public static boolean isBrokenPlugin(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(8);
        }
        PluginId pluginId = descriptor2.getPluginId();
        Set<String> set = PluginManagerCore.getBrokenPluginVersions().get(pluginId);
        return set != null && set.contains(descriptor2.getVersion());
    }

    public static void updateBrokenPlugins(Map<PluginId, Set<String>> brokenPlugins) {
        brokenPluginVersions = new SoftReference<Map<PluginId, Set<String>>>(brokenPlugins);
        Path updatedBrokenPluginFile = PluginManagerCore.getUpdatedBrokenPluginFile();
        try (DataOutputStream out2 = new DataOutputStream(new BufferedOutputStream(Files.newOutputStream(updatedBrokenPluginFile, new OpenOption[0]), 32000));){
            out2.write(2);
            out2.writeUTF(PluginManagerCore.getBuildNumber().asString());
            out2.writeInt(brokenPlugins.size());
            for (Map.Entry<PluginId, Set<String>> entry : brokenPlugins.entrySet()) {
                out2.writeUTF(entry.getKey().getIdString());
                out2.writeShort(entry.getValue().size());
                for (String s : entry.getValue()) {
                    out2.writeUTF(s);
                }
            }
        }
        catch (NoSuchFileException out2) {
        }
        catch (IOException e) {
            PluginManagerCore.getLogger().error("Failed to read " + updatedBrokenPluginFile, e);
        }
    }

    @NotNull
    static @NotNull Map<@NotNull PluginId, @NotNull Set<String>> getBrokenPluginVersions() {
        Map<PluginId, Set<String>> result2;
        if (IGNORE_DISABLED_PLUGINS) {
            Map<PluginId, Set<String>> map = Collections.emptyMap();
            if (map == null) {
                PluginManagerCore.$$$reportNull$$$0(9);
            }
            return map;
        }
        Map<PluginId, Set<String>> map = result2 = brokenPluginVersions == null ? null : brokenPluginVersions.get();
        if (result2 == null) {
            result2 = PluginManagerCore.readBrokenPluginFile();
            brokenPluginVersions = new SoftReference<Map<PluginId, Set<String>>>(result2);
        }
        Map<PluginId, Set<String>> map2 = result2;
        if (map2 == null) {
            PluginManagerCore.$$$reportNull$$$0(10);
        }
        return map2;
    }

    @NotNull
    private static Map<PluginId, Set<String>> readBrokenPluginFile() {
        Map<PluginId, Set<String>> result2 = null;
        Path updatedBrokenPluginFile = PluginManagerCore.getUpdatedBrokenPluginFile();
        if (Files.exists(updatedBrokenPluginFile, new LinkOption[0]) && (result2 = PluginManagerCore.tryReadBrokenPluginsFile(updatedBrokenPluginFile)) != null) {
            PluginManagerCore.getLogger().debug("Using cached broken plugins file");
        }
        if (result2 == null && (result2 = PluginManagerCore.tryReadBrokenPluginsFile(Paths.get(PathManager.getBinPath() + "/brokenPlugins.db", new String[0]))) != null) {
            PluginManagerCore.getLogger().debug("Using broken plugins file from IDE distribution");
        }
        if (result2 != null) {
            Map<PluginId, Set<String>> map = result2;
            if (map == null) {
                PluginManagerCore.$$$reportNull$$$0(11);
            }
            return map;
        }
        Map<PluginId, Set<String>> map = Collections.emptyMap();
        if (map == null) {
            PluginManagerCore.$$$reportNull$$$0(12);
        }
        return map;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static Map<PluginId, Set<String>> tryReadBrokenPluginsFile(Path brokenPluginsStorage) {
        try (DataInputStream stream2 = new DataInputStream(new BufferedInputStream(Files.newInputStream(brokenPluginsStorage, new OpenOption[0]), 32000));){
            int version = stream2.readUnsignedByte();
            if (version != 2) {
                PluginManagerCore.getLogger().info("Unsupported version of " + brokenPluginsStorage + "(fileVersion=" + version + ", supportedVersion=2)");
                Map<PluginId, Set<String>> map = null;
                return map;
            }
            String buildNumber = stream2.readUTF();
            if (!buildNumber.equals(PluginManagerCore.getBuildNumber().toString())) {
                PluginManagerCore.getLogger().info("Ignoring cached broken plugins file from an earlier IDE build (" + buildNumber + ")");
                Map<PluginId, Set<String>> map = null;
                return map;
            }
            int count = stream2.readInt();
            HashMap<PluginId, Set<String>> result2 = new HashMap<PluginId, Set<String>>(count);
            for (int i = 0; i < count; ++i) {
                PluginId pluginId = PluginId.getId(stream2.readUTF());
                String[] versions2 = new String[stream2.readUnsignedShort()];
                for (int j = 0; j < versions2.length; ++j) {
                    versions2[j] = stream2.readUTF();
                }
                result2.put(pluginId, versions2.length == 1 ? Collections.singleton(versions2[0]) : new HashSet<String>(Arrays.asList(versions2)));
            }
            HashMap<PluginId, Set<String>> hashMap = result2;
            return hashMap;
        }
        catch (NoSuchFileException stream2) {
            return null;
        }
        catch (IOException e) {
            PluginManagerCore.getLogger().error("Failed to read " + brokenPluginsStorage, e);
        }
        return null;
    }

    public static void writePluginsList(@NotNull Collection<PluginId> ids, @NotNull Writer writer) throws IOException {
        if (ids == null) {
            PluginManagerCore.$$$reportNull$$$0(13);
        }
        if (writer == null) {
            PluginManagerCore.$$$reportNull$$$0(14);
        }
        ArrayList<PluginId> sortedIds = new ArrayList<PluginId>(ids);
        sortedIds.sort(null);
        for (PluginId id : sortedIds) {
            writer.write(id.getIdString());
            writer.write(10);
        }
    }

    public static boolean disablePlugin(@NotNull PluginId id) {
        if (id == null) {
            PluginManagerCore.$$$reportNull$$$0(15);
        }
        return PluginEnabler.HEADLESS.disableById(Collections.singleton(id));
    }

    public static boolean enablePlugin(@NotNull PluginId id) {
        if (id == null) {
            PluginManagerCore.$$$reportNull$$$0(16);
        }
        return PluginEnabler.HEADLESS.enableById(Collections.singleton(id));
    }

    public static boolean isModuleDependency(@NotNull PluginId dependentPluginId) {
        if (dependentPluginId == null) {
            PluginManagerCore.$$$reportNull$$$0(17);
        }
        return dependentPluginId.getIdString().startsWith(MODULE_DEPENDENCY_PREFIX);
    }

    @ApiStatus.Internal
    @NotNull
    public static PluginException createPluginException(@NotNull String errorMessage2, @Nullable Throwable cause, @NotNull Class<?> pluginClass) {
        ClassLoader classLoader;
        if (errorMessage2 == null) {
            PluginManagerCore.$$$reportNull$$$0(18);
        }
        if (pluginClass == null) {
            PluginManagerCore.$$$reportNull$$$0(19);
        }
        PluginId pluginId = (classLoader = pluginClass.getClassLoader()) instanceof PluginAwareClassLoader ? ((PluginAwareClassLoader)((Object)classLoader)).getPluginId() : PluginManagerCore.getPluginByClassName(pluginClass.getName());
        return new PluginException(errorMessage2, cause, pluginId);
    }

    @Nullable
    public static PluginId getPluginByClassName(@NotNull String className2) {
        PluginId id;
        if (className2 == null) {
            PluginManagerCore.$$$reportNull$$$0(20);
        }
        return (id = PluginManagerCore.getPluginOrPlatformByClassName(className2)) != null && !CORE_ID.equals(id) ? id : null;
    }

    @Nullable
    public static PluginId getPluginOrPlatformByClassName(@NotNull String className2) {
        PluginDescriptor result2;
        if (className2 == null) {
            PluginManagerCore.$$$reportNull$$$0(21);
        }
        return (result2 = PluginManagerCore.getPluginDescriptorOrPlatformByClassName(className2)) == null ? null : result2.getPluginId();
    }

    @ApiStatus.Internal
    @Nullable
    public static PluginDescriptor getPluginDescriptorOrPlatformByClassName(@NotNull @NonNls String className2) {
        PluginSet pluginSet;
        if (className2 == null) {
            PluginManagerCore.$$$reportNull$$$0(22);
        }
        if ((pluginSet = PluginManagerCore.pluginSet) == null || className2.startsWith("java.") || className2.startsWith("javax.") || className2.startsWith("kotlin.") || className2.startsWith("groovy.") || !className2.contains(".")) {
            return null;
        }
        IdeaPluginDescriptorImpl result2 = null;
        for (IdeaPluginDescriptorImpl o : pluginSet.getRawListOfEnabledModules()) {
            ClassLoader classLoader = o.getClassLoader();
            if (!PluginManagerCore.hasLoadedClass(className2, classLoader)) continue;
            result2 = o;
            break;
        }
        if (result2 == null) {
            return null;
        }
        if (!CORE_ID.equals(result2.getPluginId()) || className2.startsWith("com.jetbrains.") || className2.startsWith("org.jetbrains.") || className2.startsWith("ksp.com.intellij.") || className2.startsWith("org.intellij.") || className2.startsWith("com.android.") || className2.startsWith("git4idea.") || className2.startsWith("org.angularjs.")) {
            return result2;
        }
        String root = null;
        for (IdeaPluginDescriptorImpl o : pluginSet.enabledPlugins) {
            if (!o.isUseIdeaClassLoader) continue;
            if (root == null && (root = PathManager.getResourceRoot(result2.getClassLoader(), className2.replace('.', '/') + ".class")) == null) {
                return null;
            }
            Path path = o.getPluginPath();
            if (!root.startsWith(FileUtilRt.toSystemIndependentName(path.toString()))) continue;
            return o;
        }
        return null;
    }

    public static boolean isDevelopedByJetBrains(@NotNull PluginDescriptor plugin) {
        String vendor;
        if (plugin == null) {
            PluginManagerCore.$$$reportNull$$$0(23);
        }
        return PluginManagerCore.isDevelopedByJetBrains(vendor = plugin.getVendor()) || PluginManagerCore.isDevelopedByJetBrains(plugin.getOrganization()) || vendor == null && !(plugin.getPluginClassLoader() instanceof PluginClassLoader) && plugin instanceof IdeaPluginDescriptorImpl && !((IdeaPluginDescriptorImpl)plugin).isUseIdeaClassLoader && ApplicationInfoEx.getInstanceEx().isVendorJetBrains();
    }

    public static boolean isDevelopedByJetBrains(@Nullable String vendorString) {
        if (vendorString == null) {
            return false;
        }
        if (PluginManagerCore.isVendorJetBrains(vendorString)) {
            return true;
        }
        for (String vendor : StringUtil.split(vendorString, ",")) {
            String vendorItem = vendor.trim();
            if (!PluginManagerCore.isVendorJetBrains(vendorItem)) continue;
            return true;
        }
        return false;
    }

    public static boolean isVendorJetBrains(@NotNull String vendorItem) {
        if (vendorItem == null) {
            PluginManagerCore.$$$reportNull$$$0(24);
        }
        return VENDOR_JETBRAINS.equals(vendorItem) || VENDOR_JETBRAINS_SRO.equals(vendorItem);
    }

    private static Path getUpdatedBrokenPluginFile() {
        return Paths.get(PathManager.getConfigPath(), new String[0]).resolve("updatedBrokenPlugins.db");
    }

    private static boolean hasLoadedClass(@NotNull String className2, @NotNull ClassLoader loader) {
        if (className2 == null) {
            PluginManagerCore.$$$reportNull$$$0(25);
        }
        if (loader == null) {
            PluginManagerCore.$$$reportNull$$$0(26);
        }
        if (loader instanceof UrlClassLoader) {
            return ((UrlClassLoader)loader).hasLoadedClass(className2);
        }
        Class<?> aClass = loader.getClass();
        if (aClass.isAnonymousClass() || aClass.isMemberClass()) {
            aClass = aClass.getSuperclass();
        }
        try {
            return MethodHandles.publicLookup().findVirtual(aClass, "hasLoadedClass", HAS_LOADED_CLASS_METHOD_TYPE).invoke(loader, className2);
        }
        catch (IllegalAccessError | IllegalAccessException | NoSuchMethodError throwable) {
        }
        catch (Throwable e) {
            PluginManagerCore.getLogger().error(e);
        }
        return false;
    }

    static boolean hasModuleDependencies(@NotNull IdeaPluginDescriptorImpl descriptor2) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(27);
        }
        for (PluginDependency dependency : descriptor2.pluginDependencies) {
            PluginId dependencyPluginId = dependency.getPluginId();
            if (!JAVA_PLUGIN_ID.equals(dependencyPluginId) && !JAVA_MODULE_ID.equals(dependencyPluginId) && !PluginManagerCore.isModuleDependency(dependencyPluginId)) continue;
            return true;
        }
        return false;
    }

    public static synchronized void invalidatePlugins() {
        pluginSet = null;
        CompletableFuture<DescriptorListLoadingContext> future = descriptorListFuture;
        if (future != null) {
            descriptorListFuture = null;
            future.cancel(false);
        }
        DisabledPluginsState.invalidate();
        ourShadowedBundledPlugins = null;
    }

    private static void logPlugins(@NotNull List<IdeaPluginDescriptorImpl> plugins, @NotNull Collection<IdeaPluginDescriptorImpl> incompletePlugins) {
        if (plugins == null) {
            PluginManagerCore.$$$reportNull$$$0(28);
        }
        if (incompletePlugins == null) {
            PluginManagerCore.$$$reportNull$$$0(29);
        }
        StringBuilder bundled = new StringBuilder();
        StringBuilder disabled = new StringBuilder();
        StringBuilder custom = new StringBuilder();
        HashSet<PluginId> disabledPlugins = new HashSet<PluginId>();
        for (IdeaPluginDescriptor ideaPluginDescriptor : plugins) {
            StringBuilder target;
            PluginId pluginId = ideaPluginDescriptor.getPluginId();
            if (!ideaPluginDescriptor.isEnabled()) {
                if (!PluginManagerCore.isDisabled(pluginId)) continue;
                disabledPlugins.add(pluginId);
                target = disabled;
            } else {
                target = ideaPluginDescriptor.isBundled() || SPECIAL_IDEA_PLUGIN_ID.equals(pluginId) ? bundled : custom;
            }
            PluginManagerCore.appendPlugin(ideaPluginDescriptor, target);
        }
        for (IdeaPluginDescriptorImpl ideaPluginDescriptorImpl : incompletePlugins) {
            PluginId pluginId = ideaPluginDescriptorImpl.getPluginId();
            if (!PluginManagerCore.isDisabled(pluginId) || disabledPlugins.contains(pluginId)) continue;
            PluginManagerCore.appendPlugin(ideaPluginDescriptorImpl, disabled);
        }
        Logger logger2 = PluginManagerCore.getLogger();
        logger2.info("Loaded bundled plugins: " + bundled);
        if (custom.length() > 0) {
            logger2.info("Loaded custom plugins: " + custom);
        }
        if (disabled.length() > 0) {
            logger2.info("Disabled plugins: " + disabled);
        }
    }

    private static void appendPlugin(IdeaPluginDescriptor descriptor2, StringBuilder target) {
        if (target.length() > 0) {
            target.append(", ");
        }
        target.append(descriptor2.getName());
        String version = descriptor2.getVersion();
        if (version != null) {
            target.append(" (").append(version).append(')');
        }
    }

    public static boolean isRunningFromSources() {
        Boolean result2 = isRunningFromSources;
        if (result2 == null) {
            isRunningFromSources = result2 = Boolean.valueOf(Files.isDirectory(Paths.get(PathManager.getHomePath(), ".idea"), new LinkOption[0]));
        }
        return result2;
    }

    @NotNull
    private static List<Supplier<HtmlChunk>> preparePluginsError(@NotNull List<Supplier<@NlsContexts.DetailedDescription String>> globalErrorsSuppliers) {
        if (globalErrorsSuppliers == null) {
            PluginManagerCore.$$$reportNull$$$0(30);
        }
        if (pluginLoadingErrors.isEmpty() && globalErrorsSuppliers.isEmpty()) {
            return new ArrayList<Supplier<HtmlChunk>>();
        }
        List<@NlsContexts.DetailedDescription T> globalErrors = globalErrorsSuppliers.stream().map(Supplier::get).collect(Collectors.toList());
        List loadingErrors = pluginLoadingErrors.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).collect(Collectors.toList());
        String logMessage = "Problems found loading plugins:\n  " + Stream.concat(globalErrors.stream(), loadingErrors.stream().map(PluginLoadingError::getInternalMessage)).collect(Collectors.joining("\n  "));
        if (isUnitTestMode || !GraphicsEnvironment.isHeadless()) {
            PluginManagerCore.getLogger().warn(logMessage);
            List<Supplier<HtmlChunk>> list2 = Stream.concat(globalErrors.stream(), loadingErrors.stream().filter(PluginLoadingError::isNotifyUser).map(PluginLoadingError::getDetailedMessage)).map(text -> () -> HtmlChunk.text(text)).collect(Collectors.toList());
            if (list2 == null) {
                PluginManagerCore.$$$reportNull$$$0(31);
            }
            return list2;
        }
        PluginManagerCore.getLogger().error(logMessage);
        return new ArrayList<Supplier<HtmlChunk>>();
    }

    @Nullable
    public static PluginLoadingError getLoadingError(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            PluginManagerCore.$$$reportNull$$$0(32);
        }
        return pluginLoadingErrors.get(pluginId);
    }

    @NotNull
    private static List<Supplier<HtmlChunk>> prepareActions(@NotNull Set<IdeaPluginDescriptorImpl> disabledIds, @NotNull Set<IdeaPluginDescriptorImpl> disabledRequiredIds) {
        if (disabledIds == null) {
            PluginManagerCore.$$$reportNull$$$0(33);
        }
        if (disabledRequiredIds == null) {
            PluginManagerCore.$$$reportNull$$$0(34);
        }
        if (disabledIds.isEmpty()) {
            List<Supplier<HtmlChunk>> list2 = Collections.emptyList();
            if (list2 == null) {
                PluginManagerCore.$$$reportNull$$$0(35);
            }
            return list2;
        }
        ArrayList<Supplier<HtmlChunk>> actions = new ArrayList<Supplier<HtmlChunk>>();
        String nameToDisable = PluginManagerCore.getFirstPluginName(disabledIds);
        actions.add(() -> HtmlChunk.link(DISABLE, nameToDisable == null ? CoreBundle.message("link.text.disable.not.loaded.plugins", new Object[0]) : CoreBundle.message("link.text.disable.plugin", nameToDisable)));
        if (!disabledRequiredIds.isEmpty()) {
            String nameToEnable = PluginManagerCore.getFirstPluginName(disabledRequiredIds);
            actions.add(() -> HtmlChunk.link(ENABLE, nameToEnable == null ? CoreBundle.message("link.text.enable.all.necessary.plugins", new Object[0]) : CoreBundle.message("link.text.enable.plugin", nameToEnable)));
        }
        actions.add(() -> HtmlChunk.link(EDIT, CoreBundle.message("link.text.open.plugin.manager", new Object[0])));
        ArrayList<Supplier<HtmlChunk>> arrayList = actions;
        if (arrayList == null) {
            PluginManagerCore.$$$reportNull$$$0(36);
        }
        return arrayList;
    }

    @Nullable
    @NlsSafe
    private static String getFirstPluginName(@NotNull Set<IdeaPluginDescriptorImpl> modules) {
        if (modules == null) {
            PluginManagerCore.$$$reportNull$$$0(37);
        }
        switch (modules.size()) {
            case 0: {
                throw new IllegalArgumentException("Plugins set should not be empty");
            }
            case 1: {
                return modules.iterator().next().getName();
            }
        }
        return null;
    }

    @ApiStatus.Internal
    static synchronized boolean onEnable(boolean enabled) {
        boolean applied;
        Set<PluginId> pluginIds = enabled ? ourPluginsToEnable : ourPluginsToDisable;
        ourPluginsToEnable = null;
        ourPluginsToDisable = null;
        boolean bl = applied = pluginIds != null;
        if (applied) {
            for (IdeaPluginDescriptorImpl module2 : PluginManagerCore.getPluginSet().allPlugins) {
                if (!pluginIds.contains(module2.getPluginId())) continue;
                module2.setEnabled(enabled);
            }
            DisabledPluginsState.setEnabledState(pluginIds, enabled);
        }
        return applied;
    }

    public static void scheduleDescriptorLoading() {
        PluginManagerCore.getOrScheduleLoading();
    }

    @NotNull
    private static synchronized CompletableFuture<DescriptorListLoadingContext> getOrScheduleLoading() {
        CompletableFuture<DescriptorListLoadingContext> future = descriptorListFuture;
        if (future != null) {
            CompletableFuture<DescriptorListLoadingContext> completableFuture = future;
            if (completableFuture == null) {
                PluginManagerCore.$$$reportNull$$$0(38);
            }
            return completableFuture;
        }
        descriptorListFuture = future = CompletableFuture.supplyAsync(() -> {
            Activity activity = StartUpMeasurer.startActivity("plugin descriptor loading", ActivityCategory.DEFAULT);
            DescriptorListLoadingContext context2 = PluginDescriptorLoader.loadDescriptors(isUnitTestMode, PluginManagerCore.isRunningFromSources());
            activity.end();
            return context2;
        }, ForkJoinPool.commonPool());
        CompletableFuture<DescriptorListLoadingContext> completableFuture = future;
        if (completableFuture == null) {
            PluginManagerCore.$$$reportNull$$$0(39);
        }
        return completableFuture;
    }

    @ApiStatus.Internal
    @NotNull
    public static CompletableFuture<List<IdeaPluginDescriptorImpl>> getEnabledPluginRawList() {
        CompletionStage completionStage = PluginManagerCore.getOrScheduleLoading().thenApply(it -> it.result.getEnabledPlugins());
        if (completionStage == null) {
            PluginManagerCore.$$$reportNull$$$0(40);
        }
        return completionStage;
    }

    @ApiStatus.Internal
    @NotNull
    public static CompletableFuture<PluginSet> initPlugins(@NotNull ClassLoader coreClassLoader) {
        CompletableFuture<DescriptorListLoadingContext> future;
        if (coreClassLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(41);
        }
        if ((future = descriptorListFuture) == null) {
            throw new IllegalStateException("Call scheduleDescriptorLoading() first");
        }
        CompletionStage completionStage = future.thenApply(context2 -> PluginManagerCore.loadAndInitializePlugins(context2, coreClassLoader));
        if (completionStage == null) {
            PluginManagerCore.$$$reportNull$$$0(42);
        }
        return completionStage;
    }

    @NotNull
    public static BuildNumber getBuildNumber() {
        BuildNumber result2 = ourBuildNumber;
        if (result2 == null) {
            result2 = BuildNumber.fromPluginsCompatibleBuild();
            if (result2 == null) {
                if (isUnitTestMode) {
                    result2 = BuildNumber.currentVersion();
                } else {
                    try {
                        result2 = ApplicationInfoImpl.getShadowInstance().getApiVersionAsNumber();
                    }
                    catch (RuntimeException ignore) {
                        result2 = BuildNumber.currentVersion();
                    }
                }
            }
            ourBuildNumber = result2;
        }
        BuildNumber buildNumber = result2;
        if (buildNumber == null) {
            PluginManagerCore.$$$reportNull$$$0(43);
        }
        return buildNumber;
    }

    private static void disableIncompatiblePlugins(@NotNull List<IdeaPluginDescriptorImpl> descriptors, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap, @NotNull Map<PluginId, PluginLoadingError> errors) {
        if (descriptors == null) {
            PluginManagerCore.$$$reportNull$$$0(44);
        }
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(45);
        }
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(46);
        }
        String selectedIds = System.getProperty("idea.load.plugins.id");
        String selectedCategory = System.getProperty("idea.load.plugins.category");
        LinkedHashSet<IdeaPluginDescriptorImpl> explicitlyEnabled = null;
        if (selectedIds != null) {
            HashSet set = new HashSet();
            for (String it : selectedIds.split(",")) {
                set.add(PluginId.getId(it));
            }
            set.addAll(ApplicationInfoImpl.getShadowInstance().getEssentialPluginsIds());
            explicitlyEnabled = new LinkedHashSet(set.size());
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                PluginId pluginId = (PluginId)iterator2.next();
                IdeaPluginDescriptorImpl descriptor2 = idMap.get(pluginId);
                if (descriptor2 == null) continue;
                explicitlyEnabled.add(descriptor2);
            }
        } else if (selectedCategory != null) {
            explicitlyEnabled = new LinkedHashSet<IdeaPluginDescriptorImpl>();
            for (IdeaPluginDescriptorImpl ideaPluginDescriptorImpl : descriptors) {
                if (!selectedCategory.equals(ideaPluginDescriptorImpl.getCategory())) continue;
                explicitlyEnabled.add(ideaPluginDescriptorImpl);
            }
        }
        if (explicitlyEnabled != null) {
            ArrayList nonOptionalDependencies = new ArrayList();
            for (IdeaPluginDescriptorImpl ideaPluginDescriptorImpl : explicitlyEnabled) {
                PluginManagerCore.processAllNonOptionalDependencies(ideaPluginDescriptorImpl, idMap, (PluginId __, IdeaPluginDescriptorImpl dependency) -> {
                    nonOptionalDependencies.add(dependency);
                    return FileVisitResult.CONTINUE;
                });
            }
            explicitlyEnabled.addAll(nonOptionalDependencies);
        }
        IdeaPluginDescriptorImpl coreDescriptor = idMap.get(CORE_ID);
        boolean bl = Boolean.parseBoolean(System.getProperty("idea.load.plugins", "true"));
        for (IdeaPluginDescriptorImpl descriptor5 : descriptors) {
            if (descriptor5 == coreDescriptor) continue;
            if (explicitlyEnabled != null) {
                if (explicitlyEnabled.contains(descriptor5)) continue;
                descriptor5.setEnabled(false);
                PluginManagerCore.getLogger().info("Plugin '" + descriptor5.getName() + "' " + (selectedIds != null ? "is not in 'idea.load.plugins.id' system property" : "category doesn't match 'idea.load.plugins.category' system property"));
                continue;
            }
            if (bl) continue;
            descriptor5.setEnabled(false);
            errors.put(descriptor5.getPluginId(), new PluginLoadingError(descriptor5, PluginManagerCore.message("plugin.loading.error.long.plugin.loading.disabled", descriptor5.getName()), PluginManagerCore.message("plugin.loading.error.short.plugin.loading.disabled", new Object[0])));
        }
    }

    public static boolean isCompatible(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(47);
        }
        return !PluginManagerCore.isIncompatible(descriptor2);
    }

    public static boolean isCompatible(@NotNull IdeaPluginDescriptor descriptor2, @Nullable BuildNumber buildNumber) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(48);
        }
        return !PluginManagerCore.isIncompatible(descriptor2, buildNumber);
    }

    public static boolean isIncompatible(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(49);
        }
        return PluginManagerCore.isIncompatible(descriptor2, PluginManagerCore.getBuildNumber());
    }

    public static boolean isIncompatible(@NotNull IdeaPluginDescriptor descriptor2, @Nullable BuildNumber buildNumber) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(50);
        }
        if (buildNumber == null) {
            buildNumber = PluginManagerCore.getBuildNumber();
        }
        return PluginManagerCore.checkBuildNumberCompatibility(descriptor2, buildNumber) != null;
    }

    @Nullable
    public static PluginLoadingError checkBuildNumberCompatibility(@NotNull IdeaPluginDescriptor descriptor2, @NotNull BuildNumber ideBuildNumber) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(51);
        }
        if (ideBuildNumber == null) {
            PluginManagerCore.$$$reportNull$$$0(52);
        }
        String sinceBuild = descriptor2.getSinceBuild();
        String untilBuild = descriptor2.getUntilBuild();
        try {
            BuildNumber untilBuildNumber;
            BuildNumber sinceBuildNumber;
            BuildNumber buildNumber = sinceBuildNumber = sinceBuild == null ? null : BuildNumber.fromString(sinceBuild, descriptor2.getName(), null);
            if (sinceBuildNumber != null && sinceBuildNumber.compareTo(ideBuildNumber) > 0) {
                return new PluginLoadingError(descriptor2, PluginManagerCore.message("plugin.loading.error.long.incompatible.since.build", descriptor2.getName(), descriptor2.getVersion(), sinceBuild, ideBuildNumber), PluginManagerCore.message("plugin.loading.error.short.incompatible.since.build", sinceBuild));
            }
            BuildNumber buildNumber2 = untilBuildNumber = untilBuild == null ? null : BuildNumber.fromString(untilBuild, descriptor2.getName(), null);
            if (untilBuildNumber != null && untilBuildNumber.compareTo(ideBuildNumber) < 0) {
                return new PluginLoadingError(descriptor2, PluginManagerCore.message("plugin.loading.error.long.incompatible.until.build", descriptor2.getName(), descriptor2.getVersion(), untilBuild, ideBuildNumber), PluginManagerCore.message("plugin.loading.error.short.incompatible.until.build", untilBuild));
            }
            return null;
        }
        catch (Exception e) {
            PluginManagerCore.getLogger().error(e);
            return new PluginLoadingError(descriptor2, PluginManagerCore.message("plugin.loading.error.long.failed.to.load.requirements.for.ide.version", descriptor2.getName()), PluginManagerCore.message("plugin.loading.error.short.failed.to.load.requirements.for.ide.version", new Object[0]));
        }
    }

    private static void checkEssentialPluginsAreAvailable(@NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap) {
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(53);
        }
        List<PluginId> required = ApplicationInfoImpl.getShadowInstance().getEssentialPluginsIds();
        ArrayList<String> missing = null;
        for (PluginId id : required) {
            IdeaPluginDescriptorImpl descriptor2 = idMap.get(id);
            if (descriptor2 != null && descriptor2.isEnabled()) continue;
            if (missing == null) {
                missing = new ArrayList<String>();
            }
            missing.add(id.getIdString());
        }
        if (missing != null) {
            throw new EssentialPluginMissingException(missing);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    static PluginManagerState initializePlugins(@NotNull DescriptorListLoadingContext context2, @NotNull ClassLoader coreLoader, boolean checkEssentialPlugins) {
        if (context2 == null) {
            PluginManagerCore.$$$reportNull$$$0(54);
        }
        if (coreLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(55);
        }
        PluginLoadingResult loadingResult2 = context2.result;
        HashMap<PluginId, PluginLoadingError> pluginErrorsById = new HashMap<PluginId, PluginLoadingError>(loadingResult2.getPluginErrors$intellij_platform_core_impl());
        @NotNull List<Supplier<String>> globalErrors = loadingResult2.getGlobalErrors();
        if (loadingResult2.duplicateModuleMap != null) {
            for (Map.Entry<PluginId, List<IdeaPluginDescriptorImpl>> entry : loadingResult2.duplicateModuleMap.entrySet()) {
                globalErrors.add(() -> CoreBundle.message("plugin.loading.error.module.declared.by.multiple.plugins", entry.getKey(), ((List)entry.getValue()).stream().map(IdeaPluginDescriptorImpl::toString).collect(Collectors.joining("\n  "))));
            }
        }
        ConcurrentHashMap<PluginId, IdeaPluginDescriptorImpl> idMap = loadingResult2.idMap;
        if (checkEssentialPlugins && !idMap.containsKey(CORE_ID)) {
            throw new EssentialPluginMissingException(Collections.singletonList(CORE_ID + " (platform prefix: " + System.getProperty("idea.platform.prefix") + ")"));
        }
        List<IdeaPluginDescriptorImpl> descriptors = loadingResult2.getEnabledPlugins();
        PluginManagerCore.disableIncompatiblePlugins(descriptors, idMap, pluginErrorsById);
        PluginSetBuilder pluginSetBuilder = new PluginSetBuilder(descriptors);
        pluginSetBuilder.checkPluginCycles(globalErrors);
        HashSet<IdeaPluginDescriptorImpl> disabledAfterInit = new HashSet<IdeaPluginDescriptorImpl>();
        HashSet<IdeaPluginDescriptorImpl> disabledRequired = new HashSet<IdeaPluginDescriptorImpl>();
        pluginSetBuilder.computeEnabledModuleMap(descriptor2 -> {
            if (pluginSetBuilder.initEnableState$intellij_platform_core_impl((IdeaPluginDescriptorImpl)descriptor2, (Map<PluginId, IdeaPluginDescriptorImpl>)idMap, (Set<IdeaPluginDescriptorImpl>)disabledRequired, context2.disabledPlugins, (Map<PluginId, PluginLoadingError>)pluginErrorsById)) {
                return false;
            }
            descriptor2.setEnabled(false);
            disabledAfterInit.add((IdeaPluginDescriptorImpl)descriptor2);
            return true;
        });
        List<Supplier<HtmlChunk>> actions = PluginManagerCore.prepareActions(disabledAfterInit, disabledRequired);
        pluginLoadingErrors = pluginErrorsById;
        List<Supplier<HtmlChunk>> errorsList = PluginManagerCore.preparePluginsError(globalErrors);
        if (!errorsList.isEmpty()) {
            List<Supplier<? extends HtmlChunk>> list2 = pluginErrors;
            synchronized (list2) {
                pluginErrors.addAll(errorsList);
                pluginErrors.addAll(actions);
            }
        }
        if (checkEssentialPlugins) {
            PluginManagerCore.checkEssentialPluginsAreAvailable(idMap);
        }
        PluginSet pluginSet = pluginSetBuilder.createPluginSet(context2.result.incompletePlugins.values());
        new ClassLoaderConfigurator(pluginSet, coreLoader).configure();
        return new PluginManagerState(pluginSet, disabledRequired, disabledAfterInit);
    }

    @Nullable
    private static Map<PluginId, List<IdeaPluginDescriptorImpl>> checkAndPut(@NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull PluginId id, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap, @Nullable Map<PluginId, List<IdeaPluginDescriptorImpl>> duplicateMap) {
        List<IdeaPluginDescriptorImpl> duplicates;
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(56);
        }
        if (id == null) {
            PluginManagerCore.$$$reportNull$$$0(57);
        }
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(58);
        }
        if (duplicateMap != null && (duplicates = duplicateMap.get(id)) != null) {
            duplicates.add(descriptor2);
            return duplicateMap;
        }
        IdeaPluginDescriptorImpl existingDescriptor = idMap.put(id, descriptor2);
        if (existingDescriptor == null) {
            return null;
        }
        idMap.remove(id);
        if (duplicateMap == null) {
            duplicateMap = new LinkedHashMap<PluginId, List<IdeaPluginDescriptorImpl>>();
        }
        ArrayList<IdeaPluginDescriptorImpl> list2 = new ArrayList<IdeaPluginDescriptorImpl>();
        list2.add(existingDescriptor);
        list2.add(descriptor2);
        duplicateMap.put(id, list2);
        return duplicateMap;
    }

    @NotNull
    @Nls
    private static Supplier<String> message(final @NotNull @PropertyKey(resourceBundle="messages.CoreBundle") @NotNull @PropertyKey(resourceBundle="messages.CoreBundle") String key, final Object ... params) {
        if (key == null) {
            PluginManagerCore.$$$reportNull$$$0(59);
        }
        if (params == null) {
            PluginManagerCore.$$$reportNull$$$0(60);
        }
        return new Supplier<String>(){

            @Override
            public String get() {
                return CoreBundle.message(key, params);
            }
        };
    }

    @NotNull
    private static synchronized PluginSet loadAndInitializePlugins(@NotNull DescriptorListLoadingContext context2, @NotNull ClassLoader coreLoader) {
        if (context2 == null) {
            PluginManagerCore.$$$reportNull$$$0(61);
        }
        if (coreLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(62);
        }
        if (IdeaPluginDescriptorImpl.disableNonBundledPlugins) {
            PluginManagerCore.getLogger().info("Running with disableThirdPartyPlugins argument, third-party plugins will be disabled");
        }
        Activity activity = StartUpMeasurer.startActivity("plugin initialization", ActivityCategory.DEFAULT);
        PluginManagerState initResult = PluginManagerCore.initializePlugins(context2, coreLoader, !isUnitTestMode);
        PluginLoadingResult result2 = context2.result;
        ourPluginsToDisable = initResult.effectiveDisabledIds;
        ourPluginsToEnable = initResult.disabledRequiredIds;
        ourShadowedBundledPlugins = result2.shadowedBundledIds;
        activity.end();
        activity.setDescription("plugin count: " + initResult.pluginSet.enabledPlugins.size());
        PluginManagerCore.logPlugins(initResult.pluginSet.allPlugins, result2.incompletePlugins.values());
        pluginSet = initResult.pluginSet;
        PluginSet pluginSet = initResult.pluginSet;
        if (pluginSet == null) {
            PluginManagerCore.$$$reportNull$$$0(63);
        }
        return pluginSet;
    }

    @NotNull
    public static Logger getLogger() {
        Logger logger2 = Logger.getInstance("#com.intellij.ide.plugins.PluginManager");
        if (logger2 == null) {
            PluginManagerCore.$$$reportNull$$$0(64);
        }
        return logger2;
    }

    @Contract(value="null -> null")
    @Nullable
    public static IdeaPluginDescriptor getPlugin(@Nullable PluginId id) {
        return id != null ? PluginManagerCore.findPlugin(id) : null;
    }

    @ApiStatus.Internal
    @Nullable
    public static IdeaPluginDescriptorImpl findPlugin(@NotNull PluginId id) {
        PluginSet pluginSet;
        IdeaPluginDescriptorImpl result2;
        if (id == null) {
            PluginManagerCore.$$$reportNull$$$0(65);
        }
        if ((result2 = (pluginSet = PluginManagerCore.getPluginSet()).findEnabledPlugin(id)) != null) {
            return result2;
        }
        for (IdeaPluginDescriptorImpl plugin : pluginSet.allPlugins) {
            if (!id.equals(plugin.getPluginId())) continue;
            return plugin;
        }
        return null;
    }

    @ApiStatus.Internal
    @Nullable
    public static IdeaPluginDescriptorImpl findPluginByModuleDependency(@NotNull PluginId id) {
        if (id == null) {
            PluginManagerCore.$$$reportNull$$$0(66);
        }
        for (IdeaPluginDescriptorImpl descriptor2 : PluginManagerCore.getPluginSet().allPlugins) {
            if (!descriptor2.modules.contains(id)) continue;
            return descriptor2;
        }
        return null;
    }

    public static boolean isPluginInstalled(@NotNull PluginId id) {
        PluginSet pluginSet;
        if (id == null) {
            PluginManagerCore.$$$reportNull$$$0(67);
        }
        if ((pluginSet = PluginManagerCore.pluginSet) == null) {
            return false;
        }
        if (pluginSet.isPluginEnabled(id)) {
            return true;
        }
        for (IdeaPluginDescriptor ideaPluginDescriptor : pluginSet.allPlugins) {
            if (!id.equals(ideaPluginDescriptor.getPluginId())) continue;
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    @NotNull
    public static Map<PluginId, IdeaPluginDescriptorImpl> buildPluginIdMap() {
        LoadingState.COMPONENTS_REGISTERED.checkOccurred();
        HashMap<PluginId, IdeaPluginDescriptorImpl> idMap = new HashMap<PluginId, IdeaPluginDescriptorImpl>(PluginManagerCore.getPluginSet().allPlugins.size());
        Map<PluginId, List<IdeaPluginDescriptorImpl>> duplicateMap = null;
        for (IdeaPluginDescriptorImpl descriptor2 : PluginManagerCore.getPluginSet().allPlugins) {
            Map<PluginId, List<IdeaPluginDescriptorImpl>> newDuplicateMap = PluginManagerCore.checkAndPut(descriptor2, descriptor2.getPluginId(), idMap, duplicateMap);
            if (newDuplicateMap != null) {
                duplicateMap = newDuplicateMap;
                continue;
            }
            for (PluginId module2 : descriptor2.modules) {
                newDuplicateMap = PluginManagerCore.checkAndPut(descriptor2, module2, idMap, duplicateMap);
                if (newDuplicateMap == null) continue;
                duplicateMap = newDuplicateMap;
            }
        }
        HashMap<PluginId, IdeaPluginDescriptorImpl> hashMap = idMap;
        if (hashMap == null) {
            PluginManagerCore.$$$reportNull$$$0(68);
        }
        return hashMap;
    }

    @ApiStatus.Internal
    public static boolean processAllNonOptionalDependencies(@NotNull IdeaPluginDescriptorImpl rootDescriptor, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idToMap, @NotNull @NotNull Function<@NotNull IdeaPluginDescriptorImpl, FileVisitResult> consumer) {
        if (rootDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(69);
        }
        if (idToMap == null) {
            PluginManagerCore.$$$reportNull$$$0(70);
        }
        if (consumer == null) {
            PluginManagerCore.$$$reportNull$$$0(71);
        }
        return PluginManagerCore.processAllNonOptionalDependencies(rootDescriptor, idToMap, (PluginId __, IdeaPluginDescriptorImpl descriptor2) -> descriptor2 != null ? (FileVisitResult)((Object)((Object)consumer.apply((IdeaPluginDescriptorImpl)descriptor2))) : FileVisitResult.SKIP_SUBTREE);
    }

    @ApiStatus.Internal
    public static boolean processAllNonOptionalDependencies(@NotNull IdeaPluginDescriptorImpl rootDescriptor, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idToMap, @NotNull @NotNull BiFunction<@NotNull PluginId, @Nullable IdeaPluginDescriptorImpl, FileVisitResult> consumer) {
        if (rootDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(72);
        }
        if (idToMap == null) {
            PluginManagerCore.$$$reportNull$$$0(73);
        }
        if (consumer == null) {
            PluginManagerCore.$$$reportNull$$$0(74);
        }
        return PluginManagerCore.processAllNonOptionalDependencies(rootDescriptor, idToMap, new HashSet<PluginId>(), consumer);
    }

    @ApiStatus.Internal
    private static boolean processAllNonOptionalDependencies(@NotNull IdeaPluginDescriptorImpl rootDescriptor, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idToMap, @NotNull Set<PluginId> depProcessed, @NotNull @NotNull BiFunction<@NotNull PluginId, @Nullable IdeaPluginDescriptorImpl, FileVisitResult> consumer) {
        if (rootDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(75);
        }
        if (idToMap == null) {
            PluginManagerCore.$$$reportNull$$$0(76);
        }
        if (depProcessed == null) {
            PluginManagerCore.$$$reportNull$$$0(77);
        }
        if (consumer == null) {
            PluginManagerCore.$$$reportNull$$$0(78);
        }
        for (PluginId dependencyId : PluginManagerCore.getNonOptionalDependenciesIds(rootDescriptor)) {
            IdeaPluginDescriptorImpl descriptor2 = idToMap.get(dependencyId);
            PluginId pluginId = descriptor2 != null ? descriptor2.getPluginId() : dependencyId;
            switch (consumer.apply(pluginId, descriptor2)) {
                case TERMINATE: {
                    return false;
                }
                case CONTINUE: {
                    if (descriptor2 == null || !depProcessed.add(descriptor2.getPluginId())) break;
                    PluginManagerCore.processAllNonOptionalDependencies(descriptor2, idToMap, depProcessed, consumer);
                    break;
                }
                case SKIP_SUBTREE: {
                    break;
                }
                case SKIP_SIBLINGS: {
                    throw new UnsupportedOperationException("FileVisitResult.SKIP_SIBLINGS is not supported");
                }
            }
        }
        return true;
    }

    @NotNull
    private static List<PluginId> getNonOptionalDependenciesIds(@NotNull IdeaPluginDescriptorImpl descriptor2) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(79);
        }
        ArrayList<PluginId> dependencies2 = new ArrayList<PluginId>();
        for (PluginDependency dependency : descriptor2.pluginDependencies) {
            if (dependency.isOptional()) continue;
            dependencies2.add(dependency.getPluginId());
        }
        for (ModuleDependenciesDescriptor.PluginReference plugin : descriptor2.dependencies.plugins) {
            dependencies2.add(plugin.id);
        }
        ArrayList<PluginId> arrayList = dependencies2;
        if (arrayList == null) {
            PluginManagerCore.$$$reportNull$$$0(80);
        }
        return arrayList;
    }

    public static synchronized boolean isUpdatedBundledPlugin(@NotNull PluginDescriptor plugin) {
        if (plugin == null) {
            PluginManagerCore.$$$reportNull$$$0(81);
        }
        return ourShadowedBundledPlugins != null && ourShadowedBundledPlugins.contains(plugin.getPluginId());
    }

    @Deprecated
    public static boolean isDisabled(@NotNull String pluginId) {
        if (pluginId == null) {
            PluginManagerCore.$$$reportNull$$$0(82);
        }
        return PluginManagerCore.isDisabled(PluginId.getId(pluginId));
    }

    @Deprecated
    public static boolean disablePlugin(@NotNull String id) {
        if (id == null) {
            PluginManagerCore.$$$reportNull$$$0(83);
        }
        return PluginManagerCore.disablePlugin(PluginId.getId(id));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static boolean enablePlugin(@NotNull String id) {
        if (id == null) {
            PluginManagerCore.$$$reportNull$$$0(84);
        }
        return PluginManagerCore.enablePlugin(PluginId.getId(id));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.2")
    public static void addDisablePluginListener(@NotNull Runnable listener2) {
        if (listener2 == null) {
            PluginManagerCore.$$$reportNull$$$0(85);
        }
        DisabledPluginsState.addDisablePluginListener(listener2);
    }

    static {
        isUnitTestMode = Boolean.getBoolean("idea.is.unit.test");
        pluginErrors = new ArrayList<Supplier<? extends HtmlChunk>>();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/ide/plugins/PluginManagerCore";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: 
            case 32: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 8: 
            case 27: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 56: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 15: 
            case 16: 
            case 57: 
            case 65: 
            case 66: 
            case 67: 
            case 83: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependentPluginId";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginClass";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 23: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vendorItem";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "incompletePlugins";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalErrorsSuppliers";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledIds";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledRequiredIds";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreClassLoader";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 45: 
            case 53: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idMap";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideBuildNumber";
                break;
            }
            case 54: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 55: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreLoader";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 69: 
            case 72: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDescriptor";
                break;
            }
            case 70: 
            case 73: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idToMap";
                break;
            }
            case 71: 
            case 74: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "depProcessed";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlugins";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginSet";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadedPlugins";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndClearPluginLoadingErrors";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/ide/plugins/PluginManagerCore";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrokenPluginVersions";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "readBrokenPluginFile";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "preparePluginsError";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareActions";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrScheduleLoading";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledPluginRawList";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "initPlugins";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildNumber";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "loadAndInitializePlugins";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPluginIdMap";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonOptionalDependenciesIds";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setPluginSet";
                break;
            }
            case 7: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "isDisabled";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isBrokenPlugin";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "writePluginsList";
                break;
            }
            case 15: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "disablePlugin";
                break;
            }
            case 16: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "enablePlugin";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isModuleDependency";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createPluginException";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPluginByClassName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getPluginOrPlatformByClassName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getPluginDescriptorOrPlatformByClassName";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isDevelopedByJetBrains";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isVendorJetBrains";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "hasLoadedClass";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "hasModuleDependencies";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "logPlugins";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "preparePluginsError";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getLoadingError";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "prepareActions";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getFirstPluginName";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "initPlugins";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "disableIncompatiblePlugins";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isCompatible";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isIncompatible";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "checkBuildNumberCompatibility";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "checkEssentialPluginsAreAvailable";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "initializePlugins";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "checkAndPut";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "message";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "loadAndInitializePlugins";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "findPlugin";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "findPluginByModuleDependency";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "isPluginInstalled";
                break;
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "processAllNonOptionalDependencies";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getNonOptionalDependenciesIds";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "isUpdatedBundledPlugin";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "addDisablePluginListener";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class EssentialPluginMissingException
    extends RuntimeException {
        public final List<String> pluginIds;

        EssentialPluginMissingException(@NotNull List<String> ids) {
            if (ids == null) {
                EssentialPluginMissingException.$$$reportNull$$$0(0);
            }
            super("Missing essential plugins: " + String.join((CharSequence)", ", ids));
            this.pluginIds = ids;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ids", "ksp/com/intellij/ide/plugins/PluginManagerCore$EssentialPluginMissingException", "<init>"));
        }
    }
}

