/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.ir.inline;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.backend.common.ir.Symbols;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import ksp.org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import ksp.org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0014R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lksp/org/jetbrains/kotlin/ir/inline/InlineFunctionResolver;", "", "<init>", "()V", "allowExternalInlining", "", "getAllowExternalInlining", "()Z", "needsInlining", "function", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFunction;", "getFunctionDeclaration", "symbol", "Lksp/org/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "shouldExcludeFunctionFromInlining", "ir.inline"})
public abstract class InlineFunctionResolver {
    public boolean getAllowExternalInlining() {
        return false;
    }

    public boolean needsInlining(@NotNull IrFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return function2.isInline() && (this.getAllowExternalInlining() || !function2.isExternal());
    }

    @Nullable
    public IrFunction getFunctionDeclaration(@NotNull IrFunctionSymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        if (this.shouldExcludeFunctionFromInlining(symbol2)) {
            return null;
        }
        IrFunction owner = symbol2.getOwner();
        IrSimpleFunction irSimpleFunction = owner instanceof IrSimpleFunction ? (IrSimpleFunction)owner : null;
        return irSimpleFunction != null && (irSimpleFunction = (IrSimpleFunction)IrFakeOverrideUtilsKt.resolveFakeOverride$default(irSimpleFunction, null, 1, null)) != null ? (IrFunction)irSimpleFunction : owner;
    }

    protected boolean shouldExcludeFunctionFromInlining(@NotNull IrFunctionSymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        return !this.needsInlining(symbol2.getOwner()) || Symbols.Companion.isLateinitIsInitializedPropertyGetter(symbol2) || Symbols.Companion.isTypeOfIntrinsic(symbol2);
    }
}

