/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.wasm.resolve.diagnostics;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.MemberDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import ksp.org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lksp/org/jetbrains/kotlin/wasm/resolve/diagnostics/WasmExternalDeclarationChecker;", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "wasm.frontend"})
@SourceDebugExtension(value={"SMAP\nWasmExternalDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmExternalDeclarationChecker.kt\norg/jetbrains/kotlin/wasm/resolve/diagnostics/WasmExternalDeclarationChecker\n+ 2 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n*L\n1#1,62:1\n37#2:63\n*S KotlinDebug\n*F\n+ 1 WasmExternalDeclarationChecker.kt\norg/jetbrains/kotlin/wasm/resolve/diagnostics/WasmExternalDeclarationChecker\n*L\n42#1:63\n*E\n"})
public final class WasmExternalDeclarationChecker
implements DeclarationChecker {
    @NotNull
    public static final WasmExternalDeclarationChecker INSTANCE = new WasmExternalDeclarationChecker();

    private WasmExternalDeclarationChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(descriptor2 instanceof MemberDescriptor) || !DescriptorUtilsKt.isEffectivelyExternal((MemberDescriptor)descriptor2)) {
            return;
        }
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (declarationDescriptor instanceof ClassDescriptor) {
            ClassKind classKind2 = ((ClassDescriptor)descriptor2).getKind();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)classKind2), (String)"getKind(...)");
            ClassKind $this$isEnumClass$iv = classKind2;
            boolean $i$f$isEnumClass = false;
            if ($this$isEnumClass$iv == ClassKind.ENUM_CLASS) {
                WasmExternalDeclarationChecker.check$reportWrongExternalDeclaration(context2, declaration2, "enum class");
            }
        } else if (declarationDescriptor instanceof PropertyDescriptor) {
            if (((PropertyDescriptor)descriptor2).isLateInit()) {
                WasmExternalDeclarationChecker.check$reportWrongExternalDeclaration(context2, declaration2, "lateinit property");
            }
        } else if (declarationDescriptor instanceof FunctionDescriptor) {
            if (((FunctionDescriptor)descriptor2).isTailrec()) {
                WasmExternalDeclarationChecker.check$reportWrongExternalDeclaration(context2, declaration2, "tailrec function");
            }
            if (((FunctionDescriptor)descriptor2).isSuspend()) {
                WasmExternalDeclarationChecker.check$reportWrongExternalDeclaration(context2, declaration2, "suspend function");
            }
        }
    }

    private static final void check$reportWrongExternalDeclaration(DeclarationCheckerContext $context, KtDeclaration $declaration, String kind) {
        $context.getTrace().report(ErrorsJs.WRONG_EXTERNAL_DECLARATION.on((KtExpression)((PsiElement)$declaration), kind));
    }
}

