/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.types.expressions;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import kotlin.Pair;
import ksp.com.intellij.openapi.util.Ref;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.VariableDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import ksp.org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import ksp.org.jetbrains.kotlin.psi.KtBinaryExpression;
import ksp.org.jetbrains.kotlin.psi.KtBlockExpression;
import ksp.org.jetbrains.kotlin.psi.KtClass;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtDoWhileExpression;
import ksp.org.jetbrains.kotlin.psi.KtElement;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtForExpression;
import ksp.org.jetbrains.kotlin.psi.KtIfExpression;
import ksp.org.jetbrains.kotlin.psi.KtLabeledExpression;
import ksp.org.jetbrains.kotlin.psi.KtNamedFunction;
import ksp.org.jetbrains.kotlin.psi.KtObjectDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import ksp.org.jetbrains.kotlin.psi.KtProperty;
import ksp.org.jetbrains.kotlin.psi.KtPsiUtil;
import ksp.org.jetbrains.kotlin.psi.KtTypeAlias;
import ksp.org.jetbrains.kotlin.psi.KtWhenExpression;
import ksp.org.jetbrains.kotlin.psi.KtWhileExpression;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.BindingContextUtils;
import ksp.org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import ksp.org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.AssignmentChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.NewSchemeOfIntegerOperatorResolutionChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.context.CallPosition;
import ksp.org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import ksp.org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import ksp.org.jetbrains.kotlin.resolve.calls.context.TemporaryTraceAndCache;
import ksp.org.jetbrains.kotlin.resolve.calls.inference.BuilderInferenceSession;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import ksp.org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import ksp.org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsUtil;
import ksp.org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import ksp.org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import ksp.org.jetbrains.kotlin.resolve.extensions.AssignResolutionAltererExtension;
import ksp.org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import ksp.org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import ksp.org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import ksp.org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.KotlinTypeKt;
import ksp.org.jetbrains.kotlin.types.TypeUtils;
import ksp.org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import ksp.org.jetbrains.kotlin.types.expressions.BasicExpressionTypingVisitor;
import ksp.org.jetbrains.kotlin.types.expressions.ControlStructureTypingVisitor;
import ksp.org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import ksp.org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import ksp.org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import ksp.org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitor;
import ksp.org.jetbrains.kotlin.types.expressions.FunctionsTypingVisitor;
import ksp.org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import ksp.org.jetbrains.kotlin.types.expressions.OperatorConventions;
import ksp.org.jetbrains.kotlin.types.expressions.PatternMatchingTypingVisitor;
import ksp.org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import ksp.org.jetbrains.kotlin.util.OperatorNameConventions;

public class ExpressionTypingVisitorForStatements
extends ExpressionTypingVisitor {
    private final LexicalWritableScope scope;
    private final BasicExpressionTypingVisitor basic;
    private final ControlStructureTypingVisitor controlStructures;
    private final PatternMatchingTypingVisitor patterns;
    private final FunctionsTypingVisitor functions;

    public ExpressionTypingVisitorForStatements(@NotNull ExpressionTypingInternals facade, @NotNull LexicalWritableScope scope, @NotNull BasicExpressionTypingVisitor basic, @NotNull ControlStructureTypingVisitor controlStructures, @NotNull PatternMatchingTypingVisitor patterns2, @NotNull FunctionsTypingVisitor functions2) {
        if (facade == null) {
            ExpressionTypingVisitorForStatements.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            ExpressionTypingVisitorForStatements.$$$reportNull$$$0(1);
        }
        if (basic == null) {
            ExpressionTypingVisitorForStatements.$$$reportNull$$$0(2);
        }
        if (controlStructures == null) {
            ExpressionTypingVisitorForStatements.$$$reportNull$$$0(3);
        }
        if (patterns2 == null) {
            ExpressionTypingVisitorForStatements.$$$reportNull$$$0(4);
        }
        if (functions2 == null) {
            ExpressionTypingVisitorForStatements.$$$reportNull$$$0(5);
        }
        super(facade);
        this.scope = scope;
        this.basic = basic;
        this.controlStructures = controlStructures;
        this.patterns = patterns2;
        this.functions = functions2;
    }

    @Nullable
    private KotlinType checkAssignmentType(@Nullable KotlinType assignmentType, @NotNull KtBinaryExpression expression2, @NotNull ExpressionTypingContext context2) {
        if (expression2 == null) {
            ExpressionTypingVisitorForStatements.$$$reportNull$$$0(6);
        }
        if (context2 == null) {
            ExpressionTypingVisitorForStatements.$$$reportNull$$$0(7);
        }
        if (assignmentType != null && !KotlinBuiltIns.isUnit(assignmentType) && !TypeUtils.noExpectedType(context2.expectedType) && !KotlinTypeKt.isError(context2.expectedType) && TypeUtils.equalTypes(context2.expectedType, assignmentType)) {
            context2.trace.report(Errors.ASSIGNMENT_TYPE_MISMATCH.on(expression2, context2.expectedType));
            return null;
        }
        return this.components.dataFlowAnalyzer.checkStatementType(expression2, context2);
    }

    @Override
    public KotlinTypeInfo visitObjectDeclaration(@NotNull KtObjectDeclaration declaration2, ExpressionTypingContext context2) {
        if (declaration2 == null) {
            ExpressionTypingVisitorForStatements.$$$reportNull$$$0(8);
        }
        this.components.localClassifierAnalyzer.processClassOrObject(this.scope, (ExpressionTypingContext)((ExpressionTypingContext)context2.replaceScope(this.scope)).replaceContextDependency(ContextDependency.INDEPENDENT), this.scope.getOwnerDescriptor(), declaration2);
        return TypeInfoFactoryKt.createTypeInfo(this.components.dataFlowAnalyzer.checkStatementType(declaration2, context2), context2);
    }

    @Override
    public KotlinTypeInfo visitProperty(@NotNull KtProperty property2, ExpressionTypingContext typingContext) {
        if (property2 == null) {
            ExpressionTypingVisitorForStatements.$$$reportNull$$$0(9);
        }
        Pair<KotlinTypeInfo, VariableDescriptor> typeInfoAndVariableDescriptor = this.components.localVariableResolver.process(property2, typingContext, this.scope, this.facade);
        this.scope.addVariableDescriptor((VariableDescriptor)typeInfoAndVariableDescriptor.getSecond());
        return (KotlinTypeInfo)typeInfoAndVariableDescriptor.getFirst();
    }

    @Override
    public KotlinTypeInfo visitTypeAlias(@NotNull KtTypeAlias typeAlias, ExpressionTypingContext context2) {
        if (typeAlias == null) {
            ExpressionTypingVisitorForStatements.$$$reportNull$$$0(10);
        }
        TypeAliasDescriptor typeAliasDescriptor = this.components.descriptorResolver.resolveTypeAliasDescriptor(context2.scope.getOwnerDescriptor(), context2.scope, typeAlias, context2.trace);
        this.scope.addClassifierDescriptor(typeAliasDescriptor);
        ForceResolveUtil.forceResolveAllContents(typeAliasDescriptor);
        this.facade.getComponents().declarationsCheckerBuilder.withTrace(context2.trace).checkLocalTypeAliasDeclaration(typeAlias, typeAliasDescriptor);
        return TypeInfoFactoryKt.createTypeInfo(this.components.dataFlowAnalyzer.checkStatementType(typeAlias, context2), context2);
    }

    @Override
    public KotlinTypeInfo visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration multiDeclaration, ExpressionTypingContext context2) {
        if (multiDeclaration == null) {
            ExpressionTypingVisitorForStatements.$$$reportNull$$$0(11);
        }
        this.components.annotationResolver.resolveAnnotationsWithArguments((LexicalScope)this.scope, multiDeclaration.getModifierList(), context2.trace);
        KtExpression initializer2 = multiDeclaration.getInitializer();
        if (initializer2 == null) {
            context2.trace.report(Errors.INITIALIZER_REQUIRED_FOR_DESTRUCTURING_DECLARATION.on(multiDeclaration));
        }
        ExpressionReceiver expressionReceiver = initializer2 != null ? ExpressionTypingUtils.getExpressionReceiver(this.facade, initializer2, (ExpressionTypingContext)((ExpressionTypingContext)context2.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT)) : null;
        this.components.destructuringDeclarationResolver.defineLocalVariablesFromDestructuringDeclaration(this.scope, multiDeclaration, expressionReceiver, initializer2, context2);
        this.components.modifiersChecker.withTrace(context2.trace).checkModifiersForDestructuringDeclaration(multiDeclaration);
        this.components.identifierChecker.checkDeclaration(multiDeclaration, context2.trace);
        if (expressionReceiver == null) {
            return TypeInfoFactoryKt.noTypeInfo(context2);
        }
        return this.facade.getTypeInfo(initializer2, context2).replaceType(this.components.dataFlowAnalyzer.checkStatementType(multiDeclaration, context2));
    }

    @Override
    public KotlinTypeInfo visitNamedFunction(@NotNull KtNamedFunction function2, ExpressionTypingContext context2) {
        if (function2 == null) {
            ExpressionTypingVisitorForStatements.$$$reportNull$$$0(12);
        }
        return this.functions.visitNamedFunction(function2, context2, function2.getName() != null, this.scope);
    }

    @Override
    public KotlinTypeInfo visitClass(@NotNull KtClass klass, ExpressionTypingContext context2) {
        if (klass == null) {
            ExpressionTypingVisitorForStatements.$$$reportNull$$$0(13);
        }
        this.components.localClassifierAnalyzer.processClassOrObject(this.scope, (ExpressionTypingContext)((ExpressionTypingContext)context2.replaceScope(this.scope)).replaceContextDependency(ContextDependency.INDEPENDENT), this.scope.getOwnerDescriptor(), klass);
        return TypeInfoFactoryKt.createTypeInfo(this.components.dataFlowAnalyzer.checkStatementType(klass, context2), context2);
    }

    @Override
    public KotlinTypeInfo visitDeclaration(@NotNull KtDeclaration dcl, ExpressionTypingContext context2) {
        if (dcl == null) {
            ExpressionTypingVisitorForStatements.$$$reportNull$$$0(14);
        }
        return TypeInfoFactoryKt.createTypeInfo(this.components.dataFlowAnalyzer.checkStatementType(dcl, context2), context2);
    }

    @Override
    public KotlinTypeInfo visitBinaryExpression(@NotNull KtBinaryExpression expression2, ExpressionTypingContext context2) {
        KotlinTypeInfo result2;
        KtOperationReferenceExpression operationSign;
        IElementType operationType;
        if (expression2 == null) {
            ExpressionTypingVisitorForStatements.$$$reportNull$$$0(15);
        }
        if ((operationType = (operationSign = expression2.getOperationReference()).getReferencedNameElementType()) == KtTokens.EQ) {
            result2 = this.visitAssignment(expression2, context2);
        } else if (OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey(operationType)) {
            result2 = this.visitAssignmentOperation(expression2, context2);
        } else {
            return this.facade.getTypeInfo(expression2, context2);
        }
        return this.components.dataFlowAnalyzer.checkType(result2, (KtExpression)expression2, (ResolutionContext)context2);
    }

    @NotNull
    protected KotlinTypeInfo visitAssignmentOperation(KtBinaryExpression expression2, ExpressionTypingContext contextWithExpectedType) {
        KotlinType binaryOperationType;
        OverloadResolutionResults<Object> binaryOperationDescriptors;
        KtExpression left;
        TemporaryTraceAndCache temporary = TemporaryTraceAndCache.create(contextWithExpectedType, "trace to resolve array set method for binary expression", expression2);
        ExpressionTypingContext context2 = (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceTraceAndCache(temporary)).replaceContextDependency(ContextDependency.INDEPENDENT);
        KtOperationReferenceExpression operationSign = expression2.getOperationReference();
        IElementType operationType = operationSign.getReferencedNameElementType();
        KtExpression leftOperand = expression2.getLeft();
        KotlinTypeInfo leftInfo = ExpressionTypingUtils.getTypeInfoOrNullType(leftOperand, context2, this.facade);
        KotlinType leftType = leftInfo.getType();
        KtExpression right = expression2.getRight();
        KtExpression ktExpression = left = leftOperand == null ? null : KtPsiUtil.deparenthesize(leftOperand);
        if (right == null || left == null) {
            temporary.commit();
            KotlinTypeInfo kotlinTypeInfo = leftInfo.clearType();
            if (kotlinTypeInfo == null) {
                ExpressionTypingVisitorForStatements.$$$reportNull$$$0(16);
            }
            return kotlinTypeInfo;
        }
        if (leftType == null) {
            KotlinTypeInfo rightInfo = this.facade.getTypeInfo(right, (ExpressionTypingContext)context2.replaceDataFlowInfo(leftInfo.getDataFlowInfo()));
            context2.trace.report(Errors.UNRESOLVED_REFERENCE.on(operationSign, operationSign));
            temporary.commit();
            KotlinTypeInfo kotlinTypeInfo = rightInfo.clearType();
            if (kotlinTypeInfo == null) {
                ExpressionTypingVisitorForStatements.$$$reportNull$$$0(17);
            }
            return kotlinTypeInfo;
        }
        if (!ArgumentTypeResolver.isFunctionLiteralOrCallableReference(right, context2) && !context2.languageVersionSettings.supportsFeature(LanguageFeature.NewInference)) {
            this.facade.getTypeInfo(right, (ExpressionTypingContext)context2.replaceContextDependency(ContextDependency.DEPENDENT));
        }
        ExpressionReceiver receiver = ExpressionReceiver.Companion.create(left, leftType, context2.trace.getBindingContext());
        Name name2 = (Name)OperatorConventions.ASSIGNMENT_OPERATIONS.get(operationType);
        TemporaryTraceAndCache temporaryForAssignmentOperation = TemporaryTraceAndCache.create(context2, "trace to check assignment operation like '+=' for", expression2);
        OverloadResolutionResults<FunctionDescriptor> assignmentOperationDescriptors = this.components.callResolver.resolveBinaryCall((ExpressionTypingContext)((ExpressionTypingContext)context2.replaceTraceAndCache(temporaryForAssignmentOperation)).replaceScope(this.scope), receiver, expression2, name2);
        KotlinType assignmentOperationType = OverloadResolutionResultsUtil.getResultingType(assignmentOperationDescriptors, context2);
        TemporaryTraceAndCache temporaryForBinaryOperation = TemporaryTraceAndCache.create(context2, "trace to check binary operation like '+' for", expression2);
        TemporaryBindingTrace ignoreReportsTrace = TemporaryBindingTrace.create(context2.trace, "Trace for checking assignability");
        ExpressionTypingContext contextForBinaryOperation = null;
        boolean lhsAssignable = this.basic.checkLValue(ignoreReportsTrace, context2, left, right, expression2, false);
        if (assignmentOperationType == null || lhsAssignable) {
            contextForBinaryOperation = (ExpressionTypingContext)((ExpressionTypingContext)context2.replaceTraceAndCache(temporaryForBinaryOperation)).replaceScope(this.scope);
            if (context2.inferenceSession instanceof BuilderInferenceSession) {
                ((BuilderInferenceSession)context2.inferenceSession).clearCallsInfoByContainingElement(right);
            }
            Name counterpartName = (Name)OperatorConventions.BINARY_OPERATION_NAMES.get(OperatorConventions.ASSIGNMENT_OPERATION_COUNTERPARTS.get(operationType));
            binaryOperationDescriptors = this.components.callResolver.resolveBinaryCall(contextForBinaryOperation, receiver, expression2, counterpartName);
            binaryOperationType = OverloadResolutionResultsUtil.getResultingType(binaryOperationDescriptors, context2);
        } else {
            binaryOperationDescriptors = OverloadResolutionResultsImpl.nameNotFound();
            binaryOperationType = null;
        }
        KotlinType type2 = assignmentOperationType != null ? assignmentOperationType : binaryOperationType;
        KotlinTypeInfo rightInfo = leftInfo;
        boolean hasRemAssignOperation = ExpressionTypingVisitorForStatements.atLeastOneOperation(assignmentOperationDescriptors.getResultingCalls(), OperatorNameConventions.REM_ASSIGN);
        boolean hasRemBinaryOperation = ExpressionTypingVisitorForStatements.atLeastOneOperation(binaryOperationDescriptors.getResultingCalls(), OperatorNameConventions.REM);
        boolean oneTypeOfModRemOperations = hasRemAssignOperation == hasRemBinaryOperation;
        boolean maybeAmbiguity = assignmentOperationDescriptors.isSuccess() && binaryOperationDescriptors.isSuccess() && oneTypeOfModRemOperations;
        boolean isResolvedToPlusAssign = !(assignmentOperationType == null || !assignmentOperationDescriptors.isSuccess() && binaryOperationDescriptors.isSuccess() || hasRemBinaryOperation && binaryOperationDescriptors.isSuccess());
        KotlinTypeInfo rhsResolutionResult = maybeAmbiguity || !isResolvedToPlusAssign ? this.completePlusResolution(contextForBinaryOperation, expression2, binaryOperationType, left, leftInfo) : null;
        if (maybeAmbiguity && rhsResolutionResult != null) {
            OverloadResolutionResults<Object> ambiguityResolutionResults = OverloadResolutionResultsUtil.ambiguity(assignmentOperationDescriptors, binaryOperationDescriptors);
            context2.trace.report(Errors.ASSIGN_OPERATOR_AMBIGUITY.on(operationSign, ambiguityResolutionResults.getResultingCalls()));
            HashSet<Object> descriptors = new HashSet<Object>();
            for (ResolvedCall<Object> resolvedCall2 : ambiguityResolutionResults.getResultingCalls()) {
                descriptors.add(resolvedCall2.getResultingDescriptor());
            }
            rightInfo = rhsResolutionResult;
            context2.trace.record(BindingContext.AMBIGUOUS_REFERENCE_TARGET, operationSign, descriptors);
        } else if (isResolvedToPlusAssign) {
            temporaryForAssignmentOperation.commit();
            if (!KotlinTypeChecker.DEFAULT.equalTypes(this.components.builtIns.getUnitType(), assignmentOperationType)) {
                context2.trace.report(Errors.ASSIGNMENT_OPERATOR_SHOULD_RETURN_UNIT.on(operationSign, assignmentOperationDescriptors.getResultingDescriptor(), operationSign));
            }
        } else {
            if (rhsResolutionResult != null) {
                rightInfo = rhsResolutionResult;
            }
            temporaryForBinaryOperation.commit();
            context2.trace.record(BindingContext.VARIABLE_REASSIGNMENT, expression2);
        }
        temporary.commit();
        KotlinTypeInfo kotlinTypeInfo = rightInfo.replaceType(this.checkAssignmentType(type2, expression2, contextWithExpectedType));
        if (kotlinTypeInfo == null) {
            ExpressionTypingVisitorForStatements.$$$reportNull$$$0(18);
        }
        return kotlinTypeInfo;
    }

    private KotlinTypeInfo completePlusResolution(ExpressionTypingContext context2, KtBinaryExpression expression2, KotlinType binaryOperationType, KtExpression leftDeparentized, KotlinTypeInfo leftInfo) {
        KtExpression leftOperand = expression2.getLeft();
        KtExpression rightOperand = expression2.getRight();
        if (leftOperand == null || rightOperand == null) {
            return null;
        }
        if (leftDeparentized instanceof KtArrayAccessExpression) {
            ExpressionTypingContext contextForResolve = (ExpressionTypingContext)((ExpressionTypingContext)context2.replaceScope(this.scope)).replaceBindingTrace(TemporaryBindingTrace.create(context2.trace, "trace to resolve array set method for assignment", expression2));
            this.basic.resolveImplicitArrayAccessSetMethod((KtArrayAccessExpression)leftDeparentized, rightOperand, contextForResolve, context2.trace);
        }
        KotlinTypeInfo rightInfo = this.facade.getTypeInfo(rightOperand, (ExpressionTypingContext)context2.replaceDataFlowInfo(leftInfo.getDataFlowInfo()));
        boolean refineJavaFieldInTypeProperly = this.components.languageVersionSettings.supportsFeature(LanguageFeature.RefineTypeCheckingOnAssignmentsToJavaFields);
        BindingContext bindingContext = context2.trace.getBindingContext();
        KotlinType leftType = leftInfo.getType();
        KotlinType expectedType = refineJavaFieldInTypeProperly ? ExpressionTypingVisitorForStatements.refineTypeByPropertyInType(bindingContext, leftOperand, leftType) : ExpressionTypingVisitorForStatements.refineTypeFromPropertySetterIfPossible(bindingContext, leftOperand, leftType);
        Ref<Boolean> hasErrorsOnTypeChecking = Ref.create(false);
        this.components.dataFlowAnalyzer.checkType(binaryOperationType, expression2, (ResolutionContext)((ExpressionTypingContext)((ExpressionTypingContext)context2.replaceExpectedType(expectedType)).replaceDataFlowInfo(rightInfo.getDataFlowInfo())).replaceCallPosition(new CallPosition.PropertyAssignment(leftDeparentized, false)), hasErrorsOnTypeChecking, true);
        this.basic.checkLValue(context2.trace, context2, leftOperand, rightOperand, expression2, false);
        if (!refineJavaFieldInTypeProperly) {
            this.checkPropertyInTypeWithWarnings(context2, expression2, binaryOperationType, rightInfo.getDataFlowInfo(), leftOperand, leftType, expectedType);
        }
        return hasErrorsOnTypeChecking.get() == false ? rightInfo : null;
    }

    private static boolean atLeastOneOperation(Collection<? extends ResolvedCall<FunctionDescriptor>> calls, Name operationName) {
        for (ResolvedCall<FunctionDescriptor> resolvedCall2 : calls) {
            if (!resolvedCall2.getCandidateDescriptor().getName().equals(operationName)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static KotlinType refineTypeFromPropertySetterIfPossible(@NotNull BindingContext bindingContext, @Nullable KtElement leftOperand, @Nullable KotlinType leftOperandType) {
        PropertySetterDescriptor setter2;
        VariableDescriptor descriptor2;
        if (bindingContext == null) {
            ExpressionTypingVisitorForStatements.$$$reportNull$$$0(19);
        }
        if ((descriptor2 = BindingContextUtils.extractVariableFromResolvedCall(bindingContext, leftOperand)) instanceof PropertyDescriptor && (setter2 = ((PropertyDescriptor)descriptor2).getSetter()) != null) {
            return setter2.getValueParameters().get(0).getType();
        }
        return leftOperandType;
    }

    @Nullable
    private static KotlinType refineTypeByPropertyInType(@NotNull BindingContext bindingContext, @Nullable KtElement leftOperand, @Nullable KotlinType leftOperandType) {
        KotlinType inType;
        VariableDescriptor descriptor2;
        if (bindingContext == null) {
            ExpressionTypingVisitorForStatements.$$$reportNull$$$0(20);
        }
        if ((descriptor2 = BindingContextUtils.extractVariableFromResolvedCall(bindingContext, leftOperand)) instanceof PropertyDescriptor && (inType = ((PropertyDescriptor)descriptor2).getInType()) != null) {
            return inType;
        }
        return leftOperandType;
    }

    @NotNull
    protected KotlinTypeInfo visitAssignment(KtBinaryExpression expression2, ExpressionTypingContext contextWithExpectedType) {
        KotlinTypeInfo resultInfo;
        KotlinTypeInfo alteredTypeInfo;
        ExpressionTypingContext context2 = (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceScope(this.scope)).replaceContextDependency(ContextDependency.INDEPENDENT);
        KtExpression leftOperand = expression2.getLeft();
        if (leftOperand instanceof KtAnnotatedExpression) {
            this.basic.resolveAnnotationsOnExpression((KtAnnotatedExpression)leftOperand, context2);
        }
        KtExpression left = KtPsiUtil.deparenthesize(leftOperand);
        KtExpression right = expression2.getRight();
        if (left instanceof KtArrayAccessExpression) {
            KtArrayAccessExpression arrayAccessExpression = (KtArrayAccessExpression)left;
            if (right == null) {
                KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context2);
                if (kotlinTypeInfo == null) {
                    ExpressionTypingVisitorForStatements.$$$reportNull$$$0(21);
                }
                return kotlinTypeInfo;
            }
            KotlinTypeInfo typeInfo = this.basic.resolveArrayAccessSetMethod(arrayAccessExpression, right, context2, context2.trace);
            this.basic.checkLValue(context2.trace, context2, arrayAccessExpression, right, expression2, true);
            KotlinTypeInfo kotlinTypeInfo = typeInfo.replaceType(this.checkAssignmentType(typeInfo.getType(), expression2, contextWithExpectedType));
            if (kotlinTypeInfo == null) {
                ExpressionTypingVisitorForStatements.$$$reportNull$$$0(22);
            }
            return kotlinTypeInfo;
        }
        KotlinTypeInfo leftInfo = ExpressionTypingUtils.getTypeInfoOrNullType(left, (ExpressionTypingContext)context2.replaceCallPosition(new CallPosition.PropertyAssignment(left, true)), this.facade);
        BindingContext bindingContext = context2.trace.getBindingContext();
        KotlinType leftType = leftInfo.getType();
        boolean refineJavaFieldInTypeProperly = this.components.languageVersionSettings.supportsFeature(LanguageFeature.RefineTypeCheckingOnAssignmentsToJavaFields);
        KotlinType expectedType = refineJavaFieldInTypeProperly ? ExpressionTypingVisitorForStatements.refineTypeByPropertyInType(bindingContext, leftOperand, leftType) : ExpressionTypingVisitorForStatements.refineTypeFromPropertySetterIfPossible(bindingContext, leftOperand, leftType);
        List assignAlterers = AssignResolutionAltererExtension.Companion.getInstances(expression2.getProject());
        if (!assignAlterers.isEmpty() && (alteredTypeInfo = (KotlinTypeInfo)assignAlterers.stream().filter(it -> it.needOverloadAssign(expression2, leftType, bindingContext)).map(it -> it.resolveAssign(bindingContext, expression2, leftOperand, left, leftInfo, context2, this.components, this.scope)).filter(Objects::nonNull).findFirst().orElse(null)) != null) {
            KotlinTypeInfo kotlinTypeInfo = alteredTypeInfo;
            if (kotlinTypeInfo == null) {
                ExpressionTypingVisitorForStatements.$$$reportNull$$$0(23);
            }
            return kotlinTypeInfo;
        }
        DataFlowInfo dataFlowInfo = leftInfo.getDataFlowInfo();
        if (right != null) {
            resultInfo = this.facade.getTypeInfo(right, (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)context2.replaceDataFlowInfo(dataFlowInfo)).replaceExpectedType(expectedType)).replaceCallPosition(new CallPosition.PropertyAssignment(leftOperand, false)));
            dataFlowInfo = resultInfo.getDataFlowInfo();
            KotlinType rightType = resultInfo.getType();
            if (left != null && expectedType != null && rightType != null) {
                DataFlowValue leftValue = this.components.dataFlowValueFactory.createDataFlowValue(left, expectedType, context2);
                DataFlowValue rightValue = this.components.dataFlowValueFactory.createDataFlowValue(right, rightType, context2);
                resultInfo = resultInfo.replaceDataFlowInfo(dataFlowInfo.assign(leftValue, rightValue, this.components.languageVersionSettings));
                NewSchemeOfIntegerOperatorResolutionChecker.checkArgument(expectedType, right, context2.trace, this.components.moduleDescriptor);
            }
        } else {
            resultInfo = leftInfo;
        }
        if (expectedType != null && leftOperand != null) {
            this.basic.checkLValue(context2.trace, context2, leftOperand, right, expression2, false);
            CallCheckerContext callCheckerContext = new CallCheckerContext(context2, this.components.deprecationResolver, this.components.moduleDescriptor, this.components.missingSupertypesResolver, this.components.callComponents, context2.trace);
            for (AssignmentChecker checker : this.components.assignmentCheckers) {
                checker.check(expression2, callCheckerContext);
            }
        }
        if (!refineJavaFieldInTypeProperly) {
            this.checkPropertyInTypeWithWarnings(context2, expression2, resultInfo.getType(), resultInfo.getDataFlowInfo(), leftOperand, leftType, expectedType);
        }
        KotlinTypeInfo kotlinTypeInfo = resultInfo.replaceType(this.components.dataFlowAnalyzer.checkStatementType(expression2, contextWithExpectedType));
        if (kotlinTypeInfo == null) {
            ExpressionTypingVisitorForStatements.$$$reportNull$$$0(24);
        }
        return kotlinTypeInfo;
    }

    private void checkPropertyInTypeWithWarnings(@NotNull ResolutionContext<?> context2, @NotNull KtBinaryExpression expression2, @Nullable KotlinType rhsType, @NotNull DataFlowInfo rhsDataFlowInfo, @Nullable KtExpression lhsOperand, @Nullable KotlinType lhsType, @Nullable KotlinType expectedType) {
        if (context2 == null) {
            ExpressionTypingVisitorForStatements.$$$reportNull$$$0(25);
        }
        if (expression2 == null) {
            ExpressionTypingVisitorForStatements.$$$reportNull$$$0(26);
        }
        if (rhsDataFlowInfo == null) {
            ExpressionTypingVisitorForStatements.$$$reportNull$$$0(27);
        }
        if (rhsType == null || expectedType == null) {
            return;
        }
        KotlinType expectedTypeByInType = ExpressionTypingVisitorForStatements.refineTypeByPropertyInType(context2.trace.getBindingContext(), lhsOperand, lhsType);
        if (expectedTypeByInType != null && expectedType != expectedTypeByInType && !TypeUtils.equalTypes(expectedType, expectedTypeByInType)) {
            Ref<Boolean> hasErrorsOnTypeChecking = Ref.create(false);
            this.components.dataFlowAnalyzer.checkType(rhsType, expression2, (ResolutionContext)((ResolutionContext)((ResolutionContext)context2.replaceExpectedType(expectedTypeByInType)).replaceDataFlowInfo(rhsDataFlowInfo)).replaceCallPosition(new CallPosition.PropertyAssignment(lhsOperand, false)), hasErrorsOnTypeChecking, false);
            if (hasErrorsOnTypeChecking.get().booleanValue()) {
                context2.trace.report(Errors.TYPE_MISMATCH_WARNING.on(expression2, expectedTypeByInType, rhsType));
            }
        }
    }

    @Override
    public KotlinTypeInfo visitExpression(@NotNull KtExpression expression2, ExpressionTypingContext context2) {
        if (expression2 == null) {
            ExpressionTypingVisitorForStatements.$$$reportNull$$$0(28);
        }
        return this.facade.getTypeInfo(expression2, context2);
    }

    @Override
    public KotlinTypeInfo visitKtElement(@NotNull KtElement element2, ExpressionTypingContext context2) {
        if (element2 == null) {
            ExpressionTypingVisitorForStatements.$$$reportNull$$$0(29);
        }
        context2.trace.report(Errors.UNSUPPORTED.on(element2, "in a block"));
        return TypeInfoFactoryKt.noTypeInfo(context2);
    }

    @Override
    public KotlinTypeInfo visitWhileExpression(@NotNull KtWhileExpression expression2, ExpressionTypingContext context2) {
        if (expression2 == null) {
            ExpressionTypingVisitorForStatements.$$$reportNull$$$0(30);
        }
        return this.controlStructures.visitWhileExpression(expression2, context2, true);
    }

    @Override
    public KotlinTypeInfo visitDoWhileExpression(@NotNull KtDoWhileExpression expression2, ExpressionTypingContext context2) {
        if (expression2 == null) {
            ExpressionTypingVisitorForStatements.$$$reportNull$$$0(31);
        }
        return this.controlStructures.visitDoWhileExpression(expression2, context2, true);
    }

    @Override
    public KotlinTypeInfo visitForExpression(@NotNull KtForExpression expression2, ExpressionTypingContext context2) {
        if (expression2 == null) {
            ExpressionTypingVisitorForStatements.$$$reportNull$$$0(32);
        }
        return this.controlStructures.visitForExpression(expression2, context2, true);
    }

    @Override
    public KotlinTypeInfo visitAnnotatedExpression(@NotNull KtAnnotatedExpression expression2, ExpressionTypingContext data2) {
        if (expression2 == null) {
            ExpressionTypingVisitorForStatements.$$$reportNull$$$0(33);
        }
        return this.basic.visitAnnotatedExpression(expression2, data2, true);
    }

    @Override
    public KotlinTypeInfo visitIfExpression(@NotNull KtIfExpression expression2, ExpressionTypingContext context2) {
        if (expression2 == null) {
            ExpressionTypingVisitorForStatements.$$$reportNull$$$0(34);
        }
        return this.controlStructures.visitIfExpression(expression2, context2);
    }

    @Override
    public KotlinTypeInfo visitWhenExpression(@NotNull KtWhenExpression expression2, ExpressionTypingContext context2) {
        if (expression2 == null) {
            ExpressionTypingVisitorForStatements.$$$reportNull$$$0(35);
        }
        return this.patterns.visitWhenExpression(expression2, context2, true);
    }

    @Override
    public KotlinTypeInfo visitBlockExpression(@NotNull KtBlockExpression expression2, ExpressionTypingContext context2) {
        if (expression2 == null) {
            ExpressionTypingVisitorForStatements.$$$reportNull$$$0(36);
        }
        return this.components.expressionTypingServices.getBlockReturnedType(expression2, context2, true);
    }

    @Override
    public KotlinTypeInfo visitLabeledExpression(@NotNull KtLabeledExpression expression2, ExpressionTypingContext context2) {
        if (expression2 == null) {
            ExpressionTypingVisitorForStatements.$$$reportNull$$$0(37);
        }
        return this.basic.visitLabeledExpression(expression2, context2, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basic";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controlStructures";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functions";
                break;
            }
            case 6: 
            case 15: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 7: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeAlias";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "multiDeclaration";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dcl";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindingContext";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rhsDataFlowInfo";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "visitAssignmentOperation";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "visitAssignment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkAssignmentType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "visitObjectDeclaration";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "visitProperty";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeAlias";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "visitDestructuringDeclaration";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "visitNamedFunction";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "visitClass";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "visitDeclaration";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "visitBinaryExpression";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "refineTypeFromPropertySetterIfPossible";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "refineTypeByPropertyInType";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "checkPropertyInTypeWithWarnings";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "visitExpression";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "visitKtElement";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "visitWhileExpression";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "visitDoWhileExpression";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "visitForExpression";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "visitAnnotatedExpression";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "visitIfExpression";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "visitWhenExpression";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "visitBlockExpression";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "visitLabeledExpression";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

