/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.konan.diagnostics;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.konan.UtilsKt;
import ksp.org.jetbrains.kotlin.psi.KtElement;
import ksp.org.jetbrains.kotlin.psi.KtTypeArgumentList;
import ksp.org.jetbrains.kotlin.psi.KtTypeProjection;
import ksp.org.jetbrains.kotlin.resolve.BindingTrace;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.konan.diagnostics.ErrorsNative;
import ksp.org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lksp/org/jetbrains/kotlin/resolve/konan/diagnostics/NativeReifiedForwardDeclarationChecker;", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lksp/org/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lksp/com/intellij/psi/PsiElement;", "context", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend.native"})
public final class NativeReifiedForwardDeclarationChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        KtTypeArgumentList ktTypeArgumentList = resolvedCall2.getCall().getTypeArgumentList();
        List<KtTypeProjection> typeArgumentList = ktTypeArgumentList != null ? ktTypeArgumentList.getArguments() : null;
        Map<TypeParameterDescriptor, KotlinType> map = resolvedCall2.getTypeArguments();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getTypeArguments(...)");
        for (Map.Entry<TypeParameterDescriptor, KotlinType> entry : map.entrySet()) {
            ClassifierDescriptor typeArgDescriptor;
            TypeParameterDescriptor typeParam = entry.getKey();
            KotlinType typeArg = entry.getValue();
            if (!typeParam.isReified() || !((typeArgDescriptor = typeArg.getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor) || UtilsKt.getForwardDeclarationKindOrNull((ClassDescriptor)typeArgDescriptor) == null) continue;
            KtElement typeArgumentPsi = typeArgumentList != null ? (KtElement)typeArgumentList.get(typeParam.getIndex()).getTypeReference() : (KtElement)resolvedCall2.getCall().getCalleeExpression();
            BindingTrace bindingTrace = context2.getTrace();
            KtElement ktElement = typeArgumentPsi;
            Intrinsics.checkNotNull((Object)ktElement);
            bindingTrace.report(ErrorsNative.FORWARD_DECLARATION_AS_REIFIED_TYPE_ARGUMENT.on(ktElement, typeArg));
        }
    }
}

