/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.checkers;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import ksp.org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import ksp.org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.psi.KtCallableDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtNamedDeclaration;
import ksp.org.jetbrains.kotlin.resolve.BindingTrace;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.SimpleType;
import ksp.org.jetbrains.kotlin.types.TypeProjection;
import ksp.org.jetbrains.kotlin.types.UnwrappedType;
import ksp.org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\f\u0010\u000b\u001a\u00020\f*\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lksp/org/jetbrains/kotlin/resolve/checkers/KClassWithIncorrectTypeArgumentChecker;", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "isKClassWithBadArgument", "", "Lksp/org/jetbrains/kotlin/types/UnwrappedType;", "frontend"})
@SourceDebugExtension(value={"SMAP\nKClassWithIncorrectTypeArgumentChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KClassWithIncorrectTypeArgumentChecker.kt\norg/jetbrains/kotlin/resolve/checkers/KClassWithIncorrectTypeArgumentChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,67:1\n1#2:68\n*E\n"})
public final class KClassWithIncorrectTypeArgumentChecker
implements DeclarationChecker {
    @NotNull
    public static final KClassWithIncorrectTypeArgumentChecker INSTANCE = new KClassWithIncorrectTypeArgumentChecker();

    private KClassWithIncorrectTypeArgumentChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(descriptor2 instanceof CallableMemberDescriptor) || Intrinsics.areEqual((Object)((CallableMemberDescriptor)descriptor2).getVisibility(), (Object)DescriptorVisibilities.LOCAL)) {
            return;
        }
        if (!(declaration2 instanceof KtCallableDeclaration) || ((KtCallableDeclaration)declaration2).getTypeReference() != null) {
            return;
        }
        if (descriptor2 instanceof PropertyAccessorDescriptor) {
            return;
        }
        KotlinType kotlinType = ((CallableMemberDescriptor)descriptor2).getReturnType();
        if (kotlinType == null) {
            return;
        }
        KotlinType returnType2 = kotlinType;
        Ref.ObjectRef typeParameterWithoutNotNullableUpperBound = new Ref.ObjectRef();
        TypeUtilsKt.contains(returnType2, (Function1<? super UnwrappedType, Boolean>)((Function1)new Function1<UnwrappedType, Boolean>(descriptor2, (Ref.ObjectRef<TypeParameterDescriptor>)typeParameterWithoutNotNullableUpperBound){
            final /* synthetic */ DeclarationDescriptor $descriptor;
            final /* synthetic */ Ref.ObjectRef<TypeParameterDescriptor> $typeParameterWithoutNotNullableUpperBound;
            {
                this.$descriptor = $descriptor;
                this.$typeParameterWithoutNotNullableUpperBound = $typeParameterWithoutNotNullableUpperBound;
                super(1);
            }

            public final Boolean invoke(UnwrappedType type2) {
                boolean kClassWithBadArgument;
                block2: {
                    Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                    kClassWithBadArgument = KClassWithIncorrectTypeArgumentChecker.access$isKClassWithBadArgument(KClassWithIncorrectTypeArgumentChecker.INSTANCE, type2);
                    if (!kClassWithBadArgument) break block2;
                    Object object = (TypeProjection)CollectionsKt.singleOrNull(type2.getArguments());
                    if (object != null && (object = object.getType()) != null && (object = ((KotlinType)object).getConstructor()) != null && (object = object.getDeclarationDescriptor()) != null) {
                        Object object2 = object;
                        DeclarationDescriptor declarationDescriptor = this.$descriptor;
                        Ref.ObjectRef<TypeParameterDescriptor> objectRef = this.$typeParameterWithoutNotNullableUpperBound;
                        Object it = object2;
                        boolean bl = false;
                        if (it instanceof TypeParameterDescriptor && Intrinsics.areEqual((Object)((TypeParameterDescriptor)it).getContainingDeclaration(), (Object)declarationDescriptor)) {
                            objectRef.element = it;
                        }
                    }
                }
                return kClassWithBadArgument;
            }
        }));
        if (typeParameterWithoutNotNullableUpperBound.element != null) {
            BindingTrace bindingTrace = context2.getTrace();
            PsiElement psiElement = declaration2;
            Object object = typeParameterWithoutNotNullableUpperBound.element;
            Intrinsics.checkNotNull((Object)object);
            bindingTrace.report(Errors.KCLASS_WITH_NULLABLE_TYPE_PARAMETER_IN_SIGNATURE.on((KtNamedDeclaration)psiElement, (TypeParameterDescriptor)object));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isKClassWithBadArgument(UnwrappedType $this$isKClassWithBadArgument) {
        TypeProjection typeProjection = (TypeProjection)CollectionsKt.singleOrNull($this$isKClassWithBadArgument.getArguments());
        Object object = typeProjection;
        if (typeProjection == null) return false;
        TypeProjection it = object;
        boolean bl = false;
        if (it.isStarProjection()) {
            return false;
        }
        UnwrappedType unwrappedType = it.getType().unwrap();
        object = unwrappedType;
        if (unwrappedType == null) {
            return false;
        }
        Object argumentType = object;
        ClassifierDescriptor classifierDescriptor = $this$isKClassWithBadArgument.getConstructor().getDeclarationDescriptor();
        if (!(classifierDescriptor instanceof ClassDescriptor)) return false;
        ClassDescriptor classDescriptor2 = (ClassDescriptor)classifierDescriptor;
        if (classDescriptor2 == null) {
            return false;
        }
        ClassDescriptor klass = classDescriptor2;
        if (!KotlinBuiltIns.isKClass(klass)) return false;
        KotlinType kotlinType = (KotlinType)argumentType;
        SimpleType simpleType2 = TypeUtilsKt.getBuiltIns((KotlinType)argumentType).getAnyType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"getAnyType(...)");
        if (TypeUtilsKt.isSubtypeOf(kotlinType, simpleType2)) return false;
        return true;
    }

    public static final /* synthetic */ boolean access$isKClassWithBadArgument(KClassWithIncorrectTypeArgumentChecker $this, UnwrappedType $receiver) {
        return $this.isKClassWithBadArgument($receiver);
    }
}

