/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import ksp.com.intellij.openapi.util.UserDataHolder;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.util.SmartList;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.builtins.FunctionTypesKt;
import ksp.org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import ksp.org.jetbrains.kotlin.builtins.PlatformToKotlinClassMapper;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptorVisitor;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import ksp.org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.SourceElement;
import ksp.org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.VariableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.annotations.Annotations;
import ksp.org.jetbrains.kotlin.descriptors.annotations.AnnotationsKt;
import ksp.org.jetbrains.kotlin.descriptors.impl.TypeParameterDescriptorImpl;
import ksp.org.jetbrains.kotlin.descriptors.impl.VariableDescriptorImpl;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.psi.KtAnnotationEntry;
import ksp.org.jetbrains.kotlin.psi.KtContextReceiverList;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtDeclarationModifierList;
import ksp.org.jetbrains.kotlin.psi.KtDynamicType;
import ksp.org.jetbrains.kotlin.psi.KtElement;
import ksp.org.jetbrains.kotlin.psi.KtElementImplStub;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtFunctionType;
import ksp.org.jetbrains.kotlin.psi.KtIntersectionType;
import ksp.org.jetbrains.kotlin.psi.KtModifierList;
import ksp.org.jetbrains.kotlin.psi.KtModifierListOwner;
import ksp.org.jetbrains.kotlin.psi.KtNullableType;
import ksp.org.jetbrains.kotlin.psi.KtParameter;
import ksp.org.jetbrains.kotlin.psi.KtParameterList;
import ksp.org.jetbrains.kotlin.psi.KtProjectionKind;
import ksp.org.jetbrains.kotlin.psi.KtPureElement;
import ksp.org.jetbrains.kotlin.psi.KtSelfType;
import ksp.org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import ksp.org.jetbrains.kotlin.psi.KtTypeArgumentList;
import ksp.org.jetbrains.kotlin.psi.KtTypeElement;
import ksp.org.jetbrains.kotlin.psi.KtTypeProjection;
import ksp.org.jetbrains.kotlin.psi.KtTypeReference;
import ksp.org.jetbrains.kotlin.psi.KtUserType;
import ksp.org.jetbrains.kotlin.psi.KtVisitorVoid;
import ksp.org.jetbrains.kotlin.psi.codeFragmentUtil.CodeFragmentUtilKt;
import ksp.org.jetbrains.kotlin.psi.debugText.DebugTextUtilKt;
import ksp.org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import ksp.org.jetbrains.kotlin.psi.psiUtil.ReservedCheckingKt;
import ksp.org.jetbrains.kotlin.psi.stubs.KotlinPlaceHolderStub;
import ksp.org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import ksp.org.jetbrains.kotlin.resolve.AnnotationResolver;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.BindingTrace;
import ksp.org.jetbrains.kotlin.resolve.ContextReceiversUtilKt;
import ksp.org.jetbrains.kotlin.resolve.DescriptorResolver;
import ksp.org.jetbrains.kotlin.resolve.IdentifierChecker;
import ksp.org.jetbrains.kotlin.resolve.ModifierCheckerCore;
import ksp.org.jetbrains.kotlin.resolve.PlatformClassesMappedToKotlinChecker;
import ksp.org.jetbrains.kotlin.resolve.PossiblyBareType;
import ksp.org.jetbrains.kotlin.resolve.QualifiedExpressionResolver;
import ksp.org.jetbrains.kotlin.resolve.TypeResolutionContext;
import ksp.org.jetbrains.kotlin.resolve.TypeResolver;
import ksp.org.jetbrains.kotlin.resolve.UpperBoundChecker;
import ksp.org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CoroutineCallCheckerKt;
import ksp.org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallableDescriptors;
import ksp.org.jetbrains.kotlin.resolve.checkers.TrailingCommaChecker;
import ksp.org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import ksp.org.jetbrains.kotlin.resolve.scopes.LazyScopeAdapter;
import ksp.org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import ksp.org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import ksp.org.jetbrains.kotlin.resolve.scopes.MemberScope;
import ksp.org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import ksp.org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import ksp.org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import ksp.org.jetbrains.kotlin.types.DefinitelyNotNullType;
import ksp.org.jetbrains.kotlin.types.DynamicType;
import ksp.org.jetbrains.kotlin.types.DynamicTypesSettings;
import ksp.org.jetbrains.kotlin.types.FlexibleTypesKt;
import ksp.org.jetbrains.kotlin.types.IntersectionTypeConstructor;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.KotlinTypeFactory;
import ksp.org.jetbrains.kotlin.types.KotlinTypeKt;
import ksp.org.jetbrains.kotlin.types.SimpleType;
import ksp.org.jetbrains.kotlin.types.TypeAliasExpander;
import ksp.org.jetbrains.kotlin.types.TypeAliasExpansion;
import ksp.org.jetbrains.kotlin.types.TypeAliasExpansionReportStrategy;
import ksp.org.jetbrains.kotlin.types.TypeAttributes;
import ksp.org.jetbrains.kotlin.types.TypeConstructor;
import ksp.org.jetbrains.kotlin.types.TypeIntersector;
import ksp.org.jetbrains.kotlin.types.TypeProjection;
import ksp.org.jetbrains.kotlin.types.TypeProjectionImpl;
import ksp.org.jetbrains.kotlin.types.TypeSubstitutor;
import ksp.org.jetbrains.kotlin.types.TypeUtils;
import ksp.org.jetbrains.kotlin.types.UnwrappedType;
import ksp.org.jetbrains.kotlin.types.Variance;
import ksp.org.jetbrains.kotlin.types.error.ErrorScope;
import ksp.org.jetbrains.kotlin.types.error.ErrorType;
import ksp.org.jetbrains.kotlin.types.error.ErrorTypeKind;
import ksp.org.jetbrains.kotlin.types.error.ErrorUtils;
import ksp.org.jetbrains.kotlin.types.error.ThrowingScope;
import ksp.org.jetbrains.kotlin.types.extensions.TypeAttributeTranslators;
import ksp.org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import ksp.org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\u0018\u0000 \u0082\u00012\u00020\u0001:\u0006\u0082\u0001\u0083\u0001\u0084\u0001B]\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J$\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001cH\u0002J:\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u001c2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020#0\u001c2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\u001c2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020!0\u001cH\u0002J\u0010\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020)H\u0002J&\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u001c2\u0006\u00100\u001a\u000201H\u0002JB\u00102\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u0002040\u001c\u0012\f\u0012\n\u0012\u0004\u0012\u00020#\u0018\u00010\u001c\u0018\u0001032\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\f\u00109\u001a\b\u0012\u0004\u0012\u00020:0\u001cH\u0002J&\u0010;\u001a\u00020<2\u0006\u00105\u001a\u0002062\f\u0010=\u001a\b\u0012\u0004\u0012\u0002040\u001c2\u0006\u0010>\u001a\u00020?H\u0002J\u0010\u0010@\u001a\u00020+2\u0006\u0010A\u001a\u00020BH\u0002J\u0018\u0010C\u001a\u00020D2\u0006\u00105\u001a\u0002062\u0006\u0010E\u001a\u00020!H\u0002J\u0010\u0010F\u001a\u00020\u001a2\u0006\u00107\u001a\u000208H\u0002J\u001e\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020L2\u0006\u00100\u001a\u000201J(\u0010M\u001a\u0004\u0018\u00010N2\u0006\u0010I\u001a\u00020J2\u0006\u0010O\u001a\u00020P2\u0006\u00100\u001a\u0002012\u0006\u0010Q\u001a\u00020\u001aJ&\u0010R\u001a\u00020S2\u0006\u0010I\u001a\u00020J2\u0006\u0010O\u001a\u00020P2\u0006\u00100\u001a\u0002012\u0006\u0010Q\u001a\u00020\u001aJ\u000e\u0010T\u001a\u00020H2\u0006\u0010U\u001a\u00020)J\u0016\u0010V\u001a\u00020<2\u0006\u00105\u001a\u0002062\u0006\u0010K\u001a\u00020LJ\u0018\u0010W\u001a\u00020B2\u0006\u00105\u001a\u0002062\u0006\u0010K\u001a\u00020LH\u0002J&\u0010W\u001a\u00020B2\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020L2\u0006\u00100\u001a\u0002012\u0006\u0010X\u001a\u00020\u001aJ\"\u0010Y\u001a\u00020Z2\u0006\u00100\u001a\u0002012\u0006\u0010I\u001a\u00020J2\n\u0010[\u001a\u0006\u0012\u0002\b\u00030\\J,\u0010]\u001a\u00020<2\u0006\u00105\u001a\u0002062\u0006\u0010^\u001a\u00020Z2\b\u0010_\u001a\u0004\u0018\u00010`2\b\u0010,\u001a\u0004\u0018\u00010aH\u0002J0\u0010b\u001a\u00020<2\u0006\u00105\u001a\u0002062\u0006\u0010^\u001a\u00020Z2\u0006\u0010c\u001a\u00020d2\u0006\u0010e\u001a\u00020f2\u0006\u0010g\u001a\u00020SH\u0002J.\u0010h\u001a\u00020<2\u0006\u00105\u001a\u0002062\u0006\u0010(\u001a\u00020N2\u0006\u0010g\u001a\u00020S2\u0006\u0010e\u001a\u00020f2\u0006\u0010^\u001a\u00020ZJ0\u0010i\u001a\u00020<2\u0006\u00105\u001a\u0002062\u0006\u0010^\u001a\u00020Z2\u0006\u0010(\u001a\u00020)2\u0006\u0010A\u001a\u00020f2\u0006\u0010g\u001a\u00020SH\u0002J2\u0010j\u001a\u00020B2\u0006\u00105\u001a\u0002062\u0006\u0010^\u001a\u00020Z2\u0006\u0010k\u001a\u00020!2\u0006\u0010l\u001a\u00020m2\b\u0010n\u001a\u0004\u0018\u00010oH\u0002J*\u0010p\u001a\b\u0012\u0004\u0012\u00020#0\u001c2\u0006\u00105\u001a\u0002062\u0006\u0010q\u001a\u00020?2\f\u0010r\u001a\b\u0012\u0004\u0012\u0002040\u001cJ.\u0010s\u001a\b\u0012\u0004\u0012\u00020#0\u001c2\u0006\u00105\u001a\u0002062\f\u0010r\u001a\b\u0012\u0004\u0012\u0002040\u001c2\b\b\u0002\u0010t\u001a\u00020uH\u0002J\u001e\u0010v\u001a\u00020B2\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020L2\u0006\u00100\u001a\u000201J\u0018\u0010w\u001a\u00020\u001a2\u0006\u00105\u001a\u0002062\u0006\u0010x\u001a\u00020BH\u0002J\u000e\u0010y\u001a\u00020\u001a*\u0004\u0018\u00010aH\u0002J\u0014\u0010z\u001a\b\u0012\u0004\u0012\u0002080\u001c*\u0004\u0018\u00010NH\u0002J\u001c\u0010{\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\u001c*\u00020J2\u0006\u0010|\u001a\u00020dH\u0002J!\u0010}\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u007f0~*\u0006\u0012\u0002\b\u00030\\H\u0000\u00a2\u0006\u0006\b\u0080\u0001\u0010\u0081\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0085\u0001\u00b2\u0006\u000e\u0010\u0086\u0001\u001a\u0005\u0018\u00010\u0087\u0001X\u008a\u0084\u0002"}, d2={"Lksp/org/jetbrains/kotlin/resolve/TypeResolver;", "", "annotationResolver", "Lksp/org/jetbrains/kotlin/resolve/AnnotationResolver;", "qualifiedExpressionResolver", "Lksp/org/jetbrains/kotlin/resolve/QualifiedExpressionResolver;", "moduleDescriptor", "Lksp/org/jetbrains/kotlin/descriptors/ModuleDescriptor;", "typeTransformerForTests", "Lksp/org/jetbrains/kotlin/resolve/TypeResolver$TypeTransformerForTests;", "dynamicTypesSettings", "Lksp/org/jetbrains/kotlin/types/DynamicTypesSettings;", "dynamicCallableDescriptors", "Lksp/org/jetbrains/kotlin/resolve/calls/tasks/DynamicCallableDescriptors;", "identifierChecker", "Lksp/org/jetbrains/kotlin/resolve/IdentifierChecker;", "platformToKotlinClassMapper", "Lksp/org/jetbrains/kotlin/builtins/PlatformToKotlinClassMapper;", "languageVersionSettings", "Lksp/org/jetbrains/kotlin/config/LanguageVersionSettings;", "upperBoundChecker", "Lksp/org/jetbrains/kotlin/resolve/UpperBoundChecker;", "typeAttributeTranslators", "Lksp/org/jetbrains/kotlin/types/extensions/TypeAttributeTranslators;", "(Lorg/jetbrains/kotlin/resolve/AnnotationResolver;Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/resolve/TypeResolver$TypeTransformerForTests;Lorg/jetbrains/kotlin/types/DynamicTypesSettings;Lorg/jetbrains/kotlin/resolve/calls/tasks/DynamicCallableDescriptors;Lorg/jetbrains/kotlin/resolve/IdentifierChecker;Lorg/jetbrains/kotlin/builtins/PlatformToKotlinClassMapper;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/UpperBoundChecker;Lorg/jetbrains/kotlin/types/extensions/TypeAttributeTranslators;)V", "isNonParenthesizedAnnotationsOnFunctionalTypesEnabled", "", "appendDefaultArgumentsForLocalClassifier", "", "Lksp/org/jetbrains/kotlin/types/TypeProjectionImpl;", "fromIndex", "", "constructorParameters", "Lksp/org/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "buildFinalArgumentList", "Lksp/org/jetbrains/kotlin/types/TypeProjection;", "argumentsFromUserType", "argumentsForOuterClass", "parameters", "canBeUsedAsBareType", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "checkNonParenthesizedAnnotationsOnFunctionalType", "", "typeElement", "Lksp/org/jetbrains/kotlin/psi/KtFunctionType;", "annotationEntries", "Lksp/org/jetbrains/kotlin/psi/KtAnnotationEntry;", "trace", "Lksp/org/jetbrains/kotlin/resolve/BindingTrace;", "collectArgumentsForClassifierTypeConstructor", "Lkotlin/Pair;", "Lksp/org/jetbrains/kotlin/psi/KtTypeProjection;", "c", "Lksp/org/jetbrains/kotlin/resolve/TypeResolutionContext;", "classifierDescriptor", "Lksp/org/jetbrains/kotlin/descriptors/ClassifierDescriptorWithTypeParameters;", "qualifierParts", "Lksp/org/jetbrains/kotlin/resolve/QualifiedExpressionResolver$ExpressionQualifierPart;", "createErrorTypeForTypeConstructor", "Lksp/org/jetbrains/kotlin/resolve/PossiblyBareType;", "arguments", "typeConstructor", "Lksp/org/jetbrains/kotlin/types/TypeConstructor;", "forceResolveTypeContents", "type", "Lksp/org/jetbrains/kotlin/types/KotlinType;", "getScopeForTypeParameter", "Lksp/org/jetbrains/kotlin/resolve/scopes/MemberScope;", "typeParameterDescriptor", "isPossibleToSpecifyTypeArgumentsFor", "resolveAbbreviatedType", "Lksp/org/jetbrains/kotlin/types/SimpleType;", "scope", "Lksp/org/jetbrains/kotlin/resolve/scopes/LexicalScope;", "typeReference", "Lksp/org/jetbrains/kotlin/psi/KtTypeReference;", "resolveClass", "Lksp/org/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "userType", "Lksp/org/jetbrains/kotlin/psi/KtUserType;", "isDebuggerContext", "resolveDescriptorForType", "Lksp/org/jetbrains/kotlin/resolve/QualifiedExpressionResolver$TypeQualifierResolutionResult;", "resolveExpandedTypeForTypeAlias", "typeAliasDescriptor", "resolvePossiblyBareType", "resolveType", "checkBounds", "resolveTypeAnnotations", "Lksp/org/jetbrains/kotlin/descriptors/annotations/Annotations;", "modifierListsOwner", "Lksp/org/jetbrains/kotlin/psi/KtElementImplStub;", "resolveTypeElement", "annotations", "outerModifierList", "Lksp/org/jetbrains/kotlin/psi/KtModifierList;", "Lksp/org/jetbrains/kotlin/psi/KtTypeElement;", "resolveTypeForClass", "classDescriptor", "Lksp/org/jetbrains/kotlin/descriptors/ClassDescriptor;", "element", "Lksp/org/jetbrains/kotlin/psi/KtElement;", "qualifierResolutionResult", "resolveTypeForClassifier", "resolveTypeForTypeAlias", "resolveTypeForTypeParameter", "typeParameter", "referenceExpression", "Lksp/org/jetbrains/kotlin/psi/KtSimpleNameExpression;", "typeArgumentList", "Lksp/org/jetbrains/kotlin/psi/KtTypeArgumentList;", "resolveTypeProjections", "constructor", "argumentElements", "resolveTypeProjectionsWithErrorConstructor", "message", "", "resolveTypeWithPossibleIntersections", "shouldCheckBounds", "inType", "canHaveFunctionTypeModifiers", "classifierDescriptorsFromInnerToOuter", "findImplicitOuterClassArguments", "outerClass", "getAllModifierLists", "", "Lksp/org/jetbrains/kotlin/psi/KtDeclarationModifierList;", "getAllModifierLists$frontend", "(Lorg/jetbrains/kotlin/psi/KtElementImplStub;)[Lorg/jetbrains/kotlin/psi/KtDeclarationModifierList;", "Companion", "TracingTypeAliasExpansionReportStrategy", "TypeTransformerForTests", "frontend", "suspendModifier", "Lksp/com/intellij/psi/PsiElement;"})
@SourceDebugExtension(value={"SMAP\nTypeResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeResolver.kt\norg/jetbrains/kotlin/resolve/TypeResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ScopeUtils.kt\norg/jetbrains/kotlin/resolve/scopes/utils/ScopeUtilsKt\n*L\n1#1,1075:1\n1#2:1076\n1#2:1090\n1557#3:1077\n1628#3,3:1078\n1567#3:1081\n1598#3,4:1082\n225#4:1086\n193#4,3:1087\n196#4,3:1091\n226#4:1094\n*S KotlinDebug\n*F\n+ 1 TypeResolver.kt\norg/jetbrains/kotlin/resolve/TypeResolver\n*L\n1027#1:1090\n985#1:1077\n985#1:1078,3\n994#1:1081\n994#1:1082,4\n1027#1:1086\n1027#1:1087,3\n1027#1:1091,3\n1027#1:1094\n*E\n"})
public final class TypeResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnnotationResolver annotationResolver;
    @NotNull
    private final QualifiedExpressionResolver qualifiedExpressionResolver;
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    @NotNull
    private final TypeTransformerForTests typeTransformerForTests;
    @NotNull
    private final DynamicTypesSettings dynamicTypesSettings;
    @NotNull
    private final DynamicCallableDescriptors dynamicCallableDescriptors;
    @NotNull
    private final IdentifierChecker identifierChecker;
    @NotNull
    private final PlatformToKotlinClassMapper platformToKotlinClassMapper;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final UpperBoundChecker upperBoundChecker;
    @NotNull
    private final TypeAttributeTranslators typeAttributeTranslators;
    private final boolean isNonParenthesizedAnnotationsOnFunctionalTypesEnabled;

    public TypeResolver(@NotNull AnnotationResolver annotationResolver, @NotNull QualifiedExpressionResolver qualifiedExpressionResolver, @NotNull ModuleDescriptor moduleDescriptor, @NotNull TypeTransformerForTests typeTransformerForTests, @NotNull DynamicTypesSettings dynamicTypesSettings, @NotNull DynamicCallableDescriptors dynamicCallableDescriptors, @NotNull IdentifierChecker identifierChecker, @NotNull PlatformToKotlinClassMapper platformToKotlinClassMapper, @NotNull LanguageVersionSettings languageVersionSettings2, @NotNull UpperBoundChecker upperBoundChecker, @NotNull TypeAttributeTranslators typeAttributeTranslators) {
        Intrinsics.checkNotNullParameter((Object)annotationResolver, (String)"annotationResolver");
        Intrinsics.checkNotNullParameter((Object)qualifiedExpressionResolver, (String)"qualifiedExpressionResolver");
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkNotNullParameter((Object)typeTransformerForTests, (String)"typeTransformerForTests");
        Intrinsics.checkNotNullParameter((Object)dynamicTypesSettings, (String)"dynamicTypesSettings");
        Intrinsics.checkNotNullParameter((Object)dynamicCallableDescriptors, (String)"dynamicCallableDescriptors");
        Intrinsics.checkNotNullParameter((Object)identifierChecker, (String)"identifierChecker");
        Intrinsics.checkNotNullParameter((Object)platformToKotlinClassMapper, (String)"platformToKotlinClassMapper");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings2, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)upperBoundChecker, (String)"upperBoundChecker");
        Intrinsics.checkNotNullParameter((Object)typeAttributeTranslators, (String)"typeAttributeTranslators");
        this.annotationResolver = annotationResolver;
        this.qualifiedExpressionResolver = qualifiedExpressionResolver;
        this.moduleDescriptor = moduleDescriptor;
        this.typeTransformerForTests = typeTransformerForTests;
        this.dynamicTypesSettings = dynamicTypesSettings;
        this.dynamicCallableDescriptors = dynamicCallableDescriptors;
        this.identifierChecker = identifierChecker;
        this.platformToKotlinClassMapper = platformToKotlinClassMapper;
        this.languageVersionSettings = languageVersionSettings2;
        this.upperBoundChecker = upperBoundChecker;
        this.typeAttributeTranslators = typeAttributeTranslators;
        this.isNonParenthesizedAnnotationsOnFunctionalTypesEnabled = this.languageVersionSettings.getFeatureSupport(LanguageFeature.NonParenthesizedAnnotationsOnFunctionalTypes) == LanguageFeature.State.ENABLED;
    }

    @NotNull
    public final KotlinType resolveTypeWithPossibleIntersections(@NotNull LexicalScope scope, @NotNull KtTypeReference typeReference, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)typeReference, (String)"typeReference");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        return this.resolveType(new TypeResolutionContext(scope, trace, false, false, CodeFragmentUtilKt.suppressDiagnosticsInDebugMode(typeReference), false, true), typeReference);
    }

    @NotNull
    public final KotlinType resolveType(@NotNull LexicalScope scope, @NotNull KtTypeReference typeReference, @NotNull BindingTrace trace, boolean checkBounds) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)typeReference, (String)"typeReference");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        return this.resolveType(new TypeResolutionContext(scope, trace, checkBounds, false, CodeFragmentUtilKt.suppressDiagnosticsInDebugMode(typeReference), false), typeReference);
    }

    @NotNull
    public final SimpleType resolveAbbreviatedType(@NotNull LexicalScope scope, @NotNull KtTypeReference typeReference, @NotNull BindingTrace trace) {
        SimpleType simpleType2;
        UnwrappedType resolvedType;
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)typeReference, (String)"typeReference");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        UnwrappedType unwrappedType = resolvedType = this.resolveType(new TypeResolutionContext(scope, trace, true, false, CodeFragmentUtilKt.suppressDiagnosticsInDebugMode(typeReference), true), typeReference).unwrap();
        if (unwrappedType instanceof DynamicType) {
            trace.report(Errors.TYPEALIAS_SHOULD_EXPAND_TO_CLASS.on((KtTypeReference)((PsiElement)typeReference), resolvedType));
            simpleType2 = ErrorUtils.createErrorType(ErrorTypeKind.PROHIBITED_DYNAMIC_TYPE, new String[0]);
        } else if (unwrappedType instanceof SimpleType) {
            simpleType2 = (SimpleType)resolvedType;
        } else {
            throw new IllegalStateException(("Unexpected type: " + resolvedType).toString());
        }
        return simpleType2;
    }

    @NotNull
    public final SimpleType resolveExpandedTypeForTypeAlias(@NotNull TypeAliasDescriptor typeAliasDescriptor) {
        Intrinsics.checkNotNullParameter((Object)typeAliasDescriptor, (String)"typeAliasDescriptor");
        TypeAliasExpansion typeAliasExpansion = TypeAliasExpansion.Companion.createWithFormalArguments(typeAliasDescriptor);
        SimpleType expandedType2 = TypeAliasExpander.Companion.getNON_REPORTING().expandWithoutAbbreviation(typeAliasExpansion, TypeAttributes.Companion.getEmpty());
        return expandedType2;
    }

    private final KotlinType resolveType(TypeResolutionContext c, KtTypeReference typeReference) {
        boolean bl;
        boolean bl2 = bl = !c.allowBareTypes;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Use resolvePossiblyBareType() when bare types are allowed";
            throw new AssertionError((Object)string2);
        }
        KotlinType kotlinType = this.resolvePossiblyBareType(c, typeReference).getActualType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getActualType(...)");
        return kotlinType;
    }

    @NotNull
    public final PossiblyBareType resolvePossiblyBareType(@NotNull TypeResolutionContext c, @NotNull KtTypeReference typeReference) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)typeReference, (String)"typeReference");
        KotlinType cachedType = (KotlinType)c.trace.getBindingContext().get(BindingContext.TYPE, typeReference);
        if (cachedType != null) {
            PossiblyBareType possiblyBareType = PossiblyBareType.type(cachedType);
            Intrinsics.checkNotNullExpressionValue((Object)possiblyBareType, (String)"type(...)");
            return possiblyBareType;
        }
        WritableSlice<KtTypeReference, KotlinType> resolvedTypeSlice = c.abbreviated ? BindingContext.ABBREVIATED_TYPE : BindingContext.TYPE;
        BindingTrace bindingTrace = c.trace;
        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"trace");
        LexicalScope lexicalScope = c.scope;
        Intrinsics.checkNotNullExpressionValue((Object)lexicalScope, (String)"scope");
        Annotations annotations2 = this.resolveTypeAnnotations(bindingTrace, lexicalScope, typeReference);
        PossiblyBareType type2 = this.resolveTypeElement(c, annotations2, typeReference.getModifierList(), typeReference.getTypeElement());
        BindingTrace bindingTrace2 = c.trace;
        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace2, (String)"trace");
        LexicalScope lexicalScope2 = c.scope;
        Intrinsics.checkNotNullExpressionValue((Object)lexicalScope2, (String)"scope");
        BindingContextUtilsKt.recordScope(bindingTrace2, lexicalScope2, typeReference);
        if (!type2.isBare()) {
            for (TypeProjection argument2 : type2.getActualType().getArguments()) {
                KotlinType kotlinType = argument2.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
                this.forceResolveTypeContents(kotlinType);
            }
            c.trace.record(resolvedTypeSlice, typeReference, type2.getActualType());
        }
        return type2;
    }

    @NotNull
    public final KtDeclarationModifierList[] getAllModifierLists$frontend(@NotNull KtElementImplStub<?> $this$getAllModifierLists) {
        Intrinsics.checkNotNullParameter($this$getAllModifierLists, (String)"<this>");
        PsiElement[] psiElementArray = $this$getAllModifierLists.getStubOrPsiChildren(KtStubElementTypes.MODIFIER_LIST, KtStubElementTypes.MODIFIER_LIST.getArrayFactory());
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getStubOrPsiChildren(...)");
        return (KtDeclarationModifierList[])psiElementArray;
    }

    private final void checkNonParenthesizedAnnotationsOnFunctionalType(KtFunctionType typeElement, List<? extends KtAnnotationEntry> annotationEntries, BindingTrace trace) {
        KtAnnotationEntry lastAnnotationEntry = (KtAnnotationEntry)CollectionsKt.lastOrNull(annotationEntries);
        UserDataHolder userDataHolder = lastAnnotationEntry;
        boolean isAnnotationsGroupedUsingBrackets = Intrinsics.areEqual(userDataHolder != null && (userDataHolder = PsiUtilsKt.getNextSiblingIgnoringWhitespaceAndComments$default((PsiElement)userDataHolder, false, 1, null)) != null && (userDataHolder = userDataHolder.getNode()) != null ? userDataHolder.getElementType() : null, (Object)KtTokens.RBRACKET);
        KtAnnotationEntry ktAnnotationEntry = lastAnnotationEntry;
        boolean hasAnnotationParentheses = (ktAnnotationEntry != null ? ktAnnotationEntry.getValueArgumentList() : null) != null;
        boolean isFunctionalTypeStartingWithParentheses = typeElement.getFirstChild() instanceof KtParameterList;
        PsiElement $this$checkNonParenthesizedAnnotationsOnFunctionalType_u24lambda_u241 = PsiUtilsKt.getPrevSiblingIgnoringWhitespaceAndComments$default(typeElement, false, 1, null);
        boolean bl = false;
        boolean hasSuspendModifierBeforeParentheses = $this$checkNonParenthesizedAnnotationsOnFunctionalType_u24lambda_u241 instanceof KtDeclarationModifierList && PsiUtilsKt.hasSuspendModifier((KtModifierList)$this$checkNonParenthesizedAnnotationsOnFunctionalType_u24lambda_u241);
        if (lastAnnotationEntry != null && isFunctionalTypeStartingWithParentheses && !hasAnnotationParentheses && !isAnnotationsGroupedUsingBrackets && !hasSuspendModifierBeforeParentheses) {
            trace.report(Errors.NON_PARENTHESIZED_ANNOTATIONS_ON_FUNCTIONAL_TYPES.on(lastAnnotationEntry));
        }
    }

    @NotNull
    public final Annotations resolveTypeAnnotations(@NotNull BindingTrace trace, @NotNull LexicalScope scope, @NotNull KtElementImplStub<?> modifierListsOwner) {
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter(modifierListsOwner, (String)"modifierListsOwner");
        KtDeclarationModifierList[] modifierLists = this.getAllModifierLists$frontend(modifierListsOwner);
        Annotations result2 = Annotations.Companion.getEMPTY();
        boolean isSplitModifierList = false;
        if (!this.isNonParenthesizedAnnotationsOnFunctionalTypesEnabled) {
            List<KtAnnotationEntry> annotationEntries;
            List<KtAnnotationEntry> list2;
            KtElementImplStub<?> ktElementImplStub = modifierListsOwner;
            KtTypeElement targetType = ktElementImplStub instanceof KtNullableType ? ((KtNullableType)modifierListsOwner).getInnerType() : (ktElementImplStub instanceof KtTypeReference ? ((KtTypeReference)modifierListsOwner).getTypeElement() : null);
            KtElementImplStub<?> ktElementImplStub2 = modifierListsOwner;
            if (ktElementImplStub2 instanceof KtNullableType) {
                KtModifierList ktModifierList = ((KtNullableType)modifierListsOwner).getModifierList();
                list2 = ktModifierList != null ? ktModifierList.getAnnotationEntries() : null;
            } else {
                list2 = annotationEntries = ktElementImplStub2 instanceof KtTypeReference ? ((KtTypeReference)modifierListsOwner).getAnnotationEntries() : null;
            }
            if (targetType instanceof KtFunctionType && ((KtFunctionType)targetType).getStub() == null && annotationEntries != null) {
                this.checkNonParenthesizedAnnotationsOnFunctionalType((KtFunctionType)targetType, annotationEntries, trace);
            }
        }
        for (KtDeclarationModifierList modifierList2 : modifierLists) {
            if (isSplitModifierList) {
                trace.report(Errors.MODIFIER_LIST_NOT_ALLOWED.on((KtModifierList)((PsiElement)modifierList2)));
            }
            List<KtAnnotationEntry> list3 = modifierList2.getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"getAnnotationEntries(...)");
            Annotations annotations2 = this.annotationResolver.resolveAnnotationsWithoutArguments(scope, list3, trace);
            result2 = AnnotationsKt.composeAnnotations(result2, annotations2);
            isSplitModifierList = true;
        }
        return result2;
    }

    private final void forceResolveTypeContents(KotlinType type2) {
        type2.getAnnotations();
        if (FlexibleTypesKt.isFlexible(type2)) {
            this.forceResolveTypeContents(FlexibleTypesKt.asFlexibleType(type2).getLowerBound());
            this.forceResolveTypeContents(FlexibleTypesKt.asFlexibleType(type2).getUpperBound());
        } else {
            type2.getConstructor();
            for (TypeProjection projection : type2.getArguments()) {
                if (projection.isStarProjection()) continue;
                KotlinType kotlinType = projection.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
                this.forceResolveTypeContents(kotlinType);
            }
        }
    }

    private final PossiblyBareType resolveTypeElement(TypeResolutionContext c, Annotations annotations2, KtModifierList outerModifierList, KtTypeElement typeElement) {
        PossiblyBareType possiblyBareType;
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        KtModifierList ktModifierList = outerModifierList;
        boolean hasSuspendModifier = ktModifierList != null ? ktModifierList.hasModifier(KtTokens.SUSPEND_KEYWORD) : false;
        Lazy suspendModifier$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PsiElement>(outerModifierList){
            final /* synthetic */ KtModifierList $outerModifierList;
            {
                this.$outerModifierList = $outerModifierList;
                super(0);
            }

            public final PsiElement invoke() {
                KtModifierList ktModifierList = this.$outerModifierList;
                return ktModifierList != null ? ktModifierList.getModifier(KtTokens.SUSPEND_KEYWORD) : null;
            }
        }));
        if (hasSuspendModifier && !this.canHaveFunctionTypeModifiers(typeElement)) {
            BindingTrace bindingTrace = c.trace;
            PsiElement psiElement = TypeResolver.resolveTypeElement$lambda$2((Lazy<? extends PsiElement>)suspendModifier$delegate);
            Intrinsics.checkNotNull((Object)psiElement);
            bindingTrace.report(Errors.WRONG_MODIFIER_TARGET.on(psiElement, KtTokens.SUSPEND_KEYWORD, "non-functional type"));
        } else if (hasSuspendModifier) {
            BindingTrace bindingTrace = c.trace;
            Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"trace");
            DiagnosticSink diagnosticSink = bindingTrace;
            PsiElement psiElement = TypeResolver.resolveTypeElement$lambda$2((Lazy<? extends PsiElement>)suspendModifier$delegate);
            Intrinsics.checkNotNull((Object)psiElement);
            CoroutineCallCheckerKt.checkCoroutinesFeature(this.languageVersionSettings, diagnosticSink, psiElement);
        }
        KtTypeElement ktTypeElement = typeElement;
        if (ktTypeElement != null) {
            ktTypeElement.accept(new KtVisitorVoid(this, c, typeElement, (Ref.ObjectRef<PossiblyBareType>)result2, annotations2, outerModifierList, hasSuspendModifier){
                final /* synthetic */ TypeResolver this$0;
                final /* synthetic */ TypeResolutionContext $c;
                final /* synthetic */ KtTypeElement $typeElement;
                final /* synthetic */ Ref.ObjectRef<PossiblyBareType> $result;
                final /* synthetic */ Annotations $annotations;
                final /* synthetic */ KtModifierList $outerModifierList;
                final /* synthetic */ boolean $hasSuspendModifier;
                {
                    this.this$0 = $receiver;
                    this.$c = $c;
                    this.$typeElement = $typeElement;
                    this.$result = $result;
                    this.$annotations = $annotations;
                    this.$outerModifierList = $outerModifierList;
                    this.$hasSuspendModifier = $hasSuspendModifier;
                }

                public void visitUserType(KtUserType type2) {
                    Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                    LexicalScope lexicalScope = this.$c.scope;
                    Intrinsics.checkNotNullExpressionValue((Object)lexicalScope, (String)"scope");
                    BindingTrace bindingTrace = this.$c.trace;
                    Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"trace");
                    QualifiedExpressionResolver.TypeQualifierResolutionResult qualifierResolutionResult = this.this$0.resolveDescriptorForType(lexicalScope, type2, bindingTrace, this.$c.isDebuggerContext);
                    ClassifierDescriptor classifier = qualifierResolutionResult.getClassifierDescriptor();
                    if (classifier == null) {
                        String[] stringArray = new String[1];
                        Intrinsics.checkNotNullExpressionValue((Object)this.$typeElement.getText(), (String)"getText(...)");
                        List<TypeProjection> arguments2 = this.this$0.resolveTypeProjections(this.$c, ErrorUtils.createErrorType(ErrorTypeKind.UNRESOLVED_TYPE, stringArray).getConstructor(), qualifierResolutionResult.getAllProjections());
                        String[] stringArray2 = new String[]{DebugTextUtilKt.getDebugText(type2)};
                        ErrorType unresolvedType = ErrorUtils.INSTANCE.createErrorTypeWithArguments(ErrorTypeKind.UNRESOLVED_TYPE, arguments2, stringArray2);
                        this.$result.element = PossiblyBareType.type(unresolvedType);
                        return;
                    }
                    KtSimpleNameExpression ktSimpleNameExpression = type2.getReferenceExpression();
                    if (ktSimpleNameExpression == null) {
                        return;
                    }
                    KtSimpleNameExpression referenceExpression2 = ktSimpleNameExpression;
                    if (!TypeResolver.access$getLanguageVersionSettings$p(this.this$0).supportsFeature(LanguageFeature.YieldIsNoMoreReserved)) {
                        BindingTrace bindingTrace2 = this.$c.trace;
                        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace2, (String)"trace");
                        ReservedCheckingKt.checkReservedYield(referenceExpression2, bindingTrace2);
                    }
                    this.$c.trace.record(BindingContext.REFERENCE_TARGET, referenceExpression2, classifier);
                    this.$result.element = this.this$0.resolveTypeForClassifier(this.$c, classifier, qualifierResolutionResult, type2, this.$annotations);
                }

                public void visitNullableType(KtNullableType nullableType) {
                    Intrinsics.checkNotNullParameter((Object)nullableType, (String)"nullableType");
                    KtTypeElement innerType = nullableType.getInnerType();
                    PossiblyBareType baseType = this.createTypeFromInner(nullableType, nullableType.getModifierList(), innerType);
                    if (!baseType.isBare() && baseType.getActualType() instanceof DefinitelyNotNullType) {
                        this.$c.trace.report(Errors.NULLABLE_ON_DEFINITELY_NOT_NULLABLE.on((KtNullableType)((PsiElement)nullableType)));
                    }
                    if (baseType.isNullable() || innerType instanceof KtNullableType || innerType instanceof KtDynamicType) {
                        this.$c.trace.report(Errors.REDUNDANT_NULLABLE.on((KtNullableType)((PsiElement)nullableType)));
                    }
                    this.$result.element = baseType.makeNullable();
                }

                private final PossiblyBareType createTypeFromInner(KtTypeElement typeElement, KtModifierList innerModifierList, KtTypeElement innerType) {
                    if (innerModifierList != null && this.$outerModifierList != null) {
                        this.$c.trace.report(Errors.MODIFIER_LIST_NOT_ALLOWED.on((KtModifierList)((PsiElement)innerModifierList)));
                    }
                    BindingTrace bindingTrace = this.$c.trace;
                    Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"trace");
                    LexicalScope lexicalScope = this.$c.scope;
                    Intrinsics.checkNotNullExpressionValue((Object)lexicalScope, (String)"scope");
                    Intrinsics.checkNotNull((Object)typeElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElementImplStub<*>");
                    Annotations innerAnnotations = AnnotationsKt.composeAnnotations(this.$annotations, this.this$0.resolveTypeAnnotations(bindingTrace, lexicalScope, (KtElementImplStub)((Object)typeElement)));
                    KtModifierList ktModifierList = this.$outerModifierList;
                    if (ktModifierList == null) {
                        ktModifierList = innerModifierList;
                    }
                    return TypeResolver.access$resolveTypeElement(this.this$0, this.$c, innerAnnotations, ktModifierList, innerType);
                }

                public void visitIntersectionType(KtIntersectionType intersectionType2) {
                    Intrinsics.checkNotNullParameter((Object)intersectionType2, (String)"intersectionType");
                    KtTypeReference ktTypeReference = intersectionType2.getLeftTypeRef();
                    if (ktTypeReference == null) {
                        return;
                    }
                    PossiblyBareType it = this.this$0.resolvePossiblyBareType(this.$c, ktTypeReference);
                    boolean bl = false;
                    if (it.isBare()) {
                        throw new IllegalStateException("There should not be bare types for intersections".toString());
                    }
                    KotlinType kotlinType = it.getActualType();
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"let(...)");
                    KotlinType leftType = kotlinType;
                    this.$result.element = PossiblyBareType.type(leftType);
                    KtTypeReference ktTypeReference2 = intersectionType2.getRightTypeRef();
                    if (ktTypeReference2 == null) {
                        return;
                    }
                    PossiblyBareType it2 = this.this$0.resolvePossiblyBareType(this.$c, ktTypeReference2);
                    boolean bl2 = false;
                    if (it2.isBare()) {
                        throw new IllegalStateException("There should not be bare types for intersections".toString());
                    }
                    KotlinType kotlinType2 = it2.getActualType();
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"let(...)");
                    KotlinType rightType = kotlinType2;
                    if (!this.$c.allowIntersectionTypes) {
                        if (!TypeResolver.access$getLanguageVersionSettings$p(this.this$0).supportsFeature(LanguageFeature.DefinitelyNonNullableTypes)) {
                            this.$c.trace.report(Errors.UNSUPPORTED_FEATURE.on(intersectionType2, (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)((Object)LanguageFeature.DefinitelyNonNullableTypes), (Object)TypeResolver.access$getLanguageVersionSettings$p(this.this$0))));
                            return;
                        }
                        if (!TypeUtilsKt.isTypeParameter(leftType) || leftType.isMarkedNullable() || !this.isNullableOrUninitializedTypeParameter(leftType)) {
                            BindingTrace bindingTrace = this.$c.trace;
                            KtTypeReference ktTypeReference3 = intersectionType2.getLeftTypeRef();
                            Intrinsics.checkNotNull((Object)ktTypeReference3);
                            bindingTrace.report(Errors.INCORRECT_LEFT_COMPONENT_OF_INTERSECTION.on((KtTypeReference)((PsiElement)ktTypeReference3)));
                            return;
                        }
                        if (!TypeUtilsKt.isAny(rightType)) {
                            BindingTrace bindingTrace = this.$c.trace;
                            KtTypeReference ktTypeReference4 = intersectionType2.getRightTypeRef();
                            Intrinsics.checkNotNull((Object)ktTypeReference4);
                            bindingTrace.report(Errors.INCORRECT_RIGHT_COMPONENT_OF_INTERSECTION.on((KtTypeReference)((PsiElement)ktTypeReference4)));
                            return;
                        }
                        DefinitelyNotNullType definitelyNotNullType = DefinitelyNotNullType.Companion.makeDefinitelyNotNull$default(DefinitelyNotNullType.Companion, leftType.unwrap(), false, false, 6, null);
                        if (definitelyNotNullType == null) {
                            StringBuilder stringBuilder2 = new StringBuilder().append("Definitely not-nullable type is not created for type parameter with nullable upper bound ");
                            TypeParameterDescriptor typeParameterDescriptor = TypeUtils.getTypeParameterDescriptorOrNull(leftType);
                            Intrinsics.checkNotNull((Object)typeParameterDescriptor);
                            throw new IllegalStateException(stringBuilder2.append(typeParameterDescriptor).toString().toString());
                        }
                        DefinitelyNotNullType definitelyNotNullType2 = definitelyNotNullType;
                        this.$result.element = PossiblyBareType.type(definitelyNotNullType2);
                    } else {
                        Object[] objectArray = new KotlinType[]{leftType, rightType};
                        this.$result.element = PossiblyBareType.type(new IntersectionTypeConstructor(CollectionsKt.listOf((Object[])objectArray)).createType());
                    }
                }

                private final boolean isNullableOrUninitializedTypeParameter(KotlinType $this$isNullableOrUninitializedTypeParameter) {
                    ClassifierDescriptor classifierDescriptor = $this$isNullableOrUninitializedTypeParameter.getConstructor().getDeclarationDescriptor();
                    TypeParameterDescriptorImpl typeParameterDescriptorImpl = classifierDescriptor instanceof TypeParameterDescriptorImpl ? (TypeParameterDescriptorImpl)classifierDescriptor : null;
                    boolean bl = typeParameterDescriptorImpl != null ? !typeParameterDescriptorImpl.isInitialized() : false;
                    if (bl) {
                        return true;
                    }
                    return KotlinTypeKt.isNullable($this$isNullableOrUninitializedTypeParameter);
                }

                /*
                 * WARNING - void declaration
                 */
                public void visitFunctionType(KtFunctionType type2) {
                    Collection<Name> collection;
                    Collection<KotlinType> collection2;
                    Iterable $this$mapTo$iv$iv;
                    Iterable $this$map$iv;
                    KtParameterList parameterList2;
                    KotlinType kotlinType;
                    List list2;
                    Ref.ObjectRef<PossiblyBareType> objectRef;
                    Ref.ObjectRef<PossiblyBareType> destination$iv$iv;
                    KotlinType kotlinType2;
                    Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                    KtTypeReference receiverTypeRef = type2.getReceiverTypeReference();
                    if (receiverTypeRef == null) {
                        kotlinType2 = null;
                    } else {
                        TypeResolutionContext typeResolutionContext = this.$c.noBareTypes();
                        Intrinsics.checkNotNullExpressionValue((Object)typeResolutionContext, (String)"noBareTypes(...)");
                        kotlinType2 = TypeResolver.access$resolveType(this.this$0, typeResolutionContext, receiverTypeRef);
                    }
                    KotlinType receiverType2 = kotlinType2;
                    KtContextReceiverList contextReceiverList = type2.getContextReceiverList();
                    if (contextReceiverList != null) {
                        void $this$mapTo$iv$iv2;
                        void $this$map$iv2;
                        BindingTrace bindingTrace = this.$c.trace;
                        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"trace");
                        ContextReceiversUtilKt.checkContextReceiversAreEnabled(bindingTrace, TypeResolver.access$getLanguageVersionSettings$p(this.this$0), contextReceiverList);
                        Iterable iterable = contextReceiverList.typeReferences();
                        TypeResolver typeResolver = this.this$0;
                        TypeResolutionContext typeResolutionContext = this.$c;
                        boolean $i$f$map = false;
                        void var11_10 = $this$map$iv2;
                        destination$iv$iv = (Ref.ObjectRef<PossiblyBareType>)new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv2) {
                            void typeRef;
                            KtTypeReference ktTypeReference = (KtTypeReference)item$iv$iv;
                            objectRef = destination$iv$iv;
                            boolean bl = false;
                            TypeResolutionContext typeResolutionContext2 = typeResolutionContext.noBareTypes();
                            Intrinsics.checkNotNullExpressionValue((Object)typeResolutionContext2, (String)"noBareTypes(...)");
                            objectRef.add((PossiblyBareType)((Object)TypeResolver.access$resolveType(typeResolver, typeResolutionContext2, (KtTypeReference)typeRef)));
                        }
                        List types2 = (List)destination$iv$iv;
                        BindingTrace bindingTrace2 = this.$c.trace;
                        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace2, (String)"trace");
                        ContextReceiversUtilKt.checkSubtypingBetweenContextReceivers(bindingTrace2, contextReceiverList, types2);
                        list2 = types2;
                    } else {
                        list2 = CollectionsKt.emptyList();
                    }
                    List contextReceiversTypes = list2;
                    List<KtParameter> list3 = type2.getParameters();
                    Intrinsics.checkNotNullExpressionValue(list3, (String)"getParameters(...)");
                    List<VariableDescriptor> parameterDescriptors = this.resolveParametersOfFunctionType(list3);
                    this.checkParametersOfFunctionType(parameterDescriptors);
                    KtTypeReference returnTypeRef = type2.getReturnTypeReference();
                    if (returnTypeRef != null) {
                        TypeResolutionContext typeResolutionContext = this.$c.noBareTypes();
                        Intrinsics.checkNotNullExpressionValue((Object)typeResolutionContext, (String)"noBareTypes(...)");
                        kotlinType = TypeResolver.access$resolveType(this.this$0, typeResolutionContext, returnTypeRef);
                    } else {
                        SimpleType simpleType2 = TypeResolver.access$getModuleDescriptor$p(this.this$0).getBuiltIns().getUnitType();
                        Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"getUnitType(...)");
                        kotlinType = simpleType2;
                    }
                    KotlinType returnType2 = kotlinType;
                    KtParameterList ktParameterList = parameterList2 = type2.getParameterList();
                    if ((ktParameterList != null ? (KotlinPlaceHolderStub<T>)ktParameterList.getStub() : null) == null) {
                        KtParameterList ktParameterList2 = parameterList2;
                        PsiElement psiElement = ktParameterList2 != null ? ktParameterList2.getTrailingComma() : null;
                        BindingTrace bindingTrace = this.$c.trace;
                        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"trace");
                        TrailingCommaChecker.INSTANCE.check(psiElement, bindingTrace, TypeResolver.access$getLanguageVersionSettings$p(this.this$0));
                    }
                    Iterable $i$f$map = parameterDescriptors;
                    List list4 = contextReceiversTypes;
                    KotlinType kotlinType3 = receiverType2;
                    Annotations annotations2 = this.$annotations;
                    KotlinBuiltIns kotlinBuiltIns = TypeResolver.access$getModuleDescriptor$p(this.this$0).getBuiltIns();
                    objectRef = this.$result;
                    boolean $i$f$map2 = false;
                    destination$iv$iv = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        VariableDescriptor bl = (VariableDescriptor)item$iv$iv;
                        collection2 = destination$iv$iv2;
                        boolean bl2 = false;
                        KotlinType kotlinType4 = it.getType();
                        Intrinsics.checkNotNullExpressionValue((Object)kotlinType4, (String)"getType(...)");
                        collection2.add(kotlinType4);
                    }
                    collection2 = (List)destination$iv$iv2;
                    $this$map$iv = parameterDescriptors;
                    $i$f$map2 = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        VariableDescriptor it = (VariableDescriptor)item$iv$iv;
                        collection = destination$iv$iv2;
                        boolean bl = false;
                        Name name2 = it.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getName(...)");
                        collection.add(name2);
                    }
                    collection = (List)destination$iv$iv2;
                    objectRef.element = PossiblyBareType.type(FunctionTypesKt.createFunctionType(kotlinBuiltIns, annotations2, kotlinType3, list4, collection2, (List<Name>)collection, returnType2, this.$hasSuspendModifier));
                }

                /*
                 * WARNING - void declaration
                 */
                private final void checkParametersOfFunctionType(List<? extends VariableDescriptor> parameterDescriptors) {
                    void $this$groupByTo$iv$iv;
                    VariableDescriptor it;
                    Iterable $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = parameterDescriptors;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Object destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (VariableDescriptor)element$iv$iv;
                        boolean bl = false;
                        if (!(!it.getName().isSpecial())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable $this$groupBy$iv = (List)destination$iv$iv;
                    boolean $i$f$groupBy = false;
                    $this$filterTo$iv$iv = $this$groupBy$iv;
                    destination$iv$iv = new LinkedHashMap<K, V>();
                    boolean $i$f$groupByTo = false;
                    for (T element$iv$iv : $this$groupByTo$iv$iv) {
                        Object object;
                        it = (VariableDescriptor)element$iv$iv;
                        boolean bl = false;
                        Name key$iv$iv = it.getName();
                        Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                        boolean $i$f$getOrPut = false;
                        V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                        if (value$iv$iv$iv == null) {
                            boolean bl2 = false;
                            List answer$iv$iv$iv = new ArrayList<E>();
                            $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                            object = answer$iv$iv$iv;
                        } else {
                            object = value$iv$iv$iv;
                        }
                        List list$iv$iv = (List)object;
                        list$iv$iv.add(element$iv$iv);
                    }
                    Object parametersByName = destination$iv$iv;
                    for (List parametersGroup : parametersByName.values()) {
                        if (parametersGroup.size() < 2) continue;
                        for (VariableDescriptor parameter2 : parametersGroup) {
                            KtParameter ktParameter;
                            SourceElement sourceElement = parameter2.getSource();
                            Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"getSource(...)");
                            PsiElement psiElement = PsiSourceElementKt.getPsi(sourceElement);
                            if ((psiElement instanceof KtParameter ? (KtParameter)psiElement : null) == null) continue;
                            ktParameter = ktParameter;
                            this.$c.trace.report(Errors.DUPLICATE_PARAMETER_NAME_IN_FUNCTION_TYPE.on((KtParameter)((PsiElement)ktParameter)));
                        }
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                private final List<VariableDescriptor> resolveParametersOfFunctionType(List<? extends KtParameter> parameters2) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable $this$forEach$iv;
                    Iterable iterable = parameters2;
                    TypeResolver typeResolver = this.this$0;
                    TypeResolutionContext typeResolutionContext = this.$c;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        KtParameter it = (KtParameter)element$iv;
                        boolean bl = false;
                        IdentifierChecker identifierChecker = TypeResolver.access$getIdentifierChecker$p(typeResolver);
                        KtDeclaration ktDeclaration = it;
                        BindingTrace bindingTrace = typeResolutionContext.trace;
                        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"trace");
                        identifierChecker.checkDeclaration(ktDeclaration, bindingTrace);
                        this.checkParameterInFunctionType(it);
                    }
                    $this$forEach$iv = parameters2;
                    typeResolver = this.this$0;
                    typeResolutionContext = this.$c;
                    boolean $i$f$map = false;
                    Iterator<T> iterator2 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void parameter2;
                        KtParameter ktParameter = (KtParameter)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        TypeResolutionContext typeResolutionContext2 = typeResolutionContext.noBareTypes();
                        Intrinsics.checkNotNullExpressionValue((Object)typeResolutionContext2, (String)"noBareTypes(...)");
                        KtTypeReference ktTypeReference = parameter2.getTypeReference();
                        Intrinsics.checkNotNull((Object)ktTypeReference);
                        KotlinType parameterType = TypeResolver.access$resolveType(typeResolver, typeResolutionContext2, ktTypeReference);
                        DeclarationDescriptor declarationDescriptor = typeResolutionContext.scope.getOwnerDescriptor();
                        AnnotationResolver annotationResolver = TypeResolver.access$getAnnotationResolver$p(typeResolver);
                        LexicalScope lexicalScope = typeResolutionContext.scope;
                        Intrinsics.checkNotNullExpressionValue((Object)lexicalScope, (String)"scope");
                        KtModifierList ktModifierList = parameter2.getModifierList();
                        BindingTrace bindingTrace = typeResolutionContext.trace;
                        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"trace");
                        Annotations annotations2 = annotationResolver.resolveAnnotationsWithoutArguments(lexicalScope, ktModifierList, bindingTrace);
                        Name name2 = parameter2.getNameAsSafeName();
                        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getNameAsSafeName(...)");
                        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Y\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ5\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e\"\u0004\b\u0001\u0010\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u0002H\u000f0\u00112\u0006\u0010\u0012\u001a\u0002H\u000fH\u0016\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016\u00a8\u0006!"}, d2={"ksp/org/jetbrains/kotlin/resolve/TypeResolver$resolveTypeElement$1$resolveParametersOfFunctionType$ParameterOfFunctionTypeDescriptor", "Lksp/org/jetbrains/kotlin/descriptors/impl/VariableDescriptorImpl;", "containingDeclaration", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "annotations", "Lksp/org/jetbrains/kotlin/descriptors/annotations/Annotations;", "name", "Lksp/org/jetbrains/kotlin/name/Name;", "type", "Lksp/org/jetbrains/kotlin/types/KotlinType;", "source", "Lksp/org/jetbrains/kotlin/descriptors/SourceElement;", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/descriptors/SourceElement;)V", "accept", "R", "D", "visitor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptorVisitor;", "data", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "cleanCompileTimeInitializerCache", "", "getCompileTimeInitializer", "", "getVisibility", "Lksp/org/jetbrains/kotlin/descriptors/DescriptorVisibility;", "isLateInit", "", "isVar", "substitute", "Lksp/org/jetbrains/kotlin/descriptors/VariableDescriptor;", "substitutor", "Lksp/org/jetbrains/kotlin/types/TypeSubstitutor;", "frontend"})
                        public final class ParameterOfFunctionTypeDescriptor
                        extends VariableDescriptorImpl {
                            public ParameterOfFunctionTypeDescriptor(DeclarationDescriptor containingDeclaration2, Annotations annotations2, Name name2, KotlinType type2, SourceElement source) {
                                Intrinsics.checkNotNullParameter((Object)containingDeclaration2, (String)"containingDeclaration");
                                Intrinsics.checkNotNullParameter((Object)annotations2, (String)"annotations");
                                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                                Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                                super(containingDeclaration2, annotations2, name2, type2, source);
                            }

                            public DescriptorVisibility getVisibility() {
                                DescriptorVisibility descriptorVisibility = DescriptorVisibilities.LOCAL;
                                Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"LOCAL");
                                return descriptorVisibility;
                            }

                            public VariableDescriptor substitute(TypeSubstitutor substitutor2) {
                                Intrinsics.checkNotNullParameter((Object)substitutor2, (String)"substitutor");
                                throw new UnsupportedOperationException("Should not be called for descriptor of type " + this.getClass());
                            }

                            public boolean isVar() {
                                return false;
                            }

                            public boolean isLateInit() {
                                return false;
                            }

                            public Void getCompileTimeInitializer() {
                                return null;
                            }

                            public void cleanCompileTimeInitializerCache() {
                            }

                            public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor2, D data2) {
                                Intrinsics.checkNotNullParameter(visitor2, (String)"visitor");
                                return visitor2.visitVariableDescriptor(this, data2);
                            }
                        }
                        ParameterOfFunctionTypeDescriptor descriptor2 = new ParameterOfFunctionTypeDescriptor(declarationDescriptor, annotations2, name2, parameterType, KotlinSourceElementKt.toSourceElement((KtPureElement)parameter2));
                        typeResolutionContext.trace.record(BindingContext.VALUE_PARAMETER, parameter2, descriptor2);
                        collection.add(descriptor2);
                    }
                    return (List)destination$iv$iv;
                }

                public void visitContextReceiverList(KtContextReceiverList contextReceiverList) {
                    Intrinsics.checkNotNullParameter((Object)contextReceiverList, (String)"contextReceiverList");
                    BindingTrace bindingTrace = this.$c.trace;
                    Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"trace");
                    ContextReceiversUtilKt.checkContextReceiversAreEnabled(bindingTrace, TypeResolver.access$getLanguageVersionSettings$p(this.this$0), contextReceiverList);
                }

                public void visitDynamicType(KtDynamicType type2) {
                    Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                    this.$result.element = PossiblyBareType.type(TypeUtilsKt.replaceAnnotations(TypeResolver.access$getDynamicCallableDescriptors$p(this.this$0).getDynamicType(), this.$annotations));
                    if (!TypeResolver.access$getDynamicTypesSettings$p(this.this$0).getDynamicTypesAllowed()) {
                        this.$c.trace.report(Errors.UNSUPPORTED.on(type2, "Dynamic types are not supported in this context"));
                    }
                }

                public void visitSelfType(KtSelfType type2) {
                    Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                    this.$c.trace.report(Errors.UNSUPPORTED.on(type2, "Self-types are not supported"));
                }

                public void visitKtElement(KtElement element2) {
                    Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                    this.$c.trace.report(Errors.UNSUPPORTED.on(element2, "Self-types are not supported yet"));
                }

                /*
                 * WARNING - void declaration
                 */
                private final void checkParameterInFunctionType(KtParameter param) {
                    block6: {
                        Object object;
                        KtModifierList modifierList2;
                        if (param.hasDefaultValue()) {
                            BindingTrace bindingTrace = this.$c.trace;
                            KtExpression ktExpression = param.getDefaultValue();
                            Intrinsics.checkNotNull((Object)ktExpression);
                            bindingTrace.report(Errors.UNSUPPORTED.on(ktExpression, "default value of parameter in function type"));
                        }
                        if (param.getName() != null) {
                            for (KtAnnotationEntry annotationEntry2 : param.getAnnotationEntries()) {
                                this.$c.trace.report(Errors.UNSUPPORTED.on(annotationEntry2, "annotation on parameter in function type"));
                            }
                        }
                        if ((modifierList2 = param.getModifierList()) != null) {
                            void $this$forEach$iv;
                            void $this$mapNotNullTo$iv$iv;
                            Intrinsics.checkNotNullExpressionValue((Object)KtTokens.MODIFIER_KEYWORDS_ARRAY, (String)"MODIFIER_KEYWORDS_ARRAY");
                            Object $this$mapNotNull$iv = KtTokens.MODIFIER_KEYWORDS_ARRAY;
                            boolean $i$f$mapNotNull = false;
                            Object[] objectArray = $this$mapNotNull$iv;
                            Collection destination$iv$iv = new ArrayList<E>();
                            boolean $i$f$mapNotNullTo = false;
                            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                            boolean $i$f$forEach = false;
                            int n = ((void)$this$forEach$iv$iv$iv).length;
                            for (int i = 0; i < n; ++i) {
                                PsiElement it$iv$iv;
                                void element$iv$iv$iv;
                                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                                boolean bl = false;
                                KtModifierKeywordToken it = (KtModifierKeywordToken)element$iv$iv;
                                boolean bl2 = false;
                                if (modifierList2.getModifier(it) == null) continue;
                                boolean bl3 = false;
                                destination$iv$iv.add(it$iv$iv);
                            }
                            $this$mapNotNull$iv = (List)destination$iv$iv;
                            object = this.$c;
                            boolean $i$f$forEach2 = false;
                            for (E element$iv : $this$forEach$iv) {
                                PsiElement it = (PsiElement)element$iv;
                                boolean bl = false;
                                ((TypeResolutionContext)object).trace.report(Errors.UNSUPPORTED.on(it, "modifier on parameter in function type"));
                            }
                        }
                        PsiElement psiElement = param.getValOrVarKeyword();
                        if (psiElement == null) break block6;
                        object = psiElement;
                        TypeResolutionContext typeResolutionContext = this.$c;
                        PsiElement it = object;
                        boolean bl = false;
                        typeResolutionContext.trace.report(Errors.UNSUPPORTED.on(it, "val or var on parameter in function type"));
                    }
                }
            });
        }
        if ((possiblyBareType = (PossiblyBareType)result2.element) == null) {
            String[] stringArray = new String[1];
            Object object = typeElement;
            if (object == null || (object = DebugTextUtilKt.getDebugText((KtElement)object)) == null) {
                object = "unknown element";
            }
            stringArray[0] = object;
            PossiblyBareType possiblyBareType2 = PossiblyBareType.type(ErrorUtils.createErrorType(ErrorTypeKind.NO_TYPE_SPECIFIED, stringArray));
            possiblyBareType = possiblyBareType2;
            Intrinsics.checkNotNullExpressionValue((Object)possiblyBareType2, (String)"type(...)");
        }
        return possiblyBareType;
    }

    private final boolean canHaveFunctionTypeModifiers(KtTypeElement $this$canHaveFunctionTypeModifiers) {
        return $this$canHaveFunctionTypeModifiers instanceof KtFunctionType;
    }

    private final KotlinType resolveTypeForTypeParameter(TypeResolutionContext c, Annotations annotations2, TypeParameterDescriptor typeParameter, KtSimpleNameExpression referenceExpression2, KtTypeArgumentList typeArgumentList) {
        KotlinType kotlinType;
        MemberScope scopeForTypeParameter = this.getScopeForTypeParameter(c, typeParameter);
        if (typeArgumentList != null) {
            TypeConstructor typeConstructor2 = ErrorUtils.createErrorType(ErrorTypeKind.ERROR_TYPE_PARAMETER, new String[0]).getConstructor();
            List<KtTypeProjection> list2 = typeArgumentList.getArguments();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getArguments(...)");
            this.resolveTypeProjections(c, typeConstructor2, list2);
            c.trace.report(Errors.TYPE_ARGUMENTS_NOT_ALLOWED.on((KtElement)((PsiElement)typeArgumentList), "for type parameters"));
        }
        DeclarationDescriptor declarationDescriptor = typeParameter.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
        DeclarationDescriptor containing = declarationDescriptor;
        if (containing instanceof ClassDescriptor) {
            DescriptorResolver.checkHasOuterClassInstance(c.scope, c.trace, referenceExpression2, (ClassDescriptor)containing);
        }
        if (scopeForTypeParameter instanceof ErrorScope && !(scopeForTypeParameter instanceof ThrowingScope)) {
            kotlinType = ErrorUtils.createErrorType(ErrorTypeKind.ERROR_TYPE_PARAMETER, new String[0]);
        } else {
            TypeConstructor typeConstructor3 = typeParameter.getTypeConstructor();
            Intrinsics.checkNotNullExpressionValue((Object)typeConstructor3, (String)"getTypeConstructor(...)");
            TypeAttributes typeAttributes = this.typeAttributeTranslators.toAttributes(annotations2, typeConstructor3, containing);
            TypeConstructor typeConstructor4 = typeParameter.getTypeConstructor();
            Intrinsics.checkNotNullExpressionValue((Object)typeConstructor4, (String)"getTypeConstructor(...)");
            kotlinType = KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(typeAttributes, typeConstructor4, CollectionsKt.emptyList(), false, scopeForTypeParameter);
        }
        return kotlinType;
    }

    private final MemberScope getScopeForTypeParameter(TypeResolutionContext c, TypeParameterDescriptor typeParameterDescriptor) {
        return c.checkBounds ? TypeIntersector.getUpperBoundsAsType(typeParameterDescriptor).getMemberScope() : (MemberScope)new LazyScopeAdapter(null, (Function0)new Function0<MemberScope>(typeParameterDescriptor){
            final /* synthetic */ TypeParameterDescriptor $typeParameterDescriptor;
            {
                this.$typeParameterDescriptor = $typeParameterDescriptor;
                super(0);
            }

            public final MemberScope invoke() {
                return TypeIntersector.getUpperBoundsAsType(this.$typeParameterDescriptor).getMemberScope();
            }
        }, 1, null);
    }

    @NotNull
    public final PossiblyBareType resolveTypeForClassifier(@NotNull TypeResolutionContext c, @NotNull ClassifierDescriptor descriptor2, @NotNull QualifiedExpressionResolver.TypeQualifierResolutionResult qualifierResolutionResult, @NotNull KtElement element2, @NotNull Annotations annotations2) {
        PossiblyBareType possiblyBareType;
        ClassifierDescriptor classifierDescriptor;
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)qualifierResolutionResult, (String)"qualifierResolutionResult");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)annotations2, (String)"annotations");
        List<QualifiedExpressionResolver.ExpressionQualifierPart> qualifierParts = qualifierResolutionResult.getQualifierParts();
        if (element2 instanceof KtUserType && ((KtUserType)element2).getStub() == null) {
            KtTypeArgumentList ktTypeArgumentList = ((KtUserType)element2).getTypeArgumentList();
            PsiElement psiElement = ktTypeArgumentList != null ? ktTypeArgumentList.getTrailingComma() : null;
            BindingTrace bindingTrace = c.trace;
            Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"trace");
            TrailingCommaChecker.INSTANCE.check(psiElement, bindingTrace, this.languageVersionSettings);
        }
        if ((classifierDescriptor = descriptor2) instanceof TypeParameterDescriptor) {
            boolean bl;
            boolean bl2 = bl = qualifierParts.size() == 1;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string2 = "Type parameter can be resolved only by it's short name, but '" + element2.getText() + "' is contradiction with " + qualifierParts.size() + " qualifier parts";
                throw new AssertionError((Object)string2);
            }
            QualifiedExpressionResolver.ExpressionQualifierPart qualifierPart = (QualifiedExpressionResolver.ExpressionQualifierPart)CollectionsKt.single(qualifierParts);
            PossiblyBareType possiblyBareType2 = PossiblyBareType.type(this.resolveTypeForTypeParameter(c, annotations2, (TypeParameterDescriptor)descriptor2, qualifierPart.getExpression(), qualifierPart.getTypeArguments()));
            Intrinsics.checkNotNull((Object)possiblyBareType2);
            possiblyBareType = possiblyBareType2;
        } else if (classifierDescriptor instanceof ClassDescriptor) {
            possiblyBareType = this.resolveTypeForClass(c, annotations2, (ClassDescriptor)descriptor2, element2, qualifierResolutionResult);
        } else if (classifierDescriptor instanceof TypeAliasDescriptor) {
            possiblyBareType = this.resolveTypeForTypeAlias(c, annotations2, (TypeAliasDescriptor)descriptor2, element2, qualifierResolutionResult);
        } else {
            throw new IllegalStateException(("Unexpected classifier type: " + descriptor2.getClass()).toString());
        }
        return possiblyBareType;
    }

    private final PossiblyBareType resolveTypeForClass(TypeResolutionContext c, Annotations annotations2, ClassDescriptor classDescriptor2, KtElement element2, QualifiedExpressionResolver.TypeQualifierResolutionResult qualifierResolutionResult) {
        boolean bl;
        boolean bl2;
        TypeConstructor typeConstructor2 = classDescriptor2.getTypeConstructor();
        Intrinsics.checkNotNullExpressionValue((Object)typeConstructor2, (String)"getTypeConstructor(...)");
        TypeConstructor typeConstructor3 = typeConstructor2;
        List<KtTypeProjection> projectionFromAllQualifierParts = qualifierResolutionResult.getAllProjections();
        List<TypeParameterDescriptor> list2 = typeConstructor3.getParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getParameters(...)");
        List<TypeParameterDescriptor> parameters2 = list2;
        if (c.allowBareTypes && projectionFromAllQualifierParts.isEmpty() && this.isPossibleToSpecifyTypeArgumentsFor(classDescriptor2)) {
            PossiblyBareType possiblyBareType = PossiblyBareType.bare(typeConstructor3, false);
            Intrinsics.checkNotNullExpressionValue((Object)possiblyBareType, (String)"bare(...)");
            return possiblyBareType;
        }
        if (ErrorUtils.isError(classDescriptor2)) {
            return this.createErrorTypeForTypeConstructor(c, projectionFromAllQualifierParts, typeConstructor3);
        }
        Pair<List<KtTypeProjection>, List<TypeProjection>> pair = this.collectArgumentsForClassifierTypeConstructor(c, classDescriptor2, qualifierResolutionResult.getQualifierParts());
        if (pair == null) {
            return this.createErrorTypeForTypeConstructor(c, projectionFromAllQualifierParts, typeConstructor3);
        }
        Pair<List<KtTypeProjection>, List<TypeProjection>> pair2 = pair;
        List collectedArgumentAsTypeProjections = (List)pair2.component1();
        List argumentsForOuterClass = (List)pair2.component2();
        boolean bl3 = bl2 = collectedArgumentAsTypeProjections.size() <= parameters2.size();
        if (_Assertions.ENABLED && !bl2) {
            boolean $i$a$-assert-TypeResolver$resolveTypeForClass$32 = false;
            String $i$a$-assert-TypeResolver$resolveTypeForClass$32 = "Collected arguments count should be not greater then parameters count, but " + collectedArgumentAsTypeProjections.size() + " instead of " + parameters2.size() + " found in " + element2.getText();
            throw new AssertionError((Object)$i$a$-assert-TypeResolver$resolveTypeForClass$32);
        }
        List<TypeProjection> argumentsFromUserType = this.resolveTypeProjections(c, typeConstructor3, collectedArgumentAsTypeProjections);
        List<TypeProjection> arguments2 = this.buildFinalArgumentList(argumentsFromUserType, argumentsForOuterClass, parameters2);
        boolean bl4 = bl = arguments2.size() == parameters2.size();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-TypeResolver$resolveTypeForClass$42 = false;
            String $i$a$-assert-TypeResolver$resolveTypeForClass$42 = "Collected arguments count should be equal to parameters count, but " + collectedArgumentAsTypeProjections.size() + " instead of " + parameters2.size() + " found in " + element2.getText();
            throw new AssertionError((Object)$i$a$-assert-TypeResolver$resolveTypeForClass$42);
        }
        TypeConstructor typeConstructor4 = classDescriptor2.getTypeConstructor();
        Intrinsics.checkNotNullExpressionValue((Object)typeConstructor4, (String)"getTypeConstructor(...)");
        SimpleType resultingType = KotlinTypeFactory.simpleNotNullType(this.typeAttributeTranslators.toAttributes(annotations2, typeConstructor4, c.scope.getOwnerDescriptor()), classDescriptor2, arguments2);
        KotlinType $i$a$-assert-TypeResolver$resolveTypeForClass$42 = this.typeTransformerForTests.transformType(resultingType);
        if ($i$a$-assert-TypeResolver$resolveTypeForClass$42 != null) {
            KotlinType it = $i$a$-assert-TypeResolver$resolveTypeForClass$42;
            boolean bl5 = false;
            PossiblyBareType possiblyBareType = PossiblyBareType.type(it);
            Intrinsics.checkNotNullExpressionValue((Object)possiblyBareType, (String)"type(...)");
            return possiblyBareType;
        }
        if (this.shouldCheckBounds(c, resultingType)) {
            TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(resultingType);
            Intrinsics.checkNotNullExpressionValue((Object)typeSubstitutor2, (String)"create(...)");
            TypeSubstitutor substitutor2 = typeSubstitutor2;
            int n = ((Collection)parameters2).size();
            for (int i = 0; i < n; ++i) {
                KotlinType argument2;
                KtTypeReference typeReference;
                TypeParameterDescriptor parameter2 = parameters2.get(i);
                Intrinsics.checkNotNullExpressionValue((Object)arguments2.get(i).getType(), (String)"getType(...)");
                KtTypeProjection ktTypeProjection = (KtTypeProjection)CollectionsKt.getOrNull((List)collectedArgumentAsTypeProjections, (int)i);
                KtTypeReference ktTypeReference = typeReference = ktTypeProjection != null ? ktTypeProjection.getTypeReference() : null;
                if (typeReference == null) continue;
                Intrinsics.checkNotNull((Object)parameter2);
                BindingTrace bindingTrace = c.trace;
                Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"trace");
                UpperBoundChecker.checkBounds$default(this.upperBoundChecker, typeReference, argument2, parameter2, substitutor2, bindingTrace, null, null, 96, null);
            }
        }
        if (TypeUtilsKt.isArrayOfNothing(resultingType)) {
            c.trace.report(Errors.UNSUPPORTED.on(element2, "Array<Nothing> is illegal"));
        }
        PossiblyBareType possiblyBareType = PossiblyBareType.type(resultingType);
        Intrinsics.checkNotNullExpressionValue((Object)possiblyBareType, (String)"type(...)");
        return possiblyBareType;
    }

    private final List<TypeProjection> buildFinalArgumentList(List<? extends TypeProjection> argumentsFromUserType, List<? extends TypeProjection> argumentsForOuterClass, List<? extends TypeParameterDescriptor> parameters2) {
        Collection collection = argumentsFromUserType;
        List<? extends TypeProjection> list2 = argumentsForOuterClass;
        if (list2 == null) {
            list2 = this.appendDefaultArgumentsForLocalClassifier(argumentsFromUserType.size(), parameters2);
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)list2);
    }

    private final boolean shouldCheckBounds(TypeResolutionContext c, KotlinType inType) {
        if (!c.checkBounds) {
            return false;
        }
        if (TypeUtilsKt.containsTypeAliasParameters(inType)) {
            return false;
        }
        return !c.abbreviated || !TypeUtilsKt.containsTypeAliases(inType);
    }

    private final PossiblyBareType resolveTypeForTypeAlias(TypeResolutionContext c, Annotations annotations2, TypeAliasDescriptor descriptor2, KtElement type2, QualifiedExpressionResolver.TypeQualifierResolutionResult qualifierResolutionResult) {
        PossiblyBareType possiblyBareType;
        ClassDescriptor classDescriptor2;
        TypeConstructor typeConstructor2 = descriptor2.getTypeConstructor();
        Intrinsics.checkNotNullExpressionValue((Object)typeConstructor2, (String)"getTypeConstructor(...)");
        TypeConstructor typeConstructor3 = typeConstructor2;
        List<KtTypeProjection> projectionFromAllQualifierParts = qualifierResolutionResult.getAllProjections();
        if (ErrorUtils.isError(descriptor2)) {
            return this.createErrorTypeForTypeConstructor(c, projectionFromAllQualifierParts, typeConstructor3);
        }
        if (!this.languageVersionSettings.supportsFeature(LanguageFeature.TypeAliases)) {
            c.trace.report(Errors.UNSUPPORTED_FEATURE.on(type2, (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)((Object)LanguageFeature.TypeAliases), (Object)this.languageVersionSettings)));
            return this.createErrorTypeForTypeConstructor(c, projectionFromAllQualifierParts, typeConstructor3);
        }
        List<TypeParameterDescriptor> list2 = typeConstructor3.getParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getParameters(...)");
        List<TypeParameterDescriptor> parameters2 = list2;
        if (c.allowBareTypes && projectionFromAllQualifierParts.isEmpty() && this.isPossibleToSpecifyTypeArgumentsFor(descriptor2) && (classDescriptor2 = descriptor2.getClassDescriptor()) != null && this.canBeUsedAsBareType(descriptor2)) {
            ClassDescriptor classDescriptor3 = descriptor2.getClassDescriptor();
            Intrinsics.checkNotNull((Object)classDescriptor3);
            PossiblyBareType possiblyBareType2 = PossiblyBareType.bare(classDescriptor3.getTypeConstructor(), TypeUtils.isNullableType(descriptor2.getExpandedType()));
            Intrinsics.checkNotNullExpressionValue((Object)possiblyBareType2, (String)"bare(...)");
            return possiblyBareType2;
        }
        QualifiedExpressionResolver.ExpressionQualifierPart expressionQualifierPart = (QualifiedExpressionResolver.ExpressionQualifierPart)CollectionsKt.lastOrNull(qualifierResolutionResult.getQualifierParts());
        if (expressionQualifierPart == null) {
            return this.createErrorTypeForTypeConstructor(c, projectionFromAllQualifierParts, typeConstructor3);
        }
        QualifiedExpressionResolver.ExpressionQualifierPart typeAliasQualifierPart = expressionQualifierPart;
        Pair<List<KtTypeProjection>, List<TypeProjection>> pair = this.collectArgumentsForClassifierTypeConstructor(c, descriptor2, qualifierResolutionResult.getQualifierParts());
        if (pair == null) {
            return this.createErrorTypeForTypeConstructor(c, projectionFromAllQualifierParts, typeConstructor3);
        }
        Pair<List<KtTypeProjection>, List<TypeProjection>> pair2 = pair;
        List argumentElementsFromUserType = (List)pair2.component1();
        List argumentsForOuterClass = (List)pair2.component2();
        List<TypeProjection> argumentsFromUserType = this.resolveTypeProjections(c, typeConstructor3, argumentElementsFromUserType);
        List<TypeProjection> arguments2 = this.buildFinalArgumentList(argumentsFromUserType, argumentsForOuterClass, parameters2);
        BindingTrace bindingTrace = c.trace;
        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"trace");
        KtTypeArgumentList ktTypeArgumentList = typeAliasQualifierPart.getTypeArguments();
        KtElement ktElement = ktTypeArgumentList != null ? (KtElement)ktTypeArgumentList : (KtElement)typeAliasQualifierPart.getExpression();
        List<TypeParameterDescriptor> list3 = descriptor2.getDeclaredTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"getDeclaredTypeParameters(...)");
        TracingTypeAliasExpansionReportStrategy reportStrategy = new TracingTypeAliasExpansionReportStrategy(bindingTrace, type2, ktElement, descriptor2, list3, argumentElementsFromUserType, this.upperBoundChecker);
        if (parameters2.size() != arguments2.size()) {
            reportStrategy.wrongNumberOfTypeArguments(descriptor2, parameters2.size());
            return this.createErrorTypeForTypeConstructor(c, projectionFromAllQualifierParts, typeConstructor3);
        }
        TypeConstructor typeConstructor4 = descriptor2.getTypeConstructor();
        Intrinsics.checkNotNullExpressionValue((Object)typeConstructor4, (String)"getTypeConstructor(...)");
        TypeAttributes attributes2 = this.typeAttributeTranslators.toAttributes(annotations2, typeConstructor4, c.scope.getOwnerDescriptor());
        if (c.abbreviated) {
            TypeConstructor typeConstructor5 = descriptor2.getTypeConstructor();
            Intrinsics.checkNotNullExpressionValue((Object)typeConstructor5, (String)"getTypeConstructor(...)");
            SimpleType abbreviatedType = KotlinTypeFactory.simpleType$default(attributes2, typeConstructor5, arguments2, false, null, 16, null);
            PossiblyBareType possiblyBareType3 = PossiblyBareType.type(abbreviatedType);
            Intrinsics.checkNotNull((Object)possiblyBareType3);
            possiblyBareType = possiblyBareType3;
        } else {
            TypeAliasExpansion typeAliasExpansion = TypeAliasExpansion.Companion.create(null, descriptor2, arguments2);
            SimpleType expandedType2 = new TypeAliasExpander(reportStrategy, c.checkBounds).expand(typeAliasExpansion, attributes2);
            PossiblyBareType possiblyBareType4 = PossiblyBareType.type(expandedType2);
            Intrinsics.checkNotNull((Object)possiblyBareType4);
            possiblyBareType = possiblyBareType4;
        }
        return possiblyBareType;
    }

    private final boolean canBeUsedAsBareType(TypeAliasDescriptor descriptor2) {
        SimpleType expandedType2 = descriptor2.getExpandedType();
        if (KotlinTypeKt.isError(expandedType2)) {
            return false;
        }
        ClassDescriptor classDescriptor2 = descriptor2.getClassDescriptor();
        if (classDescriptor2 == null) {
            return false;
        }
        ClassDescriptor classDescriptor3 = classDescriptor2;
        if (!this.isPossibleToSpecifyTypeArgumentsFor(classDescriptor3)) {
            return false;
        }
        LinkedHashSet<TypeParameterDescriptor> usedTypeParameters = new LinkedHashSet<TypeParameterDescriptor>();
        for (TypeProjection argument2 : expandedType2.getArguments()) {
            if (argument2.isStarProjection()) continue;
            if (argument2.getProjectionKind() != Variance.INVARIANT) {
                return false;
            }
            ClassifierDescriptor classifierDescriptor = argument2.getType().getConstructor().getDeclarationDescriptor();
            TypeParameterDescriptor typeParameterDescriptor = classifierDescriptor instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)classifierDescriptor : null;
            if (typeParameterDescriptor == null) {
                return false;
            }
            TypeParameterDescriptor argumentTypeDescriptor = typeParameterDescriptor;
            if (!Intrinsics.areEqual((Object)argumentTypeDescriptor.getContainingDeclaration(), (Object)descriptor2)) {
                return false;
            }
            if (usedTypeParameters.contains(argumentTypeDescriptor)) {
                return false;
            }
            usedTypeParameters.add(argumentTypeDescriptor);
        }
        return true;
    }

    private final PossiblyBareType createErrorTypeForTypeConstructor(TypeResolutionContext c, List<? extends KtTypeProjection> arguments2, TypeConstructor typeConstructor2) {
        List list2 = TypeResolver.resolveTypeProjectionsWithErrorConstructor$default(this, c, arguments2, null, 4, null);
        String[] stringArray = new String[1];
        Object object = typeConstructor2.getDeclarationDescriptor();
        if (object == null || (object = object.getName()) == null || (object = ((Name)object).asString()) == null) {
            object = typeConstructor2.toString();
        }
        Object object2 = object;
        Intrinsics.checkNotNull((Object)object2);
        stringArray[0] = object2;
        PossiblyBareType possiblyBareType = PossiblyBareType.type(ErrorUtils.INSTANCE.createErrorTypeWithArguments(ErrorTypeKind.TYPE_FOR_ERROR_TYPE_CONSTRUCTOR, (List<? extends TypeProjection>)list2, stringArray));
        Intrinsics.checkNotNullExpressionValue((Object)possiblyBareType, (String)"type(...)");
        return possiblyBareType;
    }

    private final boolean isPossibleToSpecifyTypeArgumentsFor(ClassifierDescriptorWithTypeParameters classifierDescriptor) {
        List<TypeParameterDescriptor> list2 = classifierDescriptor.getTypeConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getParameters(...)");
        TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)CollectionsKt.firstOrNull(list2);
        if (typeParameterDescriptor == null) {
            return false;
        }
        TypeParameterDescriptor firstTypeParameter = typeParameterDescriptor;
        return firstTypeParameter.getOriginal().getContainingDeclaration() instanceof ClassifierDescriptorWithTypeParameters;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<List<KtTypeProjection>, List<TypeProjection>> collectArgumentsForClassifierTypeConstructor(TypeResolutionContext c, ClassifierDescriptorWithTypeParameters classifierDescriptor, List<QualifiedExpressionResolver.ExpressionQualifierPart> qualifierParts) {
        Object currentParameters;
        Object qualifierPart;
        List<ClassifierDescriptorWithTypeParameters> classifierDescriptorChain = this.classifierDescriptorsFromInnerToOuter(classifierDescriptor);
        List reversedQualifierParts = CollectionsKt.asReversed(qualifierParts);
        boolean wasStatic = false;
        SmartList result2 = new SmartList();
        int index2 = 0;
        int classifierChainLastIndex = Math.min(classifierDescriptorChain.size(), reversedQualifierParts.size()) - 1;
        if (index2 <= classifierChainLastIndex) {
            while (true) {
                List<TypeParameterDescriptor> declaredTypeParameters;
                qualifierPart = (QualifiedExpressionResolver.ExpressionQualifierPart)reversedQualifierParts.get(index2);
                KtTypeArgumentList ktTypeArgumentList = ((QualifiedExpressionResolver.QualifierPart)qualifierPart).getTypeArguments();
                List list2 = ktTypeArgumentList != null ? ktTypeArgumentList.getArguments() : null;
                if (list2 == null) {
                    list2 = CollectionsKt.emptyList();
                }
                List currentArguments = list2;
                Intrinsics.checkNotNullExpressionValue(classifierDescriptorChain.get(index2).getDeclaredTypeParameters(), (String)"getDeclaredTypeParameters(...)");
                Object object = currentParameters = wasStatic ? CollectionsKt.emptyList() : declaredTypeParameters;
                if (wasStatic && !((Collection)currentArguments).isEmpty() && !((Collection)declaredTypeParameters).isEmpty()) {
                    BindingTrace bindingTrace = c.trace;
                    KtTypeArgumentList ktTypeArgumentList2 = ((QualifiedExpressionResolver.QualifierPart)qualifierPart).getTypeArguments();
                    Intrinsics.checkNotNull((Object)ktTypeArgumentList2);
                    bindingTrace.report(Errors.TYPE_ARGUMENTS_FOR_OUTER_CLASS_WHEN_NESTED_REFERENCED.on((KtTypeArgumentList)((PsiElement)ktTypeArgumentList2)));
                    return null;
                }
                if (currentArguments.size() != currentParameters.size()) {
                    KtTypeArgumentList ktTypeArgumentList3 = ((QualifiedExpressionResolver.QualifierPart)qualifierPart).getTypeArguments();
                    c.trace.report(Errors.WRONG_NUMBER_OF_TYPE_ARGUMENTS.on((KtElement)((PsiElement)(ktTypeArgumentList3 != null ? (KtElement)ktTypeArgumentList3 : (KtElement)((QualifiedExpressionResolver.ExpressionQualifierPart)qualifierPart).getExpression())), currentParameters.size(), classifierDescriptorChain.get(index2)));
                    return null;
                }
                result2.addAll(currentArguments);
                boolean bl = wasStatic = wasStatic || !classifierDescriptorChain.get(index2).isInner();
                if (index2 == classifierChainLastIndex) break;
                ++index2;
            }
        }
        List nonClassQualifierParts = reversedQualifierParts.subList(Math.min(classifierChainLastIndex + 1, reversedQualifierParts.size()), reversedQualifierParts.size());
        qualifierPart = nonClassQualifierParts.iterator();
        while (qualifierPart.hasNext()) {
            KtTypeArgumentList typeArguments2 = ((QualifiedExpressionResolver.ExpressionQualifierPart)qualifierPart.next()).component3();
            if (typeArguments2 == null) continue;
            c.trace.report(Errors.TYPE_ARGUMENTS_NOT_ALLOWED.on((KtElement)((PsiElement)typeArguments2), "here"));
            return null;
        }
        List<TypeParameterDescriptor> list3 = classifierDescriptor.getTypeConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"getParameters(...)");
        List<TypeParameterDescriptor> parameters2 = list3;
        if (result2.size() < parameters2.size()) {
            boolean bl;
            currentParameters = parameters2.get(result2.size()).getOriginal().getContainingDeclaration();
            ClassDescriptor classDescriptor2 = currentParameters instanceof ClassDescriptor ? (ClassDescriptor)currentParameters : null;
            if (classDescriptor2 == null) {
                return new Pair(result2, null);
            }
            ClassDescriptor nextParameterOwner = classDescriptor2;
            LexicalScope lexicalScope = c.scope;
            Intrinsics.checkNotNullExpressionValue((Object)lexicalScope, (String)"scope");
            List<TypeProjection> restArguments = this.findImplicitOuterClassArguments(lexicalScope, nextParameterOwner);
            List<TypeParameterDescriptor> restParameters = parameters2.subList(result2.size(), parameters2.size());
            Iterable iterable = this.classifierDescriptorsFromInnerToOuter(classifierDescriptor);
            int n = 0;
            for (Object t : iterable) {
                void it;
                ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = (ClassifierDescriptorWithTypeParameters)t;
                int n2 = n;
                boolean bl2 = false;
                int n3 = it.getDeclaredTypeParameters().size();
                n = n2 + n3;
            }
            int typeArgumentsCanBeSpecifiedCount = n;
            if (restArguments == null && typeArgumentsCanBeSpecifiedCount > result2.size()) {
                c.trace.report(Errors.OUTER_CLASS_ARGUMENTS_REQUIRED.on((KtElement)((PsiElement)((QualifiedExpressionResolver.ExpressionQualifierPart)CollectionsKt.first(qualifierParts)).getExpression()), nextParameterOwner));
                return null;
            }
            if (restArguments == null) {
                boolean bl3;
                boolean bl4 = bl3 = typeArgumentsCanBeSpecifiedCount == result2.size();
                if (_Assertions.ENABLED && !bl3) {
                    boolean $i$a$-assert-TypeResolver$collectArgumentsForClassifierTypeConstructor$32 = false;
                    String $i$a$-assert-TypeResolver$collectArgumentsForClassifierTypeConstructor$32 = "Number of type arguments that can be specified (" + typeArgumentsCanBeSpecifiedCount + ") should be equal to actual arguments number " + result2.size() + ", (classifier: " + classifierDescriptor + ')';
                    throw new AssertionError((Object)$i$a$-assert-TypeResolver$collectArgumentsForClassifierTypeConstructor$32);
                }
                return new Pair(result2, null);
            }
            boolean bl5 = bl = restParameters.size() == restArguments.size();
            if (_Assertions.ENABLED && !bl) {
                boolean bl6 = false;
                String string2 = "Number of type of restParameters should be equal to " + restParameters.size() + ", but " + restArguments.size() + " were found for " + classifierDescriptor + '/' + nextParameterOwner;
                throw new AssertionError((Object)string2);
            }
            return new Pair(result2, restArguments);
        }
        return new Pair(result2, null);
    }

    private final List<ClassifierDescriptorWithTypeParameters> classifierDescriptorsFromInnerToOuter(ClassifierDescriptor $this$classifierDescriptorsFromInnerToOuter) {
        return SequencesKt.toList((Sequence)SequencesKt.generateSequence((Function0)((Function0)new Function0<ClassifierDescriptorWithTypeParameters>($this$classifierDescriptorsFromInnerToOuter){
            final /* synthetic */ ClassifierDescriptor $this_classifierDescriptorsFromInnerToOuter;
            {
                this.$this_classifierDescriptorsFromInnerToOuter = $receiver;
                super(0);
            }

            public final ClassifierDescriptorWithTypeParameters invoke() {
                ClassifierDescriptor classifierDescriptor = this.$this_classifierDescriptorsFromInnerToOuter;
                return classifierDescriptor instanceof ClassifierDescriptorWithTypeParameters ? (ClassifierDescriptorWithTypeParameters)classifierDescriptor : null;
            }
        }), (Function1)classifierDescriptorsFromInnerToOuter.2.INSTANCE));
    }

    private final List<TypeProjection> resolveTypeProjectionsWithErrorConstructor(TypeResolutionContext c, List<? extends KtTypeProjection> argumentElements, String message2) {
        String[] stringArray = new String[]{message2};
        return this.resolveTypeProjections(c, ErrorUtils.INSTANCE.createErrorTypeConstructor(ErrorTypeKind.TYPE_FOR_ERROR_TYPE_CONSTRUCTOR, stringArray), argumentElements);
    }

    static /* synthetic */ List resolveTypeProjectionsWithErrorConstructor$default(TypeResolver typeResolver, TypeResolutionContext typeResolutionContext, List list2, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = "Error type for resolving type projections";
        }
        return typeResolver.resolveTypeProjectionsWithErrorConstructor(typeResolutionContext, list2, string2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<TypeProjectionImpl> appendDefaultArgumentsForLocalClassifier(int fromIndex, List<? extends TypeParameterDescriptor> constructorParameters) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = constructorParameters.subList(fromIndex, constructorParameters.size());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new TypeProjectionImpl(it.getOriginal().getDefaultType()));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TypeProjection> resolveTypeProjections(@NotNull TypeResolutionContext c, @NotNull TypeConstructor constructor2, @NotNull List<? extends KtTypeProjection> argumentElements) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)constructor2, (String)"constructor");
        Intrinsics.checkNotNullParameter(argumentElements, (String)"argumentElements");
        Iterable $this$mapIndexed$iv = argumentElements;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            TypeProjection typeProjection;
            void i;
            KtProjectionKind projectionKind;
            void argumentElement;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            KtTypeProjection ktTypeProjection = (KtTypeProjection)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)argumentElement.getProjectionKind()), (String)"getProjectionKind(...)");
            KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)argumentElement;
            BindingTrace bindingTrace = c.trace;
            Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"trace");
            ModifierCheckerCore.INSTANCE.check(ktModifierListOwner, bindingTrace, null, this.languageVersionSettings);
            if (projectionKind == KtProjectionKind.STAR) {
                List<TypeParameterDescriptor> parameters2;
                Intrinsics.checkNotNullExpressionValue(constructor2.getParameters(), (String)"getParameters(...)");
                if (parameters2.size() > i) {
                    TypeParameterDescriptor parameterDescriptor = parameters2.get((int)i);
                    typeProjection = TypeUtils.makeStarProjection(parameterDescriptor);
                } else {
                    typeProjection = new TypeProjectionImpl(Variance.OUT_VARIANCE, ErrorUtils.createErrorType(ErrorTypeKind.ERROR_TYPE_PROJECTION, new String[0]));
                }
            } else {
                TypeResolutionContext typeResolutionContext = c.noBareTypes();
                Intrinsics.checkNotNullExpressionValue((Object)typeResolutionContext, (String)"noBareTypes(...)");
                KtTypeReference ktTypeReference = argumentElement.getTypeReference();
                Intrinsics.checkNotNull((Object)ktTypeReference);
                KotlinType type2 = this.resolveType(typeResolutionContext, ktTypeReference);
                Variance kind = Companion.resolveProjectionKind(projectionKind);
                if (constructor2.getParameters().size() > i) {
                    TypeParameterDescriptor parameterDescriptor = constructor2.getParameters().get((int)i);
                    if (kind != Variance.INVARIANT && parameterDescriptor.getVariance() != Variance.INVARIANT) {
                        if (kind == parameterDescriptor.getVariance()) {
                            BindingTrace bindingTrace2 = c.trace;
                            PsiElement psiElement = (PsiElement)argumentElement;
                            ClassifierDescriptor classifierDescriptor = constructor2.getDeclarationDescriptor();
                            Intrinsics.checkNotNull((Object)classifierDescriptor);
                            bindingTrace2.report(Errors.REDUNDANT_PROJECTION.on((KtTypeProjection)psiElement, classifierDescriptor));
                        } else {
                            BindingTrace bindingTrace3 = c.trace;
                            PsiElement psiElement = (PsiElement)argumentElement;
                            ClassifierDescriptor classifierDescriptor = constructor2.getDeclarationDescriptor();
                            Intrinsics.checkNotNull((Object)classifierDescriptor);
                            bindingTrace3.report(Errors.CONFLICTING_PROJECTION.on((KtTypeProjection)psiElement, classifierDescriptor));
                        }
                    }
                }
                typeProjection = new TypeProjectionImpl(kind, type2);
            }
            collection.add(typeProjection);
        }
        return (List)destination$iv$iv;
    }

    private final List<TypeProjection> findImplicitOuterClassArguments(LexicalScope $this$findImplicitOuterClassArguments, ClassDescriptor outerClass) {
        ClassDescriptor classDescriptor2;
        block5: {
            HierarchicalScope $this$findFirstFromMeAndParent$iv = $this$findImplicitOuterClassArguments;
            boolean $i$f$findFirstFromMeAndParent = false;
            HierarchicalScope $this$processForMeAndParent$iv$iv = $this$findFirstFromMeAndParent$iv;
            boolean $i$f$processForMeAndParent = false;
            HierarchicalScope currentScope$iv$iv = $this$processForMeAndParent$iv$iv;
            while (true) {
                ClassDescriptor classDescriptor3;
                HierarchicalScope it$iv = currentScope$iv$iv;
                boolean bl = false;
                HierarchicalScope scope = it$iv;
                boolean bl2 = false;
                if (scope instanceof LexicalScope && ((LexicalScope)scope).getKind() == LexicalScopeKind.CLASS_MEMBER_SCOPE) {
                    DeclarationDescriptor declarationDescriptor = ((LexicalScope)scope).getOwnerDescriptor();
                    Intrinsics.checkNotNull((Object)declarationDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                    classDescriptor3 = (ClassDescriptor)declarationDescriptor;
                } else {
                    classDescriptor3 = null;
                }
                if (classDescriptor3 != null) {
                    ClassDescriptor it$iv2 = classDescriptor3;
                    boolean bl3 = false;
                    classDescriptor2 = it$iv2;
                    break block5;
                }
                if (currentScope$iv$iv.getParent() == null) break;
            }
            classDescriptor2 = null;
        }
        if (classDescriptor2 == null) {
            return null;
        }
        ClassDescriptor enclosingClass = classDescriptor2;
        return DescriptorUtilsKt.findImplicitOuterClassArguments(enclosingClass, outerClass);
    }

    @Nullable
    public final ClassifierDescriptor resolveClass(@NotNull LexicalScope scope, @NotNull KtUserType userType, @NotNull BindingTrace trace, boolean isDebuggerContext) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)userType, (String)"userType");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        return this.resolveDescriptorForType(scope, userType, trace, isDebuggerContext).getClassifierDescriptor();
    }

    @NotNull
    public final QualifiedExpressionResolver.TypeQualifierResolutionResult resolveDescriptorForType(@NotNull LexicalScope scope, @NotNull KtUserType userType, @NotNull BindingTrace trace, boolean isDebuggerContext) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)userType, (String)"userType");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        if (userType.getQualifier() != null) {
            KtUserType ktUserType = userType.getQualifier();
            Intrinsics.checkNotNull((Object)ktUserType);
            object = ktUserType.getTypeArguments().iterator();
            while (object.hasNext()) {
                KtTypeProjection typeArgument = (KtTypeProjection)object.next();
                if (typeArgument.getTypeReference() != null) {
                    KtTypeReference it;
                    boolean bl = false;
                    this.forceResolveTypeContents(this.resolveType(scope, it, trace, false));
                }
            }
        }
        Object $this$resolveDescriptorForType_u24lambda_u2414 = object = this.qualifiedExpressionResolver.resolveDescriptorForType(userType, scope, trace, isDebuggerContext);
        boolean bl = false;
        if (((QualifiedExpressionResolver.TypeQualifierResolutionResult)$this$resolveDescriptorForType_u24lambda_u2414).getClassifierDescriptor() != null) {
            PlatformClassesMappedToKotlinChecker.reportPlatformClassMappedToKotlin(this.platformToKotlinClassMapper, trace, userType, ((QualifiedExpressionResolver.TypeQualifierResolutionResult)$this$resolveDescriptorForType_u24lambda_u2414).getClassifierDescriptor());
        }
        return object;
    }

    private static final PsiElement resolveTypeElement$lambda$2(Lazy<? extends PsiElement> $suspendModifier$delegate) {
        Lazy<? extends PsiElement> lazy = $suspendModifier$delegate;
        return (PsiElement)lazy.getValue();
    }

    @JvmStatic
    @NotNull
    public static final Variance resolveProjectionKind(@NotNull KtProjectionKind projectionKind) {
        return Companion.resolveProjectionKind(projectionKind);
    }

    public static final /* synthetic */ LanguageVersionSettings access$getLanguageVersionSettings$p(TypeResolver $this) {
        return $this.languageVersionSettings;
    }

    public static final /* synthetic */ PossiblyBareType access$resolveTypeElement(TypeResolver $this, TypeResolutionContext c, Annotations annotations2, KtModifierList outerModifierList, KtTypeElement typeElement) {
        return $this.resolveTypeElement(c, annotations2, outerModifierList, typeElement);
    }

    public static final /* synthetic */ KotlinType access$resolveType(TypeResolver $this, TypeResolutionContext c, KtTypeReference typeReference) {
        return $this.resolveType(c, typeReference);
    }

    public static final /* synthetic */ ModuleDescriptor access$getModuleDescriptor$p(TypeResolver $this) {
        return $this.moduleDescriptor;
    }

    public static final /* synthetic */ DynamicCallableDescriptors access$getDynamicCallableDescriptors$p(TypeResolver $this) {
        return $this.dynamicCallableDescriptors;
    }

    public static final /* synthetic */ DynamicTypesSettings access$getDynamicTypesSettings$p(TypeResolver $this) {
        return $this.dynamicTypesSettings;
    }

    public static final /* synthetic */ IdentifierChecker access$getIdentifierChecker$p(TypeResolver $this) {
        return $this.identifierChecker;
    }

    public static final /* synthetic */ AnnotationResolver access$getAnnotationResolver$p(TypeResolver $this) {
        return $this.annotationResolver;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lksp/org/jetbrains/kotlin/resolve/TypeResolver$Companion;", "", "()V", "resolveProjectionKind", "Lksp/org/jetbrains/kotlin/types/Variance;", "projectionKind", "Lksp/org/jetbrains/kotlin/psi/KtProjectionKind;", "frontend"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Variance resolveProjectionKind(@NotNull KtProjectionKind projectionKind) {
            Variance variance2;
            Intrinsics.checkNotNullParameter((Object)((Object)projectionKind), (String)"projectionKind");
            switch (WhenMappings.$EnumSwitchMapping$0[projectionKind.ordinal()]) {
                case 1: {
                    variance2 = Variance.IN_VARIANCE;
                    break;
                }
                case 2: {
                    variance2 = Variance.OUT_VARIANCE;
                    break;
                }
                case 3: {
                    variance2 = Variance.INVARIANT;
                    break;
                }
                default: {
                    throw new IllegalStateException("Illegal projection kind:" + (Object)((Object)projectionKind));
                }
            }
            return variance2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[KtProjectionKind.values().length];
                try {
                    nArray[KtProjectionKind.IN.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[KtProjectionKind.OUT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[KtProjectionKind.NONE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J(\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\u000bH\u0016J\"\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\b2\b\u0010#\u001a\u0004\u0018\u00010\u000b2\u0006\u0010&\u001a\u00020!H\u0016J\u0010\u0010'\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\bH\u0016J\u0010\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020*H\u0016J\u0018\u0010+\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\b2\u0006\u0010,\u001a\u00020-H\u0016R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006."}, d2={"Lksp/org/jetbrains/kotlin/resolve/TypeResolver$TracingTypeAliasExpansionReportStrategy;", "Lksp/org/jetbrains/kotlin/types/TypeAliasExpansionReportStrategy;", "trace", "Lksp/org/jetbrains/kotlin/resolve/BindingTrace;", "type", "Lksp/org/jetbrains/kotlin/psi/KtElement;", "typeArgumentsOrTypeName", "typeAliasDescriptor", "Lksp/org/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "typeParameters", "", "Lksp/org/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "typeArguments", "Lksp/org/jetbrains/kotlin/psi/KtTypeProjection;", "upperBoundChecker", "Lksp/org/jetbrains/kotlin/resolve/UpperBoundChecker;", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;Ljava/util/List;Ljava/util/List;Lorg/jetbrains/kotlin/resolve/UpperBoundChecker;)V", "mappedArguments", "", "getTrace", "()Lorg/jetbrains/kotlin/resolve/BindingTrace;", "getType", "()Lorg/jetbrains/kotlin/psi/KtElement;", "getTypeAliasDescriptor", "()Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "getTypeArgumentsOrTypeName", "getUpperBoundChecker", "()Lorg/jetbrains/kotlin/resolve/UpperBoundChecker;", "boundsViolationInSubstitution", "", "substitutor", "Lksp/org/jetbrains/kotlin/types/TypeSubstitutor;", "unsubstitutedArgument", "Lksp/org/jetbrains/kotlin/types/KotlinType;", "argument", "typeParameter", "conflictingProjection", "typeAlias", "substitutedArgument", "recursiveTypeAlias", "repeatedAnnotation", "annotation", "Lksp/org/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "wrongNumberOfTypeArguments", "numberOfParameters", "", "frontend"})
    @SourceDebugExtension(value={"SMAP\nTypeResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeResolver.kt\norg/jetbrains/kotlin/resolve/TypeResolver$TracingTypeAliasExpansionReportStrategy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1075:1\n1#2:1076\n*E\n"})
    private static final class TracingTypeAliasExpansionReportStrategy
    implements TypeAliasExpansionReportStrategy {
        @NotNull
        private final BindingTrace trace;
        @Nullable
        private final KtElement type;
        @Nullable
        private final KtElement typeArgumentsOrTypeName;
        @NotNull
        private final TypeAliasDescriptor typeAliasDescriptor;
        @NotNull
        private final UpperBoundChecker upperBoundChecker;
        @NotNull
        private final Map<TypeParameterDescriptor, KtTypeProjection> mappedArguments;

        public TracingTypeAliasExpansionReportStrategy(@NotNull BindingTrace trace, @Nullable KtElement type2, @Nullable KtElement typeArgumentsOrTypeName, @NotNull TypeAliasDescriptor typeAliasDescriptor, @NotNull List<? extends TypeParameterDescriptor> typeParameters2, @NotNull List<? extends KtTypeProjection> typeArguments2, @NotNull UpperBoundChecker upperBoundChecker) {
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            Intrinsics.checkNotNullParameter((Object)typeAliasDescriptor, (String)"typeAliasDescriptor");
            Intrinsics.checkNotNullParameter(typeParameters2, (String)"typeParameters");
            Intrinsics.checkNotNullParameter(typeArguments2, (String)"typeArguments");
            Intrinsics.checkNotNullParameter((Object)upperBoundChecker, (String)"upperBoundChecker");
            this.trace = trace;
            this.type = type2;
            this.typeArgumentsOrTypeName = typeArgumentsOrTypeName;
            this.typeAliasDescriptor = typeAliasDescriptor;
            this.upperBoundChecker = upperBoundChecker;
            this.mappedArguments = MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)typeParameters2, (Iterable)typeArguments2));
        }

        @NotNull
        public final BindingTrace getTrace() {
            return this.trace;
        }

        @Nullable
        public final KtElement getType() {
            return this.type;
        }

        @Nullable
        public final KtElement getTypeArgumentsOrTypeName() {
            return this.typeArgumentsOrTypeName;
        }

        @NotNull
        public final TypeAliasDescriptor getTypeAliasDescriptor() {
            return this.typeAliasDescriptor;
        }

        @NotNull
        public final UpperBoundChecker getUpperBoundChecker() {
            return this.upperBoundChecker;
        }

        @Override
        public void wrongNumberOfTypeArguments(@NotNull TypeAliasDescriptor typeAlias, int numberOfParameters) {
            Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
            if (this.typeArgumentsOrTypeName != null) {
                this.trace.report(Errors.WRONG_NUMBER_OF_TYPE_ARGUMENTS.on((KtElement)((PsiElement)this.typeArgumentsOrTypeName), numberOfParameters, this.typeAliasDescriptor));
            }
        }

        @Override
        public void conflictingProjection(@NotNull TypeAliasDescriptor typeAlias, @Nullable TypeParameterDescriptor typeParameter, @NotNull KotlinType substitutedArgument) {
            KtTypeProjection argumentElement;
            KtTypeProjection ktTypeProjection;
            Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
            Intrinsics.checkNotNullParameter((Object)substitutedArgument, (String)"substitutedArgument");
            TypeParameterDescriptor typeParameterDescriptor = typeParameter;
            if (typeParameterDescriptor != null) {
                TypeParameterDescriptor it = typeParameterDescriptor;
                boolean bl = false;
                ktTypeProjection = this.mappedArguments.get(it);
            } else {
                ktTypeProjection = argumentElement = null;
            }
            if (argumentElement != null) {
                this.trace.report(Errors.CONFLICTING_PROJECTION.on((KtTypeProjection)((PsiElement)argumentElement), typeParameter));
            } else if (this.type != null) {
                this.trace.report(Errors.CONFLICTING_PROJECTION_IN_TYPEALIAS_EXPANSION.on((KtElement)((PsiElement)this.type), this.typeAliasDescriptor.getUnderlyingType()));
            }
        }

        @Override
        public void recursiveTypeAlias(@NotNull TypeAliasDescriptor typeAlias) {
            Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
            if (this.type != null) {
                this.trace.report(Errors.RECURSIVE_TYPEALIAS_EXPANSION.on((KtElement)((PsiElement)this.type), typeAlias));
            }
        }

        @Override
        public void boundsViolationInSubstitution(@NotNull TypeSubstitutor substitutor2, @NotNull KotlinType unsubstitutedArgument, @NotNull KotlinType argument2, @NotNull TypeParameterDescriptor typeParameter) {
            KtTypeProjection argumentElement;
            Intrinsics.checkNotNullParameter((Object)substitutor2, (String)"substitutor");
            Intrinsics.checkNotNullParameter((Object)unsubstitutedArgument, (String)"unsubstitutedArgument");
            Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
            Intrinsics.checkNotNullParameter((Object)typeParameter, (String)"typeParameter");
            ClassifierDescriptor descriptorForUnsubstitutedArgument = unsubstitutedArgument.getConstructor().getDeclarationDescriptor();
            KtTypeProjection ktTypeProjection = argumentElement = this.mappedArguments.get(descriptorForUnsubstitutedArgument);
            KtTypeReference argumentTypeReferenceElement = ktTypeProjection != null ? ktTypeProjection.getTypeReference() : null;
            UpperBoundChecker.checkBounds$default(this.upperBoundChecker, argumentTypeReferenceElement, argument2, typeParameter, substitutor2, this.trace, this.type, null, 64, null);
        }

        @Override
        public void repeatedAnnotation(@NotNull AnnotationDescriptor annotation2) {
            Intrinsics.checkNotNullParameter((Object)annotation2, (String)"annotation");
            SourceElement sourceElement = annotation2.getSource();
            KotlinSourceElement kotlinSourceElement = sourceElement instanceof KotlinSourceElement ? (KotlinSourceElement)sourceElement : null;
            KtElement ktElement = kotlinSourceElement != null ? kotlinSourceElement.getPsi() : null;
            KtAnnotationEntry ktAnnotationEntry = ktElement instanceof KtAnnotationEntry ? (KtAnnotationEntry)ktElement : null;
            if (ktAnnotationEntry == null) {
                return;
            }
            KtAnnotationEntry annotationEntry2 = ktAnnotationEntry;
            this.trace.report(Errors.REPEATED_ANNOTATION.on((KtAnnotationEntry)((PsiElement)annotationEntry2)));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lksp/org/jetbrains/kotlin/resolve/TypeResolver$TypeTransformerForTests;", "", "()V", "transformType", "Lksp/org/jetbrains/kotlin/types/KotlinType;", "kotlinType", "frontend"})
    public static class TypeTransformerForTests {
        @Nullable
        public KotlinType transformType(@NotNull KotlinType kotlinType) {
            Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"kotlinType");
            return null;
        }
    }
}

