/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.psi.stubs.elements;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.stubs.IStubElementType;
import ksp.com.intellij.psi.stubs.IndexSink;
import ksp.com.intellij.psi.stubs.StubElement;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.com.intellij.psi.tree.IStubFileElementType;
import ksp.com.intellij.util.ArrayFactory;
import ksp.com.intellij.util.ReflectionUtil;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.idea.KotlinLanguage;
import ksp.org.jetbrains.kotlin.psi.KtClassOrObject;
import ksp.org.jetbrains.kotlin.psi.KtElementImplStub;
import ksp.org.jetbrains.kotlin.psi.KtFunction;
import ksp.org.jetbrains.kotlin.psi.KtProperty;

public abstract class KtStubElementType<StubT extends StubElement<?>, PsiT extends KtElementImplStub<?>>
extends IStubElementType<StubT, PsiT> {
    @NotNull
    private final Constructor<PsiT> byNodeConstructor;
    @NotNull
    private final Constructor<PsiT> byStubConstructor;
    @NotNull
    private final PsiT[] emptyArray;
    @NotNull
    private final ArrayFactory<PsiT> arrayFactory;

    public KtStubElementType(@NotNull @NonNls String debugName, @NotNull Class<PsiT> psiClass, @NotNull Class<?> stubClass) {
        if (debugName == null) {
            KtStubElementType.$$$reportNull$$$0(0);
        }
        if (psiClass == null) {
            KtStubElementType.$$$reportNull$$$0(1);
        }
        if (stubClass == null) {
            KtStubElementType.$$$reportNull$$$0(2);
        }
        super(debugName, KotlinLanguage.INSTANCE);
        try {
            this.byNodeConstructor = psiClass.getConstructor(ASTNode.class);
            this.byStubConstructor = psiClass.getConstructor(stubClass);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Stub element type declaration for " + psiClass.getSimpleName() + " is missing required constructors", e);
        }
        this.emptyArray = (KtElementImplStub[])Array.newInstance(psiClass, 0);
        this.arrayFactory = count -> {
            if (count == 0) {
                return this.emptyArray;
            }
            return (KtElementImplStub[])Array.newInstance(psiClass, count);
        };
    }

    @NotNull
    public PsiT createPsiFromAst(@NotNull ASTNode node) {
        if (node == null) {
            KtStubElementType.$$$reportNull$$$0(3);
        }
        KtElementImplStub ktElementImplStub = (KtElementImplStub)ReflectionUtil.createInstance(this.byNodeConstructor, node);
        if (ktElementImplStub == null) {
            KtStubElementType.$$$reportNull$$$0(4);
        }
        return (PsiT)ktElementImplStub;
    }

    @Override
    @NotNull
    public PsiT createPsi(@NotNull StubT stub) {
        if (stub == null) {
            KtStubElementType.$$$reportNull$$$0(5);
        }
        KtElementImplStub ktElementImplStub = (KtElementImplStub)ReflectionUtil.createInstance(this.byStubConstructor, stub);
        if (ktElementImplStub == null) {
            KtStubElementType.$$$reportNull$$$0(6);
        }
        return (PsiT)ktElementImplStub;
    }

    @Override
    @NotNull
    public String getExternalId() {
        String string2 = "kotlin." + this.getDebugName();
        if (string2 == null) {
            KtStubElementType.$$$reportNull$$$0(7);
        }
        return string2;
    }

    @Override
    public boolean shouldCreateStub(ASTNode node) {
        PsiElement psi2 = node.getPsi();
        if (psi2 instanceof KtClassOrObject || psi2 instanceof KtFunction) {
            return true;
        }
        if (psi2 instanceof KtProperty) {
            return !((KtProperty)psi2).isLocal();
        }
        return KtStubElementType.createStubDependingOnParent(node);
    }

    private static boolean createStubDependingOnParent(ASTNode node) {
        ASTNode parent2 = node.getTreeParent();
        IElementType parentType = parent2.getElementType();
        if (parentType instanceof IStubElementType) {
            return ((IStubElementType)parentType).shouldCreateStub(parent2);
        }
        return parentType instanceof IStubFileElementType;
    }

    @Override
    public void indexStub(@NotNull StubT stub, @NotNull IndexSink sink) {
        if (stub == null) {
            KtStubElementType.$$$reportNull$$$0(8);
        }
        if (sink == null) {
            KtStubElementType.$$$reportNull$$$0(9);
        }
    }

    @NotNull
    public ArrayFactory<PsiT> getArrayFactory() {
        ArrayFactory<PsiT> arrayFactory = this.arrayFactory;
        if (arrayFactory == null) {
            KtStubElementType.$$$reportNull$$$0(10);
        }
        return arrayFactory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/org/jetbrains/kotlin/psi/stubs/elements/KtStubElementType";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/org/jetbrains/kotlin/psi/stubs/elements/KtStubElementType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createPsiFromAst";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createPsi";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalId";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createPsiFromAst";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createPsi";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "indexStub";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

