/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.load.kotlin;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.load.kotlin.DeserializedDescriptorResolver;
import ksp.org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import ksp.org.jetbrains.kotlin.load.kotlin.KotlinClassFinderKt;
import ksp.org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.serialization.deserialization.ClassData;
import ksp.org.jetbrains.kotlin.serialization.deserialization.ClassDataFinder;
import ksp.org.jetbrains.kotlin.utils.DeserializationHelpersKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lksp/org/jetbrains/kotlin/load/kotlin/JavaClassDataFinder;", "Lksp/org/jetbrains/kotlin/serialization/deserialization/ClassDataFinder;", "kotlinClassFinder", "Lksp/org/jetbrains/kotlin/load/kotlin/KotlinClassFinder;", "deserializedDescriptorResolver", "Lksp/org/jetbrains/kotlin/load/kotlin/DeserializedDescriptorResolver;", "(Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder;Lorg/jetbrains/kotlin/load/kotlin/DeserializedDescriptorResolver;)V", "getKotlinClassFinder$descriptors_jvm", "()Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder;", "findClassData", "Lksp/org/jetbrains/kotlin/serialization/deserialization/ClassData;", "classId", "Lksp/org/jetbrains/kotlin/name/ClassId;", "descriptors.jvm"})
public final class JavaClassDataFinder
implements ClassDataFinder {
    @NotNull
    private final KotlinClassFinder kotlinClassFinder;
    @NotNull
    private final DeserializedDescriptorResolver deserializedDescriptorResolver;

    public JavaClassDataFinder(@NotNull KotlinClassFinder kotlinClassFinder, @NotNull DeserializedDescriptorResolver deserializedDescriptorResolver) {
        Intrinsics.checkNotNullParameter((Object)kotlinClassFinder, (String)"kotlinClassFinder");
        Intrinsics.checkNotNullParameter((Object)deserializedDescriptorResolver, (String)"deserializedDescriptorResolver");
        this.kotlinClassFinder = kotlinClassFinder;
        this.deserializedDescriptorResolver = deserializedDescriptorResolver;
    }

    @NotNull
    public final KotlinClassFinder getKotlinClassFinder$descriptors_jvm() {
        return this.kotlinClassFinder;
    }

    @Override
    @Nullable
    public ClassData findClassData(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        KotlinJvmBinaryClass kotlinJvmBinaryClass2 = KotlinClassFinderKt.findKotlinClass(this.kotlinClassFinder, classId, DeserializationHelpersKt.jvmMetadataVersionOrDefault(this.deserializedDescriptorResolver.getComponents().getConfiguration()));
        if (kotlinJvmBinaryClass2 == null) {
            return null;
        }
        KotlinJvmBinaryClass kotlinClass = kotlinJvmBinaryClass2;
        boolean bl = Intrinsics.areEqual((Object)kotlinClass.getClassId(), (Object)classId);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string2 = "Class with incorrect id found: expected " + classId + ", actual " + kotlinClass.getClassId();
            throw new AssertionError((Object)string2);
        }
        return this.deserializedDescriptorResolver.readClassData$descriptors_jvm(kotlinClass);
    }
}

