/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.js.translate.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.impl.source.tree.LeafPsiElement;
import ksp.com.intellij.util.SmartList;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.backend.common.CommonCoroutineCodegenUtilKt;
import ksp.org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import ksp.org.jetbrains.kotlin.builtins.StandardNames;
import ksp.org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import ksp.org.jetbrains.kotlin.config.CompilerConfiguration;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.SourceElement;
import ksp.org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import ksp.org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsExpression;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsFunction;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsName;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsParameter;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsScope;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsStatement;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsVars;
import ksp.org.jetbrains.kotlin.js.backend.ast.metadata.CoroutineMetadata;
import ksp.org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import ksp.org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import ksp.org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import ksp.org.jetbrains.kotlin.js.translate.context.Namer;
import ksp.org.jetbrains.kotlin.js.translate.context.TranslationContext;
import ksp.org.jetbrains.kotlin.js.translate.context.UsageTracker;
import ksp.org.jetbrains.kotlin.js.translate.expression.ExpressionVisitor;
import ksp.org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import ksp.org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsicWithReceiverComputed;
import ksp.org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.TypeOfFIFKt;
import ksp.org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import ksp.org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import ksp.org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import ksp.org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import ksp.org.jetbrains.kotlin.psi.Call;
import ksp.org.jetbrains.kotlin.psi.KtBlockExpression;
import ksp.org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import ksp.org.jetbrains.kotlin.psi.KtElement;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtFunctionLiteral;
import ksp.org.jetbrains.kotlin.psi.KtLambdaExpression;
import ksp.org.jetbrains.kotlin.psi.KtPsiFactory;
import ksp.org.jetbrains.kotlin.psi.KtTypeArgumentList;
import ksp.org.jetbrains.kotlin.psi.KtTypeProjection;
import ksp.org.jetbrains.kotlin.psi.KtValueArgumentList;
import ksp.org.jetbrains.kotlin.psi.LambdaArgument;
import ksp.org.jetbrains.kotlin.psi.ValueArgument;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.DescriptorUtils;
import ksp.org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ArgumentUnmapped;
import ksp.org.jetbrains.kotlin.resolve.calls.model.DataFlowInfoForArguments;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import ksp.org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;
import ksp.org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import ksp.org.jetbrains.kotlin.resolve.checkers.PrimitiveNumericComparisonInfo;
import ksp.org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import ksp.org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import ksp.org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.TypeUtils;
import ksp.org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0098\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b\u001a&\u0010\n\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f\u001a@\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001\u001a\u0018\u0010\u001c\u001a\u00020\u000f2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0016\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0016\u0010!\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010%\u001a\u00020$2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\"\u0010&\u001a\u00020'*\u00020\u00182\u0006\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020+\u001a\u001a\u0010,\u001a\u00020\b*\u00020\u00182\u0006\u0010-\u001a\u00020\u00142\u0006\u0010.\u001a\u00020\u000f\u001a\u001a\u0010,\u001a\u00020\b*\u00020\u00182\u0006\u0010\t\u001a\u00020\b2\u0006\u0010.\u001a\u00020\u000f\u001a\"\u0010/\u001a\u00020\u0006*\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010-\u001a\u00020\u00142\u0006\u00100\u001a\u00020\u000f\u001a\u0016\u00101\u001a\u00020\u000f*\u00020\u00182\n\u00102\u001a\u0006\u0012\u0002\b\u00030#\u001a\"\u00103\u001a\u00020'*\u0002042\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010-\u001a\u00020\u00142\u0006\u00105\u001a\u00020\u001a\u001a\u0014\u00106\u001a\u0004\u0018\u00010 *\u00020\u00182\u0006\u0010.\u001a\u000207\u001a\u0012\u00108\u001a\u00020 *\u00020\u00182\u0006\u0010.\u001a\u000207\u001a\u0014\u00109\u001a\u0004\u0018\u00010:*\u00020\u00182\u0006\u0010.\u001a\u000207\u001a\n\u0010;\u001a\u00020\u001a*\u00020\u0014\u001a\n\u0010<\u001a\u00020\u001a*\u00020\u0014\u001a\n\u0010=\u001a\u00020 *\u00020 \u001aH\u0010>\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H@0\u0005\u0012\u0004\u0012\u0002HA0?0\u0005\"\u0004\b\u0000\u0010@\"\u0004\b\u0001\u0010A*\b\u0012\u0004\u0012\u0002H@0\u00052\u0012\u0010B\u001a\u000e\u0012\u0004\u0012\u0002H@\u0012\u0004\u0012\u0002HA0C\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006D"}, d2={"finalElement", "Lksp/com/intellij/psi/PsiElement;", "getFinalElement", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;", "createPrototypeStatements", "", "Lksp/org/jetbrains/kotlin/js/backend/ast/JsStatement;", "superName", "Lksp/org/jetbrains/kotlin/js/backend/ast/JsName;", "name", "definePackageAlias", "", "varName", "tag", "parentRef", "Lksp/org/jetbrains/kotlin/js/backend/ast/JsExpression;", "generateDelegateCall", "classDescriptor", "Lksp/org/jetbrains/kotlin/descriptors/ClassDescriptor;", "fromDescriptor", "Lksp/org/jetbrains/kotlin/descriptors/FunctionDescriptor;", "toDescriptor", "thisObject", "context", "Lksp/org/jetbrains/kotlin/js/translate/context/TranslationContext;", "detectDefaultParameters", "", "source", "getReferenceToJsClass", "classifierDescriptor", "Lksp/org/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "type", "Lksp/org/jetbrains/kotlin/types/KotlinType;", "getReferenceToJsClassOrArray", "resolveAccessorCall", "Lksp/org/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lksp/org/jetbrains/kotlin/descriptors/PropertyDescriptor;", "suspendPropertyDescriptor", "addAccessorsToPrototype", "", "containingClass", "propertyDescriptor", "literal", "Lksp/org/jetbrains/kotlin/js/backend/ast/JsObjectLiteral;", "addFunctionButNotExport", "descriptor", "expression", "addFunctionToPrototype", "function", "createCoroutineResult", "resolvedCall", "fillCoroutineMetadata", "Lksp/org/jetbrains/kotlin/js/backend/ast/JsFunction;", "hasController", "getPrecisePrimitiveType", "Lksp/org/jetbrains/kotlin/psi/KtExpression;", "getPrecisePrimitiveTypeNotNull", "getPrimitiveNumericComparisonInfo", "Lksp/org/jetbrains/kotlin/resolve/checkers/PrimitiveNumericComparisonInfo;", "hasOrInheritsParametersWithDefaultValue", "hasOwnParametersWithDefaultValue", "refineType", "splitToRanges", "Lkotlin/Pair;", "T", "S", "classifier", "Lkotlin/Function1;", "js.translator"})
@SourceDebugExtension(value={"SMAP\nutils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 utils.kt\norg/jetbrains/kotlin/js/translate/utils/UtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,344:1\n1557#2:345\n1628#2,3:346\n1755#2,3:350\n1557#2:353\n1628#2,3:354\n1#3:349\n*S KotlinDebug\n*F\n+ 1 utils.kt\norg/jetbrains/kotlin/js/translate/utils/UtilsKt\n*L\n136#1:345\n136#1:346,3\n344#1:350,3\n339#1:353\n339#1:354,3\n*E\n"})
public final class UtilsKt {
    @NotNull
    public static final JsStatement generateDelegateCall(@NotNull ClassDescriptor classDescriptor2, @NotNull FunctionDescriptor fromDescriptor, @NotNull FunctionDescriptor toDescriptor2, @NotNull JsExpression thisObject, @NotNull TranslationContext context2, boolean detectDefaultParameters, @Nullable PsiElement source) {
        PsiElement jsParamName;
        List list2;
        Intrinsics.checkNotNullParameter((Object)classDescriptor2, (String)"classDescriptor");
        Intrinsics.checkNotNullParameter((Object)fromDescriptor, (String)"fromDescriptor");
        Intrinsics.checkNotNullParameter((Object)toDescriptor2, (String)"toDescriptor");
        Intrinsics.checkNotNullParameter((Object)thisObject, (String)"thisObject");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        JsName overriddenMemberFunctionName = UtilsKt.generateDelegateCall$getNameForFunctionWithPossibleDefaultParam(toDescriptor2, detectDefaultParameters, context2);
        JsNameRef overriddenMemberFunctionRef = new JsNameRef(overriddenMemberFunctionName, thisObject);
        SmartList<JsParameter> parameters2 = new SmartList<JsParameter>();
        SmartList<JsNameRef> args = new SmartList<JsNameRef>();
        if (DescriptorUtils.isExtension(fromDescriptor)) {
            JsName jsName = JsScope.declareTemporaryName(Namer.getReceiverParameterName());
            Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"declareTemporaryName(...)");
            JsName extensionFunctionReceiverName = jsName;
            parameters2.add(new JsParameter(extensionFunctionReceiverName));
            args.add(new JsNameRef(extensionFunctionReceiverName));
        }
        if (fromDescriptor.isSuspend()) {
            List<ValueParameterDescriptor> list3 = fromDescriptor.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"getValueParameters(...)");
            Collection collection = list3;
            ValueParameterDescriptor valueParameterDescriptor = context2.getContinuationParameterDescriptor();
            Intrinsics.checkNotNull((Object)valueParameterDescriptor);
            list2 = CollectionsKt.plus((Collection)collection, (Object)valueParameterDescriptor);
        } else {
            List list4 = fromDescriptor.getValueParameters();
            list2 = list4;
            Intrinsics.checkNotNullExpressionValue(list4, (String)"getValueParameters(...)");
        }
        List valueParameterDescriptors = list2;
        for (ValueParameterDescriptor param : valueParameterDescriptors) {
            String paramName;
            Intrinsics.checkNotNullExpressionValue((Object)param.getName().asString(), (String)"asString(...)");
            Intrinsics.checkNotNullExpressionValue((Object)JsScope.declareTemporaryName(paramName), (String)"declareTemporaryName(...)");
            parameters2.add(new JsParameter((JsName)((Object)jsParamName)));
            args.add(new JsNameRef((JsName)((Object)jsParamName)));
        }
        FunctionIntrinsic intrinsic = context2.intrinsics().getFunctionIntrinsic(toDescriptor2, context2);
        JsExpression invocation = intrinsic instanceof FunctionIntrinsicWithReceiverComputed ? ((FunctionIntrinsicWithReceiverComputed)intrinsic).apply(thisObject, (List<? extends JsExpression>)args, context2) : (JsExpression)new JsInvocation((JsExpression)overriddenMemberFunctionRef, (List<? extends JsExpression>)args);
        invocation.setSource(source);
        JsFunction jsFunction = TranslationUtils.simpleReturnFunction(context2.scope(), invocation);
        Intrinsics.checkNotNullExpressionValue((Object)jsFunction, (String)"simpleReturnFunction(...)");
        JsFunction functionObject = jsFunction;
        functionObject.setSource(source);
        PsiElement psiElement = source;
        jsParamName = psiElement != null ? UtilsKt.getFinalElement(psiElement) : null;
        functionObject.getBody().setSource(jsParamName instanceof LeafPsiElement ? (LeafPsiElement)jsParamName : null);
        functionObject.getParameters().addAll((Collection<JsParameter>)parameters2);
        if (MetadataProperties.isSuspend(functionObject)) {
            UtilsKt.fillCoroutineMetadata(functionObject, context2, fromDescriptor, false);
        }
        JsName fromFunctionName = UtilsKt.generateDelegateCall$getNameForFunctionWithPossibleDefaultParam(fromDescriptor, detectDefaultParameters, context2);
        JsExpression jsExpression = JsAstUtils.prototypeOf(context2.getInnerReference(classDescriptor2));
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"prototypeOf(...)");
        JsExpression prototypeRef = jsExpression;
        JsNameRef functionRef = new JsNameRef(fromFunctionName, prototypeRef);
        JsStatement jsStatement = JsAstUtils.assignment(functionRef, functionObject).makeStmt();
        Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"makeStmt(...)");
        return jsStatement;
    }

    @NotNull
    public static final <T, S> List<Pair<List<T>, S>> splitToRanges(@NotNull List<? extends T> $this$splitToRanges, @NotNull Function1<? super T, ? extends S> classifier) {
        Intrinsics.checkNotNullParameter($this$splitToRanges, (String)"<this>");
        Intrinsics.checkNotNullParameter(classifier, (String)"classifier");
        if ($this$splitToRanges.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        int lastIndex = 0;
        Object lastClass = classifier.invoke($this$splitToRanges.get(0));
        List result2 = new ArrayList();
        for (IndexedValue indexedValue : SequencesKt.drop((Sequence)SequencesKt.withIndex((Sequence)CollectionsKt.asSequence((Iterable)$this$splitToRanges)), (int)1)) {
            int index2 = indexedValue.component1();
            Object e = indexedValue.component2();
            Object cls = classifier.invoke(e);
            if (Intrinsics.areEqual((Object)cls, (Object)lastClass)) continue;
            ((Collection)result2).add(new Pair($this$splitToRanges.subList(lastIndex, index2), lastClass));
            lastClass = cls;
            lastIndex = index2;
        }
        ((Collection)result2).add(new Pair($this$splitToRanges.subList(lastIndex, $this$splitToRanges.size()), lastClass));
        return result2;
    }

    @NotNull
    public static final JsExpression getReferenceToJsClass(@NotNull KotlinType type2, @NotNull TranslationContext context2) {
        JsExpression jsExpression;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        JsExpression it = jsExpression = UtilsKt.getReferenceToJsClassOrArray(type2, context2);
        boolean bl = false;
        MetadataProperties.setKType(it, TypeOfFIFKt.createKType(context2, type2));
        return jsExpression;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JsExpression getReferenceToJsClassOrArray(@NotNull KotlinType type2, @NotNull TranslationContext context2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            void $this$mapTo$iv$iv;
            Collection<KotlinType> collection = type2.getConstructor().getSupertypes();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getSupertypes(...)");
            Iterable $this$map$iv = collection;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KotlinType kotlinType = (KotlinType)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(UtilsKt.getReferenceToJsClass(it.getConstructor().getDeclarationDescriptor(), context2));
            }
            List list2 = (List)destination$iv$iv;
            return new JsArrayLiteral(list2);
        }
        ClassifierDescriptor classifierDescriptor2 = classifierDescriptor;
        return UtilsKt.getReferenceToJsClass(classifierDescriptor2, context2);
    }

    @NotNull
    public static final JsExpression getReferenceToJsClass(@Nullable ClassifierDescriptor classifierDescriptor, @NotNull TranslationContext context2) {
        JsExpression jsExpression;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ClassifierDescriptor classifierDescriptor2 = classifierDescriptor;
        if (classifierDescriptor2 instanceof ClassDescriptor) {
            jsExpression = ReferenceTranslator.translateAsTypeReference((ClassDescriptor)classifierDescriptor, context2);
        } else if (classifierDescriptor2 instanceof TypeParameterDescriptor) {
            boolean bl = ((TypeParameterDescriptor)classifierDescriptor).isReified();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            UsageTracker usageTracker = context2.usageTracker();
            if (usageTracker != null) {
                usageTracker.used(classifierDescriptor);
            }
            if ((jsExpression = context2.captureTypeIfNeedAndGetCapturedName((TypeParameterDescriptor)classifierDescriptor)) == null) {
                jsExpression = context2.getNameForDescriptor(classifierDescriptor).makeRef();
            }
        } else {
            throw new IllegalStateException("Can't get reference for " + classifierDescriptor);
        }
        JsExpression jsExpression2 = jsExpression;
        Intrinsics.checkNotNull((Object)jsExpression2);
        JsExpression it = jsExpression2;
        boolean bl = false;
        MetadataProperties.setPrimitiveKClass(it, ExpressionVisitor.getPrimitiveClass(context2, classifierDescriptor));
        return jsExpression2;
    }

    @NotNull
    public static final JsStatement addFunctionToPrototype(@NotNull TranslationContext $this$addFunctionToPrototype, @NotNull ClassDescriptor classDescriptor2, @NotNull FunctionDescriptor descriptor2, @NotNull JsExpression function2) {
        Intrinsics.checkNotNullParameter((Object)$this$addFunctionToPrototype, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)classDescriptor2, (String)"classDescriptor");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        JsExpression jsExpression = JsAstUtils.prototypeOf($this$addFunctionToPrototype.getInnerReference(classDescriptor2));
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"prototypeOf(...)");
        JsExpression prototypeRef = jsExpression;
        JsNameRef functionRef = new JsNameRef($this$addFunctionToPrototype.getNameForDescriptor(descriptor2), prototypeRef);
        JsStatement jsStatement = JsAstUtils.assignment(functionRef, function2).makeStmt();
        Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"makeStmt(...)");
        return jsStatement;
    }

    public static final void addAccessorsToPrototype(@NotNull TranslationContext $this$addAccessorsToPrototype, @NotNull ClassDescriptor containingClass, @NotNull PropertyDescriptor propertyDescriptor, @NotNull JsObjectLiteral literal) {
        Intrinsics.checkNotNullParameter((Object)$this$addAccessorsToPrototype, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)containingClass, (String)"containingClass");
        Intrinsics.checkNotNullParameter((Object)propertyDescriptor, (String)"propertyDescriptor");
        Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
        JsExpression jsExpression = JsAstUtils.prototypeOf($this$addAccessorsToPrototype.getInnerReference(containingClass));
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"prototypeOf(...)");
        JsExpression prototypeRef = jsExpression;
        JsName jsName = $this$addAccessorsToPrototype.getNameForDescriptor(propertyDescriptor);
        Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"getNameForDescriptor(...)");
        JsName propertyName = jsName;
        JsInvocation jsInvocation = JsAstUtils.defineProperty(prototypeRef, propertyName.getIdent(), literal);
        Intrinsics.checkNotNullExpressionValue((Object)jsInvocation, (String)"defineProperty(...)");
        JsInvocation defineProperty = jsInvocation;
        $this$addAccessorsToPrototype.addDeclarationStatement(defineProperty.makeStmt());
    }

    public static final void fillCoroutineMetadata(@NotNull JsFunction $this$fillCoroutineMetadata, @NotNull TranslationContext context2, @NotNull FunctionDescriptor descriptor2, boolean hasController) {
        Intrinsics.checkNotNullParameter((Object)$this$fillCoroutineMetadata, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PropertyDescriptor suspendPropertyDescriptor = (PropertyDescriptor)CollectionsKt.first((Iterable)context2.getCurrentModule().getPackage(StandardNames.COROUTINES_INTRINSICS_PACKAGE_FQ_NAME).getMemberScope().getContributedVariables(CommonCoroutineCodegenUtilKt.getCOROUTINE_SUSPENDED_NAME(), NoLookupLocation.FROM_BACKEND));
        JsExpression suspendObject = CallTranslator.INSTANCE.translateGet(context2, UtilsKt.resolveAccessorCall(suspendPropertyDescriptor, context2), null);
        JsName jsName = context2.getNameForDescriptor(TranslationUtils.getCoroutineDoResumeFunction(context2));
        JsExpression jsExpression = ReferenceTranslator.translateAsTypeReference(TranslationUtils.getCoroutineBaseClass(context2), context2);
        JsName jsName2 = UtilsKt.fillCoroutineMetadata$getCoroutinePropertyName(context2, "state");
        JsName jsName3 = UtilsKt.fillCoroutineMetadata$getCoroutinePropertyName(context2, "exceptionState");
        JsName jsName4 = UtilsKt.fillCoroutineMetadata$getCoroutinePropertyName(context2, "finallyPath");
        JsName jsName5 = UtilsKt.fillCoroutineMetadata$getCoroutinePropertyName(context2, "result");
        JsName jsName6 = UtilsKt.fillCoroutineMetadata$getCoroutinePropertyName(context2, "exception");
        boolean bl = descriptor2.getDispatchReceiverParameter() != null;
        SourceElement sourceElement = descriptor2.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"getSource(...)");
        PsiElement psiElement = PsiSourceElementKt.getPsi(sourceElement);
        Intrinsics.checkNotNull((Object)jsName);
        Intrinsics.checkNotNull((Object)jsExpression);
        MetadataProperties.setCoroutineMetadata($this$fillCoroutineMetadata, new CoroutineMetadata(jsName, jsName2, jsName3, jsName4, jsName5, jsName6, jsExpression, suspendObject, hasController, bl, psiElement));
    }

    private static final ResolvedCall<PropertyDescriptor> resolveAccessorCall(PropertyDescriptor suspendPropertyDescriptor, TranslationContext context2) {
        return new ResolvedCall<PropertyDescriptor>(context2, suspendPropertyDescriptor){
            final /* synthetic */ TranslationContext $context;
            final /* synthetic */ PropertyDescriptor $suspendPropertyDescriptor;
            {
                this.$context = $context;
                this.$suspendPropertyDescriptor = $suspendPropertyDescriptor;
            }

            public ResolutionStatus getStatus() {
                return ResolutionStatus.SUCCESS;
            }

            public Call getCall() {
                return new Call(this.$context){
                    final /* synthetic */ TranslationContext $context;
                    {
                        this.$context = $context;
                    }

                    public ASTNode getCallOperationNode() {
                        return null;
                    }

                    public Receiver getExplicitReceiver() {
                        return null;
                    }

                    public ReceiverValue getDispatchReceiver() {
                        return null;
                    }

                    public KtExpression getCalleeExpression() {
                        return null;
                    }

                    public KtValueArgumentList getValueArgumentList() {
                        return null;
                    }

                    public List<ValueArgument> getValueArguments() {
                        return CollectionsKt.emptyList();
                    }

                    public List<LambdaArgument> getFunctionLiteralArguments() {
                        return CollectionsKt.emptyList();
                    }

                    public List<KtTypeProjection> getTypeArguments() {
                        return CollectionsKt.emptyList();
                    }

                    public KtTypeArgumentList getTypeArgumentList() {
                        return null;
                    }

                    public KtElement getCallElement() {
                        Project project = this.$context.getConfig().getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                        return new KtPsiFactory(project, false, 2, null).createExpression("COROUTINE_SUSPENDED");
                    }

                    public Call.CallType getCallType() {
                        return Call.CallType.DEFAULT;
                    }
                };
            }

            public PropertyDescriptor getCandidateDescriptor() {
                return this.$suspendPropertyDescriptor;
            }

            public PropertyDescriptor getResultingDescriptor() {
                return this.$suspendPropertyDescriptor;
            }

            public Void getExtensionReceiver() {
                return null;
            }

            public Void getDispatchReceiver() {
                return null;
            }

            public List<ReceiverValue> getContextReceivers() {
                return CollectionsKt.emptyList();
            }

            public ExplicitReceiverKind getExplicitReceiverKind() {
                return ExplicitReceiverKind.NO_EXPLICIT_RECEIVER;
            }

            public Map<ValueParameterDescriptor, ResolvedValueArgument> getValueArguments() {
                return new LinkedHashMap<K, V>();
            }

            public List<ResolvedValueArgument> getValueArgumentsByIndex() {
                return new ArrayList<E>();
            }

            public ArgumentUnmapped getArgumentMapping(ValueArgument valueArgument) {
                Intrinsics.checkNotNullParameter((Object)valueArgument, (String)"valueArgument");
                return ArgumentUnmapped.INSTANCE;
            }

            public Map<TypeParameterDescriptor, KotlinType> getTypeArguments() {
                return new LinkedHashMap<K, V>();
            }

            public DataFlowInfoForArguments getDataFlowInfoForArguments() {
                throw new IllegalStateException();
            }

            public KotlinType getSmartCastDispatchReceiverType() {
                return null;
            }
        };
    }

    @NotNull
    public static final JsStatement definePackageAlias(@NotNull String name2, @NotNull JsName varName, @NotNull String tag, @NotNull JsExpression parentRef) {
        JsVars jsVars;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)varName, (String)"varName");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)parentRef, (String)"parentRef");
        JsNameRef selfRef = new JsNameRef(name2, parentRef);
        JsBinaryOperation jsBinaryOperation = JsAstUtils.or(selfRef, JsAstUtils.assignment(selfRef.deepCopy(), new JsObjectLiteral(false)));
        Intrinsics.checkNotNullExpressionValue((Object)jsBinaryOperation, (String)"or(...)");
        JsBinaryOperation rhs = jsBinaryOperation;
        JsVars $this$definePackageAlias_u24lambda_u243 = jsVars = JsAstUtils.newVar(varName, rhs);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$definePackageAlias_u24lambda_u243);
        MetadataProperties.setExportedPackage($this$definePackageAlias_u24lambda_u243, tag);
        JsVars jsVars2 = jsVars;
        Intrinsics.checkNotNullExpressionValue((Object)jsVars2, (String)"apply(...)");
        return jsVars2;
    }

    @NotNull
    public static final PsiElement getFinalElement(@NotNull PsiElement $this$finalElement) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)$this$finalElement, (String)"<this>");
        PsiElement psiElement2 = $this$finalElement;
        if (psiElement2 instanceof KtFunctionLiteral) {
            psiElement = ((KtFunctionLiteral)$this$finalElement).getRBrace();
            if (psiElement == null) {
                psiElement = $this$finalElement;
            }
        } else if (psiElement2 instanceof KtDeclarationWithBody) {
            psiElement = ((KtDeclarationWithBody)$this$finalElement).getBodyBlockExpression();
            if (psiElement == null || (psiElement = ((KtBlockExpression)psiElement).getRBrace()) == null) {
                KtExpression ktExpression = ((KtDeclarationWithBody)$this$finalElement).getBodyExpression();
                psiElement = ktExpression != null ? (PsiElement)ktExpression : $this$finalElement;
            }
        } else if (psiElement2 instanceof KtLambdaExpression) {
            psiElement = ((KtLambdaExpression)$this$finalElement).getBodyExpression();
            if (psiElement == null || (psiElement = ((KtBlockExpression)psiElement).getRBrace()) == null) {
                psiElement = $this$finalElement;
            }
        } else {
            psiElement = $this$finalElement;
        }
        return psiElement;
    }

    @NotNull
    public static final JsName addFunctionButNotExport(@NotNull TranslationContext $this$addFunctionButNotExport, @NotNull FunctionDescriptor descriptor2, @NotNull JsExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)$this$addFunctionButNotExport, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        JsName jsName = $this$addFunctionButNotExport.getInnerNameForDescriptor(descriptor2);
        Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"getInnerNameForDescriptor(...)");
        return UtilsKt.addFunctionButNotExport($this$addFunctionButNotExport, jsName, expression2);
    }

    @NotNull
    public static final JsName addFunctionButNotExport(@NotNull TranslationContext $this$addFunctionButNotExport, @NotNull JsName name2, @NotNull JsExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)$this$addFunctionButNotExport, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (expression2 instanceof JsFunction) {
            ((JsFunction)expression2).setName(name2);
            $this$addFunctionButNotExport.addDeclarationStatement(expression2.makeStmt());
        } else {
            $this$addFunctionButNotExport.addDeclarationStatement(JsAstUtils.newVar(name2, expression2));
        }
        return name2;
    }

    @NotNull
    public static final List<JsStatement> createPrototypeStatements(@NotNull JsName superName, @NotNull JsName name2) {
        Intrinsics.checkNotNullParameter((Object)superName, (String)"superName");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        JsNameRef jsNameRef = superName.makeRef();
        Intrinsics.checkNotNullExpressionValue((Object)jsNameRef, (String)"makeRef(...)");
        JsNameRef superclassRef = jsNameRef;
        JsExpression jsExpression = JsAstUtils.prototypeOf(superclassRef);
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"prototypeOf(...)");
        JsExpression superPrototype = jsExpression;
        JsExpression[] jsExpressionArray = new JsExpression[]{superPrototype};
        JsInvocation superPrototypeInstance = new JsInvocation((JsExpression)new JsNameRef("create", "Object"), jsExpressionArray);
        JsNameRef jsNameRef2 = name2.makeRef();
        Intrinsics.checkNotNullExpressionValue((Object)jsNameRef2, (String)"makeRef(...)");
        JsNameRef classRef = jsNameRef2;
        JsExpression jsExpression2 = JsAstUtils.prototypeOf(classRef);
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression2, (String)"prototypeOf(...)");
        JsExpression prototype = jsExpression2;
        JsStatement jsStatement = JsAstUtils.assignment(prototype, superPrototypeInstance).makeStmt();
        Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"makeStmt(...)");
        JsStatement prototypeStatement = jsStatement;
        JsNameRef constructorRef = new JsNameRef("constructor", prototype.deepCopy());
        JsStatement jsStatement2 = JsAstUtils.assignment(constructorRef, classRef.deepCopy()).makeStmt();
        Intrinsics.checkNotNullExpressionValue((Object)jsStatement2, (String)"makeStmt(...)");
        JsStatement constructorStatement = jsStatement2;
        Object[] objectArray = new JsStatement[]{prototypeStatement, constructorStatement};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public static final JsExpression createCoroutineResult(@NotNull TranslationContext $this$createCoroutineResult, @NotNull ResolvedCall<?> resolvedCall2) {
        JsNameRef jsNameRef;
        Intrinsics.checkNotNullParameter((Object)$this$createCoroutineResult, (String)"<this>");
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        KtElement ktElement = resolvedCall2.getCall().getCallElement();
        Intrinsics.checkNotNullExpressionValue((Object)ktElement, (String)"getCallElement(...)");
        KtElement callElement = ktElement;
        JsExpression coroutineRef = TranslationUtils.translateContinuationArgument($this$createCoroutineResult).source(callElement);
        JsNameRef $this$createCoroutineResult_u24lambda_u244 = jsNameRef = new JsNameRef("$$coroutineResult$$", coroutineRef);
        boolean bl = false;
        MetadataProperties.setSideEffects($this$createCoroutineResult_u24lambda_u244, SideEffectKind.DEPENDS_ON_STATE);
        $this$createCoroutineResult_u24lambda_u244.setSource(callElement);
        MetadataProperties.setCoroutineResult($this$createCoroutineResult_u24lambda_u244, true);
        MetadataProperties.setSynthetic($this$createCoroutineResult_u24lambda_u244, true);
        return jsNameRef;
    }

    @NotNull
    public static final KotlinType refineType(@NotNull KotlinType $this$refineType) {
        KotlinType kotlinType;
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter((Object)$this$refineType, (String)"<this>");
            Set<KotlinType> set = TypeUtils.getAllSupertypes($this$refineType);
            Intrinsics.checkNotNullExpressionValue(set, (String)"getAllSupertypes(...)");
            Iterable iterable = set;
            for (Object t : iterable) {
                KotlinType p0 = (KotlinType)t;
                boolean bl = false;
                if (!KotlinBuiltIns.isPrimitiveTypeOrNullablePrimitiveType(p0)) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        if ((kotlinType = (KotlinType)v1) == null) {
            kotlinType = $this$refineType;
        }
        return kotlinType;
    }

    @Nullable
    public static final KotlinType getPrecisePrimitiveType(@NotNull TranslationContext $this$getPrecisePrimitiveType, @NotNull KtExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)$this$getPrecisePrimitiveType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        BindingContext bindingContext = $this$getPrecisePrimitiveType.bindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"bindingContext(...)");
        BindingContext bindingContext2 = bindingContext;
        KotlinType kotlinType = bindingContext2.getType(expression2);
        if (kotlinType == null) {
            return null;
        }
        KotlinType ktType2 = kotlinType;
        return UtilsKt.refineType(ktType2);
    }

    @NotNull
    public static final KotlinType getPrecisePrimitiveTypeNotNull(@NotNull TranslationContext $this$getPrecisePrimitiveTypeNotNull, @NotNull KtExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)$this$getPrecisePrimitiveTypeNotNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        KotlinType kotlinType = UtilsKt.getPrecisePrimitiveType($this$getPrecisePrimitiveTypeNotNull, expression2);
        if (kotlinType == null) {
            throw new IllegalStateException("Type must be not null for " + expression2);
        }
        return kotlinType;
    }

    @Nullable
    public static final PrimitiveNumericComparisonInfo getPrimitiveNumericComparisonInfo(@NotNull TranslationContext $this$getPrimitiveNumericComparisonInfo, @NotNull KtExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)$this$getPrimitiveNumericComparisonInfo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        CompilerConfiguration compilerConfiguration = $this$getPrimitiveNumericComparisonInfo.getConfig().getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfiguration, (String)"getConfiguration(...)");
        LanguageVersionSettings it = CommonConfigurationKeysKt.getLanguageVersionSettings(compilerConfiguration);
        boolean bl = false;
        return it.supportsFeature(LanguageFeature.ProperIeee754Comparisons) ? (PrimitiveNumericComparisonInfo)$this$getPrimitiveNumericComparisonInfo.bindingContext().get(BindingContext.PRIMITIVE_NUMERIC_COMPARISON_INFO, expression2) : null;
    }

    public static final boolean hasOrInheritsParametersWithDefaultValue(@NotNull FunctionDescriptor $this$hasOrInheritsParametersWithDefaultValue) {
        Intrinsics.checkNotNullParameter((Object)$this$hasOrInheritsParametersWithDefaultValue, (String)"<this>");
        Boolean bl = DFS.ifAny(CollectionsKt.listOf((Object)$this$hasOrInheritsParametersWithDefaultValue), UtilsKt::hasOrInheritsParametersWithDefaultValue$lambda$7, hasOrInheritsParametersWithDefaultValue.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"ifAny(...)");
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean hasOwnParametersWithDefaultValue(@NotNull FunctionDescriptor $this$hasOwnParametersWithDefaultValue) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$hasOwnParametersWithDefaultValue, (String)"<this>");
        List<ValueParameterDescriptor> list2 = $this$hasOwnParametersWithDefaultValue.getOriginal().getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getValueParameters(...)");
        Iterable $this$any$iv = list2;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
            boolean bl2 = false;
            if (it.declaresDefaultValue()) return true;
            Intrinsics.checkNotNull((Object)it);
            if (ArgumentsUtilsKt.isActualParameterWithCorrespondingExpectedDefault(it)) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private static final JsName generateDelegateCall$getNameForFunctionWithPossibleDefaultParam(FunctionDescriptor $this$generateDelegateCall_u24getNameForFunctionWithPossibleDefaultParam, boolean $detectDefaultParameters, TranslationContext $context) {
        JsName jsName = $detectDefaultParameters && UtilsKt.hasOrInheritsParametersWithDefaultValue($this$generateDelegateCall_u24getNameForFunctionWithPossibleDefaultParam) ? $context.scope().declareName($context.getNameForDescriptor($this$generateDelegateCall_u24getNameForFunctionWithPossibleDefaultParam).getIdent() + "$default") : $context.getNameForDescriptor($this$generateDelegateCall_u24getNameForFunctionWithPossibleDefaultParam);
        Intrinsics.checkNotNull((Object)jsName);
        return jsName;
    }

    private static final JsName fillCoroutineMetadata$getCoroutinePropertyName(TranslationContext $context, String id) {
        JsName jsName = $context.getNameForDescriptor(TranslationUtils.getCoroutineProperty($context, id));
        Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"getNameForDescriptor(...)");
        return jsName;
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable hasOrInheritsParametersWithDefaultValue$lambda$7(FunctionDescriptor current) {
        void $this$mapTo$iv$iv;
        Collection<? extends FunctionDescriptor> collection = current.getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getOverriddenDescriptors(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FunctionDescriptor functionDescriptor = (FunctionDescriptor)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getOriginal());
        }
        return (List)destination$iv$iv;
    }
}

