/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.native.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.builtins.StandardNames;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.ClassMembersKt;
import ksp.org.jetbrains.kotlin.fir.FirElement;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.native.FirNativeErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirResolvable;
import ksp.org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import ksp.org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirWrappedArgumentExpression;
import ksp.org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.resolve.annotations.ThrowUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000  2\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0004 !\"#B\u000f\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J*\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u00022\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u0012\u001a\u00020\u00132\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J.\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00130\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c*\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u000e\u0010\u001e\u001a\u00020\u000f*\u0004\u0018\u00010\u001fH\u0002\u0082\u0001\u0002$%\u00a8\u0006&"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "mppKind", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/MppCheckerKind;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/MppCheckerKind;)V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkInheritance", "", "throwsAnnotation", "Lksp/org/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "decodeThrowsFilter", "Lksp/org/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker$ThrowsFilter;", "session", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "getInheritedThrows", "", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "function", "Lksp/org/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "getClassTypes", "", "Lksp/org/jetbrains/kotlin/fir/types/ConeKotlinType;", "hasUnresolvedArgument", "Lksp/org/jetbrains/kotlin/fir/FirElement;", "Companion", "ForExpectClass", "Regular", "ThrowsFilter", "Lksp/org/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker$ForExpectClass;", "Lksp/org/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker$Regular;", "checkers.native"})
@SourceDebugExtension(value={"SMAP\nFirNativeThrowsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNativeThrowsChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n+ 5 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,209:1\n2632#2,3:210\n1663#2,8:213\n1611#2,9:221\n1863#2:230\n1864#2:232\n1620#2:233\n808#2,11:238\n1557#2:249\n1628#2,2:250\n1630#2:253\n1#3:231\n23#4,4:234\n43#5:252\n*S KotlinDebug\n*F\n+ 1 FirNativeThrowsChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker\n*L\n81#1:210,3\n99#1:213,8\n105#1:221,9\n105#1:230\n105#1:232\n105#1:233\n202#1:238,11\n203#1:249\n203#1:250,2\n203#1:253\n105#1:231\n186#1:234,4\n203#1:252\n*E\n"})
public abstract class FirNativeThrowsChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ClassId throwsClassId = ClassId.Companion.topLevel(ThrowUtilKt.getKOTLIN_THROWS_ANNOTATION_FQ_NAME());
    @NotNull
    private static final FqName cancellationExceptionFqName = new FqName("kotlin.coroutines.cancellation.CancellationException");
    @NotNull
    private static final Set<ClassId> cancellationExceptionAndSupersClassIds;

    private FirNativeThrowsChecker(MppCheckerKind mppKind) {
        super(mppKind);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirAnnotationCall throwsAnnotation;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirAnnotation firAnnotation = FirAnnotationUtilsKt.getAnnotationByClassId(declaration2, throwsClassId, context2.getSession());
        FirAnnotationCall firAnnotationCall = throwsAnnotation = firAnnotation instanceof FirAnnotationCall ? (FirAnnotationCall)firAnnotation : null;
        if (!this.checkInheritance(declaration2, throwsAnnotation, context2, reporter)) {
            return;
        }
        if (this.hasUnresolvedArgument(throwsAnnotation)) {
            return;
        }
        Object object = throwsAnnotation;
        if (object == null || (object = this.getClassTypes((FirAnnotationCall)object, context2.getSession())) == null) {
            return;
        }
        Object classTypes = object;
        if (classTypes.isEmpty()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)throwsAnnotation.getSource(), FirNativeErrors.INSTANCE.getTHROWS_LIST_EMPTY(), (DiagnosticContext)context2, null, 8, null);
            return;
        }
        FirElement firElement = declaration2;
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.SUSPEND_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"SUSPEND_KEYWORD");
        if (FirKeywordUtilsKt.hasModifier(firElement, ktModifierKeywordToken)) {
            boolean bl;
            block9: {
                Iterable $this$none$iv = (Iterable)classTypes;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        ConeKotlinType it = (ConeKotlinType)element$iv;
                        boolean bl2 = false;
                        if (!CollectionsKt.contains((Iterable)cancellationExceptionAndSupersClassIds, (Object)ConeTypeUtilsKt.getClassId(it))) continue;
                        bl = false;
                        break block9;
                    }
                    bl = true;
                }
            }
            if (bl) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)throwsAnnotation.getSource(), FirNativeErrors.INSTANCE.getMISSING_EXCEPTION_IN_THROWS_ON_SUSPEND(), (Object)cancellationExceptionFqName, (DiagnosticContext)context2, null, 16, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkInheritance(FirDeclaration declaration2, FirAnnotationCall throwsAnnotation, CheckerContext context2, DiagnosticReporter reporter) {
        if (!(declaration2 instanceof FirSimpleFunction)) {
            return true;
        }
        Iterable $this$distinctBy$iv = this.getInheritedThrows((FirSimpleFunction)declaration2, throwsAnnotation, context2).entrySet();
        boolean $i$f$distinctBy = false;
        HashSet<ThrowsFilter> set$iv = new HashSet<ThrowsFilter>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            Map.Entry it = (Map.Entry)e$iv;
            boolean bl = false;
            ThrowsFilter key$iv = (ThrowsFilter)it.getValue();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List inherited = list$iv;
        if (inherited.size() >= 2) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            $this$distinctBy$iv = inherited;
            KtDiagnosticFactory1<Collection<FirRegularClassSymbol>> ktDiagnosticFactory1 = FirNativeErrors.INSTANCE.getINCOMPATIBLE_THROWS_INHERITED();
            AbstractKtSourceElement abstractKtSourceElement = declaration2.getSource();
            DiagnosticReporter diagnosticReporter = reporter;
            boolean $i$f$mapNotNull = false;
            set$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                FirRegularClassSymbol it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                Map.Entry it = (Map.Entry)element$iv$iv;
                boolean bl2 = false;
                ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag((FirCallableSymbol)it.getKey());
                if ((coneClassLikeLookupTag != null ? LookupTagUtilsKt.toFirRegularClassSymbol(coneClassLikeLookupTag, context2.getSession()) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            KtDiagnosticReportHelpersKt.reportOn$default(diagnosticReporter, abstractKtSourceElement, ktDiagnosticFactory1, (Object)list2, (DiagnosticContext)context2, null, 16, null);
            return false;
        }
        Map.Entry entry = (Map.Entry)CollectionsKt.firstOrNull((List)inherited);
        if (entry == null) {
            return true;
        }
        Map.Entry entry2 = entry;
        FirNamedFunctionSymbol overriddenMember = (FirNamedFunctionSymbol)entry2.getKey();
        ThrowsFilter overriddenThrows = (ThrowsFilter)entry2.getValue();
        FirAnnotationCall firAnnotationCall = throwsAnnotation;
        if ((firAnnotationCall != null ? firAnnotationCall.getSource() : null) != null && !Intrinsics.areEqual((Object)this.decodeThrowsFilter(throwsAnnotation, context2.getSession()), (Object)overriddenThrows)) {
            FirRegularClassSymbol containingClassSymbol;
            ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(overriddenMember);
            FirRegularClassSymbol firRegularClassSymbol = containingClassSymbol = coneClassLikeLookupTag != null ? LookupTagUtilsKt.toFirRegularClassSymbol(coneClassLikeLookupTag, context2.getSession()) : null;
            if (containingClassSymbol != null) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)throwsAnnotation.getSource(), FirNativeErrors.INSTANCE.getINCOMPATIBLE_THROWS_OVERRIDE(), (Object)containingClassSymbol, (DiagnosticContext)context2, null, 16, null);
            }
            return false;
        }
        return true;
    }

    private final Map<FirNamedFunctionSymbol, ThrowsFilter> getInheritedThrows(FirSimpleFunction function2, FirAnnotationCall throwsAnnotation, CheckerContext context2) {
        Set visited2 = new LinkedHashSet();
        Map result2 = new LinkedHashMap();
        FirNativeThrowsChecker.getInheritedThrows$getInheritedThrows(visited2, context2, function2, result2, this, throwsAnnotation, function2.getSymbol());
        return result2;
    }

    private final boolean hasUnresolvedArgument(FirElement $this$hasUnresolvedArgument) {
        if ($this$hasUnresolvedArgument instanceof FirWrappedArgumentExpression) {
            return this.hasUnresolvedArgument(((FirWrappedArgumentExpression)$this$hasUnresolvedArgument).getExpression());
        }
        if ($this$hasUnresolvedArgument instanceof FirResolvable && FirReferenceUtilsKt.isError(((FirResolvable)$this$hasUnresolvedArgument).getCalleeReference())) {
            return true;
        }
        if ($this$hasUnresolvedArgument instanceof FirVarargArgumentsExpression) {
            for (FirExpression argument2 : ((FirVarargArgumentsExpression)$this$hasUnresolvedArgument).getArguments()) {
                if (!this.hasUnresolvedArgument(argument2)) continue;
                return true;
            }
        }
        if ($this$hasUnresolvedArgument instanceof FirCall) {
            for (FirExpression argument2 : ((FirCall)$this$hasUnresolvedArgument).getArgumentList().getArguments()) {
                if (!this.hasUnresolvedArgument(argument2)) continue;
                return true;
            }
        }
        if ($this$hasUnresolvedArgument instanceof FirResolvedQualifier) {
            FirClassLikeSymbol<?> firClassLikeSymbol = ((FirResolvedQualifier)$this$hasUnresolvedArgument).getSymbol();
            if (firClassLikeSymbol != null) {
                FirClassLikeSymbol<?> symbol2 = firClassLikeSymbol;
                boolean bl = false;
                if (symbol2 instanceof FirTypeAliasSymbol) {
                    FirTypeRef $this$coneTypeSafe$iv = ((FirTypeAliasSymbol)symbol2).getResolvedExpandedTypeRef();
                    boolean $i$f$coneTypeSafe = false;
                    FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                    ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                    if (!(coneKotlinType instanceof ConeKotlinType)) {
                        coneKotlinType = null;
                    }
                    boolean bl2 = coneKotlinType != null ? ConeTypeUtilsKt.hasError(coneKotlinType) : false;
                    if (bl2) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final ThrowsFilter decodeThrowsFilter(FirAnnotationCall throwsAnnotation, FirSession session2) {
        Object object = throwsAnnotation;
        return new ThrowsFilter(object != null && (object = this.getClassTypes((FirAnnotationCall)object, session2)) != null ? CollectionsKt.toSet((Iterable)((Iterable)object)) : null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ConeKotlinType> getClassTypes(FirAnnotationCall $this$getClassTypes, FirSession session2) {
        List list2;
        FirVarargArgumentsExpression firVarargArgumentsExpression;
        List<FirExpression> arguments2 = $this$getClassTypes.getArgumentList().getArguments();
        List<FirExpression> list3 = CollectionsKt.firstOrNull(arguments2);
        FirVarargArgumentsExpression firVarargArgumentsExpression2 = firVarargArgumentsExpression = list3 instanceof FirVarargArgumentsExpression ? (FirVarargArgumentsExpression)((Object)list3) : null;
        if (firVarargArgumentsExpression != null && (list3 = firVarargArgumentsExpression.getArguments()) != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterIsInstanceTo$iv$iv;
            void $this$filterIsInstance$iv;
            Iterable iterable = list3;
            boolean $i$f$filterIsInstance22 = false;
            void var8_9 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof FirGetClassCall)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $i$f$filterIsInstance22 = (List)destination$iv$iv;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FirGetClassCall firGetClassCall = (FirGetClassCall)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                FirCall $this$arguments$iv = (FirCall)it;
                boolean $i$f$getArguments = false;
                collection.add(TypeExpansionUtilsKt.fullyExpandedType(FirTypeUtilsKt.getResolvedType((FirExpression)CollectionsKt.first($this$arguments$iv.getArgumentList().getArguments())), session2));
            }
            list2 = (List)destination$iv$iv2;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private static final void getInheritedThrows$getInheritedThrows(Set<FirNamedFunctionSymbol> visited2, CheckerContext $context, FirSimpleFunction $function, Map<FirNamedFunctionSymbol, ThrowsFilter> result2, FirNativeThrowsChecker this$0, FirAnnotationCall localThrowsAnnotation, FirNamedFunctionSymbol localFunctionSymbol) {
        FirRegularClassSymbol containingClassSymbol;
        if (!visited2.add(localFunctionSymbol)) {
            return;
        }
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(localFunctionSymbol);
        FirRegularClassSymbol firRegularClassSymbol = containingClassSymbol = coneClassLikeLookupTag != null ? LookupTagUtilsKt.toFirRegularClassSymbol(coneClassLikeLookupTag, $context.getSession()) : null;
        if (containingClassSymbol != null) {
            List<FirNamedFunctionSymbol> overriddenFunctions2 = FirHelpersKt.directOverriddenFunctions(localFunctionSymbol, $context.getSession(), $context.getScopeSession());
            if (Intrinsics.areEqual((Object)localFunctionSymbol, (Object)$function.getSymbol()) || localThrowsAnnotation == null && !((Collection)overriddenFunctions2).isEmpty()) {
                for (FirNamedFunctionSymbol overriddenFunction : overriddenFunctions2) {
                    FirAnnotation firAnnotation;
                    FirAnnotationCall annotation2 = ClassMembersKt.isSubstitutionOrIntersectionOverride(overriddenFunction) ? null : ((firAnnotation = FirAnnotationUtilsKt.getAnnotationByClassId(overriddenFunction, throwsClassId, $context.getSession())) instanceof FirAnnotationCall ? (FirAnnotationCall)firAnnotation : null);
                    FirNativeThrowsChecker.getInheritedThrows$getInheritedThrows(visited2, $context, $function, result2, this$0, annotation2, overriddenFunction);
                }
            } else {
                result2.put(localFunctionSymbol, this$0.decodeThrowsFilter(localThrowsAnnotation, $context.getSession()));
            }
        }
    }

    public /* synthetic */ FirNativeThrowsChecker(MppCheckerKind mppKind, DefaultConstructorMarker $constructor_marker) {
        this(mppKind);
    }

    static {
        Object[] objectArray = new ClassId[]{ClassId.Companion.topLevel(StandardNames.FqNames.throwable), ClassId.Companion.topLevel(new FqName("kotlin.Exception")), ClassId.Companion.topLevel(new FqName("kotlin.RuntimeException")), ClassId.Companion.topLevel(new FqName("kotlin.IllegalStateException")), ClassId.Companion.topLevel(cancellationExceptionFqName)};
        cancellationExceptionAndSupersClassIds = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker$Companion;", "", "()V", "cancellationExceptionAndSupersClassIds", "", "Lksp/org/jetbrains/kotlin/name/ClassId;", "cancellationExceptionFqName", "Lksp/org/jetbrains/kotlin/name/FqName;", "throwsClassId", "checkers.native"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker$ForExpectClass;", "Lksp/org/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker;", "()V", "check", "", "declaration", "Lksp/org/jetbrains/kotlin/fir/declarations/FirDeclaration;", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.native"})
    @SourceDebugExtension(value={"SMAP\nFirNativeThrowsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNativeThrowsChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker$ForExpectClass\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,209:1\n37#2:210\n*S KotlinDebug\n*F\n+ 1 FirNativeThrowsChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker$ForExpectClass\n*L\n48#1:210\n*E\n"})
    public static final class ForExpectClass
    extends FirNativeThrowsChecker {
        @NotNull
        public static final ForExpectClass INSTANCE = new ForExpectClass();

        private ForExpectClass() {
            super(MppCheckerKind.Common, null);
        }

        @Override
        public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            FirMemberDeclaration firMemberDeclaration = declaration2 instanceof FirMemberDeclaration ? (FirMemberDeclaration)declaration2 : null;
            if (firMemberDeclaration != null) {
                FirMemberDeclaration $this$isExpect$iv = firMemberDeclaration;
                boolean $i$f$isExpect = false;
                bl = $this$isExpect$iv.getStatus().isExpect();
            } else {
                bl = false;
            }
            if (!bl) {
                return;
            }
            super.check(declaration2, context2, reporter);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker$Regular;", "Lksp/org/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker;", "()V", "check", "", "declaration", "Lksp/org/jetbrains/kotlin/fir/declarations/FirDeclaration;", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.native"})
    @SourceDebugExtension(value={"SMAP\nFirNativeThrowsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNativeThrowsChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker$Regular\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,209:1\n37#2:210\n*S KotlinDebug\n*F\n+ 1 FirNativeThrowsChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker$Regular\n*L\n41#1:210\n*E\n"})
    public static final class Regular
    extends FirNativeThrowsChecker {
        @NotNull
        public static final Regular INSTANCE = new Regular();

        private Regular() {
            super(MppCheckerKind.Platform, null);
        }

        @Override
        public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            FirMemberDeclaration firMemberDeclaration = declaration2 instanceof FirMemberDeclaration ? (FirMemberDeclaration)declaration2 : null;
            if (firMemberDeclaration != null) {
                FirMemberDeclaration $this$isExpect$iv = firMemberDeclaration;
                boolean $i$f$isExpect = false;
                bl = $this$isExpect$iv.getStatus().isExpect();
            } else {
                bl = false;
            }
            if (bl) {
                return;
            }
            super.check(declaration2, context2, reporter);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001b\u0010\t\u001a\u00020\u00002\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0019\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker$ThrowsFilter;", "", "classes", "", "Lksp/org/jetbrains/kotlin/fir/types/ConeKotlinType;", "(Ljava/util/Set;)V", "getClasses", "()Ljava/util/Set;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "checkers.native"})
    private static final class ThrowsFilter {
        @Nullable
        private final Set<ConeKotlinType> classes;

        public ThrowsFilter(@Nullable Set<? extends ConeKotlinType> classes2) {
            this.classes = classes2;
        }

        @Nullable
        public final Set<ConeKotlinType> getClasses() {
            return this.classes;
        }

        @Nullable
        public final Set<ConeKotlinType> component1() {
            return this.classes;
        }

        @NotNull
        public final ThrowsFilter copy(@Nullable Set<? extends ConeKotlinType> classes2) {
            return new ThrowsFilter(classes2);
        }

        public static /* synthetic */ ThrowsFilter copy$default(ThrowsFilter throwsFilter, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                set = throwsFilter.classes;
            }
            return throwsFilter.copy(set);
        }

        @NotNull
        public String toString() {
            return "ThrowsFilter(classes=" + this.classes + ')';
        }

        public int hashCode() {
            return this.classes == null ? 0 : ((Object)this.classes).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ThrowsFilter)) {
                return false;
            }
            ThrowsFilter throwsFilter = (ThrowsFilter)other;
            return Intrinsics.areEqual(this.classes, throwsFilter.classes);
        }
    }
}

