/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceFile;
import ksp.org.jetbrains.kotlin.KtVirtualFileSourceFile;
import ksp.org.jetbrains.kotlin.descriptors.SourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.ClassMembersKt;
import ksp.org.jetbrains.kotlin.fir.FirElement;
import ksp.org.jetbrains.kotlin.fir.UtilsKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFile;
import ksp.org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import ksp.org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.java.JavaBinarySourceElement;
import ksp.org.jetbrains.kotlin.fir.modules.FirJavaModuleResolverProviderKt;
import ksp.org.jetbrains.kotlin.fir.references.FirReference;
import ksp.org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.load.kotlin.JvmPackagePartSource;
import ksp.org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import ksp.org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import ksp.org.jetbrains.kotlin.load.kotlin.VirtualFileKotlinClass;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.resolve.jvm.modules.JavaModuleResolver;
import ksp.org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J1\u0010\f\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u0011J5\u0010\u0012\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u0017\u00a8\u0006\u0018"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJvmModuleAccessibilityQualifiedAccessChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "()V", "check", "", "expression", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkClassAccess", "symbol", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "element", "Lksp/org/jetbrains/kotlin/fir/FirElement;", "checkClassAccess$checkers_jvm", "checkPackageAccess", "fileFromPackage", "Lksp/com/intellij/openapi/vfs/VirtualFile;", "referencedPackageFqName", "Lksp/org/jetbrains/kotlin/name/FqName;", "checkPackageAccess$checkers_jvm", "checkers.jvm"})
public final class FirJvmModuleAccessibilityQualifiedAccessChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirJvmModuleAccessibilityQualifiedAccessChecker INSTANCE = new FirJvmModuleAccessibilityQualifiedAccessChecker();

    private FirJvmModuleAccessibilityQualifiedAccessChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirCallableSymbol firCallableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(expression2.getCalleeReference(), false, 1, null);
        if (firCallableSymbol == null) {
            return;
        }
        FirCallableSymbol callableSymbol = firCallableSymbol;
        if (callableSymbol.getOrigin().getFromSource()) {
            return;
        }
        ConeClassLikeLookupTag containingClass = ClassMembersKt.containingClassLookupTag(callableSymbol);
        if (containingClass != null) {
            FirRegularClassSymbol firRegularClassSymbol = LookupTagUtilsKt.toFirRegularClassSymbol(containingClass, context2.getSession());
            if (firRegularClassSymbol == null) {
                return;
            }
            FirRegularClassSymbol containingClassSymbol = firRegularClassSymbol;
            this.checkClassAccess$checkers_jvm(context2, containingClassSymbol, expression2, reporter);
        } else {
            DeserializedContainerSource deserializedContainerSource = callableSymbol.getContainerSource();
            JvmPackagePartSource jvmPackagePartSource = deserializedContainerSource instanceof JvmPackagePartSource ? (JvmPackagePartSource)deserializedContainerSource : null;
            if (jvmPackagePartSource == null) {
                return;
            }
            JvmPackagePartSource containerSource = jvmPackagePartSource;
            KotlinJvmBinaryClass kotlinJvmBinaryClass2 = containerSource.getKnownJvmBinaryClass();
            Object object = kotlinJvmBinaryClass2 instanceof VirtualFileKotlinClass ? (VirtualFileKotlinClass)kotlinJvmBinaryClass2 : null;
            if (object == null || (object = ((VirtualFileKotlinClass)object).getFile()) == null) {
                return;
            }
            Object virtualFile2 = object;
            FqName fqName2 = containerSource.getClassName().getPackageFqName();
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"getPackageFqName(...)");
            this.checkPackageAccess$checkers_jvm(context2, (VirtualFile)virtualFile2, fqName2, expression2, reporter);
        }
    }

    public final void checkClassAccess$checkers_jvm(@NotNull CheckerContext context2, @NotNull FirClassSymbol<?> symbol2, @NotNull FirElement element2, @NotNull DiagnosticReporter reporter) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (symbol2.getOrigin().getFromSource()) {
            return;
        }
        SourceElement sourceElement = DeclarationAttributesKt.getSourceElement((FirClassLikeDeclaration)symbol2.getFir());
        SourceElement sourceElement2 = sourceElement;
        if (sourceElement2 instanceof JavaBinarySourceElement) {
            object = ((JavaBinarySourceElement)sourceElement).getVirtualFile();
        } else if (sourceElement2 instanceof KotlinJvmBinarySourceElement) {
            KotlinJvmBinaryClass kotlinJvmBinaryClass2 = ((KotlinJvmBinarySourceElement)sourceElement).getBinaryClass();
            object = kotlinJvmBinaryClass2 instanceof VirtualFileKotlinClass ? (VirtualFileKotlinClass)kotlinJvmBinaryClass2 : null;
            if (object == null || (object = ((VirtualFileKotlinClass)object).getFile()) == null) {
                return;
            }
        } else {
            return;
        }
        VirtualFile virtualFile2 = object;
        this.checkPackageAccess$checkers_jvm(context2, virtualFile2, UtilsKt.packageFqName((FirBasedSymbol)symbol2), element2, reporter);
    }

    public final void checkPackageAccess$checkers_jvm(@NotNull CheckerContext context2, @NotNull VirtualFile fileFromPackage, @NotNull FqName referencedPackageFqName, @NotNull FirElement element2, @NotNull DiagnosticReporter reporter) {
        JavaModuleResolver.AccessError accessError;
        Object source;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fileFromPackage, (String)"fileFromPackage");
        Intrinsics.checkNotNullParameter((Object)referencedPackageFqName, (String)"referencedPackageFqName");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirFile firFile = context2.getContainingFile();
        KtSourceFile ktSourceFile = firFile != null ? firFile.getSourceFile() : null;
        KtVirtualFileSourceFile ktVirtualFileSourceFile = ktSourceFile instanceof KtVirtualFileSourceFile ? (KtVirtualFileSourceFile)ktSourceFile : null;
        VirtualFile fileFromOurModule = ktVirtualFileSourceFile != null ? ktVirtualFileSourceFile.getVirtualFile() : null;
        JavaModuleResolver.AccessError accessError2 = FirJavaModuleResolverProviderKt.getJavaModuleResolverProvider(context2.getSession()).getJavaModuleResolver().checkAccessibility(fileFromOurModule, fileFromPackage, referencedPackageFqName);
        if (accessError2 == null) {
            return;
        }
        JavaModuleResolver.AccessError diagnostic = accessError2;
        Object object = ReferenceUtilsKt.toReference(element2, context2.getSession());
        if (object == null || (object = ((FirReference)object).getSource()) == null) {
            object = source = element2.getSource();
        }
        if ((accessError = diagnostic) instanceof JavaModuleResolver.AccessError.ModuleDoesNotExportPackage) {
            AbstractKtSourceElement abstractKtSourceElement = (AbstractKtSourceElement)source;
            KtDiagnosticFactory2<String, String> ktDiagnosticFactory2 = FirJvmErrors.INSTANCE.getJAVA_MODULE_DOES_NOT_EXPORT_PACKAGE();
            String string2 = ((JavaModuleResolver.AccessError.ModuleDoesNotExportPackage)diagnostic).getDependencyModuleName();
            String string3 = referencedPackageFqName.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, abstractKtSourceElement, ktDiagnosticFactory2, (Object)string2, (Object)string3, (DiagnosticContext)context2, null, 32, null);
        } else if (accessError instanceof JavaModuleResolver.AccessError.ModuleDoesNotReadModule) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirJvmErrors.INSTANCE.getJAVA_MODULE_DOES_NOT_DEPEND_ON_MODULE(), (Object)((JavaModuleResolver.AccessError.ModuleDoesNotReadModule)diagnostic).getDependencyModuleName(), (DiagnosticContext)context2, null, 16, null);
        } else if (Intrinsics.areEqual((Object)accessError, (Object)JavaModuleResolver.AccessError.ModuleDoesNotReadUnnamedModule.INSTANCE)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirJvmErrors.INSTANCE.getJAVA_MODULE_DOES_NOT_READ_UNNAMED_MODULE(), (DiagnosticContext)context2, null, 8, null);
        }
    }
}

