/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.lang.LighterASTNode;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.util.diff.FlyweightCapableTreeStructure;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtFakeSourceElement;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtLightSourceElement;
import ksp.org.jetbrains.kotlin.KtNodeTypes;
import ksp.org.jetbrains.kotlin.KtPsiSourceElement;
import ksp.org.jetbrains.kotlin.KtRealPsiSourceElement;
import ksp.org.jetbrains.kotlin.KtRealSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceElementKind;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import ksp.org.jetbrains.kotlin.fir.FirFunctionTypeParameter;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirModifier;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirModifierList;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.type.FirFunctionalTypeParameterSyntaxChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.type.FirUnsupportedModifiersInFunctionTypeParameterChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.psi.KtValVarKeywordOwner;
import ksp.org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import ksp.org.jetbrains.kotlin.util.LightTreeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\u0010\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0011"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/type/FirUnsupportedModifiersInFunctionTypeParameterChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/type/FirFunctionalTypeParameterSyntaxChecker;", "()V", "checkAnnotations", "", "source", "Lksp/org/jetbrains/kotlin/KtSourceElement;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "checkModifiers", "checkPsiOrLightTree", "", "element", "Lksp/org/jetbrains/kotlin/fir/FirFunctionTypeParameter;", "checkValOrVarKeyword", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirUnsupportedModifiersInFunctionTypeParameterChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirUnsupportedModifiersInFunctionTypeParameterChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/type/FirUnsupportedModifiersInFunctionTypeParameterChecker\n+ 2 KtSourceElement.kt\norg/jetbrains/kotlin/KtSourceElementKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n645#2,4:91\n651#2,6:95\n651#2,6:107\n774#3:101\n865#3,2:102\n1557#3:104\n1628#3,2:105\n1630#3:113\n*S KotlinDebug\n*F\n+ 1 FirUnsupportedModifiersInFunctionTypeParameterChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/type/FirUnsupportedModifiersInFunctionTypeParameterChecker\n*L\n39#1:91,4\n42#1:95,6\n73#1:107,6\n73#1:101\n73#1:102,2\n73#1:104\n73#1:105,2\n73#1:113\n*E\n"})
public final class FirUnsupportedModifiersInFunctionTypeParameterChecker
extends FirFunctionalTypeParameterSyntaxChecker {
    @NotNull
    public static final FirUnsupportedModifiersInFunctionTypeParameterChecker INSTANCE = new FirUnsupportedModifiersInFunctionTypeParameterChecker();

    private FirUnsupportedModifiersInFunctionTypeParameterChecker() {
    }

    @Override
    public void checkPsiOrLightTree(@NotNull FirFunctionTypeParameter element2, @NotNull KtSourceElement source, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        this.checkModifiers(source, reporter, context2);
        this.checkAnnotations(source, reporter, context2);
        this.checkValOrVarKeyword(source, reporter, context2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void checkValOrVarKeyword(KtSourceElement source, DiagnosticReporter reporter, CheckerContext context2) {
        KtSourceElement ktSourceElement;
        KtSourceElement ktSourceElement2 = source;
        if (ktSourceElement2 instanceof KtPsiSourceElement) {
            KtPsiSourceElement ktPsiSourceElement;
            PsiElement psiElement = ((KtPsiSourceElement)source).getPsi();
            PsiElement psiElement2 = psiElement instanceof KtValVarKeywordOwner ? (KtValVarKeywordOwner)psiElement : null;
            if (psiElement2 != null && (psiElement2 = psiElement2.getValOrVarKeyword()) != null) {
                PsiElement psiElement3 = psiElement2;
                KtSourceElementKind kind$iv = KtRealSourceElementKind.INSTANCE;
                boolean $i$f$toKtPsiSourceElement = false;
                KtSourceElementKind ktSourceElementKind = kind$iv;
                if (ktSourceElementKind instanceof KtRealSourceElementKind) {
                    ktPsiSourceElement = new KtRealPsiSourceElement(psiElement3);
                } else {
                    if (!(ktSourceElementKind instanceof KtFakeSourceElementKind)) throw new NoWhenBranchMatchedException();
                    ktPsiSourceElement = new KtFakeSourceElement(psiElement3, (KtFakeSourceElementKind)kind$iv);
                }
            } else {
                ktPsiSourceElement = null;
            }
            ktSourceElement = ktPsiSourceElement;
        } else {
            KtLightSourceElement ktLightSourceElement;
            if (!(ktSourceElement2 instanceof KtLightSourceElement)) throw new NoWhenBranchMatchedException();
            LighterASTNode lighterASTNode = LightTreePositioningStrategiesKt.valOrVarKeyword(source.getTreeStructure(), source.getLighterASTNode());
            if (lighterASTNode != null) {
                void $this$toKtLightSourceElement_u24default$iv;
                LighterASTNode lighterASTNode2 = lighterASTNode;
                FlyweightCapableTreeStructure<LighterASTNode> flyweightCapableTreeStructure = source.getTreeStructure();
                KtSourceElementKind kind$iv = KtRealSourceElementKind.INSTANCE;
                int startOffset$iv = $this$toKtLightSourceElement_u24default$iv.getStartOffset();
                int endOffset$iv = $this$toKtLightSourceElement_u24default$iv.getEndOffset();
                boolean $i$f$toKtLightSourceElement = false;
                ktLightSourceElement = new KtLightSourceElement((LighterASTNode)$this$toKtLightSourceElement_u24default$iv, startOffset$iv, endOffset$iv, flyweightCapableTreeStructure, kind$iv);
            } else {
                ktLightSourceElement = null;
            }
            ktSourceElement = ktLightSourceElement;
        }
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement keyword = ktSourceElement;
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)keyword, FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"val or var on parameter in function type", (DiagnosticContext)context2, null, 16, null);
    }

    private final boolean checkModifiers(KtSourceElement source, DiagnosticReporter reporter, CheckerContext context2) {
        FirModifierList firModifierList = FirKeywordUtilsKt.getModifierList(source);
        if (firModifierList == null) {
            return true;
        }
        FirModifierList modifiersList = firModifierList;
        for (FirModifier<?> modifier : modifiersList.getModifiers()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)modifier.getSource(), FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"modifier on parameter in function type", (DiagnosticContext)context2, null, 16, null);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkAnnotations(KtSourceElement source, DiagnosticReporter reporter, CheckerContext context2) {
        List list2;
        FirModifierList firModifierList = FirKeywordUtilsKt.getModifierList(source);
        if (firModifierList == null) {
            return true;
        }
        FirModifierList commonModifiersList = firModifierList;
        FirModifierList firModifierList2 = commonModifiersList;
        if (firModifierList2 instanceof FirModifierList.FirLightModifierList) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            LighterASTNode it;
            void $this$filterTo$iv$iv;
            FlyweightCapableTreeStructure<LighterASTNode> tree = ((FirModifierList.FirLightModifierList)commonModifiersList).getTree();
            List<LighterASTNode> children2 = LightTreeUtilsKt.getChildren(((FirModifierList.FirLightModifierList)commonModifiersList).getModifierList(), tree);
            Iterable $this$filter$iv = children2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (LighterASTNode)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getTokenType(), (Object)KtNodeTypes.ANNOTATION_ENTRY)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (LighterASTNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                LighterASTNode $this$toKtLightSourceElement_u24default$iv = it;
                KtSourceElementKind kind$iv = KtRealSourceElementKind.INSTANCE;
                int startOffset$iv = $this$toKtLightSourceElement_u24default$iv.getStartOffset();
                int endOffset$iv = $this$toKtLightSourceElement_u24default$iv.getEndOffset();
                boolean $i$f$toKtLightSourceElement = false;
                collection.add(new KtLightSourceElement($this$toKtLightSourceElement_u24default$iv, startOffset$iv, endOffset$iv, tree, kind$iv));
            }
            list2 = (List)destination$iv$iv;
        } else if (firModifierList2 instanceof FirModifierList.FirPsiModifierList) {
            ASTNode aSTNode = ((FirModifierList.FirPsiModifierList)commonModifiersList).getModifierList().getNode();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getNode(...)");
            Sequence<ASTNode> children3 = PsiUtilsKt.children(aSTNode);
            list2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter(children3, (Function1)checkAnnotations.annotationsSource.3.INSTANCE), (Function1)checkAnnotations.annotationsSource.4.INSTANCE));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        List annotationsSource2 = list2;
        for (KtSourceElement ann : annotationsSource2) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)ann, FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"annotation on parameter in function type", (DiagnosticContext)context2, null, 16, null);
        }
        return false;
    }
}

