/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeProjection;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J,\u0010\f\u001a\u00020\u0006*\b\u0012\u0002\b\u0003\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0010"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirStandaloneQualifierChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirResolvedQualifier;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirResolvedQualifierChecker;", "()V", "check", "", "expression", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reportErrorOn", "Lksp/org/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "source", "Lksp/org/jetbrains/kotlin/KtSourceElement;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirStandaloneQualifierChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirStandaloneQualifierChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirStandaloneQualifierChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,55:1\n1755#2,3:56\n*S KotlinDebug\n*F\n+ 1 FirStandaloneQualifierChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirStandaloneQualifierChecker\n*L\n30#1:56,3\n*E\n"})
public final class FirStandaloneQualifierChecker
extends FirExpressionChecker<FirResolvedQualifier> {
    @NotNull
    public static final FirStandaloneQualifierChecker INSTANCE = new FirStandaloneQualifierChecker();

    private FirStandaloneQualifierChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirResolvedQualifier expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!FirHelpersKt.isStandalone(expression2, context2)) {
            return;
        }
        if (!ConeBuiltinTypeUtilsKt.isUnit(FirTypeUtilsKt.getResolvedType(expression2))) {
            boolean bl;
            block6: {
                Iterable $this$any$iv = expression2.getTypeArguments();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirTypeProjection it = (FirTypeProjection)element$iv;
                        boolean bl2 = false;
                        if (!(it.getSource() != null)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (bl) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getEXPLICIT_TYPE_ARGUMENTS_IN_PROPERTY_ACCESS(), (Object)"Object", (DiagnosticContext)context2, null, 16, null);
            }
            return;
        }
        this.reportErrorOn((FirBasedSymbol)expression2.getSymbol(), expression2.getSource(), context2, reporter);
    }

    private final void reportErrorOn(FirBasedSymbol<?> $this$reportErrorOn, KtSourceElement source, CheckerContext context2, DiagnosticReporter reporter) {
        FirBasedSymbol<?> firBasedSymbol = $this$reportErrorOn;
        if (firBasedSymbol instanceof FirRegularClassSymbol) {
            if (((FirRegularClassSymbol)$this$reportErrorOn).getClassKind() == ClassKind.OBJECT) {
                return;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getNO_COMPANION_OBJECT(), $this$reportErrorOn, (DiagnosticContext)context2, null, 16, null);
        } else if (firBasedSymbol instanceof FirTypeAliasSymbol) {
            FirRegularClassSymbol firRegularClassSymbol = DeclarationUtilsKt.fullyExpandedClass((FirClassLikeSymbol)$this$reportErrorOn, context2.getSession());
            if (firRegularClassSymbol != null) {
                this.reportErrorOn(firRegularClassSymbol, source, context2, reporter);
            }
        } else if (firBasedSymbol == null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getEXPRESSION_EXPECTED_PACKAGE_FOUND(), (DiagnosticContext)context2, null, 8, null);
        }
    }
}

