/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtRealSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import ksp.org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import ksp.org.jetbrains.kotlin.fir.FirAnnotationContainer;
import ksp.org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import ksp.org.jetbrains.kotlin.fir.FirPureAbstractElement;
import ksp.org.jetbrains.kotlin.fir.UtilsKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirBackingField;
import ksp.org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirConstructor;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDanglingModifierList;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirField;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFile;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import ksp.org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import ksp.org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import ksp.org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import ksp.org.jetbrains.kotlin.fir.declarations.FirVariable;
import ksp.org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.resolve.CallableIdUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import ksp.org.jetbrains.kotlin.fir.types.CustomAnnotationTypeAttributeKt;
import ksp.org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.name.StandardClassIds;
import ksp.org.jetbrains.kotlin.resolve.AnnotationTargetList;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J0\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J*\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u00132\b\u0010\u001a\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u001b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002JO\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0002\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0001\u001a\u0004\u0010\u0001(\u0000J \u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\"\u0010\"\u001a\u00020\t2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020!2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J0\u0010(\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010)\u001a\u00020 2\u0006\u0010$\u001a\u00020%H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00f2\u0001\u0004\n\u00020!\u00a8\u0006*"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnnotationChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "deprecatedClassId", "Lksp/org/jetbrains/kotlin/name/FqName;", "deprecatedSinceKotlinClassId", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkAnnotationContainer", "Lksp/org/jetbrains/kotlin/fir/FirAnnotationContainer;", "checkAnnotationTarget", "annotation", "Lksp/org/jetbrains/kotlin/fir/expressions/FirAnnotation;", "checkAnnotationUseSiteTarget", "annotated", "target", "Lksp/org/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;", "checkDeprecatedCalls", "deprecatedSinceKotlin", "deprecated", "checkMultiFieldValueClassAnnotationRestrictions", "checkPropertyGetter", "", "diagnostic", "Lksp/org/jetbrains/kotlin/diagnostics/KtDiagnosticFactory1;", "", "Lksp/org/jetbrains/kotlin/fir/declarations/FirProperty;", "checkRepeatedAnnotations", "annotationContainer", "type", "Lksp/org/jetbrains/kotlin/fir/types/ConeKotlinType;", "checkRepeatedAnnotationsInProperty", "property", "reportIfMfvc", "hint", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirAnnotationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirAnnotationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnnotationChecker\n+ 2 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,380:1\n23#2,4:381\n1755#3,3:385\n1755#3,3:388\n1557#3:391\n1628#3,3:392\n*S KotlinDebug\n*F\n+ 1 FirAnnotationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnnotationChecker\n*L\n98#1:381,4\n163#1:385,3\n171#1:388,3\n355#1:391\n355#1:392,3\n*E\n"})
public final class FirAnnotationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirAnnotationChecker INSTANCE = new FirAnnotationChecker();
    @NotNull
    private static final FqName deprecatedClassId = new FqName("kotlin.Deprecated");
    @NotNull
    private static final FqName deprecatedSinceKotlinClassId = new FqName("kotlin.DeprecatedSinceKotlin");

    private FirAnnotationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            if (declaration2 instanceof FirDanglingModifierList) {
                return;
            }
            this.checkAnnotationContainer(declaration2, context2, reporter);
            if (!(declaration2 instanceof FirCallableDeclaration)) break block2;
            FirReceiverParameter firReceiverParameter = ((FirCallableDeclaration)declaration2).getReceiverParameter();
            if (firReceiverParameter != null) {
                FirReceiverParameter it = firReceiverParameter;
                boolean bl = false;
                INSTANCE.checkAnnotationContainer(it, context2, reporter);
            }
        }
    }

    private final void checkAnnotationContainer(FirAnnotationContainer declaration2, CheckerContext context2, DiagnosticReporter reporter) {
        FirReceiverParameter receiverParameter;
        FirAnnotation deprecated = null;
        FirAnnotation deprecatedSinceKotlin = null;
        for (FirAnnotation firAnnotation : declaration2.getAnnotations()) {
            FqName fqName2;
            if (CallableIdUtilsKt.fqName(firAnnotation, context2.getSession()) == null) continue;
            if (Intrinsics.areEqual((Object)fqName2, (Object)deprecatedClassId)) {
                deprecated = firAnnotation;
            } else if (Intrinsics.areEqual((Object)fqName2, (Object)deprecatedSinceKotlinClassId)) {
                deprecatedSinceKotlin = firAnnotation;
            }
            this.checkAnnotationTarget(declaration2, firAnnotation, context2, reporter);
        }
        if (declaration2 instanceof FirCallableDeclaration && (receiverParameter = ((FirCallableDeclaration)declaration2).getReceiverParameter()) != null) {
            for (FirAnnotation receiverAnnotation : receiverParameter.getAnnotations()) {
                this.reportIfMfvc(context2, reporter, receiverAnnotation, "receivers", FirTypeUtilsKt.getConeType(receiverParameter.getTypeRef()));
            }
        }
        if (deprecatedSinceKotlin != null) {
            this.checkDeprecatedCalls(deprecatedSinceKotlin, deprecated, context2, reporter);
        }
        this.checkRepeatedAnnotations(declaration2, context2, reporter);
        if (declaration2 instanceof FirCallableDeclaration) {
            if (declaration2 instanceof FirProperty) {
                this.checkRepeatedAnnotationsInProperty((FirProperty)declaration2, context2, reporter);
            }
            KtSourceElement ktSourceElement = declaration2.getSource();
            if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtRealSourceElementKind) {
                KtSourceElement ktSourceElement2 = ((FirCallableDeclaration)declaration2).getReturnTypeRef().getSource();
                if ((ktSourceElement2 != null ? ktSourceElement2.getKind() : null) instanceof KtRealSourceElementKind) {
                    FirTypeRef $this$coneTypeSafe$iv = ((FirCallableDeclaration)declaration2).getReturnTypeRef();
                    boolean bl = false;
                    FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                    ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                    if (!(coneKotlinType instanceof ConeKotlinType)) {
                        coneKotlinType = null;
                    }
                    this.checkRepeatedAnnotations(coneKotlinType, context2, reporter);
                }
            }
        } else if (declaration2 instanceof FirTypeAlias) {
            this.checkRepeatedAnnotations(FirTypeUtilsKt.getConeType(((FirTypeAlias)declaration2).getExpandedTypeRef()), context2, reporter);
        }
    }

    private final void reportIfMfvc(CheckerContext context2, DiagnosticReporter reporter, FirAnnotation annotation2, String hint, ConeKotlinType type2) {
        if (DeclarationUtilsKt.needsMultiFieldValueClassFlattening(type2, context2.getSession())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation2.getSource(), FirErrors.INSTANCE.getANNOTATION_ON_ILLEGAL_MULTI_FIELD_VALUE_CLASS_TYPED_TARGET(), (Object)hint, (DiagnosticContext)context2, null, 16, null);
        }
    }

    private final void checkMultiFieldValueClassAnnotationRestrictions(FirAnnotationContainer declaration2, FirAnnotation annotation2, CheckerContext context2, DiagnosticReporter reporter) {
        Pair pair;
        AnnotationUseSiteTarget annotationUseSiteTarget = annotation2.getUseSiteTarget();
        switch (annotationUseSiteTarget == null ? -1 : WhenMappings.$EnumSwitchMapping$0[annotationUseSiteTarget.ordinal()]) {
            case 1: {
                FirPureAbstractElement firPureAbstractElement = declaration2 instanceof FirBackingField ? (FirBackingField)declaration2 : null;
                if (firPureAbstractElement == null || (firPureAbstractElement = firPureAbstractElement.getReturnTypeRef()) == null) {
                    return;
                }
                pair = TuplesKt.to((Object)"fields", (Object)firPureAbstractElement);
                break;
            }
            case 2: {
                Object object = declaration2 instanceof FirBackingField ? (FirBackingField)declaration2 : null;
                if (object == null || (object = ((FirBackingField)object).getPropertySymbol()) == null || (object = ((FirPropertySymbol)object).getDelegate()) == null || (object = FirTypeUtilsKt.getResolvedType((FirExpression)object)) == null) {
                    return;
                }
                pair = TuplesKt.to((Object)"delegate fields", (Object)object);
                break;
            }
            case 3: {
                FirPureAbstractElement firPureAbstractElement = declaration2 instanceof FirCallableDeclaration ? (FirCallableDeclaration)declaration2 : null;
                if (firPureAbstractElement == null || (firPureAbstractElement = ((FirCallableDeclaration)firPureAbstractElement).getReceiverParameter()) == null || (firPureAbstractElement = ((FirReceiverParameter)firPureAbstractElement).getTypeRef()) == null) {
                    return;
                }
                pair = TuplesKt.to((Object)"receivers", (Object)firPureAbstractElement);
                break;
            }
            case -1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                if (declaration2 instanceof FirProperty && !((FirProperty)declaration2).isLocal()) {
                    Set<KotlinTarget> allowedAnnotationTargets = FirAnnotationHelpersKt.getAllowedAnnotationTargets(annotation2, context2.getSession());
                    if (Intrinsics.areEqual((Object)DeclarationAttributesKt.getFromPrimaryConstructor((FirProperty)declaration2), (Object)true) && allowedAnnotationTargets.contains((Object)KotlinTarget.VALUE_PARAMETER)) {
                        return;
                    }
                    if (allowedAnnotationTargets.contains((Object)KotlinTarget.PROPERTY)) {
                        return;
                    }
                    if (allowedAnnotationTargets.contains((Object)KotlinTarget.FIELD)) {
                        pair = TuplesKt.to((Object)"fields", (Object)((FirProperty)declaration2).getReturnTypeRef());
                        break;
                    }
                    return;
                }
                if (declaration2 instanceof FirField) {
                    pair = TuplesKt.to((Object)"fields", (Object)((FirField)declaration2).getReturnTypeRef());
                    break;
                }
                if (declaration2 instanceof FirValueParameter) {
                    pair = TuplesKt.to((Object)"parameters", (Object)((FirValueParameter)declaration2).getReturnTypeRef());
                    break;
                }
                if (declaration2 instanceof FirVariable) {
                    pair = TuplesKt.to((Object)"variables", (Object)((FirVariable)declaration2).getReturnTypeRef());
                    break;
                }
                if (declaration2 instanceof FirPropertyAccessor && ((FirPropertyAccessor)declaration2).isGetter() && FirAnnotationChecker.checkMultiFieldValueClassAnnotationRestrictions$hasNoReceivers((FirPropertyAccessor)declaration2)) {
                    pair = TuplesKt.to((Object)"getters", (Object)((FirPropertyAccessor)declaration2).getReturnTypeRef());
                    break;
                }
                return;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Pair pair2 = pair;
        String hint = (String)pair2.component1();
        Object type2 = pair2.component2();
        ConeKotlinType coneKotlinType = type2 instanceof ConeKotlinType ? (ConeKotlinType)type2 : null;
        if (coneKotlinType == null) {
            Intrinsics.checkNotNull((Object)type2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.FirTypeRef");
            coneKotlinType = FirTypeUtilsKt.getConeType((FirTypeRef)type2);
        }
        this.reportIfMfvc(context2, reporter, annotation2, hint, coneKotlinType);
    }

    private final void checkAnnotationTarget(FirAnnotationContainer declaration2, FirAnnotation annotation2, CheckerContext context2, DiagnosticReporter reporter) {
        Object targetDescription;
        AnnotationTargetList actualTargets = FirHelpersKt.getActualTargetList(declaration2);
        Set<KotlinTarget> applicableTargets = FirAnnotationHelpersKt.getAllowedAnnotationTargets(annotation2, context2.getSession());
        AnnotationUseSiteTarget useSiteTarget2 = annotation2.getUseSiteTarget();
        if (useSiteTarget2 != null) {
            this.checkAnnotationUseSiteTarget(declaration2, annotation2, useSiteTarget2, context2, reporter);
        }
        if (FirAnnotationChecker.checkAnnotationTarget$check(applicableTargets, useSiteTarget2, actualTargets.getDefaultTargets()) || FirAnnotationChecker.checkAnnotationTarget$check(applicableTargets, useSiteTarget2, actualTargets.getCanBeSubstituted()) || FirAnnotationChecker.checkAnnotationTarget$checkWithUseSiteTargets(useSiteTarget2, actualTargets, applicableTargets)) {
            if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ValueClasses)) {
                this.checkMultiFieldValueClassAnnotationRestrictions(declaration2, annotation2, context2, reporter);
            }
            return;
        }
        Object object = (KotlinTarget)((Object)CollectionsKt.firstOrNull(actualTargets.getDefaultTargets()));
        if (object == null || (object = object.getDescription()) == null) {
            object = targetDescription = "unidentified target";
        }
        if (useSiteTarget2 != null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation2.getSource(), FirErrors.INSTANCE.getWRONG_ANNOTATION_TARGET_WITH_USE_SITE_TARGET(), targetDescription, (Object)useSiteTarget2.getRenderName(), (DiagnosticContext)context2, null, 32, null);
        } else {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation2.getSource(), FirErrors.INSTANCE.getWRONG_ANNOTATION_TARGET(), targetDescription, (DiagnosticContext)context2, null, 16, null);
        }
    }

    private final void checkAnnotationUseSiteTarget(FirAnnotationContainer annotated, FirAnnotation annotation2, AnnotationUseSiteTarget target, CheckerContext context2, DiagnosticReporter reporter) {
        KtSourceElement ktSourceElement = annotation2.getSource();
        if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.FromUseSiteTarget.INSTANCE)) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[target.ordinal()]) {
            case 5: 
            case 6: {
                KtDiagnosticFactory1<String> ktDiagnosticFactory1;
                boolean bl = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession()).supportsFeature(LanguageFeature.ProhibitUseSiteGetTargetAnnotations);
                if (bl) {
                    ktDiagnosticFactory1 = FirErrors.INSTANCE.getINAPPLICABLE_TARGET_ON_PROPERTY();
                } else if (!bl) {
                    ktDiagnosticFactory1 = FirErrors.INSTANCE.getINAPPLICABLE_TARGET_ON_PROPERTY_WARNING();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                this.checkPropertyGetter(annotated, annotation2, target, context2, reporter, ktDiagnosticFactory1);
                break;
            }
            case 1: {
                FirPropertySymbol propertySymbol;
                if (!(annotated instanceof FirBackingField) || (propertySymbol = ((FirBackingField)annotated).getPropertySymbol()).getDelegateFieldSymbol() == null || DeclarationAttributesKt.getHasBackingField(propertySymbol)) break;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation2.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_TARGET_PROPERTY_HAS_NO_BACKING_FIELD(), (DiagnosticContext)context2, null, 8, null);
                break;
            }
            case 2: {
                if (!(annotated instanceof FirBackingField) || ((FirBackingField)annotated).getPropertySymbol().getDelegateFieldSymbol() != null) break;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation2.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_TARGET_PROPERTY_HAS_NO_DELEGATE(), (DiagnosticContext)context2, null, 8, null);
                break;
            }
            case 7: 
            case 9: {
                if (this.checkPropertyGetter(annotated, annotation2, target, context2, reporter, FirErrors.INSTANCE.getINAPPLICABLE_TARGET_ON_PROPERTY()) || ((FirProperty)annotated).isVar()) break;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation2.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_TARGET_PROPERTY_IMMUTABLE(), (Object)target.getRenderName(), (DiagnosticContext)context2, null, 16, null);
                break;
            }
            case 8: {
                if (annotated instanceof FirValueParameter) {
                    FirDeclaration container2 = (FirDeclaration)CollectionsKt.lastOrNull(context2.getContainingDeclarations());
                    if (container2 instanceof FirConstructor && ((FirConstructor)container2).isPrimary()) {
                        KtSourceElement ktSourceElement2 = annotated.getSource();
                        if (ktSourceElement2 != null ? LightTreePositioningStrategiesKt.hasValOrVar(ktSourceElement2) : false) break;
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation2.getSource(), FirErrors.INSTANCE.getREDUNDANT_ANNOTATION_TARGET(), (Object)target.getRenderName(), (DiagnosticContext)context2, null, 16, null);
                        break;
                    }
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation2.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_PARAM_TARGET(), (DiagnosticContext)context2, null, 8, null);
                    break;
                }
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation2.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_PARAM_TARGET(), (DiagnosticContext)context2, null, 8, null);
                break;
            }
            case 4: {
                if (annotated instanceof FirFile) break;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation2.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_FILE_TARGET(), (DiagnosticContext)context2, null, 8, null);
                break;
            }
            case 3: {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation2.getSource(), FirErrors.INSTANCE.getWRONG_ANNOTATION_TARGET_WITH_USE_SITE_TARGET(), (Object)"declaration", (Object)target.getRenderName(), (DiagnosticContext)context2, null, 32, null);
            }
        }
    }

    private final boolean checkPropertyGetter(FirAnnotationContainer annotated, FirAnnotation annotation2, AnnotationUseSiteTarget target, CheckerContext context2, DiagnosticReporter reporter, KtDiagnosticFactory1<String> diagnostic) {
        boolean isReport;
        boolean bl = isReport = !(annotated instanceof FirProperty) || ((FirProperty)annotated).isLocal();
        if (isReport) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation2.getSource(), diagnostic, (Object)target.getRenderName(), (DiagnosticContext)context2, null, 16, null);
        }
        return isReport;
    }

    private final void checkDeprecatedCalls(FirAnnotation deprecatedSinceKotlin, FirAnnotation deprecated, CheckerContext context2, DiagnosticReporter reporter) {
        FirFile closestFirFile = context2.getContainingFile();
        if (closestFirFile != null && !UtilsKt.getPackageFqName(closestFirFile).startsWith(StandardClassIds.INSTANCE.getBASE_KOTLIN_PACKAGE().shortName())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)deprecatedSinceKotlin.getSource(), FirErrors.INSTANCE.getDEPRECATED_SINCE_KOTLIN_OUTSIDE_KOTLIN_SUBPACKAGE(), (DiagnosticContext)context2, null, 8, null);
        }
        if (deprecated == null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)deprecatedSinceKotlin.getSource(), FirErrors.INSTANCE.getDEPRECATED_SINCE_KOTLIN_WITHOUT_DEPRECATED(), (DiagnosticContext)context2, null, 8, null);
        } else {
            Map<Name, FirExpression> argumentMapping2 = deprecated.getArgumentMapping().getMapping();
            for (Name name2 : argumentMapping2.keySet()) {
                if (!Intrinsics.areEqual((Object)name2.getIdentifier(), (Object)"level")) continue;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)deprecatedSinceKotlin.getSource(), FirErrors.INSTANCE.getDEPRECATED_SINCE_KOTLIN_WITH_DEPRECATED_LEVEL(), (DiagnosticContext)context2, null, 8, null);
                break;
            }
        }
    }

    private final void checkRepeatedAnnotations(FirAnnotationContainer annotationContainer, CheckerContext context2, DiagnosticReporter reporter) {
        FirAnnotationHelpersKt.checkRepeatedAnnotation(annotationContainer, annotationContainer.getAnnotations(), context2, reporter);
    }

    private final void checkRepeatedAnnotations(ConeKotlinType type2, CheckerContext context2, DiagnosticReporter reporter) {
        if (type2 == null) {
            return;
        }
        ConeKotlinType fullyExpandedType2 = TypeExpansionUtilsKt.fullyExpandedType(type2, context2.getSession());
        FirAnnotationHelpersKt.checkRepeatedAnnotation(null, CustomAnnotationTypeAttributeKt.getCustomAnnotations(fullyExpandedType2.getAttributes()), context2, reporter);
        for (ConeTypeProjection typeArgument : fullyExpandedType2.getTypeArguments()) {
            if (!(typeArgument instanceof ConeKotlinType)) continue;
            this.checkRepeatedAnnotations((ConeKotlinType)typeArgument, context2, reporter);
        }
    }

    private final void checkRepeatedAnnotationsInProperty(FirProperty property2, CheckerContext context2, DiagnosticReporter reporter) {
        Pair[] pairArray = new Pair[3];
        FirPropertyAccessor firPropertyAccessor = property2.getGetter();
        pairArray[0] = TuplesKt.to((Object)((Object)AnnotationUseSiteTarget.PROPERTY_GETTER), firPropertyAccessor != null ? FirAnnotationChecker.checkRepeatedAnnotationsInProperty$getAnnotationTypes(firPropertyAccessor) : null);
        FirPropertyAccessor firPropertyAccessor2 = property2.getSetter();
        pairArray[1] = TuplesKt.to((Object)((Object)AnnotationUseSiteTarget.PROPERTY_SETTER), firPropertyAccessor2 != null ? FirAnnotationChecker.checkRepeatedAnnotationsInProperty$getAnnotationTypes(firPropertyAccessor2) : null);
        Object object = property2.getSetter();
        pairArray[2] = TuplesKt.to((Object)((Object)AnnotationUseSiteTarget.SETTER_PARAMETER), FirAnnotationChecker.checkRepeatedAnnotationsInProperty$getAnnotationTypes(object != null && (object = ((FirPropertyAccessor)object).getValueParameters()) != null ? (FirValueParameter)CollectionsKt.single((List)object) : null));
        Map propertyAnnotations = MapsKt.mapOf((Pair[])pairArray);
        boolean isError = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession()).supportsFeature(LanguageFeature.ProhibitRepeatedUseSiteTargetAnnotations);
        for (FirAnnotation annotation2 : property2.getAnnotations()) {
            List existingAnnotations;
            AnnotationUseSiteTarget useSiteTarget2;
            AnnotationUseSiteTarget annotationUseSiteTarget = annotation2.getUseSiteTarget();
            if (annotationUseSiteTarget == null) {
                annotationUseSiteTarget = FirAnnotationHelpersKt.getDefaultUseSiteTarget(property2, annotation2, context2);
            }
            if ((List)propertyAnnotations.get((Object)(useSiteTarget2 = annotationUseSiteTarget)) == null || !existingAnnotations.contains(FirTypeUtilsKt.getConeType(annotation2.getAnnotationTypeRef())) || FirAnnotationHelpersKt.isRepeatable(annotation2, context2.getSession())) continue;
            KtDiagnosticFactory0 factory2 = isError ? FirErrors.INSTANCE.getREPEATED_ANNOTATION() : FirErrors.INSTANCE.getREPEATED_ANNOTATION_WARNING();
            KtSourceElement ktSourceElement = annotation2.getSource();
            if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation2.getSource(), factory2, (DiagnosticContext)context2, null, 8, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean checkMultiFieldValueClassAnnotationRestrictions$hasNoReceivers(FirPropertyAccessor $this$checkMultiFieldValueClassAnnotationRestrictions_u24hasNoReceivers) {
        if (!$this$checkMultiFieldValueClassAnnotationRestrictions_u24hasNoReceivers.getContextReceivers().isEmpty()) return false;
        FirReceiverParameter firReceiverParameter = $this$checkMultiFieldValueClassAnnotationRestrictions_u24hasNoReceivers.getReceiverParameter();
        if ((firReceiverParameter != null ? firReceiverParameter.getTypeRef() : null) != null) return false;
        if ($this$checkMultiFieldValueClassAnnotationRestrictions_u24hasNoReceivers.getPropertySymbol().getResolvedReceiverTypeRef() != null) return false;
        if (!$this$checkMultiFieldValueClassAnnotationRestrictions_u24hasNoReceivers.getPropertySymbol().getResolvedContextReceivers().isEmpty()) return false;
        return true;
    }

    private static final boolean checkAnnotationTarget$check(Set<? extends KotlinTarget> applicableTargets, AnnotationUseSiteTarget useSiteTarget2, List<? extends KotlinTarget> targets) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = targets;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinTarget it = (KotlinTarget)((Object)element$iv);
                    boolean bl2 = false;
                    if (!(applicableTargets.contains((Object)it) && (useSiteTarget2 == null || KotlinTarget.Companion.getUSE_SITE_MAPPING().get((Object)useSiteTarget2) == it))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean checkAnnotationTarget$checkWithUseSiteTargets(AnnotationUseSiteTarget useSiteTarget2, AnnotationTargetList actualTargets, Set<? extends KotlinTarget> applicableTargets) {
        boolean bl;
        block4: {
            if (useSiteTarget2 == null) {
                return false;
            }
            KotlinTarget useSiteMapping = KotlinTarget.Companion.getUSE_SITE_MAPPING().get((Object)useSiteTarget2);
            Iterable $this$any$iv = actualTargets.getOnlyWithUseSiteTarget();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinTarget it = (KotlinTarget)((Object)element$iv);
                    boolean bl2 = false;
                    if (!(applicableTargets.contains((Object)it) && it == useSiteMapping)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ConeKotlinType> checkRepeatedAnnotationsInProperty$getAnnotationTypes(FirAnnotationContainer $this$checkRepeatedAnnotationsInProperty_u24getAnnotationTypes) {
        List list2;
        Object object = $this$checkRepeatedAnnotationsInProperty_u24getAnnotationTypes;
        if (object != null && (object = object.getAnnotations()) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FirAnnotation firAnnotation = (FirAnnotation)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(FirTypeUtilsKt.getConeType(it.getAnnotationTypeRef()));
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AnnotationUseSiteTarget.values().length];
            try {
                nArray[AnnotationUseSiteTarget.FIELD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.PROPERTY_DELEGATE_FIELD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.RECEIVER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.FILE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.PROPERTY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.PROPERTY_GETTER.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.PROPERTY_SETTER.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.CONSTRUCTOR_PARAMETER.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.SETTER_PARAMETER.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

