/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.graph.impl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import ksp.com.intellij.util.graph.Graph;
import ksp.com.intellij.util.graph.InboundSemiGraph;
import ksp.org.jetbrains.annotations.Nullable;

public class ShortestPathFinder<Node> {
    private final InboundSemiGraph<Node> myGraph;

    public ShortestPathFinder(Graph<Node> graph) {
        this.myGraph = graph;
    }

    public ShortestPathFinder(InboundSemiGraph<Node> graph) {
        this.myGraph = graph;
    }

    @Nullable
    public List<Node> findPath(Node start, Node finish) {
        HashMap nextNodes = new HashMap();
        ArrayDeque<Node> queue = new ArrayDeque<Node>();
        queue.addLast(finish);
        boolean found = false;
        while (!queue.isEmpty()) {
            Object node = queue.removeFirst();
            if (node.equals(start)) {
                found = true;
                break;
            }
            Iterator<Node> in = this.myGraph.getIn(node);
            while (in.hasNext()) {
                Node prev = in.next();
                if (nextNodes.containsKey(prev)) continue;
                nextNodes.put(prev, node);
                queue.addLast(prev);
            }
        }
        if (!found) {
            return null;
        }
        ArrayList<Node> path = new ArrayList<Node>();
        Object current = start;
        while (!current.equals(finish)) {
            path.add(current);
            current = nextNodes.get(current);
        }
        path.add(finish);
        return path;
    }
}

