/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.jvm.checkers;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.kotlin.config.JvmAnalysisFlags;
import ksp.org.jetbrains.kotlin.config.JvmTarget;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ModalityUtilsKt;
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import ksp.org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.name.JvmStandardClassIds;
import ksp.org.jetbrains.kotlin.psi.KtAnnotationEntry;
import ksp.org.jetbrains.kotlin.psi.KtClassOrObject;
import ksp.org.jetbrains.kotlin.psi.KtConstructor;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import ksp.org.jetbrains.kotlin.psi.KtElementImplStub;
import ksp.org.jetbrains.kotlin.psi.KtParameter;
import ksp.org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import ksp.org.jetbrains.kotlin.psi.KtProperty;
import ksp.org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.DescriptorUtils;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.jvm.JdkClassesKt;
import ksp.org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import ksp.org.jetbrains.kotlin.resolve.jvm.checkers.JvmRecordApplicabilityCheckerKt;
import ksp.org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lksp/org/jetbrains/kotlin/resolve/jvm/checkers/JvmRecordApplicabilityChecker;", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "jvmTarget", "Lksp/org/jetbrains/kotlin/config/JvmTarget;", "(Lorg/jetbrains/kotlin/config/JvmTarget;)V", "check", "", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend.java"})
@SourceDebugExtension(value={"SMAP\nJvmRecordApplicabilityChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmRecordApplicabilityChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/JvmRecordApplicabilityChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,169:1\n288#2,2:170\n*S KotlinDebug\n*F\n+ 1 JvmRecordApplicabilityChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/JvmRecordApplicabilityChecker\n*L\n45#1:170,2\n*E\n"})
public final class JvmRecordApplicabilityChecker
implements DeclarationChecker {
    @NotNull
    private final JvmTarget jvmTarget;

    public JvmRecordApplicabilityChecker(@NotNull JvmTarget jvmTarget) {
        Intrinsics.checkNotNullParameter(jvmTarget, "jvmTarget");
        this.jvmTarget = jvmTarget;
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        List<KtParameter> parameters2;
        Iterator<Object> modifierOrName;
        KtElementImplStub reportOn;
        Object element$iv22;
        block27: {
            PsiElement psiElement;
            block29: {
                block28: {
                    Object v2;
                    block26: {
                        Intrinsics.checkNotNullParameter(declaration2, "declaration");
                        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
                        Intrinsics.checkNotNullParameter(context2, "context");
                        if (!(descriptor2 instanceof ClassDescriptor) || !(declaration2 instanceof KtClassOrObject)) {
                            return;
                        }
                        for (KtSuperTypeListEntry supertypeEntry : ((KtClassOrObject)declaration2).getSuperTypeListEntries()) {
                            KotlinType supertype2 = (KotlinType)context2.getTrace().get(BindingContext.TYPE, supertypeEntry.getTypeReference());
                            Object object = supertype2;
                            if (!Intrinsics.areEqual(object != null && (object = ((KotlinType)object).getConstructor()) != null && (object = object.getDeclarationDescriptor()) != null ? DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)object) : null, JdkClassesKt.getJAVA_LANG_RECORD_FQ_NAME())) continue;
                            context2.getTrace().report(ErrorsJvm.ILLEGAL_JAVA_LANG_RECORD_SUPERTYPE.on(supertypeEntry));
                            return;
                        }
                        if (!JvmAnnotationUtilKt.isJvmRecord((ClassDescriptor)descriptor2)) {
                            return;
                        }
                        List<KtAnnotationEntry> list2 = ((KtClassOrObject)declaration2).getAnnotationEntries();
                        Intrinsics.checkNotNullExpressionValue(list2, "getAnnotationEntries(...)");
                        Iterable $this$firstOrNull$iv = list2;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv22 : $this$firstOrNull$iv) {
                            KtAnnotationEntry it = (KtAnnotationEntry)element$iv22;
                            boolean bl = false;
                            if (!Intrinsics.areEqual(it.getShortName(), JvmStandardClassIds.JVM_RECORD_ANNOTATION_FQ_NAME.shortName())) continue;
                            v2 = element$iv22;
                            break block26;
                        }
                        v2 = null;
                    }
                    KtAnnotationEntry ktAnnotationEntry = v2;
                    KtElementImplStub ktElementImplStub = reportOn = ktAnnotationEntry != null ? (KtElementImplStub)ktAnnotationEntry : (KtElementImplStub)((Object)declaration2);
                    if (DescriptorUtilsKt.resolveTopLevelClass(context2.getModuleDescriptor(), JdkClassesKt.getJAVA_LANG_RECORD_FQ_NAME(), NoLookupLocation.FOR_DEFAULT_IMPORTS) == null) {
                        context2.getTrace().report(ErrorsJvm.JVM_RECORD_REQUIRES_JDK15.on(reportOn));
                        return;
                    }
                    if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.JvmRecordSupport)) {
                        context2.getTrace().report(Errors.UNSUPPORTED_FEATURE.on(reportOn, TuplesKt.to(LanguageFeature.JvmRecordSupport, context2.getLanguageVersionSettings())));
                        return;
                    }
                    if (!JvmRecordApplicabilityCheckerKt.access$areRecordsAllowed(this.jvmTarget, context2.getLanguageVersionSettings().getFlag(JvmAnalysisFlags.getEnableJvmPreview()))) {
                        context2.getTrace().report(ErrorsJvm.JVM_RECORDS_ILLEGAL_BYTECODE_TARGET.on(reportOn));
                        return;
                    }
                    if (((ClassDescriptor)descriptor2).getKind() == ClassKind.ENUM_CLASS) {
                        PsiElement psiElement2 = ((KtClassOrObject)declaration2).getModifierList();
                        if ((psiElement2 == null || (psiElement2 = psiElement2.getModifier(KtTokens.ENUM_KEYWORD)) == null) && (psiElement2 = ((KtClassOrObject)declaration2).getNameIdentifier()) == null) {
                            psiElement2 = declaration2;
                        }
                        modifierOrName = psiElement2;
                        context2.getTrace().report(ErrorsJvm.ENUM_JVM_RECORD.on((PsiElement)((Object)modifierOrName)));
                        return;
                    }
                    if (ModalityUtilsKt.isFinalClass((ClassDescriptor)descriptor2)) break block27;
                    psiElement = ((KtClassOrObject)declaration2).getModifierList();
                    if (psiElement == null) break block28;
                    KtModifierKeywordToken[] ktModifierKeywordTokenArray = new KtModifierKeywordToken[3];
                    Intrinsics.checkNotNullExpressionValue(KtTokens.ABSTRACT_KEYWORD, "ABSTRACT_KEYWORD");
                    Intrinsics.checkNotNullExpressionValue(KtTokens.OPEN_KEYWORD, "OPEN_KEYWORD");
                    Intrinsics.checkNotNullExpressionValue(KtTokens.SEALED_KEYWORD, "SEALED_KEYWORD");
                    if ((psiElement = JvmRecordApplicabilityCheckerKt.access$findOneOfModifiers(psiElement, ktModifierKeywordTokenArray)) != null) break block29;
                }
                if ((psiElement = ((KtClassOrObject)declaration2).getNameIdentifier()) == null) {
                    psiElement = declaration2;
                }
            }
            modifierOrName = psiElement;
            context2.getTrace().report(ErrorsJvm.NON_FINAL_JVM_RECORD.on((PsiElement)((Object)modifierOrName)));
            return;
        }
        if (((ClassDescriptor)descriptor2).isInner()) {
            PsiElement psiElement = ((KtClassOrObject)declaration2).getModifierList();
            if ((psiElement == null || (psiElement = psiElement.getModifier(KtTokens.INNER_KEYWORD)) == null) && (psiElement = ((KtClassOrObject)declaration2).getNameIdentifier()) == null) {
                psiElement = declaration2;
            }
            modifierOrName = psiElement;
            context2.getTrace().report(ErrorsJvm.INNER_JVM_RECORD.on((PsiElement)((Object)modifierOrName)));
            return;
        }
        if (DescriptorUtils.isLocal(descriptor2)) {
            context2.getTrace().report(ErrorsJvm.LOCAL_JVM_RECORD.on(reportOn));
            return;
        }
        for (KtDeclaration member2 : ((KtClassOrObject)declaration2).getDeclarations()) {
            PropertyDescriptor propertyDescriptor;
            if (!(member2 instanceof KtProperty) || ((element$iv22 = context2.getTrace().get(BindingContext.DECLARATION_TO_DESCRIPTOR, member2)) instanceof PropertyDescriptor ? (PropertyDescriptor)element$iv22 : null) == null) continue;
            propertyDescriptor = propertyDescriptor;
            if (!Intrinsics.areEqual(context2.getTrace().getBindingContext().get(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor), true) && ((KtProperty)member2).getDelegate() == null) continue;
            context2.getTrace().report(ErrorsJvm.FIELD_IN_JVM_RECORD.on(member2));
            return;
        }
        for (KtSuperTypeListEntry superTypeEntry : ((KtClassOrObject)declaration2).getSuperTypeListEntries()) {
            if (!(superTypeEntry instanceof KtDelegatedSuperTypeEntry)) continue;
            context2.getTrace().report(ErrorsJvm.DELEGATION_BY_IN_JVM_RECORD.on(superTypeEntry));
            return;
        }
        for (KotlinType supertype2 : ((ClassDescriptor)descriptor2).getTypeConstructor().getSupertypes()) {
            ClassDescriptor classDescriptor2;
            element$iv22 = supertype2.getConstructor().getDeclarationDescriptor();
            ClassDescriptor classDescriptor3 = element$iv22 instanceof ClassDescriptor ? (ClassDescriptor)element$iv22 : null;
            if (classDescriptor3 == null || (classDescriptor2 = classDescriptor3).getKind() == ClassKind.INTERFACE || Intrinsics.areEqual(DescriptorUtilsKt.getFqNameSafe(classDescriptor2), JdkClassesKt.getJAVA_LANG_RECORD_FQ_NAME())) continue;
            PsiElement psiElement = ((KtClassOrObject)declaration2).getNameIdentifier();
            if (psiElement == null) {
                psiElement = declaration2;
            }
            PsiElement reportSupertypeOn = psiElement;
            context2.getTrace().report(ErrorsJvm.JVM_RECORD_EXTENDS_CLASS.on(reportSupertypeOn, supertype2));
            return;
        }
        if (!((ClassDescriptor)descriptor2).isData()) {
            context2.getTrace().report(ErrorsJvm.NON_DATA_CLASS_JVM_RECORD.on(reportOn));
            return;
        }
        KtPrimaryConstructor primaryConstructor2 = ((KtClassOrObject)declaration2).getPrimaryConstructor();
        Object object = primaryConstructor2;
        if (object == null || (object = ((KtConstructor)object).getValueParameters()) == null) {
            object = CollectionsKt.emptyList();
        }
        if ((parameters2 = object).isEmpty()) {
            PsiElement psiElement;
            KtElementImplStub ktElementImplStub = primaryConstructor2;
            PsiElement psiElement3 = ktElementImplStub != null && (ktElementImplStub = ktElementImplStub.getValueParameterList()) != null ? (PsiElement)ktElementImplStub : (psiElement = ((KtClassOrObject)declaration2).getNameIdentifier());
            if (psiElement != null) {
                PsiElement it = psiElement;
                boolean bl = false;
                context2.getTrace().report(ErrorsJvm.JVM_RECORD_WITHOUT_PRIMARY_CONSTRUCTOR_PARAMETERS.on(it));
                return;
            }
        }
        for (KtParameter parameter2 : parameters2) {
            if (parameter2.hasValOrVar() && !parameter2.isMutable()) continue;
            context2.getTrace().report(ErrorsJvm.JVM_RECORD_NOT_VAL_PARAMETER.on(parameter2));
            return;
        }
        for (KtParameter parameter2 : CollectionsKt.dropLast(parameters2, 1)) {
            if (!parameter2.isVarArg()) continue;
            context2.getTrace().report(ErrorsJvm.JVM_RECORD_NOT_LAST_VARARG_PARAMETER.on(parameter2));
            return;
        }
    }
}

