/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.jvm.checkers;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.load.java.descriptors.JavaMethodDescriptor;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtModifierList;
import ksp.org.jetbrains.kotlin.psi.KtModifierListOwner;
import ksp.org.jetbrains.kotlin.resolve.OverridingUtil;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.jvm.checkers.JavaNullabilityChecker;
import ksp.org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.TypeProjection;
import ksp.org.jetbrains.kotlin.types.TypeSubstitution;
import ksp.org.jetbrains.kotlin.types.TypeSubstitutor;
import ksp.org.jetbrains.kotlin.types.TypeWithEnhancementKt;
import ksp.org.jetbrains.kotlin.types.UnwrappedType;
import ksp.org.jetbrains.kotlin.types.Variance;
import ksp.org.jetbrains.kotlin.types.checker.KotlinTypePreparator;
import ksp.org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lksp/org/jetbrains/kotlin/resolve/jvm/checkers/JavaOverrideWithWrongNullabilityOverrideChecker;", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "typePreparatorUnwrappingEnhancement", "Lksp/org/jetbrains/kotlin/types/checker/KotlinTypePreparator;", "check", "", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend.java"})
public final class JavaOverrideWithWrongNullabilityOverrideChecker
implements DeclarationChecker {
    @NotNull
    public static final JavaOverrideWithWrongNullabilityOverrideChecker INSTANCE = new JavaOverrideWithWrongNullabilityOverrideChecker();
    @NotNull
    private static final KotlinTypePreparator typePreparatorUnwrappingEnhancement = new KotlinTypePreparator(){

        public UnwrappedType prepareType(KotlinTypeMarker type2) {
            Intrinsics.checkNotNullParameter(type2, "type");
            UnwrappedType it = super.prepareType(type2);
            boolean bl = false;
            KotlinType kotlinType = TypeWithEnhancementKt.getEnhancementDeeply(it);
            if (kotlinType == null) {
                kotlinType = it;
            }
            return kotlinType.unwrap();
        }
    };

    private JavaOverrideWithWrongNullabilityOverrideChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        boolean hasOverrideNode;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (!(descriptor2 instanceof CallableMemberDescriptor)) {
            return;
        }
        if (((CallableMemberDescriptor)descriptor2).getOverriddenDescriptors().isEmpty()) {
            return;
        }
        KtModifierList modifierList2 = declaration2.getModifierList();
        boolean bl = hasOverrideNode = modifierList2 != null && modifierList2.hasModifier(KtTokens.OVERRIDE_KEYWORD);
        if (!hasOverrideNode) {
            return;
        }
        DeclarationDescriptor declarationDescriptor = ((CallableMemberDescriptor)descriptor2).getContainingDeclaration();
        ClassDescriptor classDescriptor2 = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (classDescriptor2 == null) {
            return;
        }
        ClassDescriptor containingClass = classDescriptor2;
        for (CallableMemberDescriptor callableMemberDescriptor : ((CallableMemberDescriptor)descriptor2).getOverriddenDescriptors()) {
            FunctionDescriptor unwrappedOverridden2;
            OverridingUtil overridingUtilWithEnhancementUnwrapped2;
            if (!(callableMemberDescriptor instanceof JavaMethodDescriptor)) continue;
            Set relatedTypeParameters = new LinkedHashSet();
            Intrinsics.checkNotNullExpressionValue(OverridingUtil.createWithTypePreparatorAndCustomSubtype(typePreparatorUnwrappingEnhancement, new Function2<KotlinType, KotlinType, Boolean>((Set<TypeParameterDescriptor>)relatedTypeParameters){
                final /* synthetic */ Set<TypeParameterDescriptor> $relatedTypeParameters;
                {
                    this.$relatedTypeParameters = $relatedTypeParameters;
                    super(2);
                }

                public final Boolean invoke(KotlinType subtype, KotlinType supertype2) {
                    Intrinsics.checkNotNull(subtype);
                    Intrinsics.checkNotNull(supertype2);
                    boolean bl = JavaNullabilityChecker.Companion.isNullableTypeAgainstNotNullTypeParameter(subtype, supertype2);
                    Set<TypeParameterDescriptor> set = this.$relatedTypeParameters;
                    boolean it = bl;
                    boolean bl2 = false;
                    if (it) {
                        ClassifierDescriptor classifierDescriptor = subtype.getConstructor().getDeclarationDescriptor();
                        ksp.org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull((Collection)set, classifierDescriptor instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)classifierDescriptor : null);
                    }
                    return !bl;
                }
            }), "createWithTypePreparatorAndCustomSubtype(...)");
            if (overridingUtilWithEnhancementUnwrapped2.isOverridableBy(callableMemberDescriptor, (CallableDescriptor)descriptor2, containingClass, true).getResult() == OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE || OverridingUtil.DEFAULT.isOverridableBy(callableMemberDescriptor, (CallableDescriptor)descriptor2, containingClass, true).getResult() != OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE) continue;
            FunctionDescriptor functionDescriptor = ((JavaMethodDescriptor)callableMemberDescriptor).substitute(TypeSubstitutor.create(new TypeSubstitution(){

                public TypeProjection get(KotlinType key) {
                    Intrinsics.checkNotNullParameter(key, "key");
                    return null;
                }

                public KotlinType prepareTopLevelType(KotlinType topLevelType, Variance position) {
                    Intrinsics.checkNotNullParameter(topLevelType, "topLevelType");
                    Intrinsics.checkNotNullParameter((Object)((Object)position), "position");
                    KotlinType kotlinType = TypeWithEnhancementKt.getEnhancementDeeply(topLevelType);
                    if (kotlinType == null) {
                        kotlinType = topLevelType;
                    }
                    return kotlinType;
                }
            }));
            if (functionDescriptor == null) {
                functionDescriptor = unwrappedOverridden2 = (FunctionDescriptor)callableMemberDescriptor;
            }
            if (!((Collection)relatedTypeParameters).isEmpty()) {
                context2.getTrace().report(ErrorsJvm.WRONG_TYPE_PARAMETER_NULLABILITY_FOR_JAVA_OVERRIDE.on((KtModifierListOwner)((PsiElement)declaration2), (TypeParameterDescriptor)CollectionsKt.first(relatedTypeParameters)));
                break;
            }
            context2.getTrace().report(ErrorsJvm.WRONG_NULLABILITY_FOR_JAVA_OVERRIDE.on((KtModifierListOwner)((PsiElement)declaration2), (CallableMemberDescriptor)descriptor2, unwrappedOverridden2));
            break;
        }
    }
}

