/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.jvm.checkers;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.annotations.Annotated;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.psi.KtBinaryExpression;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import ksp.org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lksp/org/jetbrains/kotlin/resolve/jvm/checkers/InconsistentOperatorFromJavaCallChecker;", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "CONCURRENT_HASH_MAP_FQ_NAME", "Lksp/org/jetbrains/kotlin/name/FqName;", "check", "", "resolvedCall", "Lksp/org/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lksp/com/intellij/psi/PsiElement;", "context", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend.java"})
public final class InconsistentOperatorFromJavaCallChecker
implements CallChecker {
    @NotNull
    public static final InconsistentOperatorFromJavaCallChecker INSTANCE = new InconsistentOperatorFromJavaCallChecker();
    @NotNull
    private static final FqName CONCURRENT_HASH_MAP_FQ_NAME = new FqName("java.util.concurrent.ConcurrentHashMap");

    private InconsistentOperatorFromJavaCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context2, "context");
        Object candidateDescriptor = resolvedCall2.getCandidateDescriptor();
        if (!Intrinsics.areEqual(candidateDescriptor.getName(), OperatorNameConventions.CONTAINS)) {
            return;
        }
        List<ValueParameterDescriptor> list2 = candidateDescriptor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "getValueParameters(...)");
        Annotated annotated = CollectionsKt.singleOrNull(list2);
        if (!(annotated != null && (annotated = annotated.getType()) != null ? TypeUtilsKt.isAnyOrNullableAny((KotlinType)annotated) : false)) {
            return;
        }
        if (!(resolvedCall2.getCall().getCallElement() instanceof KtBinaryExpression) || !resolvedCall2.getStatus().possibleTransformToSuccess()) {
            return;
        }
        Iterator<?> iterator2 = DescriptorUtilsKt.overriddenTreeUniqueAsSequence(candidateDescriptor, false).iterator();
        while (iterator2.hasNext()) {
            ClassDescriptor containingClass;
            CallableDescriptor callableDescriptor = (CallableDescriptor)iterator2.next();
            DeclarationDescriptor declarationDescriptor = callableDescriptor.getContainingDeclaration();
            ClassDescriptor classDescriptor2 = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
            if (classDescriptor2 == null || !Intrinsics.areEqual(DescriptorUtilsKt.fqNameOrNull(containingClass = classDescriptor2), CONCURRENT_HASH_MAP_FQ_NAME)) continue;
            context2.getTrace().report(ErrorsJvm.CONCURRENT_HASH_MAP_CONTAINS_OPERATOR.on(context2.getLanguageVersionSettings(), reportOn));
            break;
        }
    }
}

