/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.jvm.checkers;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtNamedDeclaration;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lksp/org/jetbrains/kotlin/resolve/jvm/checkers/FunctionDelegateMemberNameClashChecker;", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend.java"})
public final class FunctionDelegateMemberNameClashChecker
implements DeclarationChecker {
    @NotNull
    public static final FunctionDelegateMemberNameClashChecker INSTANCE = new FunctionDelegateMemberNameClashChecker();

    private FunctionDelegateMemberNameClashChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter(declaration2, "declaration");
                Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
                Intrinsics.checkNotNullParameter(context2, "context");
                if (!(descriptor2 instanceof CallableMemberDescriptor)) {
                    return;
                }
                DeclarationDescriptor declarationDescriptor = ((CallableMemberDescriptor)descriptor2).getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getContainingDeclaration(...)");
                DeclarationDescriptor container2 = declarationDescriptor;
                if (!(container2 instanceof ClassDescriptor) || !((ClassDescriptor)container2).isFun()) {
                    return;
                }
                if (((CallableMemberDescriptor)descriptor2).getExtensionReceiverParameter() != null) break block7;
                List<ValueParameterDescriptor> list2 = ((CallableMemberDescriptor)descriptor2).getValueParameters();
                Intrinsics.checkNotNullExpressionValue(list2, "getValueParameters(...)");
                if (!(!((Collection)list2).isEmpty())) break block8;
            }
            return;
        }
        if (descriptor2 instanceof FunctionDescriptor && Intrinsics.areEqual(((FunctionDescriptor)descriptor2).getName().asString(), "getFunctionDelegate") || descriptor2 instanceof PropertyDescriptor && Intrinsics.areEqual(((PropertyDescriptor)descriptor2).getName().asString(), "functionDelegate")) {
            PsiElement psiElement = declaration2 instanceof KtNamedDeclaration ? (KtNamedDeclaration)declaration2 : null;
            if (psiElement == null || (psiElement = psiElement.getNameIdentifier()) == null) {
                psiElement = declaration2;
            }
            PsiElement reportOn = psiElement;
            context2.getTrace().report(ErrorsJvm.FUNCTION_DELEGATE_MEMBER_NAME_CLASH.on(reportOn));
        }
    }
}

