/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.FieldDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.psi.KtAnnotationEntry;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lksp/org/jetbrains/kotlin/resolve/checkers/VolatileAnnotationChecker;", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "CONCURRENT_VOLATILE_ANNOTATION_FQ_NAME", "Lksp/org/jetbrains/kotlin/name/FqName;", "JVM_VOLATILE_ANNOTATION_FQ_NAME", "check", "", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "findVolatileAnnotation", "Lksp/org/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "Lksp/org/jetbrains/kotlin/descriptors/FieldDescriptor;", "frontend"})
@SourceDebugExtension(value={"SMAP\nVolatileAnnotationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VolatileAnnotationChecker.kt\norg/jetbrains/kotlin/resolve/checkers/VolatileAnnotationChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,41:1\n288#2,2:42\n*S KotlinDebug\n*F\n+ 1 VolatileAnnotationChecker.kt\norg/jetbrains/kotlin/resolve/checkers/VolatileAnnotationChecker\n*L\n38#1:42,2\n*E\n"})
public final class VolatileAnnotationChecker
implements DeclarationChecker {
    @NotNull
    public static final VolatileAnnotationChecker INSTANCE = new VolatileAnnotationChecker();
    @NotNull
    private static final FqName JVM_VOLATILE_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.Volatile");
    @NotNull
    private static final FqName CONCURRENT_VOLATILE_ANNOTATION_FQ_NAME = new FqName("kotlin.concurrent.Volatile");

    private VolatileAnnotationChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        AnnotationDescriptor delegateAnnotation;
        AnnotationDescriptor fieldAnnotation;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (!(descriptor2 instanceof PropertyDescriptor)) {
            return;
        }
        FieldDescriptor fieldDescriptor = ((PropertyDescriptor)descriptor2).getBackingField();
        AnnotationDescriptor annotationDescriptor = fieldAnnotation = fieldDescriptor != null ? this.findVolatileAnnotation(fieldDescriptor) : null;
        if (fieldAnnotation != null && !((PropertyDescriptor)descriptor2).isVar()) {
            KtAnnotationEntry ktAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(fieldAnnotation);
            if (ktAnnotationEntry == null) {
                return;
            }
            KtAnnotationEntry annotationEntry2 = ktAnnotationEntry;
            context2.getTrace().report(Errors.VOLATILE_ON_VALUE.on((KtAnnotationEntry)((PsiElement)annotationEntry2)));
        }
        FieldDescriptor fieldDescriptor2 = ((PropertyDescriptor)descriptor2).getDelegateField();
        AnnotationDescriptor annotationDescriptor2 = delegateAnnotation = fieldDescriptor2 != null ? this.findVolatileAnnotation(fieldDescriptor2) : null;
        if (delegateAnnotation != null) {
            KtAnnotationEntry ktAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(delegateAnnotation);
            if (ktAnnotationEntry == null) {
                return;
            }
            KtAnnotationEntry annotationEntry3 = ktAnnotationEntry;
            context2.getTrace().report(Errors.VOLATILE_ON_DELEGATE.on((KtAnnotationEntry)((PsiElement)annotationEntry3)));
        }
    }

    private final AnnotationDescriptor findVolatileAnnotation(FieldDescriptor $this$findVolatileAnnotation) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = $this$findVolatileAnnotation.getAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AnnotationDescriptor it = (AnnotationDescriptor)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual(it.getFqName(), JVM_VOLATILE_ANNOTATION_FQ_NAME) || Intrinsics.areEqual(it.getFqName(), CONCURRENT_VOLATILE_ANNOTATION_FQ_NAME))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }
}

