/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.kotlin.config.ApiVersion;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.resolve.AnnotationsKt;
import ksp.org.jetbrains.kotlin.resolve.checkers.KotlinVersionStringAnnotationValueChecker;
import ksp.org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lksp/org/jetbrains/kotlin/resolve/checkers/SinceKotlinAnnotationValueChecker;", "Lksp/org/jetbrains/kotlin/resolve/checkers/KotlinVersionStringAnnotationValueChecker;", "()V", "extraCheck", "", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtDeclaration;", "annotation", "Lksp/org/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "version", "", "diagnosticHolder", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticSink;", "languageVersionSettings", "Lksp/org/jetbrains/kotlin/config/LanguageVersionSettings;", "frontend"})
public final class SinceKotlinAnnotationValueChecker
extends KotlinVersionStringAnnotationValueChecker {
    @NotNull
    public static final SinceKotlinAnnotationValueChecker INSTANCE = new SinceKotlinAnnotationValueChecker();

    private SinceKotlinAnnotationValueChecker() {
        super(AnnotationsKt.getSINCE_KOTLIN_FQ_NAME());
    }

    @Override
    public void extraCheck(@NotNull KtDeclaration declaration2, @NotNull AnnotationDescriptor annotation2, @NotNull String version, @NotNull DiagnosticSink diagnosticHolder, @NotNull LanguageVersionSettings languageVersionSettings2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(annotation2, "annotation");
        Intrinsics.checkNotNullParameter(version, "version");
        Intrinsics.checkNotNullParameter(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkNotNullParameter(languageVersionSettings2, "languageVersionSettings");
        ApiVersion apiVersion = ApiVersion.Companion.parse(version);
        ApiVersion specified = languageVersionSettings2.getApiVersion();
        if (apiVersion != null && apiVersion.compareTo(specified) > 0) {
            PsiElement psiElement = PsiSourceElementKt.getPsi(annotation2.getSource());
            if (psiElement == null) {
                psiElement = declaration2;
            }
            diagnosticHolder.report(Errors.NEWER_VERSION_IN_SINCE_KOTLIN.on(psiElement, specified.getVersionString()));
        }
    }
}

