/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.checkers;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.kotlin.config.AnalysisFlags;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtTypeParameter;
import ksp.org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.BindingTrace;
import ksp.org.jetbrains.kotlin.resolve.MissingSupertypesResolver;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\u0011"}, d2={"Lksp/org/jetbrains/kotlin/resolve/checkers/MissingDependencySupertypeChecker;", "", "()V", "checkSupertypes", "", "declaration", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "reportOn", "Lksp/com/intellij/psi/PsiElement;", "trace", "Lksp/org/jetbrains/kotlin/resolve/BindingTrace;", "missingSupertypesResolver", "Lksp/org/jetbrains/kotlin/resolve/MissingSupertypesResolver;", "classifierType", "Lksp/org/jetbrains/kotlin/types/KotlinType;", "ForCalls", "ForDeclarations", "frontend"})
public final class MissingDependencySupertypeChecker {
    @NotNull
    public static final MissingDependencySupertypeChecker INSTANCE = new MissingDependencySupertypeChecker();

    private MissingDependencySupertypeChecker() {
    }

    public final boolean checkSupertypes(@NotNull KotlinType classifierType, @NotNull PsiElement reportOn, @NotNull BindingTrace trace, @NotNull MissingSupertypesResolver missingSupertypesResolver) {
        Intrinsics.checkNotNullParameter(classifierType, "classifierType");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(missingSupertypesResolver, "missingSupertypesResolver");
        return this.checkSupertypes(classifierType.getConstructor().getDeclarationDescriptor(), reportOn, trace, missingSupertypesResolver);
    }

    public final boolean checkSupertypes(@Nullable DeclarationDescriptor declaration2, @NotNull PsiElement reportOn, @NotNull BindingTrace trace, @NotNull MissingSupertypesResolver missingSupertypesResolver) {
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(missingSupertypesResolver, "missingSupertypesResolver");
        if (!(declaration2 instanceof ClassifierDescriptor)) {
            return false;
        }
        Set<ClassifierDescriptor> missingSupertypes = missingSupertypesResolver.getMissingSuperClassifiers((ClassifierDescriptor)declaration2);
        for (ClassifierDescriptor missingClassifier : missingSupertypes) {
            trace.report(Errors.MISSING_DEPENDENCY_SUPERCLASS.on(reportOn, DescriptorUtilsKt.getFqNameSafe(missingClassifier), DescriptorUtilsKt.getFqNameSafe(declaration2)));
        }
        return !((Collection)missingSupertypes).isEmpty();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lksp/org/jetbrains/kotlin/resolve/checkers/MissingDependencySupertypeChecker$ForCalls;", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "declaration", "Lksp/org/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "Lksp/org/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "getDeclaration", "(Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;)Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "check", "", "resolvedCall", "Lksp/org/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lksp/com/intellij/psi/PsiElement;", "context", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
    public static final class ForCalls
    implements CallChecker {
        @NotNull
        public static final ForCalls INSTANCE = new ForCalls();

        private ForCalls() {
        }

        @Override
        public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
            boolean unresolvedLazySupertypesByDefault;
            Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
            Intrinsics.checkNotNullParameter(reportOn, "reportOn");
            Intrinsics.checkNotNullParameter(context2, "context");
            Object descriptor2 = resolvedCall2.getResultingDescriptor();
            ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getDispatchReceiverParameter();
            boolean errorReported = INSTANCE.checkSupertypes(receiverParameterDescriptor != null ? this.getDeclaration(receiverParameterDescriptor) : null, reportOn, context2.getTrace(), context2.getMissingSupertypesResolver());
            boolean eagerChecksAllowed = context2.getLanguageVersionSettings().getFlag(AnalysisFlags.getExtendedCompilerChecks());
            boolean bl = unresolvedLazySupertypesByDefault = descriptor2 instanceof ConstructorDescriptor || descriptor2 instanceof FakeCallableDescriptorForObject;
            if (eagerChecksAllowed || !unresolvedLazySupertypesByDefault && !errorReported) {
                INSTANCE.checkSupertypes(descriptor2.getContainingDeclaration(), reportOn, context2.getTrace(), context2.getMissingSupertypesResolver());
                ReceiverParameterDescriptor receiverParameterDescriptor2 = descriptor2.getExtensionReceiverParameter();
                INSTANCE.checkSupertypes(receiverParameterDescriptor2 != null ? this.getDeclaration(receiverParameterDescriptor2) : null, reportOn, context2.getTrace(), context2.getMissingSupertypesResolver());
            }
        }

        private final ClassifierDescriptor getDeclaration(ReceiverParameterDescriptor $this$declaration) {
            return $this$declaration.getValue().getType().getConstructor().getDeclarationDescriptor();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lksp/org/jetbrains/kotlin/resolve/checkers/MissingDependencySupertypeChecker$ForDeclarations;", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend"})
    public static final class ForDeclarations
    implements DeclarationChecker {
        @NotNull
        public static final ForDeclarations INSTANCE = new ForDeclarations();

        private ForDeclarations() {
        }

        @Override
        public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            Intrinsics.checkNotNullParameter(context2, "context");
            BindingTrace trace = context2.getTrace();
            if (descriptor2 instanceof ClassDescriptor) {
                INSTANCE.checkSupertypes(descriptor2, (PsiElement)declaration2, trace, context2.getMissingSupertypesResolver());
            }
            if (declaration2 instanceof KtTypeParameterListOwner) {
                for (KtTypeParameter ktTypeParameter : ((KtTypeParameterListOwner)declaration2).getTypeParameters()) {
                    TypeParameterDescriptor typeParameterDescriptor;
                    if ((TypeParameterDescriptor)trace.getBindingContext().get(BindingContext.TYPE_PARAMETER, ktTypeParameter) == null) continue;
                    for (KotlinType upperBound : typeParameterDescriptor.getUpperBounds()) {
                        Intrinsics.checkNotNull(upperBound);
                        Intrinsics.checkNotNull(ktTypeParameter);
                        INSTANCE.checkSupertypes(upperBound, (PsiElement)ktTypeParameter, trace, context2.getMissingSupertypesResolver());
                    }
                }
            }
        }
    }
}

