/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.checkers;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.NotFoundClasses;
import ksp.org.jetbrains.kotlin.descriptors.SourceElement;
import ksp.org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.Diagnostic;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.resolve.BindingTrace;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerKt;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.checkers.ClassifierUsageChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.ClassifierUsageCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import ksp.org.jetbrains.kotlin.serialization.deserialization.IncompatibleVersionErrorData;
import ksp.org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerAbiStability;
import ksp.org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource;
import ksp.org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedMemberDescriptor;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\u0012\u001a\u0004\u0018\u00010\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0016"}, d2={"Lksp/org/jetbrains/kotlin/resolve/checkers/MissingDependencyClassChecker;", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lksp/org/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lksp/com/intellij/psi/PsiElement;", "context", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "collectDiagnostics", "", "Lksp/org/jetbrains/kotlin/diagnostics/Diagnostic;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/CallableDescriptor;", "diagnosticFor", "Lksp/org/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "incompatibilityDiagnosticFor", "source", "Lksp/org/jetbrains/kotlin/descriptors/SourceElement;", "ClassifierUsage", "frontend"})
@SourceDebugExtension(value={"SMAP\nMissingDependencyClassChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MissingDependencyClassChecker.kt\norg/jetbrains/kotlin/resolve/checkers/MissingDependencyClassChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n1#2:105\n1853#3,2:106\n*S KotlinDebug\n*F\n+ 1 MissingDependencyClassChecker.kt\norg/jetbrains/kotlin/resolve/checkers/MissingDependencyClassChecker\n*L\n90#1:106,2\n*E\n"})
public final class MissingDependencyClassChecker
implements CallChecker {
    @NotNull
    public static final MissingDependencyClassChecker INSTANCE = new MissingDependencyClassChecker();

    private MissingDependencyClassChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        block1: {
            Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
            Intrinsics.checkNotNullParameter(reportOn, "reportOn");
            Intrinsics.checkNotNullParameter(context2, "context");
            Object resultingDescriptor = resolvedCall2.getResultingDescriptor();
            Intrinsics.checkNotNull(resultingDescriptor);
            for (Diagnostic diagnostic : this.collectDiagnostics(reportOn, (CallableDescriptor)resultingDescriptor)) {
                context2.getTrace().report(diagnostic);
            }
            DeserializedMemberDescriptor deserializedMemberDescriptor = resultingDescriptor instanceof DeserializedMemberDescriptor ? (DeserializedMemberDescriptor)resultingDescriptor : null;
            DeserializedContainerSource containerSource = deserializedMemberDescriptor != null ? deserializedMemberDescriptor.getContainerSource() : null;
            Diagnostic diagnostic = this.incompatibilityDiagnosticFor(containerSource, reportOn);
            if (diagnostic == null) break block1;
            Diagnostic diagnostic2 = diagnostic;
            BindingTrace bindingTrace = context2.getTrace();
            Diagnostic p0 = diagnostic2;
            boolean bl = false;
            bindingTrace.report(p0);
        }
    }

    private final Diagnostic diagnosticFor(ClassifierDescriptor descriptor2, PsiElement reportOn) {
        if (descriptor2 instanceof NotFoundClasses.MockClassDescriptor) {
            return Errors.MISSING_DEPENDENCY_CLASS.on(reportOn, DescriptorUtilsKt.getFqNameSafe(descriptor2));
        }
        return this.incompatibilityDiagnosticFor(descriptor2.getSource(), reportOn);
    }

    private final Diagnostic incompatibilityDiagnosticFor(SourceElement source, PsiElement reportOn) {
        if (source instanceof DeserializedContainerSource) {
            IncompatibleVersionErrorData<?> incompatibility = ((DeserializedContainerSource)source).getIncompatibility();
            if (incompatibility != null) {
                return Errors.INCOMPATIBLE_CLASS.on(reportOn, ((DeserializedContainerSource)source).getPresentableString(), incompatibility);
            }
            if (((DeserializedContainerSource)source).isPreReleaseInvisible()) {
                return Errors.PRE_RELEASE_CLASS.on(reportOn, ((DeserializedContainerSource)source).getPresentableString());
            }
            if (((DeserializedContainerSource)source).getAbiStability() == DeserializedContainerAbiStability.UNSTABLE) {
                return Errors.IR_WITH_UNSTABLE_ABI_COMPILED_CLASS.on(reportOn, ((DeserializedContainerSource)source).getPresentableString());
            }
        }
        return null;
    }

    private final Set<Diagnostic> collectDiagnostics(PsiElement reportOn, CallableDescriptor descriptor2) {
        Object object;
        Set result2 = CollectionsKt.newLinkedHashSetWithExpectedSize(1);
        KotlinType kotlinType = descriptor2.getReturnType();
        if (kotlinType != null) {
            KotlinType p0 = kotlinType;
            boolean bl = false;
            MissingDependencyClassChecker.collectDiagnostics$consider$2(reportOn, result2, p0);
        }
        if ((object = descriptor2.getExtensionReceiverParameter()) != null && (object = object.getValue()) != null && (object = object.getType()) != null) {
            Object p0 = object;
            boolean bl = false;
            MissingDependencyClassChecker.collectDiagnostics$consider$2(reportOn, result2, (KotlinType)p0);
        }
        List<ValueParameterDescriptor> list2 = descriptor2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "getValueParameters(...)");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
            boolean bl = false;
            KotlinType kotlinType2 = it.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType2, "getType(...)");
            MissingDependencyClassChecker.collectDiagnostics$consider$2(reportOn, result2, kotlinType2);
        }
        return result2;
    }

    private static final void collectDiagnostics$consider(PsiElement $reportOn, Set<Diagnostic> result2, ClassDescriptor classDescriptor2) {
        block1: {
            Diagnostic diagnostic = INSTANCE.diagnosticFor(classDescriptor2, $reportOn);
            if (diagnostic != null) {
                result2.add(diagnostic);
                return;
            }
            DeclarationDescriptor declarationDescriptor = classDescriptor2.getContainingDeclaration();
            ClassDescriptor classDescriptor3 = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
            if (classDescriptor3 == null) break block1;
            ClassDescriptor p0 = classDescriptor3;
            boolean bl = false;
            MissingDependencyClassChecker.collectDiagnostics$consider($reportOn, result2, p0);
        }
    }

    private static final void collectDiagnostics$consider$2(PsiElement $reportOn, Set<Diagnostic> result2, KotlinType type2) {
        block1: {
            if (CallCheckerKt.isComputingDeferredType(INSTANCE, type2)) break block1;
            ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
            ClassDescriptor classDescriptor2 = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
            if (classDescriptor2 != null) {
                ClassDescriptor p0 = classDescriptor2;
                boolean bl = false;
                MissingDependencyClassChecker.collectDiagnostics$consider($reportOn, result2, p0);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lksp/org/jetbrains/kotlin/resolve/checkers/MissingDependencyClassChecker$ClassifierUsage;", "Lksp/org/jetbrains/kotlin/resolve/checkers/ClassifierUsageChecker;", "()V", "check", "", "targetDescriptor", "Lksp/org/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "element", "Lksp/com/intellij/psi/PsiElement;", "context", "Lksp/org/jetbrains/kotlin/resolve/checkers/ClassifierUsageCheckerContext;", "frontend"})
    @SourceDebugExtension(value={"SMAP\nMissingDependencyClassChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MissingDependencyClassChecker.kt\norg/jetbrains/kotlin/resolve/checkers/MissingDependencyClassChecker$ClassifierUsage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n1#2:105\n*E\n"})
    public static final class ClassifierUsage
    implements ClassifierUsageChecker {
        @NotNull
        public static final ClassifierUsage INSTANCE = new ClassifierUsage();

        private ClassifierUsage() {
        }

        @Override
        public void check(@NotNull ClassifierDescriptor targetDescriptor, @NotNull PsiElement element2, @NotNull ClassifierUsageCheckerContext context2) {
            block1: {
                Object object;
                Intrinsics.checkNotNullParameter(targetDescriptor, "targetDescriptor");
                Intrinsics.checkNotNullParameter(element2, "element");
                Intrinsics.checkNotNullParameter(context2, "context");
                Diagnostic diagnostic = INSTANCE.diagnosticFor(targetDescriptor, element2);
                if (diagnostic != null) {
                    Diagnostic diagnostic2 = diagnostic;
                    object = context2.getTrace();
                    Diagnostic p0 = diagnostic2;
                    boolean bl = false;
                    object.report(p0);
                }
                DeserializedMemberDescriptor deserializedMemberDescriptor = targetDescriptor instanceof DeserializedMemberDescriptor ? (DeserializedMemberDescriptor)((Object)targetDescriptor) : null;
                DeserializedContainerSource containerSource = deserializedMemberDescriptor != null ? deserializedMemberDescriptor.getContainerSource() : null;
                Diagnostic diagnostic3 = INSTANCE.incompatibilityDiagnosticFor(containerSource, element2);
                if (diagnostic3 == null) break block1;
                object = diagnostic3;
                BindingTrace bindingTrace = context2.getTrace();
                Object p0 = object;
                boolean bl = false;
                bindingTrace.report((Diagnostic)p0);
            }
        }
    }
}

