/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.checkers;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtProperty;
import ksp.org.jetbrains.kotlin.psi.KtTypeParameter;
import ksp.org.jetbrains.kotlin.psi.KtTypeParameterList;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lksp/org/jetbrains/kotlin/resolve/checkers/LocalVariableTypeParametersChecker;", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend"})
public final class LocalVariableTypeParametersChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (!(declaration2 instanceof KtProperty) || !(descriptor2 instanceof LocalVariableDescriptor)) {
            return;
        }
        List<KtTypeParameter> list2 = ((KtProperty)declaration2).getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "getTypeParameters(...)");
        List<KtTypeParameter> typeParameters2 = list2;
        KtTypeParameterList typeParametersList = ((KtProperty)declaration2).getTypeParameterList();
        if (typeParameters2.isEmpty() || typeParametersList == null) {
            return;
        }
        DiagnosticFactory0<KtTypeParameterList> diagnostic = context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProhibitTypeParametersForLocalVariables) ? Errors.LOCAL_VARIABLE_WITH_TYPE_PARAMETERS : Errors.LOCAL_VARIABLE_WITH_TYPE_PARAMETERS_WARNING;
        context2.getTrace().report(diagnostic.on((KtTypeParameterList)((PsiElement)typeParametersList)));
    }
}

