/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.SourceElement;
import ksp.org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.psi.KtClass;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtElementImplStub;
import ksp.org.jetbrains.kotlin.psi.KtNamedFunction;
import ksp.org.jetbrains.kotlin.psi.KtProperty;
import ksp.org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.sam.SamConversionResolverImplKt;
import ksp.org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0010"}, d2={"Lksp/org/jetbrains/kotlin/resolve/checkers/FunInterfaceDeclarationChecker;", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkSingleAbstractMember", "abstractMember", "Lksp/org/jetbrains/kotlin/descriptors/FunctionDescriptor;", "funInterfaceKeyword", "Lksp/com/intellij/psi/PsiElement;", "frontend"})
@SourceDebugExtension(value={"SMAP\nFunInterfaceDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunInterfaceDeclarationChecker.kt\norg/jetbrains/kotlin/resolve/checkers/FunInterfaceDeclarationChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n798#2,11:82\n*S KotlinDebug\n*F\n+ 1 FunInterfaceDeclarationChecker.kt\norg/jetbrains/kotlin/resolve/checkers/FunInterfaceDeclarationChecker\n*L\n47#1:82,11\n*E\n"})
public final class FunInterfaceDeclarationChecker
implements DeclarationChecker {
    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        void $this$filterIsInstanceTo$iv$iv;
        Object reportOn;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (!(declaration2 instanceof KtClass)) {
            return;
        }
        if (!(descriptor2 instanceof ClassDescriptor) || !((ClassDescriptor)descriptor2).isFun()) {
            return;
        }
        PsiElement psiElement = ((KtClass)declaration2).getFunKeyword();
        if (psiElement == null) {
            return;
        }
        PsiElement funKeyword = psiElement;
        List<CallableMemberDescriptor> abstractMembers = SamConversionResolverImplKt.getAbstractMembers((ClassDescriptor)descriptor2);
        for (CallableMemberDescriptor abstractMember : abstractMembers) {
            PsiElement psiElement2;
            if (!(abstractMember instanceof PropertyDescriptor)) continue;
            boolean reportOnProperty = Intrinsics.areEqual(((PropertyDescriptor)abstractMember).getContainingDeclaration(), descriptor2);
            if (reportOnProperty) {
                SourceElement sourceElement = ((PropertyDescriptor)abstractMember).getSource();
                Intrinsics.checkNotNullExpressionValue(sourceElement, "getSource(...)");
                PsiElement psiElement3 = PsiSourceElementKt.getPsi(sourceElement);
                psiElement2 = psiElement3 instanceof KtProperty ? (KtProperty)psiElement3 : null;
                if (psiElement2 == null || (psiElement2 = ((KtProperty)psiElement2).getValOrVarKeyword()) == null) {
                    psiElement2 = funKeyword;
                }
            } else {
                psiElement2 = funKeyword;
            }
            reportOn = psiElement2;
            context2.getTrace().report(Errors.FUN_INTERFACE_CANNOT_HAVE_ABSTRACT_PROPERTIES.on((PsiElement)reportOn));
            if (reportOnProperty) continue;
            return;
        }
        Iterable $this$filterIsInstance$iv = abstractMembers;
        boolean $i$f$filterIsInstance = false;
        reportOn = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FunctionDescriptor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        FunctionDescriptor abstractMember = (FunctionDescriptor)CollectionsKt.singleOrNull((List)destination$iv$iv);
        if (abstractMember == null) {
            context2.getTrace().report(Errors.FUN_INTERFACE_WRONG_COUNT_OF_ABSTRACT_MEMBERS.on(funKeyword));
            return;
        }
        this.checkSingleAbstractMember(abstractMember, funKeyword, context2);
    }

    private final void checkSingleAbstractMember(FunctionDescriptor abstractMember, PsiElement funInterfaceKeyword, DeclarationCheckerContext context2) {
        SourceElement sourceElement = abstractMember.getSource();
        Intrinsics.checkNotNullExpressionValue(sourceElement, "getSource(...)");
        PsiElement psiElement = PsiSourceElementKt.getPsi(sourceElement);
        KtNamedFunction ktFunction = psiElement instanceof KtNamedFunction ? (KtNamedFunction)psiElement : null;
        List<TypeParameterDescriptor> list2 = abstractMember.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "getTypeParameters(...)");
        if (!((Collection)list2).isEmpty()) {
            PsiElement psiElement2;
            KtElementImplStub ktElementImplStub = ktFunction;
            if (ktElementImplStub != null && (ktElementImplStub = ktElementImplStub.getTypeParameterList()) != null) {
                psiElement2 = ktElementImplStub;
            } else {
                KtNamedFunction ktNamedFunction = ktFunction;
                psiElement2 = ktNamedFunction != null ? ktNamedFunction.getFunKeyword() : null;
                if (psiElement2 == null) {
                    psiElement2 = funInterfaceKeyword;
                }
            }
            PsiElement psiElement3 = psiElement2;
            Intrinsics.checkNotNull(psiElement3);
            PsiElement reportOn = psiElement3;
            context2.getTrace().report(Errors.FUN_INTERFACE_ABSTRACT_METHOD_WITH_TYPE_PARAMETERS.on(reportOn));
            return;
        }
        for (ValueParameterDescriptor parameter2 : abstractMember.getValueParameters()) {
            Intrinsics.checkNotNull(parameter2);
            if (!ArgumentsUtilsKt.hasDefaultValue(parameter2)) continue;
            SourceElement sourceElement2 = parameter2.getSource();
            Intrinsics.checkNotNullExpressionValue(sourceElement2, "getSource(...)");
            PsiElement psiElement4 = PsiSourceElementKt.getPsi(sourceElement2);
            if (psiElement4 == null) {
                KtNamedFunction ktNamedFunction = ktFunction;
                psiElement4 = ktNamedFunction != null ? ktNamedFunction.getFunKeyword() : null;
                if (psiElement4 == null) {
                    psiElement4 = funInterfaceKeyword;
                }
            }
            PsiElement reportOn = psiElement4;
            context2.getTrace().report(Errors.FUN_INTERFACE_ABSTRACT_METHOD_WITH_DEFAULT_VALUE.on(reportOn));
            return;
        }
    }
}

