/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.checkers;

import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.resolve.checkers.BigFunctionTypeAvailabilityChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.ClassifierUsageChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.ClassifierUsageCheckerContext;
import ksp.org.jetbrains.kotlin.types.SimpleType;
import ksp.org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lksp/org/jetbrains/kotlin/resolve/checkers/BigFunctionTypeAvailabilityChecker;", "Lksp/org/jetbrains/kotlin/resolve/checkers/ClassifierUsageChecker;", "()V", "check", "", "targetDescriptor", "Lksp/org/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "element", "Lksp/com/intellij/psi/PsiElement;", "context", "Lksp/org/jetbrains/kotlin/resolve/checkers/ClassifierUsageCheckerContext;", "frontend"})
public final class BigFunctionTypeAvailabilityChecker
implements ClassifierUsageChecker {
    @NotNull
    public static final BigFunctionTypeAvailabilityChecker INSTANCE = new BigFunctionTypeAvailabilityChecker();

    private BigFunctionTypeAvailabilityChecker() {
    }

    @Override
    public void check(@NotNull ClassifierDescriptor targetDescriptor, @NotNull PsiElement element2, @NotNull ClassifierUsageCheckerContext context2) {
        Intrinsics.checkNotNullParameter(targetDescriptor, "targetDescriptor");
        Intrinsics.checkNotNullParameter(element2, "element");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.FunctionTypesWithBigArity)) {
            return;
        }
        SimpleType simpleType2 = targetDescriptor.getDefaultType();
        Intrinsics.checkNotNullExpressionValue(simpleType2, "getDefaultType(...)");
        if (TypeUtilsKt.contains(simpleType2, check.1.INSTANCE)) {
            context2.getTrace().report(Errors.UNSUPPORTED_FEATURE.on(element2, TuplesKt.to(LanguageFeature.FunctionTypesWithBigArity, context2.getLanguageVersionSettings())));
        }
    }
}

