/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.calls.components;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.kotlin.builtins.FunctionTypesKt;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import ksp.org.jetbrains.kotlin.resolve.calls.components.candidate.ResolutionCandidate;
import ksp.org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilder;
import ksp.org.jetbrains.kotlin.resolve.calls.inference.model.TypeVariableFromCallableDescriptor;
import ksp.org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import ksp.org.jetbrains.kotlin.resolve.calls.model.LambdaKotlinCallArgument;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolutionPart;
import ksp.org.jetbrains.kotlin.resolve.calls.model.SimpleTypeArgument;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.UnwrappedType;
import ksp.org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lksp/org/jetbrains/kotlin/resolve/calls/components/PostponedVariablesInitializerResolutionPart;", "Lksp/org/jetbrains/kotlin/resolve/calls/model/ResolutionPart;", "()V", "process", "", "Lksp/org/jetbrains/kotlin/resolve/calls/components/candidate/ResolutionCandidate;", "workIndex", "", "resolution"})
public final class PostponedVariablesInitializerResolutionPart
extends ResolutionPart {
    @NotNull
    public static final PostponedVariablesInitializerResolutionPart INSTANCE = new PostponedVariablesInitializerResolutionPart();

    private PostponedVariablesInitializerResolutionPart() {
    }

    @Override
    public void process(@NotNull ResolutionCandidate $this$process, int workIndex) {
        Intrinsics.checkNotNullParameter($this$process, "<this>");
        ConstraintSystemBuilder csBuilder = $this$process.getSystem().getBuilder();
        for (Map.Entry<KotlinCallArgument, ValueParameterDescriptor> entry : $this$process.getResolvedCall().getArgumentToCandidateParameter().entrySet()) {
            KotlinCallArgument argument2 = entry.getKey();
            ValueParameterDescriptor parameter2 = entry.getValue();
            if (!$this$process.getCallComponents().getStatelessCallbacks().isBuilderInferenceCall(argument2, parameter2)) continue;
            KotlinType kotlinType = parameter2.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
            if (FunctionTypesKt.getReceiverTypeFromFunctionType(kotlinType) == null) continue;
            boolean dontUseBuilderInferenceIfPossible = $this$process.getCallComponents().getLanguageVersionSettings().supportsFeature(LanguageFeature.UseBuilderInferenceOnlyIfNeeded);
            if (argument2 instanceof LambdaKotlinCallArgument && !((LambdaKotlinCallArgument)argument2).getHasBuilderInferenceAnnotation()) {
                ((LambdaKotlinCallArgument)argument2).setHasBuilderInferenceAnnotation(true);
            }
            if (dontUseBuilderInferenceIfPossible) continue;
            for (TypeVariableFromCallableDescriptor freshVariable : $this$process.getResolvedCall().getFreshVariablesSubstitutor().getFreshVariables()) {
                KotlinType receiverType2;
                if ($this$process.getResolvedCall().getTypeArgumentMappingByOriginal().getTypeArgument(freshVariable.getOriginalTypeParameter()) instanceof SimpleTypeArgument || csBuilder.isPostponedTypeVariable(freshVariable) || !TypeUtilsKt.contains(receiverType2, (Function1<? super UnwrappedType, Boolean>)new Function1<UnwrappedType, Boolean>(freshVariable){
                    final /* synthetic */ TypeVariableFromCallableDescriptor $freshVariable;
                    {
                        this.$freshVariable = $freshVariable;
                        super(1);
                    }

                    public final Boolean invoke(UnwrappedType it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return Intrinsics.areEqual(it.getConstructor(), this.$freshVariable.getOriginalTypeParameter().getTypeConstructor());
                    }
                })) continue;
                csBuilder.markPostponedVariable(freshVariable);
            }
        }
    }
}

