/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.calls.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.util.PsiTreeUtil;
import ksp.org.jetbrains.kotlin.builtins.FunctionTypesKt;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.contracts.parsing.PsiContractsUtilsKt;
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import ksp.org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import ksp.org.jetbrains.kotlin.descriptors.EffectiveVisibilityUtilsKt;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.SourceElement;
import ksp.org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.Visibilities;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.lexer.KtToken;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.psi.Call;
import ksp.org.jetbrains.kotlin.psi.KtBinaryExpression;
import ksp.org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import ksp.org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import ksp.org.jetbrains.kotlin.psi.KtElement;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtOperationExpression;
import ksp.org.jetbrains.kotlin.psi.KtParameter;
import ksp.org.jetbrains.kotlin.psi.KtPsiUtil;
import ksp.org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import ksp.org.jetbrains.kotlin.psi.KtSuperExpression;
import ksp.org.jetbrains.kotlin.psi.KtThisExpression;
import ksp.org.jetbrains.kotlin.psi.ValueArgument;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.BindingTrace;
import ksp.org.jetbrains.kotlin.resolve.DescriptorUtils;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import ksp.org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.util.CallResolverUtilKt;
import ksp.org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import ksp.org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.inline.InlineUtil;
import ksp.org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import ksp.org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import ksp.org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import ksp.org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.SimpleType;
import ksp.org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0017\u001a\u00020\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J,\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0002J(\u0010&\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020%H\u0002J \u0010*\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020!2\u0006\u0010,\u001a\u00020%H\u0002J\u0018\u0010-\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%H\u0002J*\u0010.\u001a\u00020\u00182\u0006\u0010/\u001a\u0002002\u0006\u0010$\u001a\u00020\u00072\b\u00101\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J*\u00102\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010$\u001a\u00020\u00072\b\u00101\u001a\u0004\u0018\u00010\u0007H\u0002J(\u00103\u001a\u00020\u00182\u0006\u00104\u001a\u00020!2\u0006\u00105\u001a\u0002062\u0006\u0010$\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J(\u00107\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\tH\u0002J2\u0010;\u001a\u00020\u00182\u0006\u0010<\u001a\u00020!2\u0006\u0010$\u001a\u00020\u00072\b\u00101\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u00105\u001a\u000206H\u0002J\"\u0010=\u001a\u0004\u0018\u00010!2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%2\u0006\u0010>\u001a\u00020\u000eH\u0002J\u0010\u0010?\u001a\u00020\u000e2\u0006\u0010@\u001a\u00020AH\u0002J\u0010\u0010B\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010C\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020!H\u0002J\u001e\u0010D\u001a\u00020\u0018*\u00020\u001e2\u0006\u0010$\u001a\u00020\u00072\b\u00101\u001a\u0004\u0018\u00010\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006E"}, d2={"Lksp/org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker;", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/FunctionDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)V", "inlinableKtParameters", "", "Lksp/org/jetbrains/kotlin/psi/KtElement;", "inlinableParameters", "Lksp/org/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "kotlin.jvm.PlatformType", "inlineFunEffectiveVisibility", "Lksp/org/jetbrains/kotlin/descriptors/EffectiveVisibility;", "isEffectivelyPrivateApiFunction", "", "<set-?>", "supportDefaultValueInline", "getSupportDefaultValueInline", "()Z", "setSupportDefaultValueInline", "(Z)V", "supportDefaultValueInline$delegate", "Lkotlin/properties/ReadWriteProperty;", "check", "", "resolvedCall", "Lksp/org/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lksp/com/intellij/psi/PsiElement;", "context", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkCallWithReceiver", "targetDescriptor", "Lksp/org/jetbrains/kotlin/descriptors/CallableDescriptor;", "receiver", "Lksp/org/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "expression", "Lksp/org/jetbrains/kotlin/psi/KtExpression;", "checkLambdaInvokeOrExtensionCall", "lambdaDescriptor", "callDescriptor", "receiverExpression", "checkNonLocalReturn", "inlinableParameterDescriptor", "parameterUsage", "checkNotInDefaultParameter", "checkPrivateClassMemberAccess", "declarationDescriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "replacementForReport", "checkRecursion", "checkSuperCalls", "callableDescriptor", "call", "Lksp/org/jetbrains/kotlin/psi/Call;", "checkValueParameter", "targetArgument", "Lksp/org/jetbrains/kotlin/psi/ValueArgument;", "targetParameterDescriptor", "checkVisibilityAndAccess", "calledDescriptor", "getCalleeDescriptor", "unwrapVariableAsFunction", "isDefinedInInlineFunction", "startDescriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "isInsideCall", "isInvokeOrInlineExtension", "reportDeprecationOnReplacement", "frontend"})
@SourceDebugExtension(value={"SMAP\nInlineChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/InlineChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,383:1\n1#2:384\n1#2:398\n764#3:385\n855#3,2:386\n1601#3,9:388\n1853#3:397\n1854#3:399\n1610#3:400\n125#4:401\n*S KotlinDebug\n*F\n+ 1 InlineChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/InlineChecker\n*L\n60#1:398\n58#1:385\n58#1:386,2\n60#1:388,9\n60#1:397\n60#1:399\n60#1:400\n101#1:401\n*E\n"})
public final class InlineChecker
implements CallChecker {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final FunctionDescriptor descriptor;
    @NotNull
    private final EffectiveVisibility inlineFunEffectiveVisibility;
    private final boolean isEffectivelyPrivateApiFunction;
    @NotNull
    private final List<ValueParameterDescriptor> inlinableParameters;
    @NotNull
    private final List<KtElement> inlinableKtParameters;
    @NotNull
    private final ReadWriteProperty supportDefaultValueInline$delegate;

    /*
     * WARNING - void declaration
     */
    public InlineChecker(@NotNull FunctionDescriptor descriptor2) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        this.descriptor = descriptor2;
        boolean bl = InlineUtil.isInline(this.descriptor);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-InlineChecker$22 = false;
            String $i$a$-assert-InlineChecker$22 = "This extension should be created only for inline functions: " + this.descriptor;
            throw new AssertionError((Object)$i$a$-assert-InlineChecker$22);
        }
        DeclarationDescriptorWithVisibility declarationDescriptorWithVisibility = this.descriptor;
        DescriptorVisibility descriptorVisibility = this.descriptor.getVisibility();
        Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "getVisibility(...)");
        this.inlineFunEffectiveVisibility = EffectiveVisibilityUtilsKt.effectiveVisibility(declarationDescriptorWithVisibility, descriptorVisibility, true);
        this.isEffectivelyPrivateApiFunction = DescriptorUtilsKt.isEffectivelyPrivateApi(this.descriptor);
        List<ValueParameterDescriptor> list2 = this.descriptor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "getValueParameters(...)");
        Iterable iterable = list2;
        InlineChecker inlineChecker = this;
        boolean $i$f$filter = false;
        void var4_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv$iv;
            boolean bl2 = false;
            if (!InlineUtil.isInlineParameter(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        inlineChecker.inlinableParameters = (List)destination$iv$iv;
        $this$filter$iv = this.inlinableParameters;
        inlineChecker = this;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KtElement it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl3 = false;
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv$iv;
            boolean bl4 = false;
            SourceElement sourceElement = it.getSource();
            KotlinSourceElement kotlinSourceElement = sourceElement instanceof KotlinSourceElement ? (KotlinSourceElement)sourceElement : null;
            if ((kotlinSourceElement != null ? kotlinSourceElement.getPsi() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        inlineChecker.inlinableKtParameters = (List)destination$iv$iv;
        this.supportDefaultValueInline$delegate = Delegates.INSTANCE.notNull();
    }

    private final boolean getSupportDefaultValueInline() {
        return (Boolean)this.supportDefaultValueInline$delegate.getValue(this, $$delegatedProperties[0]);
    }

    private final void setSupportDefaultValueInline(boolean bl) {
        this.supportDefaultValueInline$delegate.setValue(this, $$delegatedProperties[0], bl);
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context2, "context");
        Call call2 = resolvedCall2.getCall();
        Intrinsics.checkNotNullExpressionValue(call2, "getCall(...)");
        Call call3 = call2;
        KtExpression ktExpression = call3.getCalleeExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression expression2 = ktExpression;
        this.setSupportDefaultValueInline(context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.InlineDefaultFunctionalParameters));
        Object targetDescriptor = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkNotNull(targetDescriptor);
        if (PsiContractsUtilsKt.isFromContractDsl((DeclarationDescriptor)targetDescriptor)) {
            return;
        }
        this.checkCallWithReceiver(context2, (CallableDescriptor)targetDescriptor, resolvedCall2.getDispatchReceiver(), expression2);
        this.checkCallWithReceiver(context2, (CallableDescriptor)targetDescriptor, resolvedCall2.getExtensionReceiver(), expression2);
        if (CollectionsKt.contains((Iterable)this.inlinableParameters, targetDescriptor)) {
            if (this.checkNotInDefaultParameter(context2, expression2) && !this.isInsideCall(expression2)) {
                context2.getTrace().report(Errors.USAGE_IS_NOT_INLINABLE.on((KtElement)((PsiElement)expression2), expression2, this.descriptor));
            }
        }
        Map<ValueParameterDescriptor, ResolvedValueArgument> map = resolvedCall2.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(map, "getValueArguments(...)");
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : map.entrySet()) {
            ValueParameterDescriptor valueDescriptor = entry.getKey();
            ResolvedValueArgument value2 = entry.getValue();
            if (value2 instanceof DefaultValueArgument) continue;
            for (ValueArgument argument2 : value2.getArguments()) {
                Intrinsics.checkNotNull(argument2);
                Intrinsics.checkNotNull(valueDescriptor);
                this.checkValueParameter(context2, (CallableDescriptor)targetDescriptor, argument2, valueDescriptor);
            }
        }
        ReceiverValue receiverValue = call3.getDispatchReceiver();
        ExpressionReceiver expressionReceiver = receiverValue instanceof ExpressionReceiver ? (ExpressionReceiver)receiverValue : null;
        KtExpression replacementForReport = expressionReceiver != null ? expressionReceiver.getExpression() : null;
        this.checkVisibilityAndAccess((CallableDescriptor)targetDescriptor, expression2, replacementForReport, context2, call3);
        this.checkRecursion(context2, (CallableDescriptor)targetDescriptor, expression2, replacementForReport);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkNotInDefaultParameter(CallCheckerContext context2, KtExpression expression2) {
        boolean allow;
        void $this$getParentOfType$iv;
        if (!this.getSupportDefaultValueInline()) return true;
        PsiElement psiElement = expression2;
        boolean strict$iv = true;
        boolean $i$f$getParentOfType = false;
        KtParameter ktParameter = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtParameter.class, strict$iv);
        if (ktParameter == null) return true;
        KtParameter it = ktParameter;
        boolean bl = false;
        if (!this.inlinableKtParameters.contains(it)) {
            return true;
        }
        boolean bl2 = allow = false;
        if (!allow) {
            context2.getTrace().report(Errors.NOT_SUPPORTED_INLINE_PARAMETER_IN_INLINE_PARAMETER_DEFAULT_VALUE.on((KtElement)((PsiElement)expression2), expression2, this.descriptor));
        }
        boolean bl3 = allow;
        if (!bl3) return false;
        return true;
    }

    private final boolean isInsideCall(KtExpression expression2) {
        KtToken token;
        KtExpression parent2 = KtPsiUtil.getParentCallIfPresent(expression2);
        if (parent2 instanceof KtBinaryExpression && ((token = KtPsiUtil.getOperationToken((KtOperationExpression)parent2)) == KtTokens.EQ || token == KtTokens.ANDAND || token == KtTokens.OROR)) {
            return false;
        }
        if (parent2 != null) {
            PsiElement current = expression2;
            while (current != parent2) {
                if (current instanceof KtBinaryExpressionWithTypeRHS) {
                    return false;
                }
                Intrinsics.checkNotNullExpressionValue(current.getParent(), "getParent(...)");
            }
        }
        return parent2 != null;
    }

    private final void checkValueParameter(CallCheckerContext context2, CallableDescriptor targetDescriptor, ValueArgument targetArgument, ValueParameterDescriptor targetParameterDescriptor) {
        KtExpression ktExpression = targetArgument.getArgumentExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression argumentExpression = ktExpression;
        CallableDescriptor argumentCallee = this.getCalleeDescriptor(context2, argumentExpression, false);
        if (argumentCallee != null && CollectionsKt.contains((Iterable)this.inlinableParameters, argumentCallee)) {
            if (this.checkNotInDefaultParameter(context2, argumentExpression)) {
                if (InlineUtil.isInline(targetDescriptor) && InlineUtil.isInlineParameter(targetParameterDescriptor)) {
                    if (InlineUtil.allowsNonLocalReturns(argumentCallee) && !InlineUtil.allowsNonLocalReturns(targetParameterDescriptor)) {
                        context2.getTrace().report(Errors.NON_LOCAL_RETURN_NOT_ALLOWED.on((KtElement)((PsiElement)argumentExpression), argumentExpression));
                    } else {
                        this.checkNonLocalReturn(context2, argumentCallee, argumentExpression);
                    }
                } else {
                    context2.getTrace().report(Errors.USAGE_IS_NOT_INLINABLE.on((KtElement)((PsiElement)argumentExpression), argumentExpression, this.descriptor));
                }
            }
        }
    }

    private final void checkCallWithReceiver(CallCheckerContext context2, CallableDescriptor targetDescriptor, ReceiverValue receiver, KtExpression expression2) {
        if (receiver == null) {
            return;
        }
        CallableDescriptor varDescriptor = null;
        KtExpression receiverExpression = null;
        ReceiverValue receiverValue = receiver;
        if (receiverValue instanceof ExpressionReceiver) {
            receiverExpression = ((ExpressionReceiver)receiver).getExpression();
            varDescriptor = this.getCalleeDescriptor(context2, receiverExpression, true);
        } else if (receiverValue instanceof ExtensionReceiver) {
            boolean bl;
            CallableDescriptor callableDescriptor = ((ExtensionReceiver)receiver).getDeclarationDescriptor();
            Intrinsics.checkNotNullExpressionValue(callableDescriptor, "<get-declarationDescriptor>(...)");
            CallableDescriptor extension = callableDescriptor;
            varDescriptor = extension.getExtensionReceiverParameter();
            boolean bl2 = bl = varDescriptor != null;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string2 = "Extension should have receiverParameterDescriptor: " + extension;
                throw new AssertionError((Object)string2);
            }
            receiverExpression = expression2;
        } else {
            varDescriptor = null;
            receiverExpression = null;
        }
        if (CollectionsKt.contains((Iterable)this.inlinableParameters, varDescriptor)) {
            CallableDescriptor callableDescriptor = varDescriptor;
            Intrinsics.checkNotNull(callableDescriptor);
            KtExpression ktExpression = receiverExpression;
            Intrinsics.checkNotNull(ktExpression);
            this.checkLambdaInvokeOrExtensionCall(context2, callableDescriptor, targetDescriptor, ktExpression);
        }
    }

    private final CallableDescriptor getCalleeDescriptor(CallCheckerContext context2, KtExpression expression2, boolean unwrapVariableAsFunction) {
        if (!(expression2 instanceof KtSimpleNameExpression) && !(expression2 instanceof KtThisExpression)) {
            return null;
        }
        KtElement ktElement = expression2;
        BindingContext bindingContext = context2.getTrace().getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        ResolvedCall<? extends CallableDescriptor> thisCall = CallUtilKt.getResolvedCall(ktElement, bindingContext);
        if (unwrapVariableAsFunction && thisCall instanceof VariableAsFunctionResolvedCall) {
            return ((VariableAsFunctionResolvedCall)((Object)thisCall)).getVariableCall().getResultingDescriptor();
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = thisCall;
        return resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null;
    }

    private final void checkLambdaInvokeOrExtensionCall(CallCheckerContext context2, CallableDescriptor lambdaDescriptor, CallableDescriptor callDescriptor, KtExpression receiverExpression) {
        boolean inlinableCall = this.isInvokeOrInlineExtension(callDescriptor);
        if (!inlinableCall) {
            if (InlineUtil.isInline(callDescriptor) && !context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ForbidExtensionCallsOnInlineFunctionalParameters)) {
                context2.getTrace().report(Errors.USAGE_IS_NOT_INLINABLE_WARNING.on((KtElement)((PsiElement)receiverExpression), receiverExpression, this.descriptor));
            } else {
                context2.getTrace().report(Errors.USAGE_IS_NOT_INLINABLE.on((KtElement)((PsiElement)receiverExpression), receiverExpression, this.descriptor));
            }
        } else {
            this.checkNonLocalReturn(context2, lambdaDescriptor, receiverExpression);
        }
    }

    private final void checkRecursion(CallCheckerContext context2, CallableDescriptor targetDescriptor, KtElement expression2, KtElement replacementForReport) {
        if (targetDescriptor.getOriginal() == this.descriptor) {
            context2.getTrace().report(Errors.RECURSION_IN_INLINE.on((KtElement)((PsiElement)expression2), expression2, this.descriptor));
            this.reportDeprecationOnReplacement(context2, expression2, replacementForReport);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInvokeOrInlineExtension(CallableDescriptor descriptor2) {
        if (!(descriptor2 instanceof SimpleFunctionDescriptor)) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getContainingDeclaration(...)");
        DeclarationDescriptor containingDeclaration = declarationDescriptor;
        if (!Intrinsics.areEqual(descriptor2.getName(), OperatorNameConventions.INVOKE)) return false;
        if (!(containingDeclaration instanceof ClassDescriptor)) return false;
        SimpleType simpleType2 = ((ClassDescriptor)containingDeclaration).getDefaultType();
        Intrinsics.checkNotNullExpressionValue(simpleType2, "getDefaultType(...)");
        if (!FunctionTypesKt.isBuiltinFunctionalType(simpleType2)) return false;
        return true;
    }

    private final void checkVisibilityAndAccess(CallableDescriptor calledDescriptor, KtElement expression2, KtElement replacementForReport, CallCheckerContext context2, Call call2) {
        EffectiveVisibility effectiveVisibility;
        if (this.isDefinedInInlineFunction(calledDescriptor)) {
            effectiveVisibility = EffectiveVisibility.Public.INSTANCE;
        } else {
            DeclarationDescriptorWithVisibility declarationDescriptorWithVisibility = calledDescriptor;
            DescriptorVisibility descriptorVisibility = calledDescriptor.getVisibility();
            Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "getVisibility(...)");
            effectiveVisibility = EffectiveVisibilityUtilsKt.effectiveVisibility(declarationDescriptorWithVisibility, descriptorVisibility, true);
        }
        EffectiveVisibility calledFunEffectiveVisibility = effectiveVisibility;
        boolean isCalledFunPublicOrPublishedApi = calledFunEffectiveVisibility.getPublicApi();
        boolean isInlineFunPublicOrPublishedApi = this.inlineFunEffectiveVisibility.getPublicApi();
        if (isInlineFunPublicOrPublishedApi && !isCalledFunPublicOrPublishedApi && calledDescriptor.getVisibility() != DescriptorVisibilities.LOCAL) {
            context2.getTrace().report(Errors.NON_PUBLIC_CALL_FROM_PUBLIC_INLINE.on((KtElement)((PsiElement)expression2), calledDescriptor, this.descriptor));
            this.reportDeprecationOnReplacement(context2, expression2, replacementForReport);
        } else {
            this.checkPrivateClassMemberAccess(calledDescriptor, expression2, replacementForReport, context2);
            if (isInlineFunPublicOrPublishedApi) {
                this.checkSuperCalls(calledDescriptor, call2, expression2, context2);
            }
        }
        boolean isConstructorCall = calledDescriptor instanceof ConstructorDescriptor;
        if (!(isConstructorCall && expression2 instanceof KtConstructorCalleeExpression || !isInlineFunPublicOrPublishedApi || this.inlineFunEffectiveVisibility.toVisibility() == Visibilities.Protected.INSTANCE || calledFunEffectiveVisibility.toVisibility() != Visibilities.Protected.INSTANCE)) {
            if (isConstructorCall) {
                context2.getTrace().report(Errors.PROTECTED_CONSTRUCTOR_CALL_FROM_PUBLIC_INLINE.on(context2.getLanguageVersionSettings(), expression2, calledDescriptor));
            } else {
                context2.getTrace().report(Errors.PROTECTED_CALL_FROM_PUBLIC_INLINE.on(context2.getLanguageVersionSettings(), expression2, calledDescriptor));
            }
            this.reportDeprecationOnReplacement(context2, expression2, replacementForReport);
        }
    }

    private final void checkPrivateClassMemberAccess(DeclarationDescriptor declarationDescriptor, KtElement expression2, KtElement replacementForReport, CallCheckerContext context2) {
        if (!this.isEffectivelyPrivateApiFunction) {
            if (DescriptorUtilsKt.isInsidePrivateClass(declarationDescriptor)) {
                context2.getTrace().report(Errors.PRIVATE_CLASS_MEMBER_FROM_INLINE.on((KtElement)((PsiElement)expression2), declarationDescriptor, this.descriptor));
                this.reportDeprecationOnReplacement(context2, expression2, replacementForReport);
            } else if (DescriptorUtilsKt.isMemberOfCompanionOfPrivateClass(declarationDescriptor)) {
                context2.getTrace().report(Errors.PRIVATE_CLASS_MEMBER_FROM_INLINE_WARNING.on((KtElement)((PsiElement)expression2), declarationDescriptor, this.descriptor));
                this.reportDeprecationOnReplacement(context2, expression2, replacementForReport);
            }
        }
    }

    private final void checkSuperCalls(CallableDescriptor callableDescriptor, Call call2, KtElement expression2, CallCheckerContext context2) {
        KtSuperExpression superCall = CallResolverUtilKt.getSuperCallExpression(call2);
        if (superCall != null) {
            KotlinType kotlinType = (KotlinType)context2.getTrace().get(BindingContext.THIS_TYPE_FOR_SUPER_EXPRESSION, superCall);
            if (kotlinType == null) {
                return;
            }
            KotlinType thisTypeForSuperCall = kotlinType;
            ClassifierDescriptor classifierDescriptor = thisTypeForSuperCall.getConstructor().getDeclarationDescriptor();
            DeclarationDescriptorWithVisibility declarationDescriptorWithVisibility = classifierDescriptor instanceof DeclarationDescriptorWithVisibility ? (DeclarationDescriptorWithVisibility)((Object)classifierDescriptor) : null;
            if (declarationDescriptorWithVisibility == null) {
                return;
            }
            DeclarationDescriptorWithVisibility descriptor2 = declarationDescriptorWithVisibility;
            if (!this.isDefinedInInlineFunction(descriptor2)) {
                BindingTrace bindingTrace = context2.getTrace();
                LanguageVersionSettings languageVersionSettings2 = context2.getLanguageVersionSettings();
                PsiElement psiElement = expression2.getParent().getParent();
                if (psiElement == null) {
                    psiElement = superCall;
                }
                bindingTrace.report(Errors.SUPER_CALL_FROM_PUBLIC_INLINE.on(languageVersionSettings2, psiElement, callableDescriptor));
            }
        }
    }

    private final boolean isDefinedInInlineFunction(DeclarationDescriptorWithVisibility startDescriptor) {
        DeclarationDescriptorWithVisibility parent2 = startDescriptor;
        while (parent2 != null) {
            if (parent2.getContainingDeclaration() == this.descriptor) {
                return true;
            }
            parent2 = DescriptorUtils.getParentOfType(parent2, DeclarationDescriptorWithVisibility.class);
        }
        return false;
    }

    private final void checkNonLocalReturn(CallCheckerContext context2, CallableDescriptor inlinableParameterDescriptor, KtExpression parameterUsage) {
        if (!InlineUtil.allowsNonLocalReturns(inlinableParameterDescriptor)) {
            return;
        }
        if (!InlineUtil.checkNonLocalReturnUsage(this.descriptor, parameterUsage, context2.getResolutionContext())) {
            context2.getTrace().report(Errors.NON_LOCAL_RETURN_NOT_ALLOWED.on((KtElement)((PsiElement)parameterUsage), parameterUsage));
        }
    }

    private final void reportDeprecationOnReplacement(CallCheckerContext $this$reportDeprecationOnReplacement, KtElement expression2, KtElement replacementForReport) {
        if (!expression2.isPhysical() && replacementForReport != null) {
            $this$reportDeprecationOnReplacement.getTrace().report(Errors.DEPRECATED_IMPLICIT_NON_PUBLIC_API_ACCESS.on((KtElement)((PsiElement)replacementForReport)));
        }
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1(new MutablePropertyReference1Impl(Reflection.getOrCreateKotlinClass(InlineChecker.class), "supportDefaultValueInline", "getSupportDefaultValueInline()Z"))};
        $$delegatedProperties = kPropertyArray;
    }
}

