/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.calls.checkers;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.kotlin.builtins.FunctionTypesKt;
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.ValueArgument;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.IncorrectCapturedApproximationCallChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.inference.CapturedTypeConstructorKt;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ArgumentMappingKt;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import ksp.org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import ksp.org.jetbrains.kotlin.resolve.calls.util.CallResolverUtilKt;
import ksp.org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import ksp.org.jetbrains.kotlin.resolve.sam.SamConversionResolverImplKt;
import ksp.org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import ksp.org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.TypeProjection;
import ksp.org.jetbrains.kotlin.types.TypeSubstitution;
import ksp.org.jetbrains.kotlin.types.TypeSubstitutor;
import ksp.org.jetbrains.kotlin.types.Variance;
import ksp.org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0012"}, d2={"Lksp/org/jetbrains/kotlin/resolve/calls/checkers/IncorrectCapturedApproximationCallChecker;", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lksp/org/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lksp/com/intellij/psi/PsiElement;", "context", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "shouldWarningBeReported", "", "expressionType", "Lksp/org/jetbrains/kotlin/types/KotlinType;", "expectedType", "dataFlowValue", "Lksp/org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "frontend"})
@SourceDebugExtension(value={"SMAP\nIncorrectCapturedApproximationCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IncorrectCapturedApproximationCallChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/IncorrectCapturedApproximationCallChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1724#2,3:99\n2622#2,3:102\n2622#2,3:105\n*S KotlinDebug\n*F\n+ 1 IncorrectCapturedApproximationCallChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/IncorrectCapturedApproximationCallChecker\n*L\n29#1:99,3\n83#1:102,3\n95#1:105,3\n*E\n"})
public final class IncorrectCapturedApproximationCallChecker
implements CallChecker {
    @NotNull
    public static final IncorrectCapturedApproximationCallChecker INSTANCE = new IncorrectCapturedApproximationCallChecker();

    private IncorrectCapturedApproximationCallChecker() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (!ArgumentMappingKt.isReallySuccess(resolvedCall2)) {
            return;
        }
        KotlinType kotlinType = resolvedCall2.getSmartCastDispatchReceiverType();
        if (kotlinType == null) {
            ReceiverValue receiverValue = resolvedCall2.getDispatchReceiver();
            if (receiverValue == null) return;
            KotlinType kotlinType2 = receiverValue.getType();
            kotlinType = kotlinType2;
            if (kotlinType2 == null) {
                return;
            }
        }
        KotlinType dispatchReceiverType = kotlinType;
        Iterable $this$all$iv = dispatchReceiverType.getArguments();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return;
            Object t = iterator2.next();
            TypeProjection it = (TypeProjection)t;
            boolean bl2 = false;
            if (it.getProjectionKind() == Variance.INVARIANT) {
                KotlinType kotlinType3 = it.getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType3, "getType(...)");
                if (!CapturedTypeConstructorKt.isCaptured(kotlinType3)) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (bl);
        boolean bl3 = false;
        if (bl3) {
            return;
        }
        TypeSubstitution typeSubstitution = TypeSubstitutor.create(dispatchReceiverType).getSubstitution();
        Intrinsics.checkNotNullExpressionValue(typeSubstitution, "getSubstitution(...)");
        TypeSubstitutor substitutor2 = CapturedTypeConstructorKt.wrapWithCapturingSubstitution(typeSubstitution, false).buildSubstitutor();
        CallableDescriptor callableDescriptor = resolvedCall2.getResultingDescriptor().getOriginal();
        if (!(callableDescriptor instanceof FunctionDescriptor)) return;
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)callableDescriptor;
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor functionDescriptor2 = functionDescriptor;
        FunctionDescriptor functionDescriptor3 = functionDescriptor2.substitute(substitutor2);
        if (functionDescriptor3 == null) {
            return;
        }
        FunctionDescriptor capturedSubstituted = functionDescriptor3;
        List<ResolvedValueArgument> list2 = resolvedCall2.getValueArgumentsByIndex();
        if (list2 == null) {
            return;
        }
        List<ResolvedValueArgument> list3 = list2;
        Iterator<ValueParameterDescriptor> iterator3 = capturedSubstituted.getValueParameters().iterator();
        int n = 0;
        while (iterator3.hasNext()) {
            int index2 = n++;
            ValueParameterDescriptor parameter2 = iterator3.next();
            for (ValueArgument argument2 : list3.get(index2).getArguments()) {
                DataFlowValue dataFlowValue2;
                KotlinType expressionType2;
                KtExpression argumentExpression;
                Intrinsics.checkNotNull(parameter2);
                Intrinsics.checkNotNull(argument2);
                KotlinType expectedType = CallResolverUtilKt.getEffectiveExpectedType(parameter2, argument2, context2.getResolutionContext());
                if (argument2.getArgumentExpression() == null) continue;
                BindingContext bindingContext = context2.getTrace().getBindingContext();
                Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
                if (CallUtilKt.getType(argumentExpression, bindingContext) == null || !this.shouldWarningBeReported(expressionType2, expectedType, dataFlowValue2 = context2.getDataFlowValueFactory().createDataFlowValue(argumentExpression, expressionType2, context2.getResolutionContext()), context2)) continue;
                context2.getTrace().report(Errors.TYPE_MISMATCH_WARNING_FOR_INCORRECT_CAPTURE_APPROXIMATION.on(argumentExpression, expectedType, expressionType2));
            }
        }
        ReceiverParameterDescriptor receiverParameterDescriptor = capturedSubstituted.getExtensionReceiverParameter();
        if (receiverParameterDescriptor == null) return;
        ReceiverParameterDescriptor extensionReceiverParameter2 = receiverParameterDescriptor;
        boolean bl4 = false;
        ReceiverValue receiverValue = resolvedCall2.getExtensionReceiver();
        if (receiverValue == null) return;
        ReceiverValue receiverValue2 = receiverValue;
        Intrinsics.checkNotNull(receiverValue2);
        ReceiverValue extensionReceiver2 = receiverValue2;
        DataFlowValue dataFlowValue3 = context2.getDataFlowValueFactory().createDataFlowValue(extensionReceiver2, context2.getResolutionContext());
        KotlinType kotlinType4 = extensionReceiver2.getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType4, "getType(...)");
        KotlinType kotlinType5 = extensionReceiverParameter2.getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType5, "getType(...)");
        if (!INSTANCE.shouldWarningBeReported(kotlinType4, kotlinType5, dataFlowValue3, context2)) return;
        Object object = extensionReceiver2 instanceof ExpressionReceiver ? (ExpressionReceiver)extensionReceiver2 : null;
        PsiElement expression2 = object != null && (object = object.getExpression()) != null ? (PsiElement)object : reportOn;
        context2.getTrace().report(Errors.RECEIVER_TYPE_MISMATCH_WARNING_FOR_INCORRECT_CAPTURE_APPROXIMATION.on(expression2, extensionReceiverParameter2.getType(), extensionReceiver2.getType()));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldWarningBeReported(KotlinType expressionType2, KotlinType expectedType, DataFlowValue dataFlowValue2, CallCheckerContext context2) {
        KotlinType it;
        void $this$none$iv;
        boolean bl;
        boolean bl2;
        Iterable $this$none$iv2 = expectedType.getArguments();
        boolean $i$f$none22 = false;
        if ($this$none$iv2 instanceof Collection && ((Collection)$this$none$iv2).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$none$iv2.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            TypeProjection arg = (TypeProjection)element$iv;
            boolean bl3 = false;
            if (!arg.isStarProjection()) {
                KotlinType kotlinType = arg.getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
                if (TypeUtilsKt.contains(kotlinType, shouldWarningBeReported.1.1.INSTANCE)) {
                    bl2 = true;
                    continue;
                }
            }
            bl2 = false;
        } while (!bl2);
        boolean bl4 = false;
        if (bl4) {
            return false;
        }
        if (TypeUtilsKt.isSubtypeOf(expressionType2, expectedType)) {
            return false;
        }
        KotlinType samExpectedType = SamConversionResolverImplKt.getFunctionTypeForSamType(expectedType, context2.getCallComponents().getSamConversionResolver(), context2.getCallComponents().getSamConversionOracle());
        if (FunctionTypesKt.isFunctionOrSuspendFunctionType(expectedType)) return false;
        KotlinType kotlinType = samExpectedType;
        if (kotlinType != null) {
            if (FunctionTypesKt.isFunctionOrSuspendFunctionType(kotlinType)) {
                return false;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) {
            return false;
        }
        Iterable $i$f$none22 = context2.getDataFlowInfo().getCollectedTypes(dataFlowValue2, context2.getLanguageVersionSettings());
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        Iterator iterator3 = $this$none$iv.iterator();
        do {
            if (!iterator3.hasNext()) return true;
            Object element$iv = iterator3.next();
            it = (KotlinType)element$iv;
            boolean bl5 = false;
        } while (!TypeUtilsKt.isSubtypeOf(it, expectedType));
        return false;
    }
}

