/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.calls.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.EnumEntryVsCompanionPriorityCallCheckerKt;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0014\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lksp/org/jetbrains/kotlin/resolve/calls/checkers/EnumEntryVsCompanionPriorityCallChecker;", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lksp/org/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lksp/com/intellij/psi/PsiElement;", "context", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "containsEntryWithName", "", "Lksp/org/jetbrains/kotlin/descriptors/ClassDescriptor;", "name", "Lksp/org/jetbrains/kotlin/name/Name;", "frontend"})
public final class EnumEntryVsCompanionPriorityCallChecker
implements CallChecker {
    @NotNull
    public static final EnumEntryVsCompanionPriorityCallChecker INSTANCE = new EnumEntryVsCompanionPriorityCallChecker();

    private EnumEntryVsCompanionPriorityCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context2, "context");
        Object descriptor2 = resolvedCall2.getCandidateDescriptor();
        if (!(descriptor2 instanceof PropertyDescriptor)) {
            return;
        }
        Name name2 = ((PropertyDescriptor)descriptor2).getName();
        Intrinsics.checkNotNullExpressionValue(name2, "getName(...)");
        Name propertyName = name2;
        DeclarationDescriptor declarationDescriptor = ((PropertyDescriptor)descriptor2).getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getContainingDeclaration(...)");
        DeclarationDescriptor containingDescriptor = declarationDescriptor;
        if (!(containingDescriptor instanceof ClassDescriptor) || !((ClassDescriptor)containingDescriptor).isCompanionObject()) {
            return;
        }
        DeclarationDescriptor declarationDescriptor2 = ((ClassDescriptor)containingDescriptor).getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor2, "getContainingDeclaration(...)");
        DeclarationDescriptor grandParent = declarationDescriptor2;
        if (grandParent instanceof ClassDescriptor && ((ClassDescriptor)grandParent).getKind() == ClassKind.ENUM_CLASS && this.containsEntryWithName((ClassDescriptor)grandParent, propertyName) && EnumEntryVsCompanionPriorityCallCheckerKt.isQualifierFor(resolvedCall2.getDispatchReceiver(), (ClassDescriptor)grandParent)) {
            context2.getResolutionContext().trace.report(Errors.DEPRECATED_ACCESS_TO_ENUM_COMPANION_PROPERTY.on(reportOn, (PropertyDescriptor)descriptor2));
        }
    }

    private final boolean containsEntryWithName(ClassDescriptor $this$containsEntryWithName, Name name2) {
        ClassifierDescriptor foundDescriptor = $this$containsEntryWithName.getUnsubstitutedMemberScope().getContributedClassifier(name2, NoLookupLocation.FOR_ALREADY_TRACKED);
        return foundDescriptor instanceof ClassDescriptor && ((ClassDescriptor)foundDescriptor).getKind() == ClassKind.ENUM_ENTRY;
    }
}

