/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.calls.checkers;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.com.intellij.psi.tree.TokenSet;
import ksp.com.intellij.psi.util.PsiTreeUtil;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.psi.KtBinaryExpression;
import ksp.org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtReferenceExpression;
import ksp.org.jetbrains.kotlin.psi.KtUnaryExpression;
import ksp.org.jetbrains.kotlin.resolve.BindingTrace;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import ksp.org.jetbrains.kotlin.resolve.deprecation.DeprecationResolver;
import ksp.org.jetbrains.kotlin.resolve.deprecation.DeprecationUtilKt;
import ksp.org.jetbrains.kotlin.resolve.deprecation.DescriptorBasedDeprecationInfo;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J$\u0010\u0006\u001a\u00020\u00072\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0015\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u001aR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lksp/org/jetbrains/kotlin/resolve/calls/checkers/DeprecatedCallChecker;", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "PROPERTY_SET_OPERATIONS", "Lksp/com/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "check", "", "targetDescriptor", "Lksp/org/jetbrains/kotlin/descriptors/CallableDescriptor;", "trace", "Lksp/org/jetbrains/kotlin/resolve/BindingTrace;", "element", "Lksp/com/intellij/psi/PsiElement;", "languageVersionSettings", "Lksp/org/jetbrains/kotlin/config/LanguageVersionSettings;", "deprecationResolver", "Lksp/org/jetbrains/kotlin/resolve/deprecation/DeprecationResolver;", "resolvedCall", "Lksp/org/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "context", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "shouldCheckPropertyGetter", "", "expression", "shouldCheckPropertyGetter$frontend", "frontend"})
@SourceDebugExtension(value={"SMAP\nDeprecatedCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeprecatedCallChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/DeprecatedCallChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n1#2:96\n*E\n"})
public final class DeprecatedCallChecker
implements CallChecker {
    @NotNull
    public static final DeprecatedCallChecker INSTANCE = new DeprecatedCallChecker();
    @NotNull
    private static final TokenSet PROPERTY_SET_OPERATIONS;

    private DeprecatedCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context2, "context");
        Object obj = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(obj, "getResultingDescriptor(...)");
        this.check((CallableDescriptor)obj, context2.getTrace(), reportOn, context2.getLanguageVersionSettings(), context2.getDeprecationResolver());
    }

    private final void check(CallableDescriptor targetDescriptor, BindingTrace trace, PsiElement element2, LanguageVersionSettings languageVersionSettings2, DeprecationResolver deprecationResolver) {
        block5: {
            block4: {
                if (targetDescriptor instanceof FakeCallableDescriptorForObject) {
                    return;
                }
                List<DescriptorBasedDeprecationInfo> deprecations2 = CollectionsKt.toMutableList((Collection)deprecationResolver.getDeprecations(targetDescriptor));
                if (targetDescriptor instanceof PropertySetterDescriptor) {
                    Collection collection = deprecations2;
                    PropertyDescriptor propertyDescriptor = ((PropertySetterDescriptor)targetDescriptor).getCorrespondingProperty();
                    Intrinsics.checkNotNullExpressionValue(propertyDescriptor, "getCorrespondingProperty(...)");
                    CollectionsKt.removeAll(collection, (Iterable)deprecationResolver.getDeprecations(propertyDescriptor));
                }
                if (!(!((Collection)deprecations2).isEmpty())) break block4;
                for (DescriptorBasedDeprecationInfo deprecation : deprecations2) {
                    trace.report(DeprecationUtilKt.createDeprecationDiagnostic(element2, deprecation, languageVersionSettings2));
                }
                break block5;
            }
            if (!(targetDescriptor instanceof PropertyDescriptor) || !this.shouldCheckPropertyGetter$frontend(element2)) break block5;
            PropertyGetterDescriptor propertyGetterDescriptor = ((PropertyDescriptor)targetDescriptor).getGetter();
            if (propertyGetterDescriptor != null) {
                PropertyGetterDescriptor it = propertyGetterDescriptor;
                boolean bl = false;
                INSTANCE.check(it, trace, element2, languageVersionSettings2, deprecationResolver);
            }
        }
    }

    public final boolean shouldCheckPropertyGetter$frontend(@NotNull PsiElement expression2) {
        KtUnaryExpression unaryExpression;
        KtExpression ktExpression;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        KtBinaryExpression binaryExpression = PsiTreeUtil.getParentOfType(expression2, KtBinaryExpression.class);
        if (binaryExpression != null) {
            KtExpression left = binaryExpression.getLeft();
            if (Intrinsics.areEqual(left, expression2) && PROPERTY_SET_OPERATIONS.contains(binaryExpression.getOperationToken())) {
                return false;
            }
            KtReferenceExpression[] referenceExpressions = (KtReferenceExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)left, KtReferenceExpression.class);
            if (referenceExpressions != null) {
                Iterator<KtReferenceExpression> iterator2 = ArrayIteratorKt.iterator(referenceExpressions);
                while (iterator2.hasNext()) {
                    KtReferenceExpression expr = iterator2.next();
                    if (!Intrinsics.areEqual(expr, expression2) || !PROPERTY_SET_OPERATIONS.contains(binaryExpression.getOperationToken())) continue;
                    return false;
                }
            }
        }
        if (PROPERTY_SET_OPERATIONS.contains((ktExpression = (unaryExpression = PsiTreeUtil.getParentOfType(expression2, KtUnaryExpression.class))) != null && (ktExpression = ((KtUnaryExpression)ktExpression).getOperationReference()) != null ? ktExpression.getReferencedNameElementType() : null)) {
            return false;
        }
        KtCallableReferenceExpression callableExpression = PsiTreeUtil.getParentOfType(expression2, KtCallableReferenceExpression.class);
        return callableExpression == null || !Intrinsics.areEqual(callableExpression.getCallableReference(), expression2);
    }

    static {
        SpreadBuilder spreadBuilder2 = new SpreadBuilder(3);
        spreadBuilder2.addSpread(KtTokens.ALL_ASSIGNMENTS.getTypes());
        spreadBuilder2.add(KtTokens.PLUSPLUS);
        spreadBuilder2.add(KtTokens.MINUSMINUS);
        TokenSet tokenSet = TokenSet.create((IElementType[])spreadBuilder2.toArray(new IElementType[spreadBuilder2.size()]));
        Intrinsics.checkNotNullExpressionValue(tokenSet, "create(...)");
        PROPERTY_SET_OPERATIONS = tokenSet;
    }
}

