/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.calls.checkers;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.kotlin.coroutines.CoroutineUtilKt;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CoroutineCallCheckerKt;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lksp/org/jetbrains/kotlin/resolve/calls/checkers/BuilderFunctionsCallChecker;", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lksp/org/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lksp/com/intellij/psi/PsiElement;", "context", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
@SourceDebugExtension(value={"SMAP\ncoroutineCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 coroutineCallChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/BuilderFunctionsCallChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,205:1\n1745#2,3:206\n*S KotlinDebug\n*F\n+ 1 coroutineCallChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/BuilderFunctionsCallChecker\n*L\n126#1:206,3\n*E\n"})
public final class BuilderFunctionsCallChecker
implements CallChecker {
    @NotNull
    public static final BuilderFunctionsCallChecker INSTANCE = new BuilderFunctionsCallChecker();

    private BuilderFunctionsCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
            Intrinsics.checkNotNullParameter(reportOn, "reportOn");
            Intrinsics.checkNotNullParameter(context2, "context");
            Object obj = resolvedCall2.getCandidateDescriptor();
            FunctionDescriptor functionDescriptor = obj instanceof FunctionDescriptor ? (FunctionDescriptor)obj : null;
            if (functionDescriptor == null) {
                return;
            }
            FunctionDescriptor descriptor2 = functionDescriptor;
            List<ValueParameterDescriptor> list2 = descriptor2.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list2, "getValueParameters(...)");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull(it);
                    if (!CoroutineUtilKt.getHasSuspendFunctionType(it)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            CoroutineCallCheckerKt.checkCoroutinesFeature(context2.getLanguageVersionSettings(), context2.getTrace(), reportOn);
        }
    }
}

