/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.calls.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.resolve.SinceKotlinAccessibility;
import ksp.org.jetbrains.kotlin.resolve.SinceKotlinUtilKt;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.DeprecatedCallChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000e"}, d2={"Lksp/org/jetbrains/kotlin/resolve/calls/checkers/ApiVersionCallChecker;", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "targetDescriptor", "Lksp/org/jetbrains/kotlin/descriptors/CallableDescriptor;", "context", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "element", "Lksp/com/intellij/psi/PsiElement;", "resolvedCall", "Lksp/org/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "frontend"})
@SourceDebugExtension(value={"SMAP\nApiVersionCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiVersionCallChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/ApiVersionCallChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,51:1\n1#2:52\n*E\n"})
public final class ApiVersionCallChecker
implements CallChecker {
    @NotNull
    public static final ApiVersionCallChecker INSTANCE = new ApiVersionCallChecker();

    private ApiVersionCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context2, "context");
        Object obj = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(obj, "getResultingDescriptor(...)");
        this.check((CallableDescriptor)obj, context2, reportOn);
    }

    private final void check(CallableDescriptor targetDescriptor, CallCheckerContext context2, PsiElement element2) {
        block3: {
            if (targetDescriptor instanceof FakeCallableDescriptorForObject) {
                return;
            }
            SinceKotlinAccessibility accessibility = SinceKotlinUtilKt.checkSinceKotlinVersionAccessibility(targetDescriptor, context2.getLanguageVersionSettings());
            if (accessibility instanceof SinceKotlinAccessibility.NotAccessible) {
                context2.getTrace().report(Errors.API_NOT_AVAILABLE.on(element2, ((SinceKotlinAccessibility.NotAccessible)accessibility).getVersion().getVersionString(), context2.getLanguageVersionSettings().getApiVersion().getVersionString()));
            }
            if (!Intrinsics.areEqual(accessibility, SinceKotlinAccessibility.Accessible.INSTANCE) || !(targetDescriptor instanceof PropertyDescriptor) || !DeprecatedCallChecker.INSTANCE.shouldCheckPropertyGetter$frontend(element2)) break block3;
            PropertyGetterDescriptor propertyGetterDescriptor = ((PropertyDescriptor)targetDescriptor).getGetter();
            if (propertyGetterDescriptor != null) {
                PropertyGetterDescriptor it = propertyGetterDescriptor;
                boolean bl = false;
                INSTANCE.check(it, context2, element2);
            }
        }
    }
}

