/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import ksp.org.jetbrains.kotlin.builtins.StandardNames;
import ksp.org.jetbrains.kotlin.builtins.UnsignedTypes;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorPsiUtilsKt;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.MemberDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.Modality;
import ksp.org.jetbrains.kotlin.descriptors.ModalityUtilsKt;
import ksp.org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.SourceElement;
import ksp.org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.annotations.Annotated;
import ksp.org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import ksp.org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.psi.KtAnnotationEntry;
import ksp.org.jetbrains.kotlin.psi.KtBackingField;
import ksp.org.jetbrains.kotlin.psi.KtCallableDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtClass;
import ksp.org.jetbrains.kotlin.psi.KtClassOrObject;
import ksp.org.jetbrains.kotlin.psi.KtConstructor;
import ksp.org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import ksp.org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import ksp.org.jetbrains.kotlin.psi.KtElement;
import ksp.org.jetbrains.kotlin.psi.KtEnumEntry;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtFile;
import ksp.org.jetbrains.kotlin.psi.KtFunction;
import ksp.org.jetbrains.kotlin.psi.KtModifierList;
import ksp.org.jetbrains.kotlin.psi.KtModifierListOwner;
import ksp.org.jetbrains.kotlin.psi.KtModifierListOwnerStub;
import ksp.org.jetbrains.kotlin.psi.KtNamedDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtNamedFunction;
import ksp.org.jetbrains.kotlin.psi.KtObjectDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtPackageDirective;
import ksp.org.jetbrains.kotlin.psi.KtParameter;
import ksp.org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import ksp.org.jetbrains.kotlin.psi.KtProperty;
import ksp.org.jetbrains.kotlin.psi.KtPropertyAccessor;
import ksp.org.jetbrains.kotlin.psi.KtPropertyDelegate;
import ksp.org.jetbrains.kotlin.psi.KtReferenceExpression;
import ksp.org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import ksp.org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import ksp.org.jetbrains.kotlin.psi.KtSuperTypeList;
import ksp.org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import ksp.org.jetbrains.kotlin.psi.KtTypeAlias;
import ksp.org.jetbrains.kotlin.psi.KtTypeConstraint;
import ksp.org.jetbrains.kotlin.psi.KtTypeParameter;
import ksp.org.jetbrains.kotlin.psi.KtTypeParameterList;
import ksp.org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import ksp.org.jetbrains.kotlin.psi.KtTypeReference;
import ksp.org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import ksp.org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.AnnotationChecker;
import ksp.org.jetbrains.kotlin.resolve.AnnotationResolverImpl;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.BindingTrace;
import ksp.org.jetbrains.kotlin.resolve.BodiesResolveContext;
import ksp.org.jetbrains.kotlin.resolve.DeclarationsChecker;
import ksp.org.jetbrains.kotlin.resolve.DeclarationsCheckerKt;
import ksp.org.jetbrains.kotlin.resolve.DescriptorResolver;
import ksp.org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import ksp.org.jetbrains.kotlin.resolve.DescriptorUtils;
import ksp.org.jetbrains.kotlin.resolve.ExposedVisibilityChecker;
import ksp.org.jetbrains.kotlin.resolve.FiniteBoundRestrictionChecker;
import ksp.org.jetbrains.kotlin.resolve.IdentifierChecker;
import ksp.org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.LateinitModifierApplicabilityChecker;
import ksp.org.jetbrains.kotlin.resolve.ModifierCheckerCore;
import ksp.org.jetbrains.kotlin.resolve.ModifiersChecker;
import ksp.org.jetbrains.kotlin.resolve.NonExpansiveInheritanceRestrictionChecker;
import ksp.org.jetbrains.kotlin.resolve.ShadowedExtensionChecker;
import ksp.org.jetbrains.kotlin.resolve.UpperBoundChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.results.TypeSpecificityComparator;
import ksp.org.jetbrains.kotlin.resolve.checkers.PlatformDiagnosticSuppressor;
import ksp.org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.inline.InlineOnlyKt;
import ksp.org.jetbrains.kotlin.resolve.scopes.MemberScope;
import ksp.org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import ksp.org.jetbrains.kotlin.types.AbbreviatedType;
import ksp.org.jetbrains.kotlin.types.DynamicTypesKt;
import ksp.org.jetbrains.kotlin.types.FlexibleTypesKt;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.KotlinTypeKt;
import ksp.org.jetbrains.kotlin.types.SimpleType;
import ksp.org.jetbrains.kotlin.types.SubstitutionUtils;
import ksp.org.jetbrains.kotlin.types.TypeAliasExpander;
import ksp.org.jetbrains.kotlin.types.TypeAliasExpansion;
import ksp.org.jetbrains.kotlin.types.TypeAliasExpansionReportStrategy;
import ksp.org.jetbrains.kotlin.types.TypeAttributes;
import ksp.org.jetbrains.kotlin.types.TypeConstructor;
import ksp.org.jetbrains.kotlin.types.TypeProjection;
import ksp.org.jetbrains.kotlin.types.TypeSubstitutor;
import ksp.org.jetbrains.kotlin.types.TypeUtils;
import ksp.org.jetbrains.kotlin.types.UnwrappedType;
import ksp.org.jetbrains.kotlin.types.Variance;
import ksp.org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import ksp.org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c4\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\u0018\u0000 \u0088\u00012\u00020\u0001:\u0004\u0088\u0001\u0089\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J$\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010&H\u0002J\u0018\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010)\u001a\u00020 2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020 2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u00020 2\u0006\u0010(\u001a\u00020\u001cH\u0002J\u0018\u00102\u001a\u00020 2\u0006\u00103\u001a\u0002042\u0006\u0010/\u001a\u000200H\u0002J\u0018\u00105\u001a\u00020 2\u0006\u00106\u001a\u0002072\u0006\u00103\u001a\u000204H\u0002J\u001c\u00108\u001a\u00020 2\u0006\u00109\u001a\u00020:2\n\u0010*\u001a\u0006\u0012\u0002\b\u00030;H\u0002J\u0010\u0010<\u001a\u00020 2\u0006\u0010=\u001a\u000207H\u0002J\u0018\u0010>\u001a\u00020 2\u0006\u00109\u001a\u00020:2\u0006\u0010*\u001a\u00020?H\u0002J\u0018\u0010@\u001a\u00020 2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020DH\u0002J\u0010\u0010E\u001a\u00020 2\u0006\u0010*\u001a\u00020?H\u0002J\u0018\u0010F\u001a\u00020 2\u0006\u0010*\u001a\u00020?2\u0006\u0010G\u001a\u00020HH\u0002J\u001c\u0010I\u001a\u00020 2\u0006\u00109\u001a\u00020:2\n\u0010*\u001a\u0006\u0012\u0002\b\u00030;H\u0002J\u0018\u0010J\u001a\u00020 2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020NH\u0002J\u0016\u0010O\u001a\u00020 2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020PJ\u0018\u0010Q\u001a\u00020 2\u0006\u0010*\u001a\u00020R2\u0006\u0010G\u001a\u00020SH\u0002J\u0018\u0010T\u001a\u00020 2\u0006\u00103\u001a\u00020D2\u0006\u0010/\u001a\u000200H\u0002J\u0016\u0010U\u001a\u00020 2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-J \u0010V\u001a\u00020 2\u0006\u0010(\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u00103\u001a\u00020DH\u0002J\u0010\u0010W\u001a\u00020 2\u0006\u00103\u001a\u000204H\u0002J\u0010\u0010X\u001a\u00020 2\u0006\u0010Y\u001a\u00020ZH\u0002J\u0018\u0010[\u001a\u00020 2\u0006\u0010*\u001a\u00020\\2\u0006\u00103\u001a\u000204H\u0002J \u0010]\u001a\u00020 2\u0006\u0010G\u001a\u00020^2\u0006\u0010*\u001a\u00020_2\u0006\u0010`\u001a\u00020aH\u0002J\u0010\u0010b\u001a\u00020 2\u0006\u00103\u001a\u000204H\u0002J\u0018\u0010c\u001a\u00020 2\u0006\u0010/\u001a\u0002002\u0006\u00103\u001a\u00020DH\u0002J\u0018\u0010d\u001a\u00020 2\u0006\u0010(\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010e\u001a\u00020 2\u0006\u0010(\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010f\u001a\u00020 2\u0006\u0010G\u001a\u00020\"H\u0002J\u0018\u0010g\u001a\u00020 2\u0006\u0010h\u001a\u00020i2\u0006\u0010j\u001a\u00020kH\u0002J\u0018\u0010l\u001a\u00020 2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J\u0018\u0010m\u001a\u00020 2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u0010n\u001a\u00020 2\u0006\u0010o\u001a\u00020aH\u0002J\u0010\u0010p\u001a\u00020 2\u0006\u0010o\u001a\u00020aH\u0002J\u0010\u0010q\u001a\u00020 2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u0010r\u001a\u00020 2\u0006\u00106\u001a\u000207H\u0002J\u0018\u0010s\u001a\u00020 2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010t\u001a\u00020SH\u0002J\u001e\u0010u\u001a\b\u0012\u0004\u0012\u00020^0v2\u0006\u0010w\u001a\u00020x2\u0006\u0010y\u001a\u00020-H\u0002J\u0010\u0010z\u001a\u00020{2\u0006\u0010(\u001a\u00020\u001cH\u0002J\u000e\u0010|\u001a\u00020 2\u0006\u0010}\u001a\u00020~JD\u0010\u007f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\u0010\u0080\u0001\u001a\u00030\u0081\u00012\u0007\u0010\u0082\u0001\u001a\u00020{2\u0006\u0010(\u001a\u00020\u001c2\u0007\u0010\u0083\u0001\u001a\u00020{2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J(\u0010\u0084\u0001\u001a\u00020 2\u000e\u0010\u0085\u0001\u001a\t\u0012\u0004\u0012\u00020k0\u0086\u00012\r\u0010\u0087\u0001\u001a\b\u0012\u0004\u0012\u00020k0\u001bH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00060\u0017R\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b*\b\u0012\u0004\u0012\u00020\u001c0\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006\u008a\u0001\u00b2\u0006\f\u0010\u008b\u0001\u001a\u00030\u008c\u0001X\u008a\u0084\u0002"}, d2={"Lksp/org/jetbrains/kotlin/resolve/DeclarationsChecker;", "", "descriptorResolver", "Lksp/org/jetbrains/kotlin/resolve/DescriptorResolver;", "modifiersChecker", "Lksp/org/jetbrains/kotlin/resolve/ModifiersChecker;", "annotationChecker", "Lksp/org/jetbrains/kotlin/resolve/AnnotationChecker;", "identifierChecker", "Lksp/org/jetbrains/kotlin/resolve/IdentifierChecker;", "trace", "Lksp/org/jetbrains/kotlin/resolve/BindingTrace;", "languageVersionSettings", "Lksp/org/jetbrains/kotlin/config/LanguageVersionSettings;", "typeSpecificityComparator", "Lksp/org/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;", "diagnosticSuppressor", "Lksp/org/jetbrains/kotlin/resolve/checkers/PlatformDiagnosticSuppressor;", "upperBoundChecker", "Lksp/org/jetbrains/kotlin/resolve/UpperBoundChecker;", "(Lorg/jetbrains/kotlin/resolve/DescriptorResolver;Lorg/jetbrains/kotlin/resolve/ModifiersChecker;Lorg/jetbrains/kotlin/resolve/AnnotationChecker;Lorg/jetbrains/kotlin/resolve/IdentifierChecker;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;Lorg/jetbrains/kotlin/resolve/checkers/PlatformDiagnosticSuppressor;Lorg/jetbrains/kotlin/resolve/UpperBoundChecker;)V", "exposedChecker", "Lksp/org/jetbrains/kotlin/resolve/ExposedVisibilityChecker;", "Lksp/org/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure;", "shadowedExtensionChecker", "Lksp/org/jetbrains/kotlin/resolve/ShadowedExtensionChecker;", "deprecationWarning", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticFactory0;", "Lksp/org/jetbrains/kotlin/psi/KtProperty;", "getDeprecationWarning", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;)Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;", "checkAccessor", "", "propertyDescriptor", "Lksp/org/jetbrains/kotlin/descriptors/PropertyDescriptor;", "accessor", "Lksp/org/jetbrains/kotlin/psi/KtPropertyAccessor;", "accessorDescriptor", "Lksp/org/jetbrains/kotlin/descriptors/PropertyAccessorDescriptor;", "checkAccessors", "property", "checkActualTypeAlias", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtTypeAlias;", "typeAliasDescriptor", "Lksp/org/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "checkAnnotationClassMembers", "classOrObject", "Lksp/org/jetbrains/kotlin/psi/KtClassOrObject;", "checkBackingField", "checkClass", "classDescriptor", "Lksp/org/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;", "checkClassButNotObject", "aClass", "Lksp/org/jetbrains/kotlin/psi/KtClass;", "checkConstructorDeclaration", "constructorDescriptor", "Lksp/org/jetbrains/kotlin/descriptors/ClassConstructorDescriptor;", "Lksp/org/jetbrains/kotlin/psi/KtConstructor;", "checkConstructorInInterface", "klass", "checkConstructorVisibility", "Lksp/org/jetbrains/kotlin/psi/KtDeclaration;", "checkEnumEntry", "enumEntry", "Lksp/org/jetbrains/kotlin/psi/KtEnumEntry;", "enumEntryClass", "Lksp/org/jetbrains/kotlin/descriptors/ClassDescriptor;", "checkExpectDeclarationHasNoExternalModifier", "checkExpectDeclarationModifiers", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/MemberDescriptor;", "checkExpectedClassConstructor", "checkExpectedFunction", "function", "Lksp/org/jetbrains/kotlin/psi/KtNamedFunction;", "functionDescriptor", "Lksp/org/jetbrains/kotlin/descriptors/FunctionDescriptor;", "checkFunction", "Lksp/org/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "checkImplicitCallableType", "Lksp/org/jetbrains/kotlin/psi/KtCallableDeclaration;", "Lksp/org/jetbrains/kotlin/descriptors/CallableDescriptor;", "checkLocalAnnotation", "checkLocalTypeAliasDeclaration", "checkMemberProperty", "checkMethodsOfAnyInInterface", "checkModifiersAndAnnotationsInPackageDirective", "file", "Lksp/org/jetbrains/kotlin/psi/KtFile;", "checkObject", "Lksp/org/jetbrains/kotlin/psi/KtObjectDeclaration;", "checkOnlyOneTypeParameterBound", "Lksp/org/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "Lksp/org/jetbrains/kotlin/psi/KtTypeParameter;", "owner", "Lksp/org/jetbrains/kotlin/psi/KtTypeParameterListOwner;", "checkOpenMembers", "checkPrimaryConstructor", "checkProperty", "checkPropertyInitializer", "checkPropertyTypeParametersAreUsedInReceiverType", "checkSupertypesForConsistency", "classifier", "Lksp/org/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "sourceElement", "Lksp/com/intellij/psi/PsiElement;", "checkTypeAliasDeclaration", "checkTypeAliasExpansion", "checkTypeParameterConstraints", "typeParameterListOwner", "checkTypeParameters", "checkTypesInClassHeader", "checkValOnAnnotationParameter", "checkVarargParameters", "callableDescriptor", "getUsedTypeAliasParameters", "", "type", "Lksp/org/jetbrains/kotlin/types/KotlinType;", "typeAlias", "noExplicitTypeOrGetterType", "", "process", "bodiesResolveContext", "Lksp/org/jetbrains/kotlin/resolve/BodiesResolveContext;", "reportMustBeInitialized", "containingDeclaration", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "hasAnyAccessorImplementation", "isOpenValDeferredInitDeprecationWarning", "reportVisibilityModifierDiagnostics", "tokens", "", "diagnostic", "Companion", "TypeAliasDeclarationCheckingReportStrategy", "frontend", "delegateClassScope", "Lksp/org/jetbrains/kotlin/resolve/scopes/MemberScope;"})
@SourceDebugExtension(value={"SMAP\nDeclarationsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeclarationsChecker.kt\norg/jetbrains/kotlin/resolve/DeclarationsChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1156:1\n1547#2:1157\n1618#2,3:1158\n798#2,11:1161\n1745#2,3:1172\n1745#2,3:1175\n1547#2:1178\n1618#2,3:1179\n1609#2:1182\n1853#2:1183\n1854#2:1186\n1610#2:1187\n1547#2:1188\n1618#2,3:1189\n3183#2,10:1192\n764#2:1202\n855#2,2:1203\n1601#2,9:1205\n1853#2:1214\n1854#2:1216\n1610#2:1217\n1547#2:1218\n1618#2,3:1219\n288#2,2:1222\n1547#2:1224\n1618#2,3:1225\n1547#2:1228\n1618#2,3:1229\n1853#2,2:1232\n1853#2,2:1234\n2622#2,3:1236\n764#2:1239\n855#2,2:1240\n1#3:1184\n1#3:1185\n1#3:1215\n*S KotlinDebug\n*F\n+ 1 DeclarationsChecker.kt\norg/jetbrains/kotlin/resolve/DeclarationsChecker\n*L\n111#1:1157\n111#1:1158,3\n112#1:1161,11\n178#1:1172,3\n183#1:1175,3\n188#1:1178\n188#1:1179,3\n208#1:1182\n208#1:1183\n208#1:1186\n208#1:1187\n399#1:1188\n399#1:1189,3\n400#1:1192,10\n409#1:1202\n409#1:1203,2\n412#1:1205,9\n412#1:1214\n412#1:1216\n412#1:1217\n413#1:1218\n413#1:1219,3\n416#1:1222,2\n432#1:1224\n432#1:1225,3\n445#1:1228\n445#1:1229,3\n548#1:1232,2\n778#1:1234,2\n867#1:1236,3\n1056#1:1239\n1056#1:1240,2\n208#1:1185\n412#1:1215\n*E\n"})
public final class DeclarationsChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DescriptorResolver descriptorResolver;
    @NotNull
    private final AnnotationChecker annotationChecker;
    @NotNull
    private final IdentifierChecker identifierChecker;
    @NotNull
    private final BindingTrace trace;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final PlatformDiagnosticSuppressor diagnosticSuppressor;
    @NotNull
    private final UpperBoundChecker upperBoundChecker;
    @NotNull
    private final ModifiersChecker.ModifiersCheckingProcedure modifiersChecker;
    @NotNull
    private final ExposedVisibilityChecker exposedChecker;
    @NotNull
    private final ShadowedExtensionChecker shadowedExtensionChecker;
    private static final ImmutableSet<String> METHOD_OF_ANY_NAMES = ImmutableSet.of("toString", "hashCode", "equals");

    public DeclarationsChecker(@NotNull DescriptorResolver descriptorResolver, @NotNull ModifiersChecker modifiersChecker, @NotNull AnnotationChecker annotationChecker, @NotNull IdentifierChecker identifierChecker, @NotNull BindingTrace trace, @NotNull LanguageVersionSettings languageVersionSettings2, @NotNull TypeSpecificityComparator typeSpecificityComparator, @NotNull PlatformDiagnosticSuppressor diagnosticSuppressor, @NotNull UpperBoundChecker upperBoundChecker) {
        Intrinsics.checkNotNullParameter(descriptorResolver, "descriptorResolver");
        Intrinsics.checkNotNullParameter(modifiersChecker, "modifiersChecker");
        Intrinsics.checkNotNullParameter(annotationChecker, "annotationChecker");
        Intrinsics.checkNotNullParameter(identifierChecker, "identifierChecker");
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(languageVersionSettings2, "languageVersionSettings");
        Intrinsics.checkNotNullParameter(typeSpecificityComparator, "typeSpecificityComparator");
        Intrinsics.checkNotNullParameter(diagnosticSuppressor, "diagnosticSuppressor");
        Intrinsics.checkNotNullParameter(upperBoundChecker, "upperBoundChecker");
        this.descriptorResolver = descriptorResolver;
        this.annotationChecker = annotationChecker;
        this.identifierChecker = identifierChecker;
        this.trace = trace;
        this.languageVersionSettings = languageVersionSettings2;
        this.diagnosticSuppressor = diagnosticSuppressor;
        this.upperBoundChecker = upperBoundChecker;
        ModifiersChecker.ModifiersCheckingProcedure modifiersCheckingProcedure = modifiersChecker.withTrace(this.trace);
        Intrinsics.checkNotNullExpressionValue(modifiersCheckingProcedure, "withTrace(...)");
        this.modifiersChecker = modifiersCheckingProcedure;
        this.exposedChecker = new ExposedVisibilityChecker(this.languageVersionSettings, this.trace);
        this.shadowedExtensionChecker = new ShadowedExtensionChecker(typeSpecificityComparator, this.trace);
    }

    /*
     * WARNING - void declaration
     */
    public final void process(@NotNull BodiesResolveContext bodiesResolveContext) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        Object propertyDescriptor;
        Intrinsics.checkNotNullParameter(bodiesResolveContext, "bodiesResolveContext");
        for (KtFile ktFile : bodiesResolveContext.getFiles()) {
            Intrinsics.checkNotNull(ktFile);
            this.checkModifiersAndAnnotationsInPackageDirective(ktFile);
            this.annotationChecker.check(ktFile, this.trace, null);
        }
        for (Map.Entry entry : bodiesResolveContext.getDeclaredClasses().entrySet()) {
            KtClassOrObject ktClassOrObject = (KtClassOrObject)entry.getKey();
            ClassDescriptorWithResolutionScopes classDescriptor2 = (ClassDescriptorWithResolutionScopes)entry.getValue();
            Intrinsics.checkNotNull(classDescriptor2);
            Intrinsics.checkNotNull(ktClassOrObject);
            this.checkClass(classDescriptor2, ktClassOrObject);
            this.modifiersChecker.checkModifiersForDeclaration(ktClassOrObject, classDescriptor2);
            this.identifierChecker.checkDeclaration(ktClassOrObject, this.trace);
            this.exposedChecker.checkClassHeader(ktClassOrObject, classDescriptor2);
        }
        for (Map.Entry entry : bodiesResolveContext.getFunctions().entrySet()) {
            KtNamedFunction ktNamedFunction = (KtNamedFunction)entry.getKey();
            SimpleFunctionDescriptor functionDescriptor = (SimpleFunctionDescriptor)entry.getValue();
            Intrinsics.checkNotNull(ktNamedFunction);
            Intrinsics.checkNotNull(functionDescriptor);
            this.checkFunction(ktNamedFunction, functionDescriptor);
            this.modifiersChecker.checkModifiersForDeclaration(ktNamedFunction, functionDescriptor);
            this.identifierChecker.checkDeclaration(ktNamedFunction, this.trace);
        }
        for (Map.Entry entry : bodiesResolveContext.getProperties().entrySet()) {
            KtProperty ktProperty = (KtProperty)entry.getKey();
            propertyDescriptor = (PropertyDescriptor)entry.getValue();
            Intrinsics.checkNotNull(ktProperty);
            Intrinsics.checkNotNull(propertyDescriptor);
            this.checkProperty(ktProperty, (PropertyDescriptor)propertyDescriptor);
            this.modifiersChecker.checkModifiersForDeclaration(ktProperty, (MemberDescriptor)propertyDescriptor);
            this.identifierChecker.checkDeclaration(ktProperty, this.trace);
        }
        Iterable iterable = bodiesResolveContext.getDestructuringDeclarationEntries().entrySet();
        boolean bl = false;
        propertyDescriptor = iterable;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            KtDestructuringDeclarationEntry entry2 = (KtDestructuringDeclarationEntry)entry.getKey();
            collection.add(entry2.getParent());
        }
        Iterable iterable2 = (List)destination$iv$iv;
        boolean bl3 = false;
        $this$mapTo$iv$iv = iterable2;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtDestructuringDeclaration)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List<KtDestructuringDeclaration> destructuringDeclarations = CollectionsKt.distinct((List)destination$iv$iv);
        for (KtDestructuringDeclaration ktDestructuringDeclaration : destructuringDeclarations) {
            this.modifiersChecker.checkModifiersForDestructuringDeclaration(ktDestructuringDeclaration);
            this.identifierChecker.checkDeclaration(ktDestructuringDeclaration, this.trace);
        }
        for (Map.Entry<KtSecondaryConstructor, ClassConstructorDescriptor> entry : bodiesResolveContext.getSecondaryConstructors().entrySet()) {
            KtSecondaryConstructor declaration2 = entry.getKey();
            ClassConstructorDescriptor constructorDescriptor = entry.getValue();
            Intrinsics.checkNotNull(constructorDescriptor);
            Intrinsics.checkNotNull(declaration2);
            this.checkConstructorDeclaration(constructorDescriptor, declaration2);
            ExposedVisibilityChecker.checkFunction$default(this.exposedChecker, declaration2, constructorDescriptor, null, 4, null);
        }
        for (Map.Entry<KtTypeAlias, TypeAliasDescriptor> entry : bodiesResolveContext.getTypeAliases().entrySet()) {
            KtTypeAlias declaration2 = entry.getKey();
            TypeAliasDescriptor typeAliasDescriptor = entry.getValue();
            Intrinsics.checkNotNull(declaration2);
            Intrinsics.checkNotNull(typeAliasDescriptor);
            this.checkTypeAliasDeclaration(declaration2, typeAliasDescriptor);
            this.modifiersChecker.checkModifiersForDeclaration(declaration2, typeAliasDescriptor);
            this.exposedChecker.checkTypeAlias(declaration2, typeAliasDescriptor);
        }
    }

    public final void checkLocalTypeAliasDeclaration(@NotNull KtTypeAlias declaration2, @NotNull TypeAliasDescriptor typeAliasDescriptor) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(typeAliasDescriptor, "typeAliasDescriptor");
        this.checkTypeAliasDeclaration(declaration2, typeAliasDescriptor);
        this.modifiersChecker.checkModifiersForDeclaration(declaration2, typeAliasDescriptor);
        this.exposedChecker.checkTypeAlias(declaration2, typeAliasDescriptor);
    }

    private final void checkTypeAliasDeclaration(KtTypeAlias declaration2, TypeAliasDescriptor typeAliasDescriptor) {
        KtTypeReference ktTypeReference = declaration2.getTypeReference();
        if (ktTypeReference == null) {
            return;
        }
        KtTypeReference typeReference = ktTypeReference;
        this.checkTypeAliasExpansion(declaration2, typeAliasDescriptor);
        SimpleType expandedType2 = typeAliasDescriptor.getExpandedType();
        if (KotlinTypeKt.isError(expandedType2)) {
            return;
        }
        ClassifierDescriptor expandedClassifier = expandedType2.getConstructor().getDeclarationDescriptor();
        if (DynamicTypesKt.isDynamic(expandedType2) || expandedClassifier instanceof TypeParameterDescriptor) {
            this.trace.report(Errors.TYPEALIAS_SHOULD_EXPAND_TO_CLASS.on((KtTypeReference)((PsiElement)typeReference), expandedType2));
        }
        if (TypeUtils.contains((KotlinType)expandedType2, checkTypeAliasDeclaration.1.INSTANCE)) {
            this.trace.report(Errors.TYPEALIAS_EXPANDED_TO_MALFORMED_TYPE.on((KtTypeReference)((PsiElement)typeReference), expandedType2, "Array<Nothing> is illegal"));
        }
        Set<TypeParameterDescriptor> usedTypeAliasParameters = this.getUsedTypeAliasParameters(expandedType2, typeAliasDescriptor);
        for (TypeParameterDescriptor typeParameter : typeAliasDescriptor.getDeclaredTypeParameters()) {
            KtTypeParameter source;
            if (usedTypeAliasParameters.contains(typeParameter)) continue;
            Intrinsics.checkNotNull(typeParameter);
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(typeParameter);
            if ((psiElement instanceof KtTypeParameter ? (KtTypeParameter)psiElement : null) == null) {
                throw new AssertionError((Object)("No source element for type parameter " + typeParameter + " of " + typeAliasDescriptor));
            }
            source = source;
            this.trace.report(Errors.UNUSED_TYPEALIAS_PARAMETER.on((KtTypeParameter)((PsiElement)source), typeParameter, expandedType2));
        }
        if (PsiUtilsKt.hasActualModifier(declaration2)) {
            this.checkActualTypeAlias(declaration2, typeAliasDescriptor);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkActualTypeAlias(KtTypeAlias declaration2, TypeAliasDescriptor typeAliasDescriptor) {
        void $this$mapTo$iv$iv;
        boolean bl;
        SimpleType rhs;
        block15: {
            Object it;
            boolean bl2;
            boolean $i$f$any;
            Iterable $this$any$iv;
            block14: {
                rhs = typeAliasDescriptor.getUnderlyingType();
                ClassifierDescriptor classDescriptor2 = rhs.getConstructor().getDeclarationDescriptor();
                if (!(classDescriptor2 instanceof ClassDescriptor)) {
                    this.trace.report(Errors.ACTUAL_TYPE_ALIAS_NOT_TO_CLASS.on((KtTypeAlias)((PsiElement)declaration2)));
                    return;
                }
                List<TypeParameterDescriptor> list2 = ((ClassDescriptor)classDescriptor2).getDeclaredTypeParameters();
                Intrinsics.checkNotNullExpressionValue(list2, "getDeclaredTypeParameters(...)");
                $this$any$iv = list2;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (TypeParameterDescriptor)element$iv;
                        boolean bl3 = false;
                        if (!(it.getVariance() != Variance.INVARIANT)) continue;
                        bl2 = true;
                        break block14;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                this.trace.report(Errors.ACTUAL_TYPE_ALIAS_TO_CLASS_WITH_DECLARATION_SITE_VARIANCE.on((KtTypeAlias)((PsiElement)declaration2)));
                return;
            }
            $this$any$iv = rhs.getArguments();
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (TypeProjection)element$iv;
                    boolean bl4 = false;
                    if (!(it.getProjectionKind() != Variance.INVARIANT || it.isStarProjection())) continue;
                    bl = true;
                    break block15;
                }
                bl = false;
            }
        }
        if (bl) {
            this.trace.report(Errors.ACTUAL_TYPE_ALIAS_WITH_USE_SITE_VARIANCE.on((KtTypeAlias)((PsiElement)declaration2)));
            return;
        }
        Iterable $this$map$iv = rhs.getArguments();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            ClassifierDescriptor classifierDescriptor = it.getType().getConstructor().getDeclarationDescriptor();
            collection.add(classifierDescriptor instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)classifierDescriptor : null);
        }
        if (!Intrinsics.areEqual((List)destination$iv$iv, typeAliasDescriptor.getDeclaredTypeParameters())) {
            this.trace.report(Errors.ACTUAL_TYPE_ALIAS_WITH_COMPLEX_SUBSTITUTION.on((KtTypeAlias)((PsiElement)declaration2)));
            return;
        }
        if (this.languageVersionSettings.supportsFeature(LanguageFeature.MultiplatformRestrictions)) {
            if (TypeUtilsKt.isNothing(rhs)) {
                this.trace.report(Errors.ACTUAL_TYPE_ALIAS_TO_NOTHING.on((KtTypeAlias)((PsiElement)declaration2)));
                return;
            }
            if (rhs.isMarkedNullable()) {
                this.trace.report(Errors.ACTUAL_TYPE_ALIAS_TO_NULLABLE_TYPE.on((KtTypeAlias)((PsiElement)declaration2)));
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<TypeParameterDescriptor> getUsedTypeAliasParameters(KotlinType type2, TypeAliasDescriptor typeAlias) {
        void $this$mapNotNullTo$iv;
        Iterable iterable = TypeUtilsKt.constituentTypes(type2);
        Collection destination$iv = new HashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ClassifierDescriptor classifierDescriptor;
            TypeParameterDescriptor descriptor2;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            KotlinType it = (KotlinType)element$iv;
            boolean bl2 = false;
            ClassifierDescriptor classifierDescriptor2 = it.getConstructor().getDeclarationDescriptor();
            TypeParameterDescriptor typeParameterDescriptor = descriptor2 = classifierDescriptor2 instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)classifierDescriptor2 : null;
            if (typeParameterDescriptor != null) {
                ClassifierDescriptor it2 = classifierDescriptor2 = typeParameterDescriptor;
                boolean bl3 = false;
                classifierDescriptor = Intrinsics.areEqual(it2.getContainingDeclaration(), typeAlias) ? classifierDescriptor2 : null;
            } else {
                classifierDescriptor = null;
            }
            if (classifierDescriptor == null) continue;
            ClassifierDescriptor it$iv = classifierDescriptor;
            boolean bl4 = false;
            destination$iv.add(it$iv);
        }
        return (Set)destination$iv;
    }

    private final void checkTypeAliasExpansion(KtTypeAlias declaration2, TypeAliasDescriptor typeAliasDescriptor) {
        TypeAliasExpansion typeAliasExpansion = TypeAliasExpansion.Companion.createWithFormalArguments(typeAliasDescriptor);
        TypeAliasDeclarationCheckingReportStrategy reportStrategy = new TypeAliasDeclarationCheckingReportStrategy(this.trace, typeAliasDescriptor, declaration2, this.upperBoundChecker);
        new TypeAliasExpander(reportStrategy, true).expandWithoutAbbreviation(typeAliasExpansion, TypeAttributes.Companion.getEmpty());
    }

    private final void checkConstructorDeclaration(ClassConstructorDescriptor constructorDescriptor, KtConstructor<?> declaration2) {
        this.modifiersChecker.checkModifiersForDeclaration(declaration2, constructorDescriptor);
        this.identifierChecker.checkDeclaration(declaration2, this.trace);
        this.checkVarargParameters(this.trace, constructorDescriptor);
        this.checkConstructorVisibility(constructorDescriptor, declaration2);
        this.checkExpectedClassConstructor(constructorDescriptor, declaration2);
    }

    private final void checkExpectedClassConstructor(ClassConstructorDescriptor constructorDescriptor, KtConstructor<?> declaration2) {
        KtConstructorDelegationCall delegationCall;
        if (!constructorDescriptor.isExpect()) {
            return;
        }
        if (declaration2.hasBody()) {
            this.trace.report(Errors.EXPECTED_DECLARATION_WITH_BODY.on((KtDeclaration)((PsiElement)declaration2)));
        }
        if (constructorDescriptor.getContainingDeclaration().getKind() == ClassKind.ENUM_CLASS) {
            this.trace.report(Errors.EXPECTED_ENUM_CONSTRUCTOR.on((KtConstructor<?>)((PsiElement)declaration2)));
        }
        if (declaration2 instanceof KtPrimaryConstructor && !DescriptorUtils.isAnnotationClass(constructorDescriptor.getConstructedClass())) {
            ClassDescriptor classDescriptor2 = constructorDescriptor.getConstructedClass();
            Intrinsics.checkNotNullExpressionValue(classDescriptor2, "getConstructedClass(...)");
            if (!InlineClassesUtilsKt.isValueClass(classDescriptor2)) {
                for (KtParameter parameter2 : ((KtPrimaryConstructor)declaration2).getValueParameters()) {
                    if (!parameter2.hasValOrVar()) continue;
                    this.trace.report(Errors.EXPECTED_CLASS_CONSTRUCTOR_PROPERTY_PARAMETER.on((KtParameter)((PsiElement)parameter2)));
                }
            }
        }
        if (declaration2 instanceof KtSecondaryConstructor && !(delegationCall = ((KtSecondaryConstructor)declaration2).getDelegationCall()).isImplicit()) {
            this.trace.report(Errors.EXPECTED_CLASS_CONSTRUCTOR_DELEGATION_CALL.on((KtConstructorDelegationCall)((PsiElement)delegationCall)));
        }
    }

    private final void checkConstructorVisibility(ClassConstructorDescriptor constructorDescriptor, KtDeclaration declaration2) {
        PsiElement visibilityModifier = KtPsiUtilKt.visibilityModifier(declaration2);
        Object object = visibilityModifier;
        if (object == null || (object = object.getNode()) == null || (object = object.getElementType()) == null) {
            return;
        }
        Object visibilityKeyword = object;
        ClassDescriptor classDescriptor2 = constructorDescriptor.getContainingDeclaration();
        if (classDescriptor2.getKind() == ClassKind.ENUM_CLASS) {
            if (!Intrinsics.areEqual(visibilityKeyword, KtTokens.PRIVATE_KEYWORD)) {
                this.trace.report(Errors.NON_PRIVATE_CONSTRUCTOR_IN_ENUM.on(visibilityModifier));
            }
        } else if (classDescriptor2.getModality() == Modality.SEALED) {
            boolean protectedIsAllowed = this.languageVersionSettings.supportsFeature(LanguageFeature.AllowSealedInheritorsInDifferentFilesOfSamePackage);
            if (!(Intrinsics.areEqual(visibilityKeyword, KtTokens.PRIVATE_KEYWORD) || protectedIsAllowed && Intrinsics.areEqual(visibilityKeyword, KtTokens.PROTECTED_KEYWORD))) {
                DiagnosticFactory0<PsiElement> factory2 = protectedIsAllowed ? Errors.NON_PRIVATE_OR_PROTECTED_CONSTRUCTOR_IN_SEALED : Errors.NON_PRIVATE_CONSTRUCTOR_IN_SEALED;
                this.trace.report(factory2.on(visibilityModifier));
            }
        }
    }

    private final void checkModifiersAndAnnotationsInPackageDirective(KtFile file2) {
        KtPackageDirective ktPackageDirective = file2.getPackageDirective();
        if (ktPackageDirective == null) {
            return;
        }
        KtPackageDirective packageDirective = ktPackageDirective;
        KtModifierList ktModifierList = packageDirective.getModifierList();
        if (ktModifierList == null) {
            return;
        }
        KtModifierList modifierList2 = ktModifierList;
        for (KtAnnotationEntry annotationEntry2 : modifierList2.getAnnotationEntries()) {
            KtSimpleNameExpression it;
            KtConstructorCalleeExpression calleeExpression = annotationEntry2.getCalleeExpression();
            if (calleeExpression == null) continue;
            if (calleeExpression.getConstructorReferenceExpression() == null) continue;
            boolean bl = false;
            this.trace.report(Errors.UNRESOLVED_REFERENCE.on((KtReferenceExpression)((PsiElement)it), it));
        }
        this.annotationChecker.check(packageDirective, this.trace, null);
        ModifierCheckerCore.INSTANCE.check(packageDirective, this.trace, null, this.languageVersionSettings);
    }

    private final void checkClass(ClassDescriptorWithResolutionScopes classDescriptor2, KtClassOrObject classOrObject) {
        this.checkSupertypesForConsistency(classDescriptor2, classOrObject);
        this.checkLocalAnnotation(classDescriptor2, classOrObject);
        this.checkTypesInClassHeader(classOrObject);
        KtClassOrObject ktClassOrObject = classOrObject;
        if (ktClassOrObject instanceof KtClass) {
            this.checkClassButNotObject((KtClass)classOrObject, classDescriptor2);
            this.descriptorResolver.checkNamesInConstraints(classOrObject, classDescriptor2, classDescriptor2.getScopeForClassHeaderResolution(), this.trace);
        } else if (ktClassOrObject instanceof KtObjectDeclaration) {
            this.checkObject((KtObjectDeclaration)classOrObject, classDescriptor2);
        }
        this.checkPrimaryConstructor(classOrObject, classDescriptor2);
        this.checkExpectDeclarationModifiers(classOrObject, classDescriptor2);
    }

    private final void checkLocalAnnotation(ClassDescriptor classDescriptor2, KtClassOrObject classOrObject) {
        if (classDescriptor2.getKind() == ClassKind.ANNOTATION_CLASS && DescriptorUtils.isLocal(classDescriptor2)) {
            this.trace.report(Errors.LOCAL_ANNOTATION_CLASS.on(this.languageVersionSettings, (KtClassOrObject)((PsiElement)classOrObject)));
        }
    }

    private final void checkTypesInClassHeader(KtClassOrObject classOrObject) {
        KotlinType type2;
        KtTypeReference typeReference;
        for (KtSuperTypeListEntry delegationSpecifier : classOrObject.getSuperTypeListEntries()) {
            KotlinType it;
            KtTypeReference typeReference2;
            if (delegationSpecifier.getTypeReference() == null) continue;
            if (DeclarationsChecker.checkTypesInClassHeader$type(typeReference2, this) == null) continue;
            boolean bl = false;
            this.upperBoundChecker.checkBoundsInSupertype(typeReference2, it, this.trace, this.languageVersionSettings);
        }
        if (!(classOrObject instanceof KtClass)) {
            return;
        }
        ArrayList<DescriptorResolver.UpperBoundCheckRequest> upperBoundCheckRequests = new ArrayList<DescriptorResolver.UpperBoundCheckRequest>();
        for (KtTypeParameter typeParameter : ((KtClass)classOrObject).getTypeParameters()) {
            if (typeParameter.getExtendsBound() == null || DeclarationsChecker.checkTypesInClassHeader$type(typeReference, this) == null) continue;
            upperBoundCheckRequests.add(new DescriptorResolver.UpperBoundCheckRequest(typeParameter.getNameAsName(), typeReference, type2));
        }
        for (KtTypeConstraint constraint : ((KtClass)classOrObject).getTypeConstraints()) {
            Object object;
            if (constraint.getBoundTypeReference() == null || DeclarationsChecker.checkTypesInClassHeader$type(typeReference, this) == null || (object = constraint.getSubjectTypeParameterName()) == null || (object = object.getReferencedNameAsName()) == null) continue;
            Object name2 = object;
            upperBoundCheckRequests.add(new DescriptorResolver.UpperBoundCheckRequest((Name)name2, typeReference, type2));
        }
        DescriptorResolver.checkUpperBoundTypes(this.trace, (List<DescriptorResolver.UpperBoundCheckRequest>)upperBoundCheckRequests, false);
        for (DescriptorResolver.UpperBoundCheckRequest request : upperBoundCheckRequests) {
            KtTypeReference ktTypeReference = request.upperBound;
            Intrinsics.checkNotNullExpressionValue(ktTypeReference, "upperBound");
            KotlinType kotlinType = request.upperBoundType;
            Intrinsics.checkNotNullExpressionValue(kotlinType, "upperBoundType");
            this.upperBoundChecker.checkBoundsInSupertype(ktTypeReference, kotlinType, this.trace, this.languageVersionSettings);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkOnlyOneTypeParameterBound(TypeParameterDescriptor descriptor2, KtTypeParameter declaration2, KtTypeParameterListOwner owner) {
        TypeConstructor constructor2;
        void $this$partition$iv;
        Collection collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        List<KotlinType> list2 = descriptor2.getUpperBounds();
        Intrinsics.checkNotNullExpressionValue(list2, "getUpperBounds(...)");
        List<KotlinType> upperBounds2 = list2;
        Iterable iterable = upperBounds2;
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            KotlinType kotlinType = (KotlinType)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getConstructor());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            constructor2 = (TypeConstructor)element$iv;
            boolean bl = false;
            if (constructor2.getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        boolean bl = false;
        Pair pair2 = TuplesKt.to(CollectionsKt.toSet(pair.getFirst()), CollectionsKt.toSet(pair.getSecond()));
        Set boundsWhichAreTypeParameters = pair2.component1();
        Set otherBounds = pair2.component2();
        if (boundsWhichAreTypeParameters.size() > 1 || boundsWhichAreTypeParameters.size() == 1 && !((Collection)otherBounds).isEmpty()) {
            KtModifierListOwnerStub ktModifierListOwnerStub;
            if (boundsWhichAreTypeParameters.size() + otherBounds.size() == 2) {
                Pair problematicBound;
                Serializable serializable;
                Object v4;
                block11: {
                    void $this$mapTo$iv$iv2;
                    void $this$map$iv2;
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv;
                    Object constraint;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    List<KtTypeConstraint> list3 = owner.getTypeConstraints();
                    Intrinsics.checkNotNullExpressionValue(list3, "getTypeConstraints(...)");
                    Iterable $i$f$mapTo2 = list3;
                    boolean $i$f$filter = false;
                    constructor2 = $this$filter$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        constraint = (KtTypeConstraint)element$iv$iv;
                        boolean bl2 = false;
                        KtSimpleNameExpression ktSimpleNameExpression = ((KtTypeConstraint)constraint).getSubjectTypeParameterName();
                        if (!Intrinsics.areEqual(ktSimpleNameExpression != null ? ktSimpleNameExpression.getReferencedNameAsName() : null, declaration2.getNameAsName())) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv2;
                    boolean $i$f$mapNotNull = false;
                    $this$filterTo$iv$iv = $this$mapNotNull$iv;
                    destination$iv$iv2 = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    constraint = $this$forEach$iv$iv$iv.iterator();
                    while (constraint.hasNext()) {
                        KtTypeReference it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = constraint.next();
                        boolean bl3 = false;
                        KtTypeConstraint constraint2 = (KtTypeConstraint)element$iv$iv;
                        boolean bl4 = false;
                        if (constraint2.getBoundTypeReference() == null) continue;
                        boolean bl5 = false;
                        destination$iv$iv2.add(it$iv$iv);
                    }
                    $this$mapNotNull$iv = (List)destination$iv$iv2;
                    boolean $i$f$map2 = false;
                    $this$mapNotNullTo$iv$iv = $this$map$iv2;
                    destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                    boolean $i$f$mapTo3 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        void typeReference;
                        constraint = (KtTypeReference)item$iv$iv;
                        collection = destination$iv$iv2;
                        boolean bl6 = false;
                        collection.add(TuplesKt.to(typeReference, this.trace.getBindingContext().get(BindingContext.TYPE, typeReference)));
                    }
                    List allBounds = (List)destination$iv$iv2;
                    Iterable $this$firstOrNull$iv = allBounds;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Pair bound = (Pair)element$iv;
                        boolean bl7 = false;
                        KotlinType kotlinType = (KotlinType)bound.getSecond();
                        if (!(!Intrinsics.areEqual(kotlinType != null ? kotlinType.getConstructor() : null, CollectionsKt.first(boundsWhichAreTypeParameters)))) continue;
                        v4 = element$iv;
                        break block11;
                    }
                    v4 = null;
                }
                ktModifierListOwnerStub = (serializable = (problematicBound = (Pair)v4)) != null && (serializable = (KtTypeReference)serializable.getFirst()) != null ? (KtModifierListOwnerStub)serializable : (KtModifierListOwnerStub)declaration2;
            } else {
                ktModifierListOwnerStub = declaration2;
            }
            KtModifierListOwnerStub reportOn = ktModifierListOwnerStub;
            DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
            MemberDescriptor memberDescriptor = declarationDescriptor instanceof MemberDescriptor ? (MemberDescriptor)declarationDescriptor : null;
            boolean bl8 = memberDescriptor != null ? InlineOnlyKt.isInlineOnly(memberDescriptor) : false;
            if (bl8) {
                return;
            }
            this.trace.report(Errors.BOUNDS_NOT_ALLOWED_IF_BOUNDED_BY_TYPE_PARAMETER.on((KtElement)((PsiElement)reportOn)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkSupertypesForConsistency(ClassifierDescriptor classifier, PsiElement sourceElement) {
        Iterable it;
        Collection collection;
        Annotated annotated;
        if (classifier instanceof TypeParameterDescriptor) {
            void $this$mapTo$iv$iv;
            List<KotlinType> list2 = ((TypeParameterDescriptor)classifier).getUpperBounds();
            Intrinsics.checkNotNullExpressionValue(list2, "getUpperBounds(...)");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                annotated = (KotlinType)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((KotlinType)((Object)it)).getConstructor());
            }
            List immediateUpperBounds = (List)destination$iv$iv;
            if (immediateUpperBounds.size() != CollectionsKt.toSet(immediateUpperBounds).size()) {
                return;
            }
        }
        Multimap<TypeParameterDescriptor, TypeProjection> multimap = SubstitutionUtils.buildDeepSubstitutionMultimap(classifier.getDefaultType());
        Intrinsics.checkNotNullExpressionValue(multimap, "buildDeepSubstitutionMultimap(...)");
        Multimap<TypeParameterDescriptor, TypeProjection> multiMap = multimap;
        Map<TypeParameterDescriptor, Collection<TypeProjection>> map = multiMap.asMap();
        Intrinsics.checkNotNullExpressionValue(map, "asMap(...)");
        for (Map.Entry<TypeParameterDescriptor, Collection<TypeProjection>> entry : map.entrySet()) {
            ClassDescriptor containingDeclaration;
            void $this$mapTo$iv$iv;
            TypeParameterDescriptor typeParameterDescriptor = entry.getKey();
            Collection<TypeProjection> projections2 = entry.getValue();
            if (projections2.size() <= 1) continue;
            Intrinsics.checkNotNull(projections2);
            Iterable $this$map$iv = projections2;
            boolean $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                TypeProjection typeProjection = (TypeProjection)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it2.getType());
            }
            Set conflictingTypes = CollectionsKt.toMutableSet((List)destination$iv$iv);
            DeclarationsChecker.Companion.removeDuplicateTypes(conflictingTypes);
            if (conflictingTypes.size() <= 1) continue;
            annotated = typeParameterDescriptor.getContainingDeclaration();
            if ((annotated instanceof ClassDescriptor ? (ClassDescriptor)annotated : null) == null) {
                throw new AssertionError((Object)("Not a class descriptor: " + typeParameterDescriptor.getContainingDeclaration()));
            }
            containingDeclaration = containingDeclaration;
            if (sourceElement instanceof KtClassOrObject) {
                KtSuperTypeList delegationSpecifierList;
                if (((KtClassOrObject)sourceElement).getSuperTypeList() == null) continue;
                this.trace.report(Errors.INCONSISTENT_TYPE_PARAMETER_VALUES.on((KtSuperTypeList)((PsiElement)delegationSpecifierList), typeParameterDescriptor, containingDeclaration, conflictingTypes));
                continue;
            }
            if (!(sourceElement instanceof KtTypeParameter)) continue;
            this.trace.report(Errors.INCONSISTENT_TYPE_PARAMETER_BOUNDS.on((KtTypeParameter)sourceElement, typeParameterDescriptor, containingDeclaration, conflictingTypes));
        }
    }

    private final void checkObject(KtObjectDeclaration declaration2, ClassDescriptorWithResolutionScopes classDescriptor2) {
        this.checkOpenMembers(classDescriptor2);
        if (declaration2.isLocal() && !declaration2.isCompanion() && !declaration2.isObjectLiteral()) {
            this.trace.report(Errors.LOCAL_OBJECT_NOT_ALLOWED.on((KtObjectDeclaration)((PsiElement)declaration2), classDescriptor2));
        }
    }

    private final void checkClassButNotObject(KtClass aClass, ClassDescriptorWithResolutionScopes classDescriptor2) {
        this.checkOpenMembers(classDescriptor2);
        this.checkTypeParameters(aClass);
        this.checkTypeParameterConstraints(aClass);
        FiniteBoundRestrictionChecker.check(aClass, classDescriptor2, this.trace);
        NonExpansiveInheritanceRestrictionChecker.check(aClass, classDescriptor2, this.trace);
        if (aClass.isInterface()) {
            this.checkConstructorInInterface(aClass);
            this.checkMethodsOfAnyInInterface(classDescriptor2);
            if (aClass.isLocal() && !(classDescriptor2.getContainingDeclaration() instanceof ClassDescriptor)) {
                this.trace.report(Errors.LOCAL_INTERFACE_NOT_ALLOWED.on((KtClass)((PsiElement)aClass), classDescriptor2));
            }
        } else if (classDescriptor2.getKind() == ClassKind.ANNOTATION_CLASS) {
            this.checkAnnotationClassMembers(aClass);
            this.checkValOnAnnotationParameter(aClass);
        } else if (aClass instanceof KtEnumEntry) {
            this.checkEnumEntry((KtEnumEntry)aClass, classDescriptor2);
        }
    }

    private final void checkPrimaryConstructor(KtClassOrObject classOrObject, ClassDescriptor classDescriptor2) {
        PsiElement it;
        ClassConstructorDescriptor classConstructorDescriptor = classDescriptor2.getUnsubstitutedPrimaryConstructor();
        if (classConstructorDescriptor == null) {
            return;
        }
        ClassConstructorDescriptor primaryConstructor2 = classConstructorDescriptor;
        KtPrimaryConstructor ktPrimaryConstructor = classOrObject.getPrimaryConstructor();
        if (ktPrimaryConstructor == null) {
            return;
        }
        KtPrimaryConstructor declaration2 = ktPrimaryConstructor;
        for (KtParameter parameter2 : declaration2.getValueParameters()) {
            PropertyDescriptor it2;
            if ((PropertyDescriptor)this.trace.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter2) == null) continue;
            boolean bl = false;
            this.modifiersChecker.checkModifiersForDeclaration(parameter2, it2);
            Intrinsics.checkNotNull(parameter2);
            LateinitModifierApplicabilityChecker.INSTANCE.checkLateinitModifierApplicability(this.trace, parameter2, it2, this.languageVersionSettings);
        }
        if (!declaration2.hasConstructorKeyword()) {
            KtModifierList ktModifierList = declaration2.getModifierList();
            if (ktModifierList != null) {
                it = ktModifierList;
                boolean bl = false;
                this.trace.report(Errors.MISSING_CONSTRUCTOR_KEYWORD.on((KtElement)it));
            }
        }
        if (declaration2.getValueParameterList() == null) {
            PsiElement psiElement = declaration2.getConstructorKeyword();
            if (psiElement != null) {
                it = psiElement;
                boolean bl = false;
                this.trace.report(Errors.MISSING_CONSTRUCTOR_BRACKETS.on(it));
            }
        }
        if (!(classOrObject instanceof KtClass)) {
            this.trace.report(Errors.CONSTRUCTOR_IN_OBJECT.on((KtDeclaration)((PsiElement)declaration2)));
        }
        this.checkConstructorDeclaration(primaryConstructor2, declaration2);
    }

    private final void checkTypeParameters(KtTypeParameterListOwner typeParameterListOwner) {
        for (KtTypeParameter ktTypeParameter : typeParameterListOwner.getTypeParameters()) {
            TypeParameterDescriptor it;
            if (!this.languageVersionSettings.supportsFeature(LanguageFeature.ClassTypeParameterAnnotations)) {
                AnnotationResolverImpl.reportUnsupportedAnnotationForTypeParameter(ktTypeParameter, this.trace, this.languageVersionSettings);
            }
            if ((TypeParameterDescriptor)this.trace.get(BindingContext.TYPE_PARAMETER, ktTypeParameter) == null) continue;
            boolean bl = false;
            DescriptorResolver.checkConflictingUpperBounds(this.trace, it, ktTypeParameter);
        }
    }

    private final void checkTypeParameterConstraints(KtTypeParameterListOwner typeParameterListOwner) {
        List<KtTypeConstraint> list2 = typeParameterListOwner.getTypeConstraints();
        Intrinsics.checkNotNullExpressionValue(list2, "getTypeConstraints(...)");
        List<KtTypeConstraint> constraints = list2;
        if (constraints.isEmpty()) {
            return;
        }
        for (KtTypeParameter typeParameter : typeParameterListOwner.getTypeParameters()) {
            TypeParameterDescriptor typeParameterDescriptor;
            if (typeParameter.getExtendsBound() != null) {
                Intrinsics.checkNotNull(typeParameter);
                if (DeclarationsChecker.Companion.hasConstraints(typeParameter, constraints)) {
                    this.trace.report(Errors.MISPLACED_TYPE_PARAMETER_CONSTRAINTS.on((KtTypeParameter)((PsiElement)typeParameter)));
                }
            }
            if ((TypeParameterDescriptor)this.trace.get(BindingContext.TYPE_PARAMETER, typeParameter) == null) continue;
            ClassifierDescriptor classifierDescriptor = typeParameterDescriptor;
            Intrinsics.checkNotNull(typeParameter);
            this.checkSupertypesForConsistency(classifierDescriptor, typeParameter);
            this.checkOnlyOneTypeParameterBound(typeParameterDescriptor, typeParameter, typeParameterListOwner);
        }
        for (KtTypeConstraint constraint : constraints) {
            List<KtAnnotationEntry> list3 = constraint.getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue(list3, "getAnnotationEntries(...)");
            Iterable $this$forEach$iv = list3;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                boolean bl = false;
                this.trace.report(Errors.ANNOTATION_IN_WHERE_CLAUSE_WARNING.on((KtAnnotationEntry)((PsiElement)it)));
            }
        }
    }

    private final void checkConstructorInInterface(KtClass klass) {
        block0: {
            KtPrimaryConstructor ktPrimaryConstructor = klass.getPrimaryConstructor();
            if (ktPrimaryConstructor == null) break block0;
            KtPrimaryConstructor it = ktPrimaryConstructor;
            boolean bl = false;
            this.trace.report(Errors.CONSTRUCTOR_IN_INTERFACE.on((KtDeclaration)((PsiElement)it)));
        }
    }

    private final void checkMethodsOfAnyInInterface(ClassDescriptorWithResolutionScopes classDescriptor2) {
        for (CallableMemberDescriptor declaredCallableMember : classDescriptor2.getDeclaredCallableMembers()) {
            PsiElement declaration2;
            if (!(declaredCallableMember instanceof FunctionDescriptor) || !((declaration2 = DescriptorToSourceUtils.descriptorToDeclaration(declaredCallableMember)) instanceof KtNamedFunction) || DeclarationsChecker.Companion.isHidingParentMemberIfPresent(declaredCallableMember) || !DeclarationsChecker.Companion.isImplementingMethodOfAny(declaredCallableMember)) continue;
            this.trace.report(Errors.METHOD_OF_ANY_IMPLEMENTED_IN_INTERFACE.on((KtDeclaration)declaration2));
        }
    }

    private final void checkAnnotationClassMembers(KtClassOrObject classOrObject) {
        for (KtDeclaration declaration2 : classOrObject.getDeclarations()) {
            if (declaration2 instanceof KtClassOrObject && this.languageVersionSettings.supportsFeature(LanguageFeature.NestedClassesInAnnotations)) continue;
            this.trace.report(Errors.ANNOTATION_CLASS_MEMBER.on(declaration2));
        }
    }

    private final void checkValOnAnnotationParameter(KtClass aClass) {
        for (KtParameter parameter2 : aClass.getPrimaryConstructorParameters()) {
            if (!parameter2.hasValOrVar()) {
                this.trace.report(Errors.MISSING_VAL_ON_ANNOTATION_PARAMETER.on((KtParameter)((PsiElement)parameter2)));
                continue;
            }
            if (!parameter2.isMutable()) continue;
            this.trace.report(Errors.VAR_ANNOTATION_PARAMETER.on((KtParameter)((PsiElement)parameter2)));
        }
    }

    private final void checkOpenMembers(ClassDescriptorWithResolutionScopes classDescriptor2) {
        if (DescriptorUtils.classCanHaveOpenMembers(classDescriptor2)) {
            return;
        }
        for (CallableMemberDescriptor memberDescriptor : classDescriptor2.getDeclaredCallableMembers()) {
            if (memberDescriptor.getKind() != CallableMemberDescriptor.Kind.DECLARATION) continue;
            Intrinsics.checkNotNull(memberDescriptor);
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(memberDescriptor);
            KtNamedDeclaration member2 = psiElement instanceof KtNamedDeclaration ? (KtNamedDeclaration)psiElement : null;
            if (member2 == null || !member2.hasModifier(KtTokens.OPEN_KEYWORD)) continue;
            if (classDescriptor2.getKind() == ClassKind.OBJECT) {
                this.trace.report(Errors.NON_FINAL_MEMBER_IN_OBJECT.on((KtNamedDeclaration)((PsiElement)member2)));
                continue;
            }
            this.trace.report(Errors.NON_FINAL_MEMBER_IN_FINAL_CLASS.on((KtNamedDeclaration)((PsiElement)member2)));
        }
    }

    private final void checkBackingField(KtProperty property) {
        block0: {
            KtBackingField ktBackingField = property.getFieldDeclaration();
            if (ktBackingField == null) break block0;
            KtBackingField it = ktBackingField;
            boolean bl = false;
            this.trace.report(Errors.EXPLICIT_BACKING_FIELDS_UNSUPPORTED.on((KtElement)((PsiElement)it)));
        }
    }

    private final void checkProperty(KtProperty property, PropertyDescriptor propertyDescriptor) {
        DeclarationDescriptor declarationDescriptor = propertyDescriptor.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getContainingDeclaration(...)");
        DeclarationDescriptor containingDeclaration = declarationDescriptor;
        if (containingDeclaration instanceof ClassDescriptor) {
            this.checkMemberProperty(property, propertyDescriptor, (ClassDescriptor)containingDeclaration);
        }
        LateinitModifierApplicabilityChecker.INSTANCE.checkLateinitModifierApplicability(this.trace, property, propertyDescriptor, this.languageVersionSettings);
        this.checkPropertyInitializer(property, propertyDescriptor);
        this.checkAccessors(property, propertyDescriptor);
        this.checkTypeParameterConstraints(property);
        ExposedVisibilityChecker.checkProperty$default(this.exposedChecker, property, propertyDescriptor, null, 4, null);
        this.shadowedExtensionChecker.checkDeclaration(property, propertyDescriptor);
        this.checkPropertyTypeParametersAreUsedInReceiverType(propertyDescriptor);
        this.checkImplicitCallableType(property, propertyDescriptor);
        this.checkExpectDeclarationModifiers(property, propertyDescriptor);
        this.checkBackingField(property);
    }

    private final void checkExpectDeclarationModifiers(KtDeclaration declaration2, MemberDescriptor descriptor2) {
        block4: {
            if (!descriptor2.isExpect()) {
                return;
            }
            if (DescriptorVisibilities.isPrivate(descriptor2.getVisibility())) {
                PsiElement psiElement = declaration2.getModifierList();
                if (psiElement == null || (psiElement = psiElement.getModifier(KtTokens.PRIVATE_KEYWORD)) == null) {
                    psiElement = declaration2;
                }
                this.trace.report(Errors.EXPECTED_PRIVATE_DECLARATION.on(psiElement));
            }
            this.checkExpectDeclarationHasNoExternalModifier(declaration2);
            if (!(declaration2 instanceof KtFunction) || !this.languageVersionSettings.supportsFeature(LanguageFeature.MultiplatformRestrictions)) break block4;
            PsiElement psiElement = ((KtFunction)declaration2).getModifierList();
            if (psiElement != null && (psiElement = psiElement.getModifier(KtTokens.TAILREC_KEYWORD)) != null) {
                PsiElement it = psiElement;
                boolean bl = false;
                this.trace.report(Errors.EXPECTED_TAILREC_FUNCTION.on(it));
            }
        }
    }

    private final void checkExpectDeclarationHasNoExternalModifier(KtDeclaration declaration2) {
        block1: {
            if (!this.languageVersionSettings.supportsFeature(LanguageFeature.MultiplatformRestrictions)) break block1;
            PsiElement psiElement = declaration2.getModifierList();
            if (psiElement != null && (psiElement = psiElement.getModifier(KtTokens.EXTERNAL_KEYWORD)) != null) {
                PsiElement it = psiElement;
                boolean bl = false;
                this.trace.report(Errors.EXPECTED_EXTERNAL_DECLARATION.on(it));
            }
        }
    }

    private final void checkPropertyTypeParametersAreUsedInReceiverType(PropertyDescriptor descriptor2) {
        List<TypeParameterDescriptor> list2 = descriptor2.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "getTypeParameters(...)");
        Set allTypeParameters = CollectionsKt.toSet((Iterable)list2);
        HashSet<TypeParameterDescriptor> allAccessibleTypeParameters = new HashSet<TypeParameterDescriptor>();
        ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getExtensionReceiverParameter();
        DeclarationsChecker.checkPropertyTypeParametersAreUsedInReceiverType$addAccessibleTypeParametersFromType(allTypeParameters, allAccessibleTypeParameters, receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null);
        for (ReceiverParameterDescriptor contextReceiverParameter : descriptor2.getContextReceiverParameters()) {
            DeclarationsChecker.checkPropertyTypeParametersAreUsedInReceiverType$addAccessibleTypeParametersFromType(allTypeParameters, allAccessibleTypeParameters, contextReceiverParameter.getType());
        }
        Set<TypeParameterDescriptor> typeParametersInaccessibleFromReceiver = SetsKt.minus(allTypeParameters, (Iterable)allAccessibleTypeParameters);
        for (TypeParameterDescriptor typeParameter : typeParametersInaccessibleFromReceiver) {
            Intrinsics.checkNotNull(typeParameter);
            PsiElement typeParameterPsi = DescriptorToSourceUtils.getSourceFromDescriptor(typeParameter);
            if (!(typeParameterPsi instanceof KtTypeParameter)) continue;
            this.trace.report(Errors.TYPE_PARAMETER_OF_PROPERTY_NOT_USED_IN_RECEIVER.on((KtTypeParameter)typeParameterPsi));
        }
    }

    private final void checkMemberProperty(KtProperty property, PropertyDescriptor propertyDescriptor, ClassDescriptor classDescriptor2) {
        KtModifierList modifierList2 = property.getModifierList();
        if (modifierList2 != null) {
            if (modifierList2.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
                if (!DescriptorUtils.classCanHaveAbstractDeclaration(classDescriptor2)) {
                    PsiElement psiElement = property;
                    String string2 = property.getName();
                    if (string2 == null) {
                        string2 = "";
                    }
                    this.trace.report(Errors.ABSTRACT_PROPERTY_IN_NON_ABSTRACT_CLASS.on((KtModifierListOwner)psiElement, string2, classDescriptor2));
                    return;
                }
            } else if (classDescriptor2.getKind() == ClassKind.INTERFACE && modifierList2.hasModifier(KtTokens.OPEN_KEYWORD) && propertyDescriptor.getModality() == Modality.ABSTRACT) {
                this.trace.report(Errors.REDUNDANT_OPEN_IN_INTERFACE.on((KtModifierListOwner)((PsiElement)property)));
            }
        }
        if (propertyDescriptor.getModality() == Modality.ABSTRACT) {
            KtPropertyAccessor setter2;
            KtElement it;
            KtExpression ktExpression = property.getInitializer();
            if (ktExpression != null) {
                it = ktExpression;
                boolean bl = false;
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_INITIALIZER.on((KtExpression)it));
            }
            KtPropertyDelegate ktPropertyDelegate = property.getDelegate();
            if (ktPropertyDelegate != null) {
                it = ktPropertyDelegate;
                boolean bl = false;
                this.trace.report(Errors.ABSTRACT_DELEGATED_PROPERTY.on((KtPropertyDelegate)it));
            }
            KtPropertyAccessor getter2 = property.getGetter();
            if (getter2 != null && getter2.hasBody()) {
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_GETTER.on((KtPropertyAccessor)((PsiElement)getter2)));
            }
            if ((setter2 = property.getSetter()) != null && setter2.hasBody()) {
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_SETTER.on((KtPropertyAccessor)((PsiElement)setter2)));
            }
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void checkPropertyInitializer(KtProperty property, PropertyDescriptor propertyDescriptor) {
        block42: {
            block43: {
                block40: {
                    block45: {
                        block44: {
                            block41: {
                                hasAnyAccessorImplementation = DeclarationsChecker.Companion.hasAnyAccessorImplementation(propertyDescriptor);
                                v0 = propertyDescriptor.getContainingDeclaration();
                                Intrinsics.checkNotNullExpressionValue(v0, "getContainingDeclaration(...)");
                                containingDeclaration = v0;
                                inInterface = DescriptorUtils.isInterface(containingDeclaration);
                                if (propertyDescriptor.getModality() == Modality.ABSTRACT) {
                                    if (!property.hasDelegateExpressionOrInitializer() && property.getTypeReference() == null) {
                                        this.trace.report(Errors.PROPERTY_WITH_NO_TYPE_NO_INITIALIZER.on((KtProperty)((PsiElement)property)));
                                    }
                                    if (inInterface && property.hasModifier(KtTokens.PRIVATE_KEYWORD) && !property.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
                                        this.trace.report(Errors.PRIVATE_PROPERTY_IN_INTERFACE.on((KtProperty)((PsiElement)property)));
                                    }
                                    return;
                                }
                                v1 = (Boolean)this.trace.getBindingContext().get(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor);
                                if (v1 == null) {
                                    v1 = false;
                                }
                                backingFieldRequired = v1;
                                if (inInterface && backingFieldRequired && hasAnyAccessorImplementation) {
                                    this.trace.report(Errors.BACKING_FIELD_IN_INTERFACE.on((KtProperty)((PsiElement)property)));
                                }
                                initializer = property.getInitializer();
                                delegate = property.getDelegate();
                                isExpect = propertyDescriptor.isExpect();
                                if (initializer == null) break block41;
                                if (inInterface) {
                                    this.trace.report(Errors.PROPERTY_INITIALIZER_IN_INTERFACE.on((KtExpression)((PsiElement)initializer)));
                                } else if (isExpect) {
                                    this.trace.report(Errors.EXPECTED_PROPERTY_INITIALIZER.on((KtExpression)((PsiElement)initializer)));
                                } else if (!backingFieldRequired) {
                                    this.trace.report(Errors.PROPERTY_INITIALIZER_NO_BACKING_FIELD.on((KtExpression)((PsiElement)initializer)));
                                } else if (property.getReceiverTypeReference() != null) {
                                    this.trace.report(Errors.EXTENSION_PROPERTY_WITH_BACKING_FIELD.on((KtExpression)((PsiElement)initializer)));
                                } else {
                                    v2 = property.getContextReceivers();
                                    Intrinsics.checkNotNullExpressionValue(v2, "getContextReceivers(...)");
                                    if (((Collection)v2).isEmpty() == false) {
                                        this.trace.report(Errors.CONTEXT_RECEIVERS_WITH_BACKING_FIELD.on((KtExpression)((PsiElement)initializer)));
                                    }
                                }
                                break block42;
                            }
                            if (delegate == null) break block43;
                            if (!inInterface) break block44;
                            this.trace.report(Errors.DELEGATED_PROPERTY_IN_INTERFACE.on((KtPropertyDelegate)((PsiElement)delegate)));
                            break block42;
                        }
                        if (!isExpect) break block45;
                        this.trace.report(Errors.EXPECTED_DELEGATED_PROPERTY.on((KtPropertyDelegate)((PsiElement)delegate)));
                        break block42;
                    }
                    if (property.getReceiverTypeReference() == null) break block42;
                    delegatedPropertyResolvedCall = (ResolvedCall)this.trace.get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, propertyDescriptor.getGetter());
                    provideDelegateResolvedCall = (ResolvedCall)this.trace.get(BindingContext.PROVIDE_DELEGATE_RESOLVED_CALL, propertyDescriptor);
                    v3 = provideDelegateResolvedCall;
                    if (v3 == null || (v3 = (FunctionDescriptor)v3.getResultingDescriptor()) == null || (v3 = v3.getReturnType()) == null) {
                        v4 = delegate.getExpression();
                        if (v4 != null) {
                            it = v4;
                            $i$a$-let-DeclarationsChecker$checkPropertyInitializer$delegateType$1 = false;
                            v5 = this.trace.getType((KtExpression)it);
                        } else {
                            v5 = v3 = null;
                        }
                        if (v5 == null) {
                            return;
                        }
                    }
                    delegateType = v3;
                    it = FlexibleTypesKt.lowerIfFlexible((KotlinType)delegateType).unwrap().getConstructor().getDeclarationDescriptor();
                    $i$a$-let-DeclarationsChecker$checkPropertyInitializer$delegateClassDescriptor$1 = false;
                    v6 = it instanceof ClassDescriptor != false ? (ClassDescriptor)it : null;
                    var15_21 = v6 != null ? (ClassifierDescriptor)v6 : ((v7 = it instanceof TypeAliasDescriptor != false ? (TypeAliasDescriptor)it : null) != null && (v7 = v7.getExpandedType()) != null && (v7 = v7.getConstructor()) != null ? v7.getDeclarationDescriptor() : null);
                    v8 = var15_21 instanceof ClassDescriptor != false ? (ClassDescriptor)var15_21 : null;
                    if (v8 == null) {
                        return;
                    }
                    delegateClassDescriptor = v8;
                    delegateClassScope$delegate = LazyKt.lazy((Function0)new Function0<MemberScope>(delegateClassDescriptor){
                        final /* synthetic */ ClassDescriptor $delegateClassDescriptor;
                        {
                            this.$delegateClassDescriptor = $delegateClassDescriptor;
                            super(0);
                        }

                        public final MemberScope invoke() {
                            return this.$delegateClassDescriptor.getUnsubstitutedMemberScope();
                        }
                    });
                    v9 = delegatedPropertyResolvedCall;
                    dispatchReceiverType = v9 != null && (v9 = v9.getDispatchReceiver()) != null ? v9.getType() : null;
                    v10 = delegatedPropertyResolvedCall;
                    extensionReceiverType = v10 != null && (v10 = v10.getExtensionReceiver()) != null ? v10.getType() : null;
                    v11 = propertyDescriptor.getTypeParameters();
                    Intrinsics.checkNotNullExpressionValue(v11, "getTypeParameters(...)");
                    it = v11;
                    var20_16 = it.iterator();
                    while (var20_16.hasNext()) {
                        var21_26 = var20_16.next();
                        typeParameter = (TypeParameterDescriptor)var21_26;
                        $i$a$-find-DeclarationsChecker$checkPropertyInitializer$usedParameter$1 = false;
                        v12 = dispatchReceiverType;
                        if (v12 != null ? TypeUtilsKt.contains(v12, (Function1<? super UnwrappedType, Boolean>)new Function1<UnwrappedType, Boolean>((TypeParameterDescriptor)typeParameter){
                            final /* synthetic */ TypeParameterDescriptor $typeParameter;
                            {
                                this.$typeParameter = $typeParameter;
                                super(1);
                            }

                            public final Boolean invoke(UnwrappedType it) {
                                Intrinsics.checkNotNullParameter(it, "it");
                                return Intrinsics.areEqual(it.getConstructor(), this.$typeParameter.getTypeConstructor());
                            }
                        }) : false) ** GOTO lbl-1000
                        v13 = extensionReceiverType;
                        v14 = v13 != null ? TypeUtilsKt.contains(v13, (Function1<? super UnwrappedType, Boolean>)new Function1<UnwrappedType, Boolean>((TypeParameterDescriptor)typeParameter){
                            final /* synthetic */ TypeParameterDescriptor $typeParameter;
                            {
                                this.$typeParameter = $typeParameter;
                                super(1);
                            }

                            public final Boolean invoke(UnwrappedType it) {
                                Intrinsics.checkNotNullParameter(it, "it");
                                return Intrinsics.areEqual(it.getConstructor(), this.$typeParameter.getTypeConstructor());
                            }
                        }) : false;
                        if (v14) lbl-1000:
                        // 2 sources

                        {
                            v15 = true;
                        } else {
                            v15 = false;
                        }
                        if (!v15) continue;
                        v16 = var21_26;
                        break block40;
                    }
                    v16 = null;
                }
                usedParameter = v16;
                if (usedParameter != null) {
                    propertyWithTypeParameterTypeFound = false;
                    names = DeclarationsChecker.checkPropertyInitializer$lambda$29(delegateClassScope$delegate).getVariableNames();
                    for (Name name : names) {
                        typeParameter = DeclarationsChecker.checkPropertyInitializer$lambda$29(delegateClassScope$delegate).getContributedVariables(name, new KotlinLookupLocation(delegate));
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            propertyInDelegateClass = (PropertyDescriptor)element$iv;
                            $i$a$-forEach-DeclarationsChecker$checkPropertyInitializer$1 = false;
                            v17 = propertyInDelegateClass.getType();
                            Intrinsics.checkNotNullExpressionValue(v17, "getType(...)");
                            if (!TypeUtilsKt.contains(v17, checkPropertyInitializer.1.1.INSTANCE)) continue;
                            propertyWithTypeParameterTypeFound = true;
                        }
                    }
                    if (!propertyWithTypeParameterTypeFound) {
                        return;
                    }
                    this.trace.report(Errors.DELEGATE_USES_EXTENSION_PROPERTY_TYPE_PARAMETER.on(this.languageVersionSettings, (KtPropertyDelegate)((PsiElement)delegate), usedParameter.getName().asString()));
                }
                break block42;
            }
            v18 = (Boolean)this.trace.getBindingContext().get(BindingContext.IS_UNINITIALIZED, propertyDescriptor);
            if (v18 == null) {
                v18 = false;
            }
            isUninitialized = v18;
            isExternal = DescriptorUtilsKt.isEffectivelyExternal(propertyDescriptor);
            if (backingFieldRequired && !inInterface && !propertyDescriptor.isLateInit() && !isExpect && isUninitialized && !isExternal) {
                if (propertyDescriptor.getExtensionReceiverParameter() != null && !hasAnyAccessorImplementation) {
                    this.trace.report(Errors.EXTENSION_PROPERTY_MUST_HAVE_ACCESSORS_OR_BE_ABSTRACT.on((KtProperty)((PsiElement)property)));
                } else if (this.diagnosticSuppressor.shouldReportNoBody(propertyDescriptor)) {
                    isOpenValDeferredInitDeprecationWarning = this.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitOpenValDeferredInitialization) == false && DeclarationsCheckerKt.getEffectiveModality(propertyDescriptor, this.languageVersionSettings) == Modality.OPEN && propertyDescriptor.isVar() == false && Intrinsics.areEqual(this.trace.getBindingContext().get(BindingContext.IS_DEFINITELY_NOT_ASSIGNED_IN_CONSTRUCTOR, propertyDescriptor), false) != false;
                    v19 = isFalsePositiveDeferredInitDeprecationWarning = isOpenValDeferredInitDeprecationWarning != false && DeclarationsCheckerKt.access$getEffectiveModality(propertyDescriptor) == Modality.FINAL;
                    if (!isFalsePositiveDeferredInitDeprecationWarning) {
                        this.reportMustBeInitialized(propertyDescriptor, containingDeclaration, hasAnyAccessorImplementation, property, isOpenValDeferredInitDeprecationWarning, this.languageVersionSettings, this.trace);
                    }
                }
            } else if (property.getTypeReference() == null && !this.languageVersionSettings.supportsFeature(LanguageFeature.ShortSyntaxForPropertyGetters)) {
                this.trace.report(Errors.UNSUPPORTED_FEATURE.on(property, TuplesKt.to(LanguageFeature.ShortSyntaxForPropertyGetters, this.languageVersionSettings)));
            } else if (this.noExplicitTypeOrGetterType(property)) {
                this.trace.report(Errors.PROPERTY_WITH_NO_TYPE_NO_INITIALIZER.on((KtProperty)((PsiElement)property)));
            }
            if (propertyDescriptor.isLateInit()) {
                if (propertyDescriptor.isExpect()) {
                    v20 /* !! */  = property.getModifierList();
                    if (v20 /* !! */  == null || (v20 /* !! */  = v20 /* !! */ .getModifier(KtTokens.LATEINIT_KEYWORD)) == null) {
                        v20 /* !! */  = property;
                    }
                    this.trace.report(Errors.EXPECTED_LATEINIT_PROPERTY.on(v20 /* !! */ ));
                }
                if (backingFieldRequired && !inInterface && !isUninitialized && !Intrinsics.areEqual(this.trace.get(BindingContext.MUST_BE_LATEINIT, propertyDescriptor), true)) {
                    this.trace.report(Errors.UNNECESSARY_LATEINIT.on((KtProperty)((PsiElement)property)));
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void reportMustBeInitialized(PropertyDescriptor propertyDescriptor, DeclarationDescriptor containingDeclaration, boolean hasAnyAccessorImplementation, KtProperty property, boolean isOpenValDeferredInitDeprecationWarning, LanguageVersionSettings languageVersionSettings, BindingTrace trace) {
        block11: {
            if (!(DeclarationsCheckerKt.getEffectiveModality(propertyDescriptor, languageVersionSettings) != Modality.ABSTRACT)) {
                $i$a$-check-DeclarationsChecker$reportMustBeInitialized$1 = false;
                $i$a$-check-DeclarationsChecker$reportMustBeInitialized$1 = "reportMustBeInitialized isn't called for abstract properties";
                throw new IllegalStateException($i$a$-check-DeclarationsChecker$reportMustBeInitialized$1.toString());
            }
            suggestMakingItFinal = containingDeclaration instanceof ClassDescriptor != false && ksp.org.jetbrains.kotlin.resolve.DeclarationsChecker$Companion.access$hasSetterAccessorImplementation(DeclarationsChecker.Companion, propertyDescriptor) == false && DeclarationsCheckerKt.getEffectiveModality(propertyDescriptor, languageVersionSettings) != Modality.FINAL && Intrinsics.areEqual(trace.getBindingContext().get(BindingContext.IS_DEFINITELY_NOT_ASSIGNED_IN_CONSTRUCTOR, propertyDescriptor), false) != false;
            v0 = suggestMakingItAbstract = containingDeclaration instanceof ClassDescriptor != false && hasAnyAccessorImplementation == false;
            if (isOpenValDeferredInitDeprecationWarning && !suggestMakingItFinal && suggestMakingItAbstract) {
                throw new IllegalStateException("Not reachable case. Every \"open val + deferred init\" case that could be made `abstract`, also could be made `final`".toString());
            }
            if (languageVersionSettings.supportsFeature(LanguageFeature.ProhibitMissedMustBeInitializedWhenThereIsNoPrimaryConstructor) || !(containingDeclaration instanceof ClassDescriptor)) ** GOTO lbl-1000
            v1 = ((ClassDescriptor)containingDeclaration).getConstructors();
            Intrinsics.checkNotNullExpressionValue(v1, "getConstructors(...)");
            $this$none$iv = v1;
            $i$f$none = false;
            if (((Collection)$this$none$iv).isEmpty()) {
                v2 = true;
            } else {
                for (T element$iv : $this$none$iv) {
                    it = (ClassConstructorDescriptor)element$iv;
                    $i$a$-none-DeclarationsChecker$reportMustBeInitialized$isMissedMustBeInitializedDeprecationWarning$1 = false;
                    if (!it.isPrimary()) continue;
                    v2 = false;
                    break block11;
                }
                v2 = true;
            }
        }
        if (v2 && Intrinsics.areEqual(trace.getBindingContext().get(BindingContext.IS_DEFINITELY_NOT_ASSIGNED_IN_CONSTRUCTOR, propertyDescriptor), false)) {
            v3 = true;
        } else lbl-1000:
        // 2 sources

        {
            v3 = false;
        }
        isMissedMustBeInitializedDeprecationWarning = v3;
        factory = suggestMakingItFinal != false && suggestMakingItAbstract != false ? Errors.MUST_BE_INITIALIZED_OR_FINAL_OR_ABSTRACT : (suggestMakingItFinal != false ? Errors.MUST_BE_INITIALIZED_OR_BE_FINAL : (suggestMakingItAbstract != false ? Errors.MUST_BE_INITIALIZED_OR_BE_ABSTRACT : Errors.MUST_BE_INITIALIZED));
        v4 = var12_13 = isMissedMustBeInitializedDeprecationWarning != false || isOpenValDeferredInitDeprecationWarning != false;
        if (var12_13) {
            Intrinsics.checkNotNull(factory);
            v5 = this.getDeprecationWarning(factory);
        } else if (!var12_13) {
            v5 = factory;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        trace.report(v5.on((KtProperty)((PsiElement)property)));
    }

    private final DiagnosticFactory0<KtProperty> getDeprecationWarning(DiagnosticFactory0<KtProperty> $this$deprecationWarning) {
        DiagnosticFactory0<KtProperty> diagnosticFactory0;
        DiagnosticFactory0<KtProperty> diagnosticFactory02 = $this$deprecationWarning;
        if (Intrinsics.areEqual(diagnosticFactory02, Errors.MUST_BE_INITIALIZED)) {
            DiagnosticFactory0<KtProperty> diagnosticFactory03 = Errors.MUST_BE_INITIALIZED_WARNING;
            diagnosticFactory0 = diagnosticFactory03;
            Intrinsics.checkNotNullExpressionValue(diagnosticFactory03, "MUST_BE_INITIALIZED_WARNING");
        } else if (Intrinsics.areEqual(diagnosticFactory02, Errors.MUST_BE_INITIALIZED_OR_BE_ABSTRACT)) {
            DiagnosticFactory0<KtProperty> diagnosticFactory04 = Errors.MUST_BE_INITIALIZED_OR_BE_ABSTRACT_WARNING;
            diagnosticFactory0 = diagnosticFactory04;
            Intrinsics.checkNotNullExpressionValue(diagnosticFactory04, "MUST_BE_INITIALIZED_OR_BE_ABSTRACT_WARNING");
        } else if (Intrinsics.areEqual(diagnosticFactory02, Errors.MUST_BE_INITIALIZED_OR_BE_FINAL)) {
            DiagnosticFactory0<KtProperty> diagnosticFactory05 = Errors.MUST_BE_INITIALIZED_OR_BE_FINAL_WARNING;
            diagnosticFactory0 = diagnosticFactory05;
            Intrinsics.checkNotNullExpressionValue(diagnosticFactory05, "MUST_BE_INITIALIZED_OR_BE_FINAL_WARNING");
        } else if (Intrinsics.areEqual(diagnosticFactory02, Errors.MUST_BE_INITIALIZED_OR_FINAL_OR_ABSTRACT)) {
            DiagnosticFactory0<KtProperty> diagnosticFactory06 = Errors.MUST_BE_INITIALIZED_OR_FINAL_OR_ABSTRACT_WARNING;
            diagnosticFactory0 = diagnosticFactory06;
            Intrinsics.checkNotNullExpressionValue(diagnosticFactory06, "MUST_BE_INITIALIZED_OR_FINAL_OR_ABSTRACT_WARNING");
        } else {
            throw new IllegalStateException("Only MUST_BE_INITIALIZED is supported".toString());
        }
        return diagnosticFactory0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean noExplicitTypeOrGetterType(KtProperty property) {
        if (property.getTypeReference() != null) return false;
        if (property.getGetter() == null) return true;
        KtPropertyAccessor ktPropertyAccessor = property.getGetter();
        Intrinsics.checkNotNull(ktPropertyAccessor);
        if (!ktPropertyAccessor.hasBlockBody()) return false;
        KtPropertyAccessor ktPropertyAccessor2 = property.getGetter();
        Intrinsics.checkNotNull(ktPropertyAccessor2);
        if (ktPropertyAccessor2.getReturnTypeReference() != null) return false;
        return true;
    }

    public final void checkFunction(@NotNull KtNamedFunction function2, @NotNull SimpleFunctionDescriptor functionDescriptor) {
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(functionDescriptor, "functionDescriptor");
        KtTypeParameterList typeParameterList = function2.getTypeParameterList();
        PsiElement nameIdentifier = function2.getNameIdentifier();
        if (typeParameterList != null && nameIdentifier != null && typeParameterList.getTextRange().getStartOffset() > nameIdentifier.getTextRange().getStartOffset()) {
            this.trace.report(Errors.DEPRECATED_TYPE_PARAMETER_SYNTAX.on((KtTypeParameterList)((PsiElement)typeParameterList)));
        }
        this.checkTypeParameterConstraints(function2);
        this.checkImplicitCallableType(function2, functionDescriptor);
        ExposedVisibilityChecker.checkFunction$default(this.exposedChecker, function2, functionDescriptor, null, 4, null);
        this.checkVarargParameters(this.trace, functionDescriptor);
        DeclarationDescriptor declarationDescriptor = functionDescriptor.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getContainingDeclaration(...)");
        DeclarationDescriptor containingDescriptor = declarationDescriptor;
        boolean hasAbstractModifier = function2.hasModifier(KtTokens.ABSTRACT_KEYWORD);
        boolean hasExternalModifier = DescriptorUtilsKt.isEffectivelyExternal(functionDescriptor);
        if (containingDescriptor instanceof ClassDescriptor) {
            boolean hasBody;
            boolean inInterface = ((ClassDescriptor)containingDescriptor).getKind() == ClassKind.INTERFACE;
            boolean isExpectClass = ((ClassDescriptor)containingDescriptor).isExpect();
            if (hasAbstractModifier && !DescriptorUtils.classCanHaveAbstractDeclaration((ClassDescriptor)containingDescriptor)) {
                this.trace.report(Errors.ABSTRACT_FUNCTION_IN_NON_ABSTRACT_CLASS.on((KtFunction)((PsiElement)function2), functionDescriptor.getName().asString(), (ClassDescriptor)containingDescriptor));
            }
            if ((hasBody = function2.hasBody()) && hasAbstractModifier) {
                this.trace.report(Errors.ABSTRACT_FUNCTION_WITH_BODY.on((KtFunction)((PsiElement)function2), functionDescriptor));
            }
            if (!hasBody && inInterface) {
                if (function2.hasModifier(KtTokens.PRIVATE_KEYWORD)) {
                    this.trace.report(Errors.PRIVATE_FUNCTION_WITH_NO_BODY.on((KtFunction)((PsiElement)function2), functionDescriptor));
                }
                if (!((ClassDescriptor)containingDescriptor).isExpect() && !hasAbstractModifier && function2.hasModifier(KtTokens.OPEN_KEYWORD)) {
                    this.trace.report(Errors.REDUNDANT_OPEN_IN_INTERFACE.on((KtModifierListOwner)((PsiElement)function2)));
                }
            }
            if (!(hasBody || hasAbstractModifier || hasExternalModifier || inInterface || isExpectClass || !this.diagnosticSuppressor.shouldReportNoBody(functionDescriptor))) {
                this.trace.report(Errors.NON_ABSTRACT_FUNCTION_WITH_NO_BODY.on((KtFunction)((PsiElement)function2), functionDescriptor));
            }
        } else if (!(function2.hasBody() || hasAbstractModifier || hasExternalModifier || functionDescriptor.isExpect() || !this.diagnosticSuppressor.shouldReportNoBody(functionDescriptor))) {
            this.trace.report(Errors.NON_MEMBER_FUNCTION_NO_BODY.on((KtFunction)((PsiElement)function2), functionDescriptor));
        }
        if (functionDescriptor.isExpect()) {
            this.checkExpectedFunction(function2, functionDescriptor);
        }
        this.shadowedExtensionChecker.checkDeclaration(function2, functionDescriptor);
    }

    private final void checkExpectedFunction(KtNamedFunction function2, FunctionDescriptor functionDescriptor) {
        if (function2.hasBody()) {
            this.trace.report(Errors.EXPECTED_DECLARATION_WITH_BODY.on((KtDeclaration)((PsiElement)function2)));
        }
        this.checkExpectDeclarationModifiers(function2, functionDescriptor);
    }

    private final void checkImplicitCallableType(KtCallableDeclaration declaration2, CallableDescriptor descriptor2) {
        block2: {
            PsiElement target;
            KotlinType it;
            block3: {
                KotlinType kotlinType = descriptor2.getReturnType();
                if (kotlinType == null || (kotlinType = kotlinType.unwrap()) == null) break block2;
                it = kotlinType;
                boolean bl = false;
                PsiElement psiElement = declaration2.getNameIdentifier();
                if (psiElement == null) {
                    psiElement = declaration2;
                }
                PsiElement psiElement2 = psiElement;
                Intrinsics.checkNotNull(psiElement2);
                target = psiElement2;
                if (declaration2.getTypeReference() != null) break block3;
                if (TypeUtilsKt.isNothing(it) && !declaration2.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
                    this.trace.report((declaration2 instanceof KtProperty ? Errors.IMPLICIT_NOTHING_PROPERTY_TYPE : Errors.IMPLICIT_NOTHING_RETURN_TYPE).on(target));
                }
                if (!TypeUtilsKt.contains(it, checkImplicitCallableType.1.1.INSTANCE)) break block2;
                this.trace.report(Errors.IMPLICIT_INTERSECTION_TYPE.on(target, it));
                break block2;
            }
            if (!TypeUtilsKt.isNothing(it) || !(it instanceof AbbreviatedType)) break block2;
            this.trace.report((declaration2 instanceof KtProperty ? Errors.ABBREVIATED_NOTHING_PROPERTY_TYPE : Errors.ABBREVIATED_NOTHING_RETURN_TYPE).on(target));
        }
    }

    private final void checkAccessors(KtProperty property, PropertyDescriptor propertyDescriptor) {
        for (PropertyAccessorDescriptor accessorDescriptor : propertyDescriptor.getAccessors()) {
            KtPropertyAccessor accessor;
            KtPropertyAccessor ktPropertyAccessor = accessor = accessorDescriptor instanceof PropertyGetterDescriptor ? property.getGetter() : property.getSetter();
            if (accessor != null) {
                this.modifiersChecker.checkModifiersForDeclaration(accessor, accessorDescriptor);
                this.identifierChecker.checkDeclaration(accessor, this.trace);
                continue;
            }
            this.modifiersChecker.runDeclarationCheckers(property, accessorDescriptor);
        }
        this.checkAccessor(propertyDescriptor, property.getGetter(), propertyDescriptor.getGetter());
        this.checkAccessor(propertyDescriptor, property.getSetter(), propertyDescriptor.getSetter());
    }

    private final void reportVisibilityModifierDiagnostics(Collection<? extends PsiElement> tokens, DiagnosticFactory0<PsiElement> diagnostic) {
        for (PsiElement psiElement : tokens) {
            this.trace.report(diagnostic.on(psiElement));
        }
    }

    private final void checkAccessor(PropertyDescriptor propertyDescriptor, KtPropertyAccessor accessor, PropertyAccessorDescriptor accessorDescriptor) {
        if (accessor == null || accessorDescriptor == null) {
            return;
        }
        if (propertyDescriptor.isExpect() && accessor.hasBody()) {
            this.trace.report(Errors.EXPECTED_DECLARATION_WITH_BODY.on((KtDeclaration)((PsiElement)accessor)));
        }
        KtModifierList ktModifierList = accessor.getModifierList();
        if (ktModifierList == null) {
            return;
        }
        KtModifierList accessorModifierList = ktModifierList;
        KtModifierKeywordToken[] ktModifierKeywordTokenArray = new KtModifierKeywordToken[]{KtTokens.PUBLIC_KEYWORD, KtTokens.PROTECTED_KEYWORD, KtTokens.PRIVATE_KEYWORD, KtTokens.INTERNAL_KEYWORD};
        Map<KtModifierKeywordToken, PsiElement> map = this.modifiersChecker.getTokensCorrespondingToModifiers(accessorModifierList, (Collection<KtModifierKeywordToken>)SetsKt.setOf(ktModifierKeywordTokenArray));
        Intrinsics.checkNotNullExpressionValue(map, "getTokensCorrespondingToModifiers(...)");
        Map<KtModifierKeywordToken, PsiElement> tokens = map;
        if (accessor.isGetter()) {
            if (!Intrinsics.areEqual(accessorDescriptor.getVisibility(), propertyDescriptor.getVisibility())) {
                Collection<PsiElement> collection = tokens.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.GETTER_VISIBILITY_DIFFERS_FROM_PROPERTY_VISIBILITY;
                Intrinsics.checkNotNullExpressionValue(diagnosticFactory0, "GETTER_VISIBILITY_DIFFERS_FROM_PROPERTY_VISIBILITY");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            } else {
                Collection<PsiElement> collection = tokens.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.REDUNDANT_MODIFIER_IN_GETTER;
                Intrinsics.checkNotNullExpressionValue(diagnosticFactory0, "REDUNDANT_MODIFIER_IN_GETTER");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            }
        } else if (ModalityUtilsKt.isOverridable(propertyDescriptor) && Intrinsics.areEqual(accessorDescriptor.getVisibility(), DescriptorVisibilities.PRIVATE) && !Intrinsics.areEqual(propertyDescriptor.getVisibility(), DescriptorVisibilities.PRIVATE)) {
            if (propertyDescriptor.getModality() == Modality.ABSTRACT) {
                Collection<PsiElement> collection = tokens.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.PRIVATE_SETTER_FOR_ABSTRACT_PROPERTY;
                Intrinsics.checkNotNullExpressionValue(diagnosticFactory0, "PRIVATE_SETTER_FOR_ABSTRACT_PROPERTY");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            } else {
                Collection<PsiElement> collection = tokens.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.PRIVATE_SETTER_FOR_OPEN_PROPERTY;
                Intrinsics.checkNotNullExpressionValue(diagnosticFactory0, "PRIVATE_SETTER_FOR_OPEN_PROPERTY");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            }
        } else {
            Integer compare = DescriptorVisibilities.compare(accessorDescriptor.getVisibility(), propertyDescriptor.getVisibility());
            if (compare == null || compare > 0) {
                Collection<PsiElement> collection = tokens.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.SETTER_VISIBILITY_INCONSISTENT_WITH_PROPERTY_VISIBILITY;
                Intrinsics.checkNotNullExpressionValue(diagnosticFactory0, "SETTER_VISIBILITY_INCONS\u2026_WITH_PROPERTY_VISIBILITY");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            }
        }
        if (propertyDescriptor.isExpect()) {
            this.checkExpectDeclarationHasNoExternalModifier(accessor);
        }
    }

    private final void checkEnumEntry(KtEnumEntry enumEntry, ClassDescriptor enumEntryClass) {
        DeclarationDescriptor declarationDescriptor = enumEntryClass.getContainingDeclaration();
        Intrinsics.checkNotNull(declarationDescriptor, "null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        ClassDescriptor enumClass2 = (ClassDescriptor)declarationDescriptor;
        if (DescriptorUtils.isEnumClass(enumClass2)) {
            if (enumClass2.isExpect() && enumEntry.getBody() != null) {
                this.trace.report(Errors.EXPECTED_ENUM_ENTRY_WITH_BODY.on((KtEnumEntry)((PsiElement)enumEntry)));
            }
        } else {
            boolean bl = DescriptorUtils.isInterface(enumClass2);
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string2 = "Enum entry should be declared in enum class: " + enumEntryClass;
                throw new AssertionError((Object)string2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkVarargParameters(BindingTrace trace, CallableDescriptor callableDescriptor) {
        void $this$filterTo$iv$iv;
        List<ValueParameterDescriptor> list2 = callableDescriptor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "getValueParameters(...)");
        Iterable $this$filter$iv = list2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv$iv;
            boolean bl = false;
            if (!(it.getVarargElementType() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List varargParameters = (List)destination$iv$iv;
        if (varargParameters.size() > 1) {
            for (ValueParameterDescriptor parameter2 : varargParameters) {
                KtParameter parameterDeclaration;
                Intrinsics.checkNotNull(parameter2);
                PsiElement $i$f$filterTo2 = DescriptorToSourceUtils.descriptorToDeclaration(parameter2);
                if (($i$f$filterTo2 instanceof KtParameter ? (KtParameter)$i$f$filterTo2 : null) == null) continue;
                parameterDeclaration = parameterDeclaration;
                trace.report(Errors.MULTIPLE_VARARG_PARAMETERS.on((KtParameter)((PsiElement)parameterDeclaration)));
            }
        }
        SimpleType simpleType2 = DescriptorUtilsKt.getBuiltIns(callableDescriptor).getNullableNothingType();
        Intrinsics.checkNotNullExpressionValue(simpleType2, "getNullableNothingType(...)");
        SimpleType nullableNothing = simpleType2;
        for (ValueParameterDescriptor parameter3 : varargParameters) {
            KtParameter parameterDeclaration;
            KotlinType kotlinType = parameter3.getVarargElementType();
            Intrinsics.checkNotNull(kotlinType);
            SimpleType varargElementType2 = FlexibleTypesKt.upperIfFlexible(kotlinType);
            if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(varargElementType2, nullableNothing) && (!InlineClassesUtilsKt.isInlineClassType(varargElementType2) || UnsignedTypes.isUnsignedType(varargElementType2) || KotlinBuiltIns.isPrimitiveTypeOrNullablePrimitiveType(varargElementType2))) continue;
            Intrinsics.checkNotNull(parameter3);
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(parameter3);
            if ((psiElement instanceof KtParameter ? (KtParameter)psiElement : null) == null) continue;
            parameterDeclaration = parameterDeclaration;
            trace.report(Errors.FORBIDDEN_VARARG_PARAMETER_TYPE.on((KtParameter)((PsiElement)parameterDeclaration), varargElementType2));
        }
    }

    private static final KotlinType checkTypesInClassHeader$type(KtTypeReference $this$checkTypesInClassHeader_u24type, DeclarationsChecker this$0) {
        return (KotlinType)this$0.trace.getBindingContext().get(BindingContext.TYPE, $this$checkTypesInClassHeader_u24type);
    }

    private static final void checkPropertyTypeParametersAreUsedInReceiverType$addAccessibleTypeParametersFromType(Set<? extends TypeParameterDescriptor> allTypeParameters, HashSet<TypeParameterDescriptor> allAccessibleTypeParameters, KotlinType type2) {
        TypeUtils.contains(type2, new Function1<UnwrappedType, Boolean>(allTypeParameters, allAccessibleTypeParameters){
            final /* synthetic */ Set<TypeParameterDescriptor> $allTypeParameters;
            final /* synthetic */ HashSet<TypeParameterDescriptor> $allAccessibleTypeParameters;
            {
                this.$allTypeParameters = $allTypeParameters;
                this.$allAccessibleTypeParameters = $allAccessibleTypeParameters;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final Boolean invoke(UnwrappedType it) {
                ClassifierDescriptor declarationDescriptor = it.getConstructor().getDeclarationDescriptor();
                if (declarationDescriptor instanceof TypeParameterDescriptor && this.$allTypeParameters.contains(declarationDescriptor) && this.$allAccessibleTypeParameters.add((TypeParameterDescriptor)declarationDescriptor)) {
                    void $this$forEach$iv;
                    List<KotlinType> list2 = ((TypeParameterDescriptor)declarationDescriptor).getUpperBounds();
                    Intrinsics.checkNotNullExpressionValue(list2, "getUpperBounds(...)");
                    Iterable iterable = list2;
                    Set<TypeParameterDescriptor> set = this.$allTypeParameters;
                    HashSet<TypeParameterDescriptor> hashSet = this.$allAccessibleTypeParameters;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        KotlinType p0 = (KotlinType)element$iv;
                        boolean bl = false;
                        DeclarationsChecker.access$checkPropertyTypeParametersAreUsedInReceiverType$addAccessibleTypeParametersFromType(set, hashSet, p0);
                    }
                }
                return false;
            }
        });
    }

    private static final MemberScope checkPropertyInitializer$lambda$29(Lazy<? extends MemberScope> $delegateClassScope$delegate) {
        Lazy<? extends MemberScope> lazy = $delegateClassScope$delegate;
        return lazy.getValue();
    }

    public static final /* synthetic */ void access$checkPropertyTypeParametersAreUsedInReceiverType$addAccessibleTypeParametersFromType(Set allTypeParameters, HashSet allAccessibleTypeParameters, KotlinType type2) {
        DeclarationsChecker.checkPropertyTypeParametersAreUsedInReceiverType$addAccessibleTypeParametersFromType(allTypeParameters, allAccessibleTypeParameters, type2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u0016\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0014H\u0002J\n\u0010\u001a\u001a\u00020\b*\u00020\u001bJ\f\u0010\u001c\u001a\u00020\b*\u00020\u001bH\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lksp/org/jetbrains/kotlin/resolve/DeclarationsChecker$Companion;", "", "()V", "METHOD_OF_ANY_NAMES", "Lcom/google/common/collect/ImmutableSet;", "", "kotlin.jvm.PlatformType", "hasConstraints", "", "typeParameter", "Lksp/org/jetbrains/kotlin/psi/KtTypeParameter;", "constraints", "", "Lksp/org/jetbrains/kotlin/psi/KtTypeConstraint;", "isHidingParentMemberIfPresent", "member", "Lksp/org/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "isImplementingMethodOfAny", "isImplementingMethodOfAnyInternal", "visitedClasses", "", "Lksp/org/jetbrains/kotlin/descriptors/ClassDescriptor;", "removeDuplicateTypes", "", "conflictingTypes", "Lksp/org/jetbrains/kotlin/types/KotlinType;", "hasAnyAccessorImplementation", "Lksp/org/jetbrains/kotlin/descriptors/PropertyDescriptor;", "hasSetterAccessorImplementation", "frontend"})
    @SourceDebugExtension(value={"SMAP\nDeclarationsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeclarationsChecker.kt\norg/jetbrains/kotlin/resolve/DeclarationsChecker$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1156:1\n1745#2,3:1157\n*S KotlinDebug\n*F\n+ 1 DeclarationsChecker.kt\norg/jetbrains/kotlin/resolve/DeclarationsChecker$Companion\n*L\n1097#1:1157,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final void removeDuplicateTypes(Set<KotlinType> conflictingTypes) {
            Iterator<KotlinType> iterator2 = conflictingTypes.iterator();
            block0: while (iterator2.hasNext()) {
                KotlinType type2 = iterator2.next();
                for (KotlinType otherType : conflictingTypes) {
                    boolean subtypeOf = KotlinTypeChecker.DEFAULT.equalTypes(type2, otherType);
                    if (type2 == otherType || !subtypeOf) continue;
                    iterator2.remove();
                    continue block0;
                }
            }
        }

        private final boolean hasConstraints(KtTypeParameter typeParameter, List<? extends KtTypeConstraint> constraints) {
            boolean bl;
            block4: {
                if (typeParameter.getName() == null) {
                    return false;
                }
                Iterable $this$any$iv = constraints;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KtTypeConstraint it = (KtTypeConstraint)element$iv;
                        boolean bl2 = false;
                        KtSimpleNameExpression ktSimpleNameExpression = it.getSubjectTypeParameterName();
                        if (!Intrinsics.areEqual(ktSimpleNameExpression != null ? ktSimpleNameExpression.getText() : null, typeParameter.getName())) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final boolean isImplementingMethodOfAny(CallableMemberDescriptor member2) {
            if (!METHOD_OF_ANY_NAMES.contains(member2.getName().asString())) {
                return false;
            }
            if (member2.getModality() == Modality.ABSTRACT) {
                return false;
            }
            return this.isImplementingMethodOfAnyInternal(member2, new HashSet());
        }

        private final boolean isImplementingMethodOfAnyInternal(CallableMemberDescriptor member2, Set<ClassDescriptor> visitedClasses) {
            for (CallableMemberDescriptor callableMemberDescriptor : member2.getOverriddenDescriptors()) {
                DeclarationDescriptor containingDeclaration;
                Intrinsics.checkNotNullExpressionValue(callableMemberDescriptor.getContainingDeclaration(), "getContainingDeclaration(...)");
                if (!(containingDeclaration instanceof ClassDescriptor) || visitedClasses.contains(containingDeclaration)) continue;
                if (Intrinsics.areEqual(DescriptorUtils.getFqName(containingDeclaration), StandardNames.FqNames.any)) {
                    return true;
                }
                Intrinsics.checkNotNull(callableMemberDescriptor);
                if (this.isHidingParentMemberIfPresent(callableMemberDescriptor)) continue;
                visitedClasses.add((ClassDescriptor)containingDeclaration);
                if (!this.isImplementingMethodOfAnyInternal(callableMemberDescriptor, visitedClasses)) continue;
                return true;
            }
            return false;
        }

        private final boolean isHidingParentMemberIfPresent(CallableMemberDescriptor member2) {
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(member2);
            KtNamedDeclaration ktNamedDeclaration = psiElement instanceof KtNamedDeclaration ? (KtNamedDeclaration)psiElement : null;
            if (ktNamedDeclaration == null) {
                return false;
            }
            KtNamedDeclaration declaration2 = ktNamedDeclaration;
            KtModifierList ktModifierList = declaration2.getModifierList();
            if (ktModifierList == null) {
                return true;
            }
            KtModifierList modifierList2 = ktModifierList;
            return !modifierList2.hasModifier(KtTokens.OVERRIDE_KEYWORD);
        }

        private final boolean hasSetterAccessorImplementation(PropertyDescriptor $this$hasSetterAccessorImplementation) {
            PropertySetterDescriptor propertySetterDescriptor = $this$hasSetterAccessorImplementation.getSetter();
            return propertySetterDescriptor != null ? DescriptorPsiUtilsKt.hasBody(propertySetterDescriptor) : false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean hasAnyAccessorImplementation(@NotNull PropertyDescriptor $this$hasAnyAccessorImplementation) {
            Intrinsics.checkNotNullParameter($this$hasAnyAccessorImplementation, "<this>");
            if (this.hasSetterAccessorImplementation($this$hasAnyAccessorImplementation)) return true;
            PropertyGetterDescriptor propertyGetterDescriptor = $this$hasAnyAccessorImplementation.getGetter();
            if (propertyGetterDescriptor == null) return false;
            if (!DescriptorPsiUtilsKt.hasBody(propertyGetterDescriptor)) return false;
            return true;
        }

        public static final /* synthetic */ boolean access$hasSetterAccessorImplementation(Companion $this, PropertyDescriptor $receiver) {
            return $this.hasSetterAccessorImplementation($receiver);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\"\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001a\u001a\u00020\u0014H\u0016J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0005H\u0016J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010 \u001a\u00020!H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\""}, d2={"Lksp/org/jetbrains/kotlin/resolve/DeclarationsChecker$TypeAliasDeclarationCheckingReportStrategy;", "Lksp/org/jetbrains/kotlin/types/TypeAliasExpansionReportStrategy;", "trace", "Lksp/org/jetbrains/kotlin/resolve/BindingTrace;", "typeAliasDescriptor", "Lksp/org/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtTypeAlias;", "upperBoundChecker", "Lksp/org/jetbrains/kotlin/resolve/UpperBoundChecker;", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;Lorg/jetbrains/kotlin/psi/KtTypeAlias;Lorg/jetbrains/kotlin/resolve/UpperBoundChecker;)V", "typeReference", "Lksp/org/jetbrains/kotlin/psi/KtTypeReference;", "getUpperBoundChecker", "()Lorg/jetbrains/kotlin/resolve/UpperBoundChecker;", "boundsViolationInSubstitution", "", "substitutor", "Lksp/org/jetbrains/kotlin/types/TypeSubstitutor;", "unsubstitutedArgument", "Lksp/org/jetbrains/kotlin/types/KotlinType;", "argument", "typeParameter", "Lksp/org/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "conflictingProjection", "typeAlias", "substitutedArgument", "recursiveTypeAlias", "repeatedAnnotation", "annotation", "Lksp/org/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "wrongNumberOfTypeArguments", "numberOfParameters", "", "frontend"})
    private static final class TypeAliasDeclarationCheckingReportStrategy
    implements TypeAliasExpansionReportStrategy {
        @NotNull
        private final BindingTrace trace;
        @NotNull
        private final UpperBoundChecker upperBoundChecker;
        @NotNull
        private final KtTypeReference typeReference;

        public TypeAliasDeclarationCheckingReportStrategy(@NotNull BindingTrace trace, @NotNull TypeAliasDescriptor typeAliasDescriptor, @NotNull KtTypeAlias declaration2, @NotNull UpperBoundChecker upperBoundChecker) {
            Intrinsics.checkNotNullParameter(trace, "trace");
            Intrinsics.checkNotNullParameter(typeAliasDescriptor, "typeAliasDescriptor");
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            Intrinsics.checkNotNullParameter(upperBoundChecker, "upperBoundChecker");
            this.trace = trace;
            this.upperBoundChecker = upperBoundChecker;
            KtTypeReference ktTypeReference = declaration2.getTypeReference();
            if (ktTypeReference == null) {
                throw new AssertionError((Object)("Incorrect type alias declaration for " + typeAliasDescriptor));
            }
            this.typeReference = ktTypeReference;
        }

        @NotNull
        public final UpperBoundChecker getUpperBoundChecker() {
            return this.upperBoundChecker;
        }

        @Override
        public void wrongNumberOfTypeArguments(@NotNull TypeAliasDescriptor typeAlias, int numberOfParameters) {
            Intrinsics.checkNotNullParameter(typeAlias, "typeAlias");
        }

        @Override
        public void conflictingProjection(@NotNull TypeAliasDescriptor typeAlias, @Nullable TypeParameterDescriptor typeParameter, @NotNull KotlinType substitutedArgument) {
            Intrinsics.checkNotNullParameter(typeAlias, "typeAlias");
            Intrinsics.checkNotNullParameter(substitutedArgument, "substitutedArgument");
            this.trace.report(Errors.CONFLICTING_PROJECTION_IN_TYPEALIAS_EXPANSION.on((KtElement)((PsiElement)this.typeReference), substitutedArgument));
        }

        @Override
        public void recursiveTypeAlias(@NotNull TypeAliasDescriptor typeAlias) {
            Intrinsics.checkNotNullParameter(typeAlias, "typeAlias");
            this.trace.report(Errors.RECURSIVE_TYPEALIAS_EXPANSION.on((KtElement)((PsiElement)this.typeReference), typeAlias));
        }

        @Override
        public void boundsViolationInSubstitution(@NotNull TypeSubstitutor substitutor2, @NotNull KotlinType unsubstitutedArgument, @NotNull KotlinType argument2, @NotNull TypeParameterDescriptor typeParameter) {
            Intrinsics.checkNotNullParameter(substitutor2, "substitutor");
            Intrinsics.checkNotNullParameter(unsubstitutedArgument, "unsubstitutedArgument");
            Intrinsics.checkNotNullParameter(argument2, "argument");
            Intrinsics.checkNotNullParameter(typeParameter, "typeParameter");
            UpperBoundChecker.checkBounds$default(this.upperBoundChecker, null, argument2, typeParameter, substitutor2, this.trace, this.typeReference, null, 64, null);
        }

        @Override
        public void repeatedAnnotation(@NotNull AnnotationDescriptor annotation2) {
            Intrinsics.checkNotNullParameter(annotation2, "annotation");
            SourceElement sourceElement = annotation2.getSource();
            KotlinSourceElement kotlinSourceElement = sourceElement instanceof KotlinSourceElement ? (KotlinSourceElement)sourceElement : null;
            KtElement ktElement = kotlinSourceElement != null ? kotlinSourceElement.getPsi() : null;
            KtAnnotationEntry ktAnnotationEntry = ktElement instanceof KtAnnotationEntry ? (KtAnnotationEntry)ktElement : null;
            if (ktAnnotationEntry == null) {
                return;
            }
            KtAnnotationEntry annotationEntry2 = ktAnnotationEntry;
            this.trace.report(Errors.REPEATED_ANNOTATION.on((KtAnnotationEntry)((PsiElement)annotationEntry2)));
        }
    }
}

